/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.SignatureSpi;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class KeyFactorySpi
extends BaseKeyFactorySpi
implements AsymmetricKeyInfoConverter {
    static final byte[] x448Prefix = Hex.decode((String)"3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode((String)"302a300506032b656e032100");
    static final byte[] Ed448Prefix = Hex.decode((String)"3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode((String)"302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String string, boolean bl, int n) {
        this.algorithm = string;
        this.isXdh = bl;
        this.specificBase = n;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(OpenSSHPrivateKeySpec.class) && key instanceof BC15EdDSAPrivateKey) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)key.getEncoded());
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(2));
                byte[] byArray = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aSN1OctetString.getOctets())).getOctets();
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey((AsymmetricKeyParameter)new Ed25519PrivateKeyParameters(byArray)));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (clazz.isAssignableFrom(OpenSSHPublicKeySpec.class) && key instanceof BC15EdDSAPublicKey) {
            try {
                byte[] byArray = key.getEncoded();
                if (!Arrays.areEqual((byte[])Ed25519Prefix, (int)0, (int)Ed25519Prefix.length, (byte[])byArray, (int)0, (int)(byArray.length - 32))) {
                    throw new InvalidKeySpecException("Invalid Ed25519 public key encoding");
                }
                Ed25519PublicKeyParameters ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(byArray, Ed25519Prefix.length);
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey((AsymmetricKeyParameter)ed25519PublicKeyParameters));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (clazz.isAssignableFrom(RawEncodedKeySpec.class)) {
            if (key instanceof XDHPublicKey) {
                return new RawEncodedKeySpec(((XDHPublicKey)key).getUEncoding());
            }
            if (key instanceof EdDSAPublicKey) {
                return new RawEncodedKeySpec(((EdDSAPublicKey)key).getPointEncoding());
            }
        } else if (clazz.isAssignableFrom(EdECPrivateKeySpec.class)) {
            if (key instanceof EdECPrivateKey) {
                Optional<byte[]> optional = ((EdECPrivateKey)key).getBytes();
                if (optional.isPresent()) {
                    return new EdECPrivateKeySpec(((EdECPrivateKey)key).getParams(), optional.get());
                }
                throw new IllegalArgumentException("no byte[] data associated with key");
            }
        } else if (clazz.isAssignableFrom(EdECPublicKeySpec.class) && key instanceof EdECPublicKey) {
            return new EdECPublicKeySpec(((EdECPublicKey)key).getParams(), ((EdECPublicKey)key).getPoint());
        }
        return super.engineGetKeySpec(key, clazz);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob((byte[])((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
                return new BC15EdDSAPrivateKey((AsymmetricKeyParameter)((Ed25519PrivateKeyParameters)asymmetricKeyParameter));
            }
            throw new InvalidKeySpecException("openssh private key not Ed25519 private key");
        }
        if (keySpec instanceof EdECPrivateKeySpec) {
            EdECPrivateKeySpec edECPrivateKeySpec = (EdECPrivateKeySpec)keySpec;
            try {
                Ed448PrivateKeyParameters ed448PrivateKeyParameters;
                if (NamedParameterSpec.ED448.getName().equalsIgnoreCase(edECPrivateKeySpec.getParams().getName())) {
                    ed448PrivateKeyParameters = SignatureSpi.getEd448PrivateKey((byte[])edECPrivateKeySpec.getBytes());
                } else if (NamedParameterSpec.ED25519.getName().equalsIgnoreCase(edECPrivateKeySpec.getParams().getName())) {
                    ed448PrivateKeyParameters = SignatureSpi.getEd25519PrivateKey((byte[])edECPrivateKeySpec.getBytes());
                } else {
                    throw new InvalidKeySpecException("unrecognized named parameters: " + edECPrivateKeySpec.getParams().getName());
                }
                return new BC15EdDSAPrivateKey((AsymmetricKeyParameter)ed448PrivateKeyParameters);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException(invalidKeyException.getMessage(), invalidKeyException);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            if (this.specificBase == 0 || this.specificBase == byArray[8]) {
                if (byArray[9] == 5 && byArray[10] == 0) {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)byArray);
                    subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithm().getAlgorithm()), subjectPublicKeyInfo.getPublicKeyData().getBytes());
                    try {
                        byArray = subjectPublicKeyInfo.getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new InvalidKeySpecException("attempt to reconstruct key failed: " + iOException.getMessage());
                    }
                }
                switch (byArray[8]) {
                    case 111: {
                        return new BC11XDHPublicKey(x448Prefix, byArray);
                    }
                    case 110: {
                        return new BC11XDHPublicKey(x25519Prefix, byArray);
                    }
                    case 113: {
                        return new BC15EdDSAPublicKey(Ed448Prefix, byArray);
                    }
                    case 112: {
                        return new BC15EdDSAPublicKey(Ed25519Prefix, byArray);
                    }
                }
                return super.engineGeneratePublic(keySpec);
            }
        } else {
            if (keySpec instanceof RawEncodedKeySpec) {
                byte[] byArray = ((RawEncodedKeySpec)keySpec).getEncoded();
                switch (this.specificBase) {
                    case 111: {
                        return new BC11XDHPublicKey((AsymmetricKeyParameter)new X448PublicKeyParameters(byArray));
                    }
                    case 110: {
                        return new BC11XDHPublicKey((AsymmetricKeyParameter)new X25519PublicKeyParameters(byArray));
                    }
                    case 113: {
                        return new BC15EdDSAPublicKey((AsymmetricKeyParameter)new Ed448PublicKeyParameters(byArray));
                    }
                    case 112: {
                        return new BC15EdDSAPublicKey((AsymmetricKeyParameter)new Ed25519PublicKeyParameters(byArray));
                    }
                }
                throw new InvalidKeySpecException("factory not a specific type, cannot recognise raw encoding");
            }
            if (keySpec instanceof EdECPublicKeySpec) {
                EdECPublicKeySpec edECPublicKeySpec = (EdECPublicKeySpec)keySpec;
                try {
                    Ed448PublicKeyParameters ed448PublicKeyParameters;
                    if (NamedParameterSpec.ED448.getName().equalsIgnoreCase(edECPublicKeySpec.getParams().getName())) {
                        ed448PublicKeyParameters = SignatureSpi.getEd448PublicKey((EdECPoint)edECPublicKeySpec.getPoint());
                    } else if (NamedParameterSpec.ED25519.getName().equalsIgnoreCase(edECPublicKeySpec.getParams().getName())) {
                        ed448PublicKeyParameters = SignatureSpi.getEd25519PublicKey((EdECPoint)edECPublicKeySpec.getPoint());
                    } else {
                        throw new InvalidKeySpecException("unrecognized named parameters: " + edECPublicKeySpec.getParams().getName());
                    }
                    return new BC15EdDSAPublicKey((AsymmetricKeyParameter)ed448PublicKeyParameters);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage(), invalidKeyException);
                }
            }
            if (keySpec instanceof OpenSSHPublicKeySpec) {
                AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey((byte[])((OpenSSHPublicKeySpec)keySpec).getEncoded());
                if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
                    return new BC15EdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded());
                }
                throw new InvalidKeySpecException("openssh public key not Ed25519 public key");
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                return new BC11XDHPrivateKey(privateKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X25519)) {
                return new BC11XDHPrivateKey(privateKeyInfo);
            }
        } else if (aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448)) {
                return new BC15EdDSAPrivateKey(privateKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed25519)) {
                return new BC15EdDSAPrivateKey(privateKeyInfo);
            }
        }
        throw new IOException("algorithm identifier " + String.valueOf(aSN1ObjectIdentifier) + " in key not recognized");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                return new BC11XDHPublicKey(subjectPublicKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X25519)) {
                return new BC11XDHPublicKey(subjectPublicKeyInfo);
            }
        } else if (aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed25519)) {
            if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448)) {
                return new BC15EdDSAPublicKey(subjectPublicKeyInfo);
            }
            if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed25519)) {
                return new BC15EdDSAPublicKey(subjectPublicKeyInfo);
            }
        }
        throw new IOException("algorithm identifier " + String.valueOf(aSN1ObjectIdentifier) + " in key not recognized");
    }
}

