/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.raw.Mod;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat512;
import org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecP521R1Field {
    static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add((int)16, (int[])nArray, (int[])nArray2, (int[])nArray3) + nArray[16] + nArray2[16];
        if (n > 511 || n == 511 && Nat.eq((int)16, (int[])nArray3, (int[])P)) {
            n += Nat.inc((int)16, (int[])nArray3);
            n &= 0x1FF;
        }
        nArray3[16] = n;
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n = Nat.inc((int)16, (int[])nArray, (int[])nArray2) + nArray[16];
        if (n > 511 || n == 511 && Nat.eq((int)16, (int[])nArray2, (int[])P)) {
            n += Nat.inc((int)16, (int[])nArray2);
            n &= 0x1FF;
        }
        nArray2[16] = n;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat.fromBigInteger((int)521, (BigInteger)bigInteger);
        if (Nat.eq((int)17, (int[])nArray, (int[])P)) {
            Nat.zero((int)17, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        int n = nArray[16];
        int n2 = Nat.shiftDownBit((int)16, (int[])nArray, (int)n, (int[])nArray2);
        nArray2[16] = n >>> 1 | n2 >>> 23;
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse((int[])P, (int[])nArray, (int[])nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 17; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create((int)33);
        SecP521R1Field.implMultiply((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP521R1Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        SecP521R1Field.implMultiply((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP521R1Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != SecP521R1Field.isZero((int[])nArray)) {
            Nat.sub((int)17, (int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat.sub((int)17, (int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[68];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt((byte[])byArray, (int)0, (int[])nArray, (int)0, (int)17);
            nArray[16] = nArray[16] & 0x1FF;
        } while (0 == Nat.lessThan((int)17, (int[])nArray, (int[])P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP521R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != SecP521R1Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int n = nArray[32];
        int n2 = Nat.shiftDownBits((int)16, (int[])nArray, (int)16, (int)9, (int)n, (int[])nArray2, (int)0) >>> 23;
        n2 += n >>> 9;
        if ((n2 += Nat.addTo((int)16, (int[])nArray, (int[])nArray2)) > 511 || n2 == 511 && Nat.eq((int)16, (int[])nArray2, (int[])P)) {
            n2 += Nat.inc((int)16, (int[])nArray2);
            n2 &= 0x1FF;
        }
        nArray2[16] = n2;
    }

    public static void reduce23(int[] nArray) {
        int n = nArray[16];
        int n2 = Nat.addWordTo((int)16, (int)(n >>> 9), (int[])nArray) + (n & 0x1FF);
        if (n2 > 511 || n2 == 511 && Nat.eq((int)16, (int[])nArray, (int[])P)) {
            n2 += Nat.inc((int)16, (int[])nArray);
            n2 &= 0x1FF;
        }
        nArray[16] = n2;
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create((int)33);
        SecP521R1Field.implSquare((int[])nArray, (int[])nArray3);
        SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void square(int[] nArray, int[] nArray2, int[] nArray3) {
        SecP521R1Field.implSquare((int[])nArray, (int[])nArray3);
        SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat.create((int)33);
        SecP521R1Field.implSquare((int[])nArray, (int[])nArray3);
        SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            SecP521R1Field.implSquare((int[])nArray2, (int[])nArray3);
            SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void squareN(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        SecP521R1Field.implSquare((int[])nArray, (int[])nArray3);
        SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            SecP521R1Field.implSquare((int[])nArray2, (int[])nArray3);
            SecP521R1Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub((int)16, (int[])nArray, (int[])nArray2, (int[])nArray3) + nArray[16] - nArray2[16];
        if (n < 0) {
            n += Nat.dec((int)16, (int[])nArray3);
            n &= 0x1FF;
        }
        nArray3[16] = n;
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = nArray[16];
        int n2 = Nat.shiftUpBit((int)16, (int[])nArray, (int)(n << 23), (int[])nArray2) | n << 1;
        nArray2[16] = n2 & 0x1FF;
    }

    protected static void implMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat512.mul((int[])nArray, (int[])nArray2, (int[])nArray3);
        int n = nArray[16];
        int n2 = nArray2[16];
        nArray3[32] = Nat.mul31BothAdd((int)16, (int)n, (int[])nArray2, (int)n2, (int[])nArray, (int[])nArray3, (int)16) + n * n2;
    }

    protected static void implSquare(int[] nArray, int[] nArray2) {
        Nat512.square((int[])nArray, (int[])nArray2);
        int n = nArray[16];
        nArray2[32] = Nat.mulWordAddTo((int)16, (int)(n << 1), (int[])nArray, (int)0, (int[])nArray2, (int)16) + n * n;
    }
}

