/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.spatialsampling;

import java.io.Serializable;
import org.openmole.spatialsampling.GIS$;
import org.openmole.spatialsampling.Geometry;
import org.openmole.spatialsampling.Math$;
import org.openmole.spatialsampling.Network;
import org.openmole.spatialsampling.Network$;
import org.openmole.spatialsampling.Network$Link$;
import org.openmole.spatialsampling.Network$Node$;
import org.openmole.spatialsampling.OSM$Buildings$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random;
import scala.util.Right;

public final class Generation$ {
    public static final Generation$ MODULE$ = new Generation$();

    public double[][] expMixtureGrid(Either<Object, Tuple2<Object, Object>> size, int centers, double maxValue, double kernelRadius, boolean normalized, Seq<Tuple2<Object, Object>> centerCoordinates, Random rng) {
        Left left;
        int n = centerCoordinates.size();
        switch (n) {
            case 0: {
                left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)centers));
                break;
            }
            default: {
                left = package$.MODULE$.Right().apply(centerCoordinates.map((Function1 & Serializable)c -> new Tuple2.mcII.sp((int)c._1$mcD$sp(), (int)c._2$mcD$sp())));
                break;
            }
        }
        Left eithcenters = left;
        return Math$.MODULE$.kernelMixture(size, (Either<Object, Seq<Tuple2<Object, Object>>>)eithcenters, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(x, y) -> Generation$.expKernel$1(x, y, maxValue, kernelRadius), rng);
    }

    public boolean expMixtureGrid$default$5() {
        return false;
    }

    public Seq<Tuple2<Object, Object>> expMixtureGrid$default$6() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public double[][] percolationGrid(int size, double percolationProba, int bordPoints, double linkwidth, int maxIterations, boolean percolateBuildings, Random rng) {
        Network x$12 = this.percolationNetwork(size, percolationProba, bordPoints, linkwidth, maxIterations, rng);
        double x$2 = linkwidth;
        double x$3 = Network$.MODULE$.networkToGrid$default$2();
        double[][] percolatedGrid = Network$.MODULE$.networkToGrid(x$12, x$3, x$2);
        return percolateBuildings ? percolatedGrid : (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])percolatedGrid), (Function1 & Serializable)x$1 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$1), (Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> 1.0 - x$2, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public boolean percolationGrid$default$6() {
        return false;
    }

    public double[][] blocksGrid(Either<Object, Tuple2<Object, Object>> size, int blocks, int blockMinSize, int blockMaxSize, Random rng) {
        Right right;
        Tuple2 tuple2;
        int n;
        Right right2;
        Tuple2 tuple22;
        int n2;
        int maxsize = scala.math.package$.MODULE$.max(blockMinSize, blockMaxSize);
        int minsize = scala.math.package$.MODULE$.min(blockMinSize, blockMaxSize);
        Either<Object, Tuple2<Object, Object>> either = size;
        if (either instanceof Left) {
            int l;
            Left left = (Left)either;
            n2 = l = BoxesRunTime.unboxToInt((Object)left.value());
        } else if (either instanceof Right && (tuple22 = (Tuple2)(right2 = (Right)either).value()) != null) {
            int ww;
            n2 = ww = tuple22._1$mcI$sp();
        } else {
            throw new MatchError(either);
        }
        int w = n2;
        Either<Object, Tuple2<Object, Object>> either2 = size;
        if (either2 instanceof Left) {
            int l;
            Left left = (Left)either2;
            n = l = BoxesRunTime.unboxToInt((Object)left.value());
        } else if (either2 instanceof Right && (tuple2 = (Tuple2)(right = (Right)either2).value()) != null) {
            int hh;
            n = hh = tuple2._2$mcI$sp();
        } else {
            throw new MatchError(either2);
        }
        int h = n;
        double[][] vals = (double[][])Array$.MODULE$.fill(w, h, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), blocks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            int n = x$6;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(rng.nextInt(w), rng.nextInt(h));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int i = sp2._1$mcI$sp();
            int j = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(i, j);
            Tuple2.mcII.sp sp4 = sp3;
            int i2 = sp4._1$mcI$sp();
            int j2 = sp4._2$mcI$sp();
            Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minsize + rng.nextInt(maxsize - minsize + 1), minsize + rng.nextInt(maxsize - minsize + 1));
            if (sp5 == null) {
                throw new MatchError((Object)sp5);
            }
            int ww = sp5._1$mcI$sp();
            int hh = sp5._2$mcI$sp();
            Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(ww, hh);
            Tuple2.mcII.sp sp7 = sp6;
            int ww2 = sp7._1$mcI$sp();
            int hh2 = sp7._2$mcI$sp();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ww2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)di -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), hh2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)dj -> {
                block1: {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i2 - ww2 / 2 + di, j2 - hh2 / 2 + dj);
                    if (sp2 == null) {
                        throw new MatchError((Object)sp2);
                    }
                    int k = sp2._1$mcI$sp();
                    int l = sp2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(k, l);
                    Tuple2.mcII.sp sp4 = sp3;
                    int k2 = sp4._1$mcI$sp();
                    int l2 = sp4._2$mcI$sp();
                    if (!(k2 >= 0 & l2 >= 0 & k2 < w & l2 < h)) break block1;
                    vals$1[k2][l2] = vals[k2][l2] + 1.0;
                }
            }));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return vals;
    }

    public double[][] randomGrid(Either<Object, Tuple2<Object, Object>> size, Random rng) {
        Right right;
        Tuple2 tuple2;
        double[][] dArray;
        Either<Object, Tuple2<Object, Object>> either = size;
        if (either instanceof Left) {
            Left left = (Left)either;
            int s = BoxesRunTime.unboxToInt((Object)left.value());
            dArray = (double[][])Array$.MODULE$.fill(s, s, (Function0)(JFunction0.mcD.sp & Serializable)() -> rng.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            int w = tuple2._1$mcI$sp();
            int h = tuple2._2$mcI$sp();
            dArray = (double[][])Array$.MODULE$.fill(w, h, (Function0)(JFunction0.mcD.sp & Serializable)() -> rng.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double());
        } else {
            throw new MatchError(either);
        }
        return dArray;
    }

    public double[][] reactionDiffusionGrid(Either<Object, Tuple2<Object, Object>> size, double growthRate, double totalPopulation, double alphaAtt, double diffusion, int diffusionSteps, Option<Seq<Seq<Object>>> initialConfiguration, boolean iterImpl, Random rng) {
        double[][] dArray;
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        if (initialConfiguration.isDefined()) {
            sp3 = new Tuple2.mcII.sp(((SeqOps)((IterableOps)initialConfiguration.get()).head()).length(), ((SeqOps)initialConfiguration.get()).length());
        } else {
            Tuple2.mcII.sp sp4;
            Either<Object, Tuple2<Object, Object>> either = size;
            if (either instanceof Left) {
                Left left = (Left)either;
                int s = BoxesRunTime.unboxToInt((Object)left.value());
                sp4 = new Tuple2.mcII.sp(s, s);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 c = (Tuple2)right.value();
                sp4 = c;
            } else {
                throw new MatchError(either);
            }
            sp3 = sp2 = sp4;
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int width = sp2._1$mcI$sp();
        int height = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(width, height);
        Tuple2.mcII.sp sp6 = sp5;
        int width2 = sp6._1$mcI$sp();
        int height2 = sp6._2$mcI$sp();
        if (initialConfiguration.isDefined()) {
            Vector copyconfig = ((IterableOnceOps)((IterableOps)initialConfiguration.get()).map((Function1 & Serializable)x$8 -> x$8.toVector())).toVector();
            dArray = (double[][])Array$.MODULE$.tabulate(width2, height2, (Function2)(JFunction2.mcDII.sp & Serializable)(i, j) -> BoxesRunTime.unboxToDouble((Object)((SeqOps)copyconfig.apply(i)).apply(j)), (ClassTag)ClassTag$.MODULE$.Double());
        } else {
            dArray = (double[][])Array$.MODULE$.fill(width2, height2, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        }
        ObjectRef arrayVals = ObjectRef.create((Object)dArray);
        DoubleRef population = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])((double[][])arrayVals.elem)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), (Function1)(JFunction1.mcZD.sp & Serializable)x$9 -> !Predef$.MODULE$.double2Double(x$9).isNaN())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        int steps = 0;
        double stepdeltapop = 0.0;
        while (population.elem < totalPopulation && stepdeltapop >= 0.0) {
            double prevpop = population.elem;
            if (population.elem == 0.0) {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)growthRate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {
                    int n = x$10;
                    int i = rng.nextInt(width2);
                    int j = rng.nextInt(height2);
                    ((double[][])arrayVals$1.elem)[i][j] = ((double[][])arrayVals$1.elem)[i][j] + 1.0;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            } else {
                double[][] oldPop = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((double[][])arrayVals.elem)), (Function1 & Serializable)x$11 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$11), (Function1)(JFunction1.mcDD.sp & Serializable)x -> scala.math.package$.MODULE$.pow(x / population$1.elem, alphaAtt), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                double ptot = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])oldPop), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), (Function1)(JFunction1.mcZD.sp & Serializable)x$12 -> !Predef$.MODULE$.double2Double(x$12).isNaN())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (iterImpl) {
                    RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)growthRate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> {
                        int n = x$13;
                        double s = 0.0;
                        double r = rng.nextDouble();
                        int i = 0;
                        int j = 0;
                        while (s < r) {
                            double d = oldPop[i][j];
                            if (!Predef$.MODULE$.double2Double(d).isNaN()) {
                                s += d / ptot;
                            }
                            if (++j != height2) continue;
                            j = 0;
                            ++i;
                        }
                        if (j == 0) {
                            j = height2 - 1;
                            --i;
                        } else {
                            --j;
                        }
                        ((double[][])arrayVals$1.elem)[i][j] = ((double[][])arrayVals$1.elem)[i][j] + 1.0;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                } else {
                    double[] probas = (double[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill((int)growthRate, (Function0)(JFunction0.mcD.sp & Serializable)() -> rng.nextDouble(), (ClassTag)ClassTag$.MODULE$.Double())), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                    double s = 0.0;
                    int i2 = 0;
                    int j2 = 0;
                    int k = 0;
                    while (k < probas.length) {
                        Tuple2.mcII.sp sp7;
                        if (s <= probas[k]) {
                            double d = oldPop[i2][j2];
                            if (!Predef$.MODULE$.double2Double(d).isNaN()) {
                                s += d / ptot;
                            }
                            if (++j2 != height2) continue;
                            j2 = 0;
                            ++i2;
                            continue;
                        }
                        ++k;
                        Tuple2.mcII.sp sp8 = sp7 = j2 == 0 ? new Tuple2.mcII.sp(i2 - 1, height2 - 1) : new Tuple2.mcII.sp(i2, j2 - 1);
                        if (sp7 == null) {
                            throw new MatchError((Object)sp7);
                        }
                        int ii = sp7._1$mcI$sp();
                        int jj = sp7._2$mcI$sp();
                        Tuple2.mcII.sp sp9 = new Tuple2.mcII.sp(ii, jj);
                        Tuple2.mcII.sp sp10 = sp9;
                        int ii2 = sp10._1$mcI$sp();
                        int jj2 = sp10._2$mcI$sp();
                        ((double[][])arrayVals.elem)[ii2][jj2] = ((double[][])arrayVals.elem)[ii2][jj2] + 1.0;
                    }
                }
            }
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), diffusionSteps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> {
                int n = x$15;
                arrayVals$1.elem = Math$.MODULE$.diffuse((double[][])arrayVals$1.elem, diffusion);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            population.elem = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])((double[][])arrayVals.elem)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), (ClassTag)ClassTag$.MODULE$.Double())), (Function1)(JFunction1.mcZD.sp & Serializable)x$16 -> !Predef$.MODULE$.double2Double(x$16).isNaN())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            stepdeltapop = population.elem - prevpop;
            ++steps;
        }
        return (double[][])arrayVals.elem;
    }

    public Option<Seq<Seq<Object>>> reactionDiffusionGrid$default$7() {
        return None$.MODULE$;
    }

    public boolean reactionDiffusionGrid$default$8() {
        return true;
    }

    public double[][] osmBuildingsGrid(double lon, double lat, double windowSize, int worldWidth) {
        Tuple4<Object, Object, Object, Object> tuple4 = GIS$.MODULE$.wgs84window(lon, lat, windowSize);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double west = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double south = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double east = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double north = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)west), (Object)BoxesRunTime.boxToDouble((double)south), (Object)BoxesRunTime.boxToDouble((double)east), (Object)BoxesRunTime.boxToDouble((double)north));
        Tuple4 tuple43 = tuple42;
        double west2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double south2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double east2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double north2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        Seq polygons = (Seq)OSM$Buildings$.MODULE$.getBuildings(west2, south2, east2, north2).map((Function1 & Serializable)x$18 -> x$18.project((Function2<Object, Object, Tuple2<Object, Object>>)(Function2 & Serializable)(lon, lat) -> GIS$.MODULE$.WGS84ToPseudoMercator(BoxesRunTime.unboxToDouble((Object)lon), BoxesRunTime.unboxToDouble((Object)lat))));
        Predef$.MODULE$.println(polygons.map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToDouble((double)Generation$.$anonfun$osmBuildingsGrid$3(x$19))));
        Predef$.MODULE$.println(polygons.map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToDouble((double)Generation$.$anonfun$osmBuildingsGrid$5(x$21))));
        Tuple2<Object, Object> tuple2 = GIS$.MODULE$.WGS84ToPseudoMercator(lon, lat);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double x0 = tuple2._1$mcD$sp();
        double y0 = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x0, y0);
        Tuple2.mcDD.sp sp3 = sp2;
        double x02 = sp3._1$mcD$sp();
        double y02 = sp3._2$mcD$sp();
        Tuple4 tuple44 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)(x02 - windowSize / (double)2)), (Object)BoxesRunTime.boxToDouble((double)(x02 + windowSize / (double)2)), (Object)BoxesRunTime.boxToDouble((double)(y02 - windowSize / (double)2)), (Object)BoxesRunTime.boxToDouble((double)(y02 + windowSize / (double)2)));
        if (tuple44 == null) {
            throw new MatchError((Object)tuple44);
        }
        double xmi = BoxesRunTime.unboxToDouble((Object)tuple44._1());
        double xma = BoxesRunTime.unboxToDouble((Object)tuple44._2());
        double ymi = BoxesRunTime.unboxToDouble((Object)tuple44._3());
        double yma = BoxesRunTime.unboxToDouble((Object)tuple44._4());
        Tuple4 tuple45 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmi), (Object)BoxesRunTime.boxToDouble((double)xma), (Object)BoxesRunTime.boxToDouble((double)ymi), (Object)BoxesRunTime.boxToDouble((double)yma));
        Tuple4 tuple46 = tuple45;
        double xmi2 = BoxesRunTime.unboxToDouble((Object)tuple46._1());
        double xma2 = BoxesRunTime.unboxToDouble((Object)tuple46._2());
        double ymi2 = BoxesRunTime.unboxToDouble((Object)tuple46._3());
        double yma2 = BoxesRunTime.unboxToDouble((Object)tuple46._4());
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(xmi2).append(" - ").append(ymi2).toString());
        double step = (windowSize - 1.0) / (double)worldWidth;
        return (double[][])ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.doubleArrayOps((double[])((IterableOnceOps)((IndexedSeqOps)((StrictOptimizedIterableOps)Range.Partial$.MODULE$.by$extension(package$.MODULE$.BigDecimal().apply(xmi2).to(package$.MODULE$.BigDecimal().apply(xma2)), (Object)BigDecimal$.MODULE$.double2bigDecimal(step))).flatMap((Function1 & Serializable)x -> (IndexedSeq)((StrictOptimizedIterableOps)Range.Partial$.MODULE$.by$extension(package$.MODULE$.BigDecimal().apply(ymi2).to(package$.MODULE$.BigDecimal().apply(yma2)), (Object)BigDecimal$.MODULE$.double2bigDecimal(step))).map((Function1 & Serializable)y -> new Geometry.Point(x.toDouble(), y.toDouble())))).map((Function1 & Serializable)p -> BoxesRunTime.boxToDouble((double)Generation$.$anonfun$osmBuildingsGrid$9(polygons, p)))).toArray((ClassTag)ClassTag$.MODULE$.Double())), worldWidth).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public Network percolationNetwork(int worldSize, double percolationProba, int bordPoints, double linkwidth, int maxIterations, Random rng) {
        Network nw = this.gridNetwork(worldSize, this.gridNetwork$default$2());
        int bordConnected = 0;
        double xmin = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)nw.nodes().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.x()))).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double xmax = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)nw.nodes().map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToDouble((double)x$26.x()))).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double ymin = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)nw.nodes().map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToDouble((double)x$27.y()))).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double ymax = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)nw.nodes().map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToDouble((double)x$28.y()))).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        for (int iteration = 0; bordConnected < bordPoints && iteration < maxIterations; ++iteration) {
            nw = nw.percolate(percolationProba, (Function1<Network.Link, Object>)(Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)Generation$.$anonfun$percolationNetwork$5(xmin, xmax, ymin, ymax, l)), rng);
            Network giantcomp = Network$.MODULE$.largestConnectedComponent(Network$.MODULE$.apply(nw.nodes(), (Set<Network.Link>)((Set)nw.links().filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)Generation$.$anonfun$percolationNetwork$6(x$29))))));
            Set nodesOnBord = (Set)giantcomp.nodes().filter((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)Generation$.$anonfun$percolationNetwork$7(xmin, xmax, ymin, ymax, n)));
            bordConnected = nodesOnBord.size();
        }
        return nw;
    }

    public Network gridNetwork(int size, boolean diagLinks) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(size / 10, size / 10);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int xstep = sp2._1$mcI$sp();
        int ystep = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(xstep, ystep);
        Tuple2.mcII.sp sp4 = sp3;
        int xstep2 = sp4._1$mcI$sp();
        int ystep2 = sp4._2$mcI$sp();
        Range ycoords = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), size).by(ystep2);
        Range xcoords = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), size).by(xstep2);
        Seq coords = (Seq)xcoords.flatMap((Function1 & Serializable)xx -> ycoords.map((Function1 & Serializable)yy -> Generation$.$anonfun$gridNetwork$2(xx, BoxesRunTime.unboxToInt((Object)yy))));
        Seq nodes = ((IterableOps)((IterableOps)coords.zipWithIndex()).map((Function1 & Serializable)c -> Network$Node$.MODULE$.apply(c._2$mcI$sp(), ((Tuple2)c._1())._1$mcD$sp(), ((Tuple2)c._1())._2$mcD$sp()))).sliding(ycoords.size(), ycoords.size()).toSeq();
        ArrayBuffer edges = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        nodes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((SeqOps)nodes.head()).indices().foreach((Function1 & Serializable)j -> Generation$.$anonfun$gridNetwork$5(i, diagLinks, edges, nodes, BoxesRunTime.unboxToInt((Object)j))));
        return Network$.MODULE$.apply((Set<Network.Node>)((IterableOnceOps)nodes.flatten(Predef$.MODULE$.$conforms())).toSet(), (Set<Network.Link>)edges.toSet());
    }

    public boolean gridNetwork$default$2() {
        return false;
    }

    private static final double expKernel$1(double x, double y, double maxValue$1, double kernelRadius$1) {
        return maxValue$1 * scala.math.package$.MODULE$.exp(-scala.math.package$.MODULE$.sqrt(scala.math.package$.MODULE$.pow(x, 2.0) + scala.math.package$.MODULE$.pow(y, 2.0)) / kernelRadius$1);
    }

    public static final /* synthetic */ double $anonfun$osmBuildingsGrid$3(Geometry.Polygon x$19) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$19.vertices()), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20.x()), (ClassTag)ClassTag$.MODULE$.Double())).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$osmBuildingsGrid$5(Geometry.Polygon x$21) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$21.vertices()), (Function1 & Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.y()), (ClassTag)ClassTag$.MODULE$.Double())).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$osmBuildingsGrid$9(Seq polygons$1, Geometry.Point p) {
        return polygons$1.exists((Function1 & Serializable)polygon -> BoxesRunTime.boxToBoolean((boolean)p.inPolygon(polygon))) ? 1.0 : 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$percolationNetwork$5(double xmin$1, double xmax$1, double ymin$1, double ymax$1, Network.Link l) {
        return l.weight() == 0.0 && (l.e1().x() != xmin$1 && l.e2().x() != xmin$1 || l.e1().x() == xmin$1 && l.e2().x() != xmin$1 || l.e2().x() == xmin$1 && l.e1().x() != xmin$1) && (l.e1().x() != xmax$1 && l.e2().x() != xmax$1 || l.e1().x() == xmax$1 && l.e2().x() != xmax$1 || l.e2().x() == xmax$1 && l.e1().x() != xmax$1) && (l.e1().y() != ymin$1 && l.e2().y() != ymin$1 || l.e1().y() == ymin$1 && l.e2().y() != ymin$1 || l.e2().y() == ymin$1 && l.e1().y() != ymin$1) && (l.e1().y() != ymax$1 && l.e2().y() != ymax$1 || l.e1().y() == ymax$1 && l.e2().y() != ymax$1 || l.e2().y() == ymax$1 && l.e1().y() != ymax$1);
    }

    public static final /* synthetic */ boolean $anonfun$percolationNetwork$6(Network.Link x$29) {
        return x$29.weight() > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$percolationNetwork$7(double xmin$1, double xmax$1, double ymin$1, double ymax$1, Network.Node n) {
        return n.x() == xmin$1 || n.x() == xmax$1 || n.y() == ymin$1 || n.y() == ymax$1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$gridNetwork$2(int xx$1, int yy) {
        return new Tuple2.mcDD.sp((double)xx$1, (double)yy);
    }

    public static final /* synthetic */ Object $anonfun$gridNetwork$5(int i$2, boolean diagLinks$1, ArrayBuffer edges$1, Seq nodes$1, int j) {
        Object object;
        Object object2;
        if (i$2 - 1 > 0) {
            Object object3 = diagLinks$1 && j - 1 > 0 ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 - 1)).apply(j - 1), 0.0)) : BoxedUnit.UNIT;
            edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 - 1)).apply(j), 0.0));
            object2 = diagLinks$1 && j + 1 < ((SeqOps)nodes$1.head()).size() ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 - 1)).apply(j + 1), 0.0)) : BoxedUnit.UNIT;
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Object object4 = j - 1 > 0 ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j - 1), 0.0)) : BoxedUnit.UNIT;
        Object object5 = j + 1 < ((SeqOps)nodes$1.head()).size() ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j + 1), 0.0)) : BoxedUnit.UNIT;
        if (i$2 + 1 < nodes$1.size()) {
            Object object6 = diagLinks$1 && j - 1 > 0 ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 + 1)).apply(j - 1), 0.0)) : BoxedUnit.UNIT;
            edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 + 1)).apply(j), 0.0));
            object = diagLinks$1 && j + 1 < ((SeqOps)nodes$1.head()).size() ? edges$1.append((Object)Network$Link$.MODULE$.apply((Network.Node)((SeqOps)nodes$1.apply(i$2)).apply(j), (Network.Node)((SeqOps)nodes$1.apply(i$2 + 1)).apply(j + 1), 0.0)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private Generation$() {
    }
}

