/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompileMetricsRecorderInterface;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DefaultExterns;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.DummyCompileMetricsRecorder;
import com.google.javascript.jscomp.FlagUsageException;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsonErrorReportGenerator;
import com.google.javascript.jscomp.PrebuildAst;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.ShowByPathWarningsGuard;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.deps.SourceCodeEscapers;
import com.google.javascript.jscomp.ijs.IjsErrors;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Function;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.io.ByteStreams;
import com.google.javascript.jscomp.jarjar.com.google.gson.Gson;
import com.google.javascript.jscomp.jarjar.com.google.gson.GsonBuilder;
import com.google.javascript.jscomp.jarjar.com.google.gson.annotations.SerializedName;
import com.google.javascript.jscomp.jarjar.com.google.gson.reflect.TypeToken;
import com.google.javascript.jscomp.jarjar.com.google.gson.stream.JsonReader;
import com.google.javascript.jscomp.jarjar.com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TokenStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class AbstractCommandLineRunner<A extends Compiler, B extends CompilerOptions> {
    static final DiagnosticType OUTPUT_SAME_AS_INPUT_ERROR = DiagnosticType.error("JSC_OUTPUT_SAME_AS_INPUT_ERROR", "Bad output file (already listed as input file): {0}");
    static final DiagnosticType COULD_NOT_SERIALIZE_AST = DiagnosticType.error("JSC_COULD_NOT_SERIALIZE_AST", "Could not serialize ast to: {0}");
    static final DiagnosticType COULD_NOT_DESERIALIZE_AST = DiagnosticType.error("JSC_COULD_NOT_DESERIALIZE_AST", "Could not deserialize ast from: {0}");
    static final DiagnosticType NO_TREE_GENERATED_ERROR = DiagnosticType.error("JSC_NO_TREE_GENERATED_ERROR", "Code contains errors. No tree was generated.");
    static final DiagnosticType INVALID_MODULE_SOURCEMAP_PATTERN = DiagnosticType.error("JSC_INVALID_MODULE_SOURCEMAP_PATTERN", "When using --module flags, the --create_source_map flag must contain %outname% in the value.");
    static final String WAITING_FOR_INPUT_WARNING = "The compiler is waiting for input via stdin.";
    @GwtIncompatible(value="Unnecessary")
    private final CommandLineConfig config;
    @GwtIncompatible(value="Unnecessary")
    private final InputStream in;
    @GwtIncompatible(value="Unnecessary")
    private final PrintStream defaultJsOutput;
    @GwtIncompatible(value="Unnecessary")
    private final PrintStream err;
    @GwtIncompatible(value="Unnecessary")
    private A compiler;
    @GwtIncompatible(value="Unnecessary")
    private Charset inputCharset;
    @GwtIncompatible(value="Unnecessary")
    private Charset outputCharset2;
    @GwtIncompatible(value="Unnecessary")
    private Charset legacyOutputCharset;
    @GwtIncompatible(value="Unnecessary")
    private boolean testMode = false;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<SourceFile>> externsSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<SourceFile>> inputsSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<JSChunk>> modulesSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Function<Integer, Void> exitCodeReceiver = SystemExitCodeReceiver.INSTANCE;
    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> rootRelativePathsMap = null;
    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> parsedModuleWrappers = null;
    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> parsedModuleOutputFiles = null;
    @GwtIncompatible(value="Unnecessary")
    private final Gson gson;
    static final String OUTPUT_MARKER = "%output%";
    private static final String OUTPUT_MARKER_JS_STRING = "%output|jsstring%";
    @GwtIncompatible(value="Unnecessary")
    private final List<JsonFileSpec> filesToStreamOut = new ArrayList<JsonFileSpec>();

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner() {
        this(System.in, System.out, System.err);
    }

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner(PrintStream out, PrintStream err) {
        this(System.in, out, err);
    }

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner(InputStream in, PrintStream out, PrintStream err) {
        this.config = new CommandLineConfig();
        this.in = Preconditions.checkNotNull(in);
        this.defaultJsOutput = Preconditions.checkNotNull(out);
        this.err = Preconditions.checkNotNull(err);
        this.gson = new Gson();
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void enableTestMode(Supplier<List<SourceFile>> externsSupplier, Supplier<List<SourceFile>> inputsSupplier, Supplier<List<JSChunk>> modulesSupplier, Function<Integer, Void> exitCodeReceiver) {
        Preconditions.checkArgument(inputsSupplier == null != (modulesSupplier == null));
        this.testMode = true;
        this.externsSupplierForTesting = externsSupplier;
        this.inputsSupplierForTesting = inputsSupplier;
        this.modulesSupplierForTesting = modulesSupplier;
        this.exitCodeReceiver = exitCodeReceiver;
    }

    @GwtIncompatible(value="Unnecessary")
    public void setExitCodeReceiver(Function<Integer, Void> newExitCodeReceiver) {
        this.exitCodeReceiver = Preconditions.checkNotNull(newExitCodeReceiver);
    }

    @GwtIncompatible(value="Unnecessary")
    protected boolean isInTestMode() {
        return this.testMode;
    }

    @GwtIncompatible(value="Unnecessary")
    private boolean isOutputInJson() {
        return this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.OUT || this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.BOTH;
    }

    @GwtIncompatible(value="Unnecessary")
    protected CommandLineConfig getCommandLineConfig() {
        return this.config;
    }

    @GwtIncompatible(value="Unnecessary")
    protected abstract A createCompiler();

    @GwtIncompatible(value="Unnecessary")
    protected abstract void prepForBundleAndAppendTo(Appendable var1, CompilerInput var2, String var3) throws IOException;

    @GwtIncompatible(value="Unnecessary")
    protected abstract void appendRuntimeTo(Appendable var1) throws IOException;

    @GwtIncompatible(value="Unnecessary")
    protected abstract B createOptions();

    @GwtIncompatible(value="Unnecessary")
    protected DiagnosticGroups getDiagnosticGroups() {
        if (this.compiler == null) {
            return new DiagnosticGroups();
        }
        return ((Compiler)this.compiler).getDiagnosticGroups();
    }

    @GwtIncompatible(value="Unnecessary")
    protected abstract void addAllowlistWarningsGuard(CompilerOptions var1, File var2);

    @GwtIncompatible(value="Unnecessary")
    protected static void setWarningGuardOptions(CompilerOptions options, ArrayList<FlagEntry<CheckLevel>> warningGuards, DiagnosticGroups diagnosticGroups) {
        if (warningGuards != null) {
            Set groupNames = DiagnosticGroups.getRegisteredGroups().keySet();
            for (FlagEntry<CheckLevel> entry : warningGuards) {
                if ("*".equals(((FlagEntry)entry).value)) {
                    for (String groupName : groupNames) {
                        if (DiagnosticGroups.wildcardExcludedGroups.contains(groupName)) continue;
                        diagnosticGroups.setWarningLevel(options, groupName, (CheckLevel)((FlagEntry)entry).flag);
                    }
                    continue;
                }
                if (groupNames.contains(((FlagEntry)entry).value)) {
                    diagnosticGroups.setWarningLevel(options, ((FlagEntry)entry).value, (CheckLevel)((FlagEntry)entry).flag);
                    continue;
                }
                throw new FlagUsageException("Unknown diagnostic group: '" + ((FlagEntry)entry).value + "'");
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected void setRunOptions(CompilerOptions options) throws IOException {
        HashSet<String> uniqueNames;
        DiagnosticGroups diagnosticGroups = this.getDiagnosticGroups();
        AbstractCommandLineRunner.setWarningGuardOptions(options, this.config.warningGuards, diagnosticGroups);
        if (!this.config.warningsAllowFile.isEmpty()) {
            this.addAllowlistWarningsGuard(options, new File(this.config.warningsAllowFile));
        }
        if (!this.config.hideWarningsFor.isEmpty()) {
            options.addWarningsGuard(new ShowByPathWarningsGuard(this.config.hideWarningsFor.toArray(new String[0]), ShowByPathWarningsGuard.ShowType.EXCLUDE));
        }
        ArrayList<String> define = new ArrayList<String>(this.config.define);
        if (this.config.browserFeaturesetYear != 0) {
            try {
                options.setBrowserFeaturesetYear(this.config.browserFeaturesetYear);
            }
            catch (IllegalStateException e) {
                throw new FlagUsageException(e.getMessage());
            }
        }
        AbstractCommandLineRunner.createDefineReplacements(define, options);
        options.setTweakProcessing(this.config.tweakProcessing);
        if (this.config.dependencyOptions != null) {
            options.setDependencyOptions(this.config.dependencyOptions);
        }
        options.devMode = this.config.jscompDevMode;
        options.setCodingConvention(this.config.codingConvention);
        options.setSummaryDetailLevel(this.config.summaryDetailLevel);
        options.setTrustedStrings(true);
        this.legacyOutputCharset = options.outputCharset = this.getLegacyOutputCharset();
        this.outputCharset2 = this.getOutputCharset2();
        this.inputCharset = this.getInputCharset();
        if (this.config.jsOutputFile.length() > 0 && this.config.skipNormalOutputs) {
            throw new FlagUsageException("skip_normal_outputs and js_output_file cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printAst) {
            throw new FlagUsageException("skip_normal_outputs and print_ast cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printTree) {
            throw new FlagUsageException("skip_normal_outputs and print_tree cannot be used together.");
        }
        if (this.config.createSourceMap.length() > 0) {
            options.sourceMapOutputPath = this.config.createSourceMap;
        } else if (this.isOutputInJson()) {
            options.sourceMapOutputPath = "%outname%";
        }
        options.sourceMapDetailLevel = this.config.sourceMapDetailLevel;
        options.sourceMapFormat = this.config.sourceMapFormat;
        options.sourceMapLocationMappings = this.config.sourceMapLocationMappings;
        options.parseInlineSourceMaps = this.config.parseInlineSourceMaps;
        options.applyInputSourceMaps = this.config.applyInputSourceMaps;
        ImmutableMap.Builder<String, SourceMapInput> inputSourceMaps = new ImmutableMap.Builder<String, SourceMapInput>();
        for (Map.Entry files : this.config.sourceMapInputFiles.entrySet()) {
            SourceFile sourceMap = SourceFile.builder().withKind(StaticSourceFile.SourceKind.NON_CODE).withPath((String)files.getValue()).build();
            inputSourceMaps.put((String)files.getKey(), new SourceMapInput(sourceMap));
        }
        options.inputSourceMaps = inputSourceMaps.buildOrThrow();
        if (!this.config.variableMapInputFile.isEmpty()) {
            options.inputVariableMap = VariableMap.load(this.config.variableMapInputFile);
        }
        if (!this.config.propertyMapInputFile.isEmpty()) {
            options.inputPropertyMap = VariableMap.load(this.config.propertyMapInputFile);
        }
        if (!this.config.outputManifests.isEmpty()) {
            uniqueNames = new HashSet<String>();
            for (String filename : this.config.outputManifests) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_manifest flags specify duplicate file names: " + filename);
            }
        }
        if (!this.config.outputBundles.isEmpty()) {
            uniqueNames = new HashSet();
            for (String filename : this.config.outputBundles) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_bundle flags specify duplicate file names: " + filename);
            }
        }
        options.transformAMDToCJSModules = this.config.transformAMDToCJSModules;
        options.setProcessCommonJSModules(this.config.processCommonJSModules);
        options.moduleRoots = this.config.moduleRoots;
        options.angularPass = this.config.angularPass;
        if (!this.config.jsonWarningsFile.isEmpty()) {
            options.addReportGenerator(new JsonErrorReportGenerator(new PrintStream(this.config.jsonWarningsFile), (SourceExcerptProvider)this.compiler));
        }
        if (this.config.errorFormat == CommandLineConfig.ErrorFormatOption.JSON) {
            JsonErrorReportGenerator errorGenerator = new JsonErrorReportGenerator(this.getErrorPrintStream(), (SourceExcerptProvider)this.compiler);
            ((Compiler)this.compiler).setErrorManager(new SortingErrorManager(ImmutableSet.of(errorGenerator)));
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected final A getCompiler() {
        return this.compiler;
    }

    @GwtIncompatible(value="Unnecessary")
    public static List<SourceFile> getBuiltinExterns(CompilerOptions.Environment env) throws IOException {
        try (InputStream input = AbstractCommandLineRunner.getExternsInput();){
            ZipInputStream zip = new ZipInputStream(input);
            String envPrefix = Ascii.toLowerCase(env.toString()) + "/";
            HashMap<String, SourceFile> mapFromExternsZip = new HashMap<String, SourceFile>();
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String filename = entry.getName();
                if (filename.contains("/")) {
                    if (!filename.startsWith(envPrefix)) continue;
                    filename = filename.substring(envPrefix.length());
                }
                BufferedInputStream entryStream = new BufferedInputStream(ByteStreams.limit(zip, entry.getSize()));
                mapFromExternsZip.put(filename, SourceFile.builder().withPath("externs.zip//" + filename).withContent(entryStream).build());
            }
            List<SourceFile> list = DefaultExterns.prepareExterns(env, mapFromExternsZip);
            return list;
        }
    }

    protected abstract String getVersionText();

    @GwtIncompatible(value="Unnecessary")
    private static InputStream getExternsInput() {
        InputStream input = AbstractCommandLineRunner.class.getResourceAsStream("/externs.zip");
        if (input == null) {
            input = AbstractCommandLineRunner.class.getResourceAsStream("externs.zip");
        }
        Preconditions.checkNotNull(input);
        return input;
    }

    @GwtIncompatible(value="Unnecessary")
    public final void run() {
        int result;
        try {
            result = this.doRun();
        }
        catch (FlagUsageException e) {
            this.err.println(e.getMessage());
            result = -1;
        }
        catch (Throwable t) {
            t.printStackTrace(this.err);
            result = -2;
        }
        this.exitCodeReceiver.apply(result);
    }

    @GwtIncompatible(value="Unnecessary")
    protected final PrintStream getErrorPrintStream() {
        return this.err;
    }

    @GwtIncompatible(value="Unnecessary")
    public List<JsonFileSpec> parseJsonFilesFromInputStream() throws IOException {
        ArrayList<JsonFileSpec> jsonFiles = new ArrayList<JsonFileSpec>();
        try (JsonReader reader = new JsonReader(new InputStreamReader(this.in, this.inputCharset));){
            reader.beginArray();
            while (reader.hasNext()) {
                JsonFileSpec jsonFile = (JsonFileSpec)this.gson.fromJson(reader, (Type)((Object)JsonFileSpec.class));
                jsonFiles.add(jsonFile);
            }
            reader.endArray();
        }
        return jsonFiles;
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, boolean allowStdIn, List<JsChunkSpec> jsChunkSpecs) throws IOException {
        return this.createInputs(files, null, allowStdIn, jsChunkSpecs);
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles, List<JsChunkSpec> jsChunkSpecs) throws IOException {
        return this.createInputs(files, jsonFiles, false, jsChunkSpecs);
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles, boolean allowStdIn, List<JsChunkSpec> jsChunkSpecs) throws IOException {
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(files.size());
        boolean usingStdin = false;
        int jsChunkIndex = 0;
        JsChunkSpec jsChunkSpec = Iterables.getFirst(jsChunkSpecs, null);
        int cumulatedInputFilesExpected = jsChunkSpec == null ? Integer.MAX_VALUE : jsChunkSpec.getNumInputs();
        for (int i = 0; i < files.size(); ++i) {
            FlagEntry<JsSourceType> file = files.get(i);
            String filename = ((FlagEntry)file).value;
            if (((FlagEntry)file).flag == JsSourceType.JS_ZIP) {
                if (this.config.typedAstListInputFilename != null) {
                    throw new FlagUsageException("Can't use TypedASTs with --zip.");
                }
                if (!"-".equals(filename)) {
                    List<SourceFile> newFiles = SourceFile.fromZipFile(filename, this.inputCharset);
                    if (this.rootRelativePathsMap.containsKey(filename)) {
                        String rootFilename = this.rootRelativePathsMap.get(filename);
                        for (SourceFile zipEntry : newFiles) {
                            String zipEntryName = zipEntry.getName();
                            Preconditions.checkState(zipEntryName.contains(filename));
                            String zipmap = zipEntryName.replace(filename, rootFilename);
                            this.rootRelativePathsMap.put(zipEntryName, zipmap);
                        }
                    }
                    inputs.addAll(newFiles);
                    if (jsChunkSpec != null) {
                        jsChunkSpec.numJsFiles += newFiles.size() - 1;
                    }
                }
            } else if (!"-".equals(filename)) {
                StaticSourceFile.SourceKind kind = ((FlagEntry)file).flag == JsSourceType.WEAKDEP ? StaticSourceFile.SourceKind.WEAK : StaticSourceFile.SourceKind.STRONG;
                SourceFile newFile = SourceFile.builder().withPath(filename).withCharset(this.inputCharset).withKind(kind).build();
                inputs.add(newFile);
            } else {
                if (this.config.typedAstListInputFilename != null) {
                    throw new FlagUsageException("Can't use TypedASTs with stdin.");
                }
                if (!this.config.defaultToStdin) {
                    throw new FlagUsageException("Can't specify stdin.");
                }
                if (usingStdin) {
                    throw new FlagUsageException("Can't specify stdin twice.");
                }
                if (!this.config.outputManifests.isEmpty()) {
                    throw new FlagUsageException("Manifest files cannot be generated when the input is from stdin.");
                }
                if (!this.config.outputBundles.isEmpty()) {
                    throw new FlagUsageException("Bundle files cannot be generated when the input is from stdin.");
                }
                this.err.println(WAITING_FOR_INPUT_WARNING);
                inputs.add(SourceFile.builder().withPath("stdin").withContent(this.in).withCharset(this.inputCharset).build());
                usingStdin = true;
            }
            if (i < cumulatedInputFilesExpected - 1 || ++jsChunkIndex >= jsChunkSpecs.size()) continue;
            jsChunkSpec = jsChunkSpecs.get(jsChunkIndex);
            cumulatedInputFilesExpected += jsChunkSpec.getNumInputs();
        }
        if (jsonFiles != null) {
            for (JsonFileSpec jsonFile : jsonFiles) {
                inputs.add(SourceFile.fromCode(jsonFile.getPath(), jsonFile.getSrc()));
            }
        }
        return inputs;
    }

    @GwtIncompatible(value="Unnecessary")
    private ImmutableList<JSError> deduplicateIjsFiles(List<FlagEntry<JsSourceType>> files, List<String> moduleRoots, boolean hasModuleSpecs) {
        String relativeName;
        String absoluteName;
        ImmutableList.Builder errors = ImmutableList.builder();
        HashMap<String, String> relativeToAbsoluteName = new HashMap<String, String>();
        for (FlagEntry<JsSourceType> file : files) {
            if (((FlagEntry)file).flag != JsSourceType.JS && ((FlagEntry)file).flag != JsSourceType.WEAKDEP) continue;
            absoluteName = ((FlagEntry)file).value;
            relativeName = this.getModuleRootRelativeName(absoluteName, moduleRoots);
            relativeToAbsoluteName.put(relativeName, absoluteName);
        }
        Iterator<FlagEntry<JsSourceType>> iterator = files.iterator();
        while (iterator.hasNext()) {
            FlagEntry<JsSourceType> file;
            file = iterator.next();
            if (((FlagEntry)file).flag != JsSourceType.IJS) continue;
            if (hasModuleSpecs) {
                throw new FlagUsageException("--ijs is incompatible with --chunk or --module.");
            }
            absoluteName = ((FlagEntry)file).value;
            if (!absoluteName.endsWith(".i.js")) {
                errors.add(JSError.make(IjsErrors.BAD_IJS_FILE_NAME, absoluteName));
                continue;
            }
            relativeName = this.getModuleRootRelativeName(absoluteName, moduleRoots);
            String relativeNonIjsName = relativeName.substring(0, relativeName.length() - ".i.js".length());
            if (!relativeToAbsoluteName.containsKey(relativeNonIjsName)) continue;
            errors.add(JSError.make(IjsErrors.CONFLICTING_IJS_FILE, (String)relativeToAbsoluteName.get(relativeNonIjsName), absoluteName));
            iterator.remove();
        }
        return errors.build();
    }

    private String getModuleRootRelativeName(String filename, List<String> moduleRoots) {
        for (String moduleRoot : moduleRoots) {
            if (!filename.startsWith(moduleRoot + "/")) continue;
            return filename.substring(moduleRoot.length() + 1);
        }
        return filename;
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createSourceInputs(List<JsChunkSpec> jsChunkSpecs, List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles, List<String> moduleRoots) throws IOException {
        if (this.isInTestMode()) {
            return this.inputsSupplierForTesting != null ? this.inputsSupplierForTesting.get() : null;
        }
        if (files.isEmpty() && jsonFiles == null && this.config.defaultToStdin) {
            files = ImmutableList.of(new FlagEntry<JsSourceType>(JsSourceType.JS, "-"));
        }
        for (JSError error : this.deduplicateIjsFiles(files, moduleRoots, !jsChunkSpecs.isEmpty())) {
            ((Compiler)this.compiler).report(error);
        }
        try {
            if (jsonFiles != null) {
                return this.createInputs(files, jsonFiles, jsChunkSpecs);
            }
            return this.createInputs(files, true, jsChunkSpecs);
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --js flag. " + e.getMessage());
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createExternInputs(List<String> files) throws IOException {
        ArrayList<FlagEntry<JsSourceType>> externFiles = new ArrayList<FlagEntry<JsSourceType>>();
        for (String file : files) {
            externFiles.add(new FlagEntry<JsSourceType>(JsSourceType.EXTERN, file));
        }
        try {
            return this.createInputs(externFiles, false, new ArrayList<JsChunkSpec>());
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --externs flag. " + e.getMessage());
        }
    }

    public static List<JSChunk> createJsModules(List<JsChunkSpec> specs, List<CompilerInput> inputs) throws IOException {
        Preconditions.checkState(specs != null);
        Preconditions.checkState(!specs.isEmpty());
        Preconditions.checkState(inputs != null);
        ArrayList<String> moduleNames = new ArrayList<String>(specs.size());
        LinkedHashMap<String, JSChunk> modulesByName = new LinkedHashMap<String, JSChunk>();
        LinkedHashMap<String, Integer> modulesFileCountMap = new LinkedHashMap<String, Integer>();
        int numJsFilesExpected = 0;
        int minJsFilesRequired = 0;
        for (JsChunkSpec spec : specs) {
            if (modulesByName.containsKey(spec.name)) {
                throw new FlagUsageException("Duplicate module name: " + spec.name);
            }
            JSChunk module = new JSChunk(spec.name);
            for (String dep : spec.deps) {
                JSChunk other = (JSChunk)modulesByName.get(dep);
                if (other == null) {
                    throw new FlagUsageException("Module '" + spec.name + "' depends on unknown module '" + dep + "'. Be sure to list modules in dependency order.");
                }
                module.addDependency(other);
            }
            if (spec.numJsFiles < 0) {
                numJsFilesExpected = -1;
            } else {
                minJsFilesRequired += spec.numJsFiles;
            }
            if (numJsFilesExpected >= 0) {
                numJsFilesExpected += spec.numJsFiles;
            }
            moduleNames.add(0, spec.name);
            modulesFileCountMap.put(spec.name, spec.numJsFiles);
            modulesByName.put(spec.name, module);
        }
        int totalNumJsFiles = inputs.size();
        if (numJsFilesExpected >= 0 || minJsFilesRequired > totalNumJsFiles) {
            if (minJsFilesRequired > totalNumJsFiles) {
                numJsFilesExpected = minJsFilesRequired;
            }
            if (numJsFilesExpected > totalNumJsFiles) {
                throw new FlagUsageException("Not enough JS files specified. Expected " + numJsFilesExpected + " but found " + totalNumJsFiles);
            }
            if (numJsFilesExpected < totalNumJsFiles) {
                throw new FlagUsageException("Too many JS files specified. Expected " + numJsFilesExpected + " but found " + totalNumJsFiles);
            }
        }
        int numJsFilesLeft = totalNumJsFiles;
        int moduleIndex = 0;
        for (String moduleName : moduleNames) {
            int numJsFiles = (Integer)modulesFileCountMap.get(moduleName);
            JSChunk module = (JSChunk)modulesByName.get(moduleName);
            if (moduleIndex == moduleNames.size() - 1 && numJsFiles == -1) {
                numJsFiles = numJsFilesLeft;
            }
            List<CompilerInput> moduleFiles = inputs.subList(numJsFilesLeft - numJsFiles, numJsFilesLeft);
            for (CompilerInput input : moduleFiles) {
                module.add(input);
            }
            numJsFilesLeft -= numJsFiles;
            ++moduleIndex;
        }
        return new ArrayList<JSChunk>(modulesByName.values());
    }

    @GwtIncompatible(value="Unnecessary")
    protected void checkModuleName(String name) {
        if (!TokenStream.isJSIdentifier(name)) {
            throw new FlagUsageException("Invalid module name: '" + name + "'");
        }
    }

    public static Map<String, String> parseModuleWrappers(List<String> specs, Iterable<JSChunk> chunks) {
        Preconditions.checkState(specs != null);
        HashMap<String, String> wrappers = new HashMap<String, String>();
        for (JSChunk c : chunks) {
            wrappers.put(c.getName(), "");
        }
        for (String spec : specs) {
            int pos = spec.indexOf(58);
            if (pos == -1) {
                throw new FlagUsageException("Expected module wrapper to have <name>:<wrapper> format: " + spec);
            }
            String name = spec.substring(0, pos);
            if (!wrappers.containsKey(name)) {
                throw new FlagUsageException("Unknown module: '" + name + "'");
            }
            String wrapper = spec.substring(pos + 1);
            if (!(wrapper = wrapper.replace(OUTPUT_MARKER, "%s").replace("%n%", "\n")).contains("%s")) {
                throw new FlagUsageException("No %s placeholder in module wrapper: '" + wrapper + "'");
            }
            wrappers.put(name, wrapper);
        }
        return wrappers;
    }

    private static ImmutableMap<String, String> parseModuleOutputFiles(List<String> specs) {
        Preconditions.checkArgument(specs != null);
        ImmutableMap.Builder<String, String> outputFilesBuilder = ImmutableMap.builder();
        for (String spec : specs) {
            int pos = spec.indexOf(58);
            if (pos == -1) {
                throw new FlagUsageException("Expected chunk_output_file to have <name>:<output_file> format: " + spec);
            }
            String name = spec.substring(0, pos);
            String filename = spec.substring(pos + 1);
            outputFilesBuilder.put(name, filename);
        }
        return outputFilesBuilder.buildOrThrow();
    }

    @GwtIncompatible(value="Unnecessary")
    @VisibleForTesting
    String getModuleOutputFileName(JSChunk m) {
        String outputFile;
        if (this.parsedModuleOutputFiles == null) {
            this.parsedModuleOutputFiles = AbstractCommandLineRunner.parseModuleOutputFiles(this.config.moduleOutputFiles);
        }
        if ((outputFile = this.parsedModuleOutputFiles.get(m.getName())) != null) {
            return this.config.moduleOutputPathPrefix + outputFile;
        }
        return this.config.moduleOutputPathPrefix + m.getName() + ".js";
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void writeModuleOutput(String fileName, Appendable out, JSChunk m) throws IOException {
        if (this.parsedModuleWrappers == null) {
            this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, ImmutableList.copyOf(((Compiler)this.compiler).getModuleGraph().getAllChunks()));
        }
        if (!this.isOutputInJson()) {
            AbstractCommandLineRunner.maybeCreateDirsForPath(fileName);
        }
        String baseName = new File(fileName).getName();
        this.writeOutput(out, (Compiler)this.compiler, m, this.parsedModuleWrappers.get(m.getName()).replace("%basename%", baseName), "%s", null, fileName);
    }

    @GwtIncompatible(value="Unnecessary")
    void writeOutput(Appendable out, Compiler compiler, @Nullable JSChunk module, String wrapper, String codePlaceholder, @Nullable Function<String, String> escaper, String filename) throws IOException {
        if (compiler.getOptions().outputJs == CompilerOptions.OutputJs.SENTINEL) {
            out.append("// No JS output because the compiler was run in checks-only mode.\n");
            return;
        }
        Preconditions.checkState(compiler.getOptions().outputJs == CompilerOptions.OutputJs.NORMAL);
        String code = module == null ? compiler.toSource() : compiler.toSource(module);
        this.writeOutput(out, compiler, code, wrapper, codePlaceholder, escaper, filename);
    }

    @GwtIncompatible(value="Unnecessary")
    @VisibleForTesting
    void writeOutput(Appendable out, Compiler compiler, String code, String wrapper, String codePlaceholder, @Nullable Function<String, String> escaper, String filename) throws IOException {
        int pos = wrapper.indexOf(codePlaceholder);
        if (pos != -1) {
            String prefix = "";
            if (pos > 0) {
                prefix = wrapper.substring(0, pos);
                out.append(prefix);
            }
            out.append(escaper == null ? code : (CharSequence)escaper.apply(code));
            int suffixStart = pos + codePlaceholder.length();
            if (suffixStart != wrapper.length()) {
                out.append(wrapper.substring(suffixStart));
            }
            out.append('\n');
            if (compiler != null && compiler.getSourceMap() != null) {
                compiler.getSourceMap().setWrapperPrefix(prefix);
            }
        } else {
            out.append(code);
            out.append('\n');
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private static void maybeCreateDirsForPath(String pathPrefix) {
        if (!Strings.isNullOrEmpty(pathPrefix)) {
            String dirName;
            String string = dirName = pathPrefix.charAt(pathPrefix.length() - 1) == File.separatorChar ? pathPrefix.substring(0, pathPrefix.length() - 1) : new File(pathPrefix).getParent();
            if (dirName != null) {
                new File(dirName).mkdirs();
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private Appendable createDefaultOutput() throws IOException {
        boolean writeOutputToFile;
        boolean bl = writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        if (writeOutputToFile) {
            return this.fileNameToLegacyOutputWriter(this.config.jsOutputFile);
        }
        return this.streamToLegacyOutputWriter(this.defaultJsOutput);
    }

    @GwtIncompatible(value="Unnecessary")
    private static void closeAppendable(Appendable output) throws IOException {
        if (output instanceof Flushable) {
            ((Flushable)((Object)output)).flush();
        }
        if (output instanceof Closeable) {
            ((Closeable)((Object)output)).close();
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected int doRun() throws IOException {
        CompileMetricsRecorderInterface metricsRecorder = this.getCompileMetricsRecorder();
        metricsRecorder.recordActionStart();
        if (this.config.printVersion) {
            this.defaultJsOutput.println(this.getVersionText());
            this.defaultJsOutput.flush();
            return 0;
        }
        Compiler.setLoggingLevel(Level.parse(this.config.loggingLevel));
        this.compiler = this.createCompiler();
        B options = this.createOptions();
        this.setRunOptions((CompilerOptions)options);
        String typedAstListInputFilename = this.config.typedAstListInputFilename;
        List<SourceFile> externs = this.createExterns((CompilerOptions)options);
        List<JSChunk> modules = null;
        Result result = null;
        this.rootRelativePathsMap = this.constructRootRelativePathsMap();
        boolean writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        ArrayList<String> outputFileNames = new ArrayList<String>();
        if (writeOutputToFile) {
            outputFileNames.add(this.config.jsOutputFile);
        }
        boolean createCommonJsModules = false;
        if (((CompilerOptions)options).getProcessCommonJSModules() && this.config.module.size() == 1 && "auto".equals(this.config.module.get(0))) {
            createCommonJsModules = true;
            this.config.module.remove(0);
        }
        ArrayList<JsChunkSpec> jsChunkSpecs = new ArrayList<JsChunkSpec>();
        for (int i = 0; i < this.config.module.size(); ++i) {
            jsChunkSpecs.add(JsChunkSpec.create((String)this.config.module.get(i), i == 0));
        }
        List<JsonFileSpec> jsonFiles = null;
        if (this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.IN || this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.BOTH) {
            jsonFiles = this.parseJsonFilesFromInputStream();
            ImmutableMap.Builder<String, SourceMapInput> inputSourceMaps = new ImmutableMap.Builder<String, SourceMapInput>();
            ImmutableMap.Builder<String, String> inputPathByWebpackId = new ImmutableMap.Builder<String, String>();
            boolean foundJsonInputSourceMap = false;
            for (JsonFileSpec jsonFile : jsonFiles) {
                if (jsonFile.getSourceMap() != null && jsonFile.getSourceMap().length() > 0) {
                    String sourceMapPath = jsonFile.getPath() + ".map";
                    SourceFile sourceMap = SourceFile.fromCode(sourceMapPath, jsonFile.getSourceMap());
                    inputSourceMaps.put(jsonFile.getPath(), new SourceMapInput(sourceMap));
                    foundJsonInputSourceMap = true;
                }
                if (jsonFile.getWebpackId() == null) continue;
                inputPathByWebpackId.put(jsonFile.getWebpackId(), jsonFile.getPath());
            }
            if (foundJsonInputSourceMap) {
                inputSourceMaps.putAll(((CompilerOptions)options).inputSourceMaps);
                ((CompilerOptions)options).inputSourceMaps = inputSourceMaps.buildOrThrow();
            }
            ((Compiler)this.compiler).initWebpackMap(inputPathByWebpackId.buildOrThrow());
        } else {
            ImmutableMap<String, String> emptyMap = ImmutableMap.of();
            ((Compiler)this.compiler).initWebpackMap(emptyMap);
        }
        ((CompilerOptions)options).setDoLateLocalization(this.config.shouldDoLateLocalization());
        ((Compiler)this.compiler).initOptions((CompilerOptions)options);
        List<SourceFile> sources = this.createSourceInputs(jsChunkSpecs, this.config.mixedJsSources, jsonFiles, this.config.moduleRoots);
        if (!jsChunkSpecs.isEmpty()) {
            if (this.isInTestMode()) {
                modules = this.modulesSupplierForTesting.get();
            } else {
                if (CompilerOptions.JsonStreamMode.IN.equals((Object)this.config.jsonStreamMode) || CompilerOptions.JsonStreamMode.NONE.equals((Object)this.config.jsonStreamMode)) {
                    for (JsChunkSpec m : jsChunkSpecs) {
                        this.checkModuleName(m.getName());
                    }
                }
                Iterator<Object> inputs = ImmutableList.builder();
                for (SourceFile source : sources) {
                    ((ImmutableList.Builder)((Object)inputs)).add(new CompilerInput(source, false));
                }
                modules = AbstractCommandLineRunner.createJsModules(jsChunkSpecs, (List<CompilerInput>)((Object)((ImmutableList.Builder)((Object)inputs)).build()));
            }
            for (JSChunk m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
            if (typedAstListInputFilename != null) {
                this.initModulesWithTypedAstFilesystem(externs, modules, (CompilerOptions)options, typedAstListInputFilename);
            } else {
                ((Compiler)this.compiler).initModules(externs, modules, (CompilerOptions)options);
            }
        } else if (typedAstListInputFilename != null) {
            this.initWithTypedAstFilesystem(externs, sources, (CompilerOptions)options, typedAstListInputFilename);
        } else {
            ((Compiler)this.compiler).init(externs, sources, (CompilerOptions)options);
        }
        if (((CompilerOptions)options).printConfig) {
            ((Compiler)this.compiler).printConfig();
        }
        if (this.config.skipNormalOutputs) {
            metricsRecorder.recordActionName("skip normal outputs");
            ((Compiler)this.compiler).orderInputsWithLargeStack();
        } else if (((Compiler)this.compiler).hasErrors()) {
            metricsRecorder.recordActionName("initialization errors occurred");
            ((Compiler)this.compiler).generateReport();
            result = ((Compiler)this.compiler).getResult();
        } else if (((CompilerOptions)options).getInstrumentForCoverageOnly()) {
            result = this.instrumentForCoverage(metricsRecorder);
        } else if (this.config.shouldSaveAfterStage1()) {
            result = this.performStage1andSave(this.config.getSaveCompilationStateToFilename(), metricsRecorder);
        } else if (typedAstListInputFilename != null) {
            result = this.parseAndPerformStages2and3(metricsRecorder);
        } else if (this.config.shouldRestoreAndPerformStage2AndSave()) {
            result = this.restoreAndPerformStage2AndSave(this.config.getContinueSavedCompilationFileName(), this.config.getSaveCompilationStateToFilename(), metricsRecorder);
        } else if (this.config.shouldRestoreAndPerformStages2And3()) {
            result = this.restoreAndPerformStages2and3(this.config.getContinueSavedCompilationFileName(), metricsRecorder);
            if (modules != null) {
                modules = ImmutableList.copyOf(((Compiler)this.compiler).getModules());
            }
        } else if (this.config.shouldRestoreAndPerformStage3()) {
            result = this.restoreAndPerformStage3(this.config.getContinueSavedCompilationFileName(), metricsRecorder);
            if (modules != null) {
                modules = ImmutableList.copyOf(((Compiler)this.compiler).getModules());
            }
        } else {
            result = this.performFullCompilation(metricsRecorder);
        }
        if (createCommonJsModules) {
            modules = ImmutableList.copyOf(((Compiler)this.compiler).getModules());
            for (JSChunk m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
        }
        for (String outputFileName : outputFileNames) {
            if (((Compiler)this.compiler).getSourceFileByName(outputFileName) == null) continue;
            ((Compiler)this.compiler).report(JSError.make(OUTPUT_SAME_AS_INPUT_ERROR, outputFileName));
            return 1;
        }
        int exitStatus = this.processResults(result, modules, options);
        metricsRecorder.recordResultMetrics((AbstractCompiler)this.compiler, result);
        return exitStatus;
    }

    protected CompileMetricsRecorderInterface getCompileMetricsRecorder() {
        return new DummyCompileMetricsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result performStage1andSave(String filename, CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName("stage 1");
        try (BufferedOutputStream serializedOutputStream = new BufferedOutputStream(new FileOutputStream(filename));){
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage1Passes();
            }
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).saveState(serializedOutputStream);
            }
            ((Compiler)this.compiler).performPostCompilationTasks();
        }
        catch (IOException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_SERIALIZE_AST, filename));
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    private void initWithTypedAstFilesystem(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions options, String filename) {
        try (BufferedInputStream typedAstListStream = new BufferedInputStream(new FileInputStream(filename));){
            ((Compiler)this.compiler).initWithTypedAstFilesystem(externs, sources, options, typedAstListStream);
        }
        catch (IOException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, filename));
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void initModulesWithTypedAstFilesystem(List<SourceFile> externs, List<JSChunk> chunks, CompilerOptions options, String filename) {
        try (BufferedInputStream typedAstListStream = new BufferedInputStream(new FileInputStream(filename));){
            ((Compiler)this.compiler).initModulesWithTypedAstFilesystem(externs, chunks, options, typedAstListStream);
        }
        catch (IOException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, filename));
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private Result parseAndPerformStages2and3(CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName("skip-checks compile");
        try {
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage2Passes();
                if (!((Compiler)this.compiler).hasErrors()) {
                    ((Compiler)this.compiler).stage3Passes();
                }
                ((Compiler)this.compiler).performPostCompilationTasks();
            }
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        return ((Compiler)this.compiler).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result restoreAndPerformStage2AndSave(String inputFilename, String outputFilename, CompileMetricsRecorderInterface metricsRecorder) {
        block17: {
            metricsRecorder.recordActionName("stage 2/3");
            try (BufferedInputStream serializedInputStream = new BufferedInputStream(new FileInputStream(inputFilename));){
                ((Compiler)this.compiler).restoreState(serializedInputStream);
                if (((Compiler)this.compiler).hasErrors()) break block17;
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage2Passes();
                if (((Compiler)this.compiler).hasErrors()) break block17;
                try (BufferedOutputStream serializedOutputStream = new BufferedOutputStream(new FileOutputStream(outputFilename));){
                    ((Compiler)this.compiler).saveState(serializedOutputStream);
                }
                catch (IOException e) {
                    ((Compiler)this.compiler).report(JSError.make(COULD_NOT_SERIALIZE_AST, outputFilename));
                }
                ((Compiler)this.compiler).performPostCompilationTasks();
            }
            catch (IOException | ClassNotFoundException e) {
                ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, inputFilename));
            }
            finally {
                ((Compiler)this.compiler).generateReport();
            }
        }
        return ((Compiler)this.compiler).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result restoreAndPerformStages2and3(String filename, CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName("stage 2/2");
        try (BufferedInputStream serializedInputStream = new BufferedInputStream(new FileInputStream(filename));){
            ((Compiler)this.compiler).restoreState(serializedInputStream);
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage2Passes();
                if (!((Compiler)this.compiler).hasErrors()) {
                    ((Compiler)this.compiler).stage3Passes();
                }
            }
            ((Compiler)this.compiler).performPostCompilationTasks();
        }
        catch (IOException | ClassNotFoundException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, filename));
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        return ((Compiler)this.compiler).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result restoreAndPerformStage3(String filename, CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName("stage 3/3");
        try (BufferedInputStream serializedInputStream = new BufferedInputStream(new FileInputStream(filename));){
            ((Compiler)this.compiler).restoreState(serializedInputStream);
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage3Passes();
            }
            ((Compiler)this.compiler).performPostCompilationTasks();
        }
        catch (IOException | ClassNotFoundException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, filename));
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        return ((Compiler)this.compiler).getResult();
    }

    @GwtIncompatible(value="Unnecessary")
    private Result performFullCompilation(CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName(((Compiler)this.compiler).getOptions().checksOnly ? "checks-only" : "full compile");
        try {
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).stage1Passes();
                if (!((Compiler)this.compiler).hasErrors()) {
                    ((Compiler)this.compiler).stage2Passes();
                    if (!((Compiler)this.compiler).hasErrors()) {
                        ((Compiler)this.compiler).stage3Passes();
                    }
                }
                ((Compiler)this.compiler).performPostCompilationTasks();
            }
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    private Result instrumentForCoverage(CompileMetricsRecorderInterface metricsRecorder) {
        metricsRecorder.recordActionName("instrument for coverage");
        try {
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                metricsRecorder.recordStartState((AbstractCompiler)this.compiler);
                ((Compiler)this.compiler).instrumentForCoverage();
            }
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    int processResults(Result result, List<JSChunk> modules, B options) throws IOException {
        if (this.config.printPassGraph) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            jsOutput.append(DotFormatter.toDot(((Compiler)this.compiler).getPassConfig().getPassGraph()));
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printAst) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ControlFlowGraph<Node> cfg = ((Compiler)this.compiler).computeCFG();
            DotFormatter.appendDot(((Compiler)this.compiler).getRoot().getLastChild(), cfg, jsOutput);
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printTree) {
            if (((Compiler)this.compiler).getRoot() == null) {
                ((Compiler)this.compiler).report(JSError.make(NO_TREE_GENERATED_ERROR, new String[0]));
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ((Compiler)this.compiler).getRoot().appendStringTree(jsOutput);
            jsOutput.append("\n");
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.skipNormalOutputs) {
            this.outputManifest();
            this.outputBundle();
            this.outputModuleGraphJson();
            return 0;
        }
        if (((CompilerOptions)options).outputJs != CompilerOptions.OutputJs.NONE && result.success) {
            this.outputModuleGraphJson();
            if (modules == null) {
                this.outputSingleBinary(options);
                if (!this.isOutputInJson()) {
                    this.outputSourceMap(options, this.config.jsOutputFile);
                }
            } else {
                DiagnosticType error = this.outputModuleBinaryAndSourceMaps(((Compiler)this.compiler).getModules(), options);
                if (error != null) {
                    ((Compiler)this.compiler).report(JSError.make(error, new String[0]));
                    return 1;
                }
            }
            if (((CompilerOptions)options).externExportsPath != null) {
                try (Writer eeOut = this.openExternExportsStream(options, this.config.jsOutputFile);){
                    eeOut.append(result.externExport);
                }
            }
            this.outputNameMaps();
            this.outputStringMap();
            this.outputManifest();
            this.outputBundle();
            this.outputInstrumentationMapping();
            if (this.isOutputInJson()) {
                this.outputJsonStream();
            }
        }
        return Math.min(result.errors.size(), 127);
    }

    @GwtIncompatible(value="Unnecessary")
    Function<String, String> getJavascriptEscaper() {
        return SourceCodeEscapers.javascriptEscaper().asFunction();
    }

    @GwtIncompatible(value="Unnecessary")
    void outputSingleBinary(B options) throws IOException {
        Function<String, String> escaper = null;
        String marker = OUTPUT_MARKER;
        if (this.config.outputWrapper.contains(OUTPUT_MARKER_JS_STRING)) {
            marker = OUTPUT_MARKER_JS_STRING;
            escaper = this.getJavascriptEscaper();
        }
        if (this.isOutputInJson()) {
            this.filesToStreamOut.add(this.createJsonFile(options, marker, escaper));
        } else {
            if (!this.config.jsOutputFile.isEmpty()) {
                AbstractCommandLineRunner.maybeCreateDirsForPath(this.config.jsOutputFile);
            }
            Appendable jsOutput = this.createDefaultOutput();
            this.writeOutput(jsOutput, (Compiler)this.compiler, (JSChunk)null, this.config.outputWrapper, marker, escaper, this.config.jsOutputFile);
            AbstractCommandLineRunner.closeAppendable(jsOutput);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    JsonFileSpec createJsonFile(B options, String outputMarker, Function<String, String> escaper) throws IOException {
        StringBuilder jsOutput = new StringBuilder();
        this.writeOutput((Appendable)jsOutput, (Compiler)this.compiler, (JSChunk)null, this.config.outputWrapper, outputMarker, escaper, this.config.jsOutputFile);
        JsonFileSpec jsonOutput = new JsonFileSpec(((Object)jsOutput).toString(), Strings.isNullOrEmpty(this.config.jsOutputFile) ? "compiled.js" : this.config.jsOutputFile);
        if (!Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath)) {
            StringBuilder sourcemap = new StringBuilder();
            ((Compiler)this.compiler).getSourceMap().appendTo(sourcemap, jsonOutput.getPath());
            jsonOutput.setSourceMap(sourcemap.toString());
        }
        return jsonOutput;
    }

    @GwtIncompatible(value="Unnecessary")
    void outputJsonStream() throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.defaultJsOutput, StandardCharsets.UTF_8)));){
            Gson gsonOut = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            Type filesCollectionType = new TypeToken<List<JsChunkSpec>>(){}.getType();
            gsonOut.toJson(this.filesToStreamOut, filesCollectionType, jsonWriter);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private DiagnosticType outputModuleBinaryAndSourceMaps(Iterable<JSChunk> modules, B options) throws IOException {
        this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, modules);
        if (!this.isOutputInJson()) {
            AbstractCommandLineRunner.maybeCreateDirsForPath(this.config.moduleOutputPathPrefix);
        }
        Writer mapFileOut = null;
        if (!this.shouldGenerateMapPerModule(options) && ((CompilerOptions)options).sourceMapOutputPath != null && this.config.jsonStreamMode != CompilerOptions.JsonStreamMode.OUT && this.config.jsonStreamMode != CompilerOptions.JsonStreamMode.BOTH) {
            return INVALID_MODULE_SOURCEMAP_PATTERN;
        }
        for (JSChunk m : modules) {
            if (m.getName().equals("$weak$")) continue;
            if (this.isOutputInJson()) {
                this.filesToStreamOut.add(this.createJsonFileFromModule(m));
                continue;
            }
            if (this.shouldGenerateMapPerModule(options)) {
                mapFileOut = this.fileNameToOutputWriter2(this.expandSourceMapPath(options, m));
            }
            String moduleFilename = this.getModuleOutputFileName(m);
            AbstractCommandLineRunner.maybeCreateDirsForPath(moduleFilename);
            try (Writer writer = this.fileNameToLegacyOutputWriter(moduleFilename);){
                if (((CompilerOptions)options).sourceMapOutputPath != null) {
                    ((Compiler)this.compiler).resetAndIntitializeSourceMap();
                }
                this.writeModuleOutput(moduleFilename, writer, m);
                if (((CompilerOptions)options).sourceMapOutputPath != null) {
                    ((Compiler)this.compiler).getSourceMap().appendTo(mapFileOut, moduleFilename);
                }
            }
            if (!this.shouldGenerateMapPerModule(options) || mapFileOut == null) continue;
            mapFileOut.close();
            mapFileOut = null;
        }
        if (mapFileOut != null) {
            mapFileOut.close();
        }
        return null;
    }

    @GwtIncompatible(value="Unnecessary")
    private JsonFileSpec createJsonFileFromModule(JSChunk module) throws IOException {
        ((Compiler)this.compiler).resetAndIntitializeSourceMap();
        String filename = this.getModuleOutputFileName(module);
        StringBuilder output = new StringBuilder();
        this.writeModuleOutput(filename, output, module);
        JsonFileSpec jsonFile = new JsonFileSpec(output.toString(), filename);
        StringBuilder moduleSourceMap = new StringBuilder();
        ((Compiler)this.compiler).getSourceMap().appendTo(moduleSourceMap, this.getModuleOutputFileName(module));
        jsonFile.setSourceMap(moduleSourceMap.toString());
        return jsonFile;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getInputCharset() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.UTF_8;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getLegacyOutputCharset() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.US_ASCII;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getOutputCharset2() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.UTF_8;
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createExterns(CompilerOptions options) throws IOException {
        return this.isInTestMode() ? this.externsSupplierForTesting.get() : this.createExternInputs(this.config.externs);
    }

    @GwtIncompatible(value="Unnecessary")
    protected boolean shouldGenerateMapPerModule(B options) {
        return ((CompilerOptions)options).sourceMapOutputPath != null && ((CompilerOptions)options).sourceMapOutputPath.contains("%outname%");
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer openExternExportsStream(B options, String path) throws IOException {
        if (((CompilerOptions)options).externExportsPath == null) {
            return null;
        }
        String exPath = ((CompilerOptions)options).externExportsPath;
        if (!exPath.contains(File.separator)) {
            File outputFile = new File(path);
            exPath = outputFile.getParent() + File.separatorChar + exPath;
        }
        return this.fileNameToOutputWriter2(exPath);
    }

    @GwtIncompatible(value="Unnecessary")
    private String expandCommandLinePath(String path, JSChunk forModule) {
        String sub = forModule != null ? this.getModuleOutputFileName(forModule) : (!this.config.module.isEmpty() ? this.config.moduleOutputPathPrefix : this.config.jsOutputFile);
        return path.replace("%outname%", sub);
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    String expandSourceMapPath(B options, JSChunk forModule) {
        if (Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath)) {
            return null;
        }
        return this.expandCommandLinePath(((CompilerOptions)options).sourceMapOutputPath, forModule);
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer fileNameToLegacyOutputWriter(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.isInTestMode()) {
            return new StringWriter();
        }
        return this.streamToLegacyOutputWriter(this.filenameToOutputStream(fileName));
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer fileNameToOutputWriter2(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.isInTestMode()) {
            return new StringWriter();
        }
        return this.streamToOutputWriter2(this.filenameToOutputStream(fileName));
    }

    @GwtIncompatible(value="Unnecessary")
    protected OutputStream filenameToOutputStream(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        return new FileOutputStream(fileName);
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer streamToLegacyOutputWriter(OutputStream stream) throws IOException {
        if (this.legacyOutputCharset == null) {
            return new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.legacyOutputCharset));
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer streamToOutputWriter2(OutputStream stream) {
        if (this.outputCharset2 == null) {
            return new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.outputCharset2));
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputSourceMap(B options, String associatedName) throws IOException {
        if (Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath) || ((CompilerOptions)options).sourceMapOutputPath.equals("/dev/null")) {
            return;
        }
        String outName = this.expandSourceMapPath(options, null);
        AbstractCommandLineRunner.maybeCreateDirsForPath(outName);
        try (Writer out = this.fileNameToOutputWriter2(outName);){
            ((Compiler)this.compiler).getSourceMap().appendTo(out, associatedName);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private String getMapPath(String outputFile) {
        String basePath = "";
        if (outputFile.isEmpty()) {
            basePath = !this.config.moduleOutputPathPrefix.isEmpty() ? this.config.moduleOutputPathPrefix : "jscompiler";
        } else {
            String fileParent;
            File file = new File(outputFile);
            String outputFileName = file.getName();
            if (outputFileName.endsWith(".js")) {
                outputFileName = outputFileName.substring(0, outputFileName.length() - 3);
            }
            basePath = (fileParent = file.getParent()) == null ? outputFileName : file.getParent() + File.separatorChar + outputFileName;
        }
        return basePath;
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputNameMaps() throws IOException {
        String propertyMapOutputPath = null;
        String variableMapOutputPath = null;
        if (this.config.createNameMapFiles) {
            String basePath = this.getMapPath(this.config.jsOutputFile);
            propertyMapOutputPath = basePath + "_props_map.out";
            variableMapOutputPath = basePath + "_vars_map.out";
        }
        if (!this.config.variableMapOutputFile.isEmpty()) {
            if (variableMapOutputPath != null) {
                throw new FlagUsageException("The flags variable_map_output_file and create_name_map_files cannot both be used simultaneously.");
            }
            variableMapOutputPath = this.config.variableMapOutputFile;
        }
        if (!this.config.propertyMapOutputFile.isEmpty()) {
            if (propertyMapOutputPath != null) {
                throw new FlagUsageException("The flags property_map_output_file and create_name_map_files cannot both be used simultaneously.");
            }
            propertyMapOutputPath = this.config.propertyMapOutputFile;
        }
        if (variableMapOutputPath != null && ((Compiler)this.compiler).getVariableMap() != null) {
            ((Compiler)this.compiler).getVariableMap().save(variableMapOutputPath);
        }
        if (propertyMapOutputPath != null && ((Compiler)this.compiler).getPropertyMap() != null) {
            ((Compiler)this.compiler).getPropertyMap().save(propertyMapOutputPath);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputStringMap() throws IOException {
        if (!this.config.stringMapOutputPath.isEmpty()) {
            if (((Compiler)this.compiler).getStringMap() == null) {
                if (!new File(this.config.stringMapOutputPath).createNewFile()) {
                    throw new IOException("Could not create file: " + this.config.stringMapOutputPath);
                }
            } else {
                ((Compiler)this.compiler).getStringMap().save(this.config.stringMapOutputPath);
            }
        }
    }

    @VisibleForTesting
    public static void createDefineReplacements(List<String> definitions, CompilerOptions options) {
        for (String override : definitions) {
            block8: {
                String[] assignment = override.split("=", 2);
                String defName = assignment[0];
                if (defName.length() > 0) {
                    String defValue = assignment.length == 1 ? "true" : assignment[1];
                    boolean isTrue = defValue.equals("true");
                    boolean isFalse = defValue.equals("false");
                    if (isTrue || isFalse) {
                        options.setDefineToBooleanLiteral(defName, isTrue);
                        continue;
                    }
                    if (defValue.length() > 1 && (defValue.charAt(0) == '\'' && defValue.charAt(defValue.length() - 1) == '\'' || defValue.charAt(0) == '\"' && defValue.charAt(defValue.length() - 1) == '\"')) {
                        String maybeStringVal = defValue.substring(1, defValue.length() - 1);
                        if (maybeStringVal.indexOf(defValue.charAt(0)) == -1) {
                            options.setDefineToStringLiteral(defName, maybeStringVal);
                            continue;
                        }
                    } else {
                        try {
                            double value = Double.parseDouble(defValue);
                            options.setDefineToDoubleLiteral(defName, value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (defValue.length() <= 0) break block8;
                            options.setDefineToStringLiteral(defName, defValue);
                        }
                        continue;
                    }
                }
            }
            throw new RuntimeException("--define flag syntax invalid: " + override);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private boolean shouldGenerateOutputPerModule(String output) {
        return !this.config.module.isEmpty() && output != null && output.contains("%outname%");
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputManifest() throws IOException {
        this.outputManifestOrBundle(this.config.outputManifests, true);
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputBundle() throws IOException {
        this.outputManifestOrBundle(this.config.outputBundles, false);
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputInstrumentationMapping() throws IOException {
        if (!Strings.isNullOrEmpty(this.config.instrumentationMappingFile)) {
            String path = this.expandCommandLinePath(this.config.instrumentationMappingFile, null);
            ((Compiler)this.compiler).getInstrumentationMapping().save(path);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputManifestOrBundle(List<String> outputFiles, boolean isManifest) throws IOException {
        if (outputFiles.isEmpty()) {
            return;
        }
        for (String output : outputFiles) {
            if (output.isEmpty()) continue;
            if (this.shouldGenerateOutputPerModule(output)) {
                Iterable<JSChunk> modules = ((Compiler)this.compiler).getModuleGraph().getAllChunks();
                for (JSChunk module : modules) {
                    Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, module));
                    try {
                        if (isManifest) {
                            this.printManifestTo(module, out);
                            continue;
                        }
                        this.printBundleTo(module, out);
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
                continue;
            }
            Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, null));
            try {
                if (this.config.module.isEmpty()) {
                    JSChunk module = ((Compiler)this.compiler).getModuleGraph().getChunkByName("$strong$");
                    if (isManifest) {
                        this.printManifestTo(module, out);
                        continue;
                    }
                    this.printBundleTo(module, out);
                    continue;
                }
                this.printModuleGraphManifestOrBundleTo(((Compiler)this.compiler).getModuleGraph(), out, isManifest);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputModuleGraphJson() throws IOException {
        if (this.config.outputModuleDependencies != null && this.config.outputModuleDependencies.length() != 0) {
            try (Writer out = this.fileNameToOutputWriter2(this.config.outputModuleDependencies);){
                this.printModuleGraphJsonTo(out);
            }
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printModuleGraphJsonTo(Appendable out) throws IOException {
        out.append(((Compiler)this.compiler).getModuleGraph().toJson().toString());
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printModuleGraphManifestOrBundleTo(JSChunkGraph graph, Appendable out, boolean isManifest) throws IOException {
        Joiner commas = Joiner.on(",");
        boolean requiresNewline = false;
        for (JSChunk module : graph.getAllChunks()) {
            if (!isManifest && module.isWeak()) continue;
            if (requiresNewline) {
                out.append("\n");
            }
            if (isManifest) {
                String dependencies = commas.join(module.getSortedDependencyNames());
                out.append(String.format("{%s%s}\n", module.getName(), dependencies.isEmpty() ? "" : ":" + dependencies));
                this.printManifestTo(module, out);
            } else {
                this.printBundleTo(module, out);
            }
            requiresNewline = true;
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printManifestTo(JSChunk module, Appendable out) throws IOException {
        for (CompilerInput input : module.getInputs()) {
            String name = input.getName();
            if (Compiler.isFillFileName(name)) continue;
            String rootRelativePath = this.rootRelativePathsMap.get(name);
            String displayName = rootRelativePath != null ? rootRelativePath : name;
            out.append(displayName);
            out.append("\n");
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printBundleTo(JSChunk module, Appendable out) throws IOException {
        List<CompilerInput> inputs = module.getInputs();
        if (((Compiler)this.compiler).getOptions().numParallelThreads > 1) {
            new PrebuildAst((AbstractCompiler)this.compiler, ((Compiler)this.compiler).getOptions().numParallelThreads).prebuild(inputs);
        }
        if (!((Compiler)this.compiler).getOptions().preventLibraryInjection) {
            for (CompilerInput input : inputs) {
                if (!"es6".equals(input.getLoadFlags().get("module"))) continue;
                this.appendRuntimeTo(out);
                break;
            }
        }
        for (CompilerInput input : inputs) {
            String name = input.getName();
            String code = input.getSourceFile().getCode();
            if (Compiler.isFillFileName(name) && code.isEmpty()) continue;
            String rootRelativePath = this.rootRelativePathsMap.get(name);
            String displayName = rootRelativePath != null ? rootRelativePath : input.getName();
            out.append("//");
            out.append(displayName);
            out.append("\n");
            this.prepForBundleAndAppendTo(out, input, code);
            out.append("\n");
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> constructRootRelativePathsMap() {
        LinkedHashMap<String, String> rootRelativePathsMap = new LinkedHashMap<String, String>();
        for (String mapString : this.config.manifestMaps) {
            int colonIndex = mapString.indexOf(58);
            Preconditions.checkState(colonIndex > 0);
            String execPath = mapString.substring(0, colonIndex);
            String rootRelativePath = mapString.substring(colonIndex + 1);
            Preconditions.checkState(rootRelativePath.indexOf(58) == -1);
            rootRelativePathsMap.put(execPath, rootRelativePath);
        }
        return rootRelativePathsMap;
    }

    @GwtIncompatible(value="Unnecessary")
    static final class SystemExitCodeReceiver
    implements Function<Integer, Void> {
        static final SystemExitCodeReceiver INSTANCE = new SystemExitCodeReceiver();

        private SystemExitCodeReceiver() {
        }

        @Override
        public Void apply(Integer exitCode) {
            int exitCodeValue = Preconditions.checkNotNull(exitCode);
            int exitCodeByte = exitCodeValue;
            if (exitCodeByte == 0 && exitCodeValue != 0) {
                exitCodeByte = -1;
            }
            System.exit(exitCodeByte);
            return null;
        }
    }

    public static class JsChunkSpec {
        private final String name;
        private final int numInputs;
        private final ImmutableList<String> deps;
        private int numJsFiles;

        private JsChunkSpec(String name, int numInputs, ImmutableList<String> deps) {
            this.name = name;
            this.numInputs = numInputs;
            this.deps = deps;
            this.numJsFiles = numInputs;
        }

        public static JsChunkSpec create(String specString, boolean isFirstChunk) {
            String[] parts = specString.split(":");
            if (parts.length < 2 || parts.length > 4) {
                throw new FlagUsageException("Expected 2-4 colon-delimited parts in chunk spec: " + specString);
            }
            String name = parts[0];
            String[] deps = parts.length > 2 && parts[2].length() > 0 ? parts[2].split(",") : new String[]{};
            int numInputs = -1;
            try {
                numInputs = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignored) {
                numInputs = -1;
            }
            if (numInputs < 0) {
                if (parts.length == 2 && "auto".equals(parts[1])) {
                    if (!isFirstChunk) {
                        throw new FlagUsageException("Invalid JS file count '" + parts[1] + "' for module: " + name + ". Only the first module may specify a size of 'auto' and it must have no dependencies.");
                    }
                } else {
                    throw new FlagUsageException("Invalid JS file count '" + parts[1] + "' for module: " + name);
                }
            }
            return new JsChunkSpec(name, numInputs, ImmutableList.copyOf(deps));
        }

        public String getName() {
            return this.name;
        }

        public int getNumInputs() {
            return this.numInputs;
        }

        public ImmutableList<String> getDeps() {
            return this.deps;
        }

        public int getNumJsFiles() {
            return this.numJsFiles;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static class FlagEntry<T> {
        private final T flag;
        private final String value;

        protected FlagEntry(T flag, String value) {
            this.flag = flag;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof FlagEntry) {
                FlagEntry that = (FlagEntry)o;
                return that.flag.equals(this.flag) && that.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.flag.hashCode() + this.value.hashCode();
        }

        public String toString() {
            return this.flag + "=" + this.value;
        }

        public T getFlag() {
            return this.flag;
        }

        public String getValue() {
            return this.value;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static enum JsSourceType {
        EXTERN("extern"),
        JS("js"),
        JS_ZIP("jszip"),
        WEAKDEP("weakdep"),
        IJS("ijs");

        @VisibleForTesting
        final String flagName;

        private JsSourceType(String flagName) {
            this.flagName = flagName;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    public static class JsonFileSpec {
        @Nullable
        private final String src;
        @Nullable
        private final String path;
        @Nullable
        @SerializedName(value="source_map", alternate={"sourceMap"})
        private String sourceMap;
        @Nullable
        @SerializedName(value="webpack_id", alternate={"webpackId"})
        private final String webpackId;

        private JsonFileSpec() {
            this(null, null, null, null);
        }

        public JsonFileSpec(String src, String path) {
            this(src, path, null, null);
        }

        public JsonFileSpec(String src, String path, String sourceMap) {
            this(src, path, sourceMap, null);
        }

        public JsonFileSpec(String src, String path, String sourceMap, @Nullable String webpackId) {
            this.src = src;
            this.path = path;
            this.sourceMap = sourceMap;
            this.webpackId = webpackId;
        }

        public String getSrc() {
            return this.src;
        }

        public String getPath() {
            return this.path;
        }

        public String getSourceMap() {
            return this.sourceMap;
        }

        public String getWebpackId() {
            return this.webpackId;
        }

        public void setSourceMap(String map) {
            this.sourceMap = map;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static class CommandLineConfig {
        private boolean printVersion;
        private boolean printTree = false;
        private boolean printAst = false;
        private boolean printPassGraph = false;
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        private String loggingLevel = Level.WARNING.getName();
        private final List<String> externs = new ArrayList<String>();
        private final List<FlagEntry<JsSourceType>> mixedJsSources = new ArrayList<FlagEntry<JsSourceType>>();
        private boolean defaultToStdin = false;
        private String jsOutputFile = "";
        private String continueSavedCompilationFileName = null;
        private int restoredCompilationStage = -1;
        private int saveAfterCompilationStage = -1;
        @Nullable
        private String typedAstListInputFilename;
        private String saveCompilationStateToFilename = null;
        private final List<String> module = new ArrayList<String>();
        private Map<String, String> sourceMapInputFiles = new HashMap<String, String>();
        private boolean parseInlineSourceMaps = false;
        private String variableMapInputFile = "";
        private String propertyMapInputFile = "";
        private String variableMapOutputFile = "";
        private boolean createNameMapFiles = false;
        private String propertyMapOutputFile = "";
        private String stringMapOutputPath = "";
        private String instrumentationMappingFile = "";
        private CodingConvention codingConvention = CodingConventions.getDefault();
        private int summaryDetailLevel = 1;
        private String outputWrapper = "";
        private final List<String> moduleWrapper = new ArrayList<String>();
        private String moduleOutputPathPrefix = "";
        private final List<String> moduleOutputFiles = new ArrayList<String>();
        private String createSourceMap = "";
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        private ImmutableList<SourceMap.LocationMapping> sourceMapLocationMappings = ImmutableList.of();
        private boolean applyInputSourceMaps = false;
        private final ArrayList<FlagEntry<CheckLevel>> warningGuards = new ArrayList();
        private final List<String> define = new ArrayList<String>();
        private Integer browserFeaturesetYear = 0;
        private CompilerOptions.TweakProcessing tweakProcessing = CompilerOptions.TweakProcessing.OFF;
        private String charset = "";
        private DependencyOptions dependencyOptions = null;
        private List<String> outputManifests = ImmutableList.of();
        private String outputModuleDependencies = null;
        private List<String> outputBundles = ImmutableList.of();
        private boolean skipNormalOutputs = false;
        private List<String> manifestMaps = ImmutableList.of();
        private boolean transformAMDToCJSModules = false;
        private boolean processCommonJSModules = false;
        private List<String> moduleRoots = ImmutableList.of("./");
        private String warningsAllowFile = "";
        private List<String> hideWarningsFor = ImmutableList.of();
        private boolean angularPass = false;
        private CompilerOptions.JsonStreamMode jsonStreamMode = CompilerOptions.JsonStreamMode.NONE;
        private ErrorFormatOption errorFormat = ErrorFormatOption.STANDARD;
        private String jsonWarningsFile = "";

        protected CommandLineConfig() {
        }

        CommandLineConfig setPrintVersion(boolean x) {
            this.printVersion = x;
            return this;
        }

        CommandLineConfig setPrintTree(boolean printTree) {
            this.printTree = printTree;
            return this;
        }

        public CommandLineConfig setPrintAst(boolean printAst) {
            this.printAst = printAst;
            return this;
        }

        public CommandLineConfig setPrintPassGraph(boolean printPassGraph) {
            this.printPassGraph = printPassGraph;
            return this;
        }

        public CommandLineConfig setJscompDevMode(CompilerOptions.DevMode jscompDevMode) {
            this.jscompDevMode = jscompDevMode;
            return this;
        }

        public CommandLineConfig setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public CommandLineConfig setExterns(List<String> externs) {
            this.externs.clear();
            this.externs.addAll(externs);
            return this;
        }

        public CommandLineConfig setMixedJsSources(List<FlagEntry<JsSourceType>> mixedJsSources) {
            this.mixedJsSources.clear();
            this.mixedJsSources.addAll(mixedJsSources);
            return this;
        }

        public CommandLineConfig setDefaultToStdin() {
            this.defaultToStdin = true;
            return this;
        }

        public CommandLineConfig setJsOutputFile(String jsOutputFile) {
            this.jsOutputFile = jsOutputFile;
            return this;
        }

        public CommandLineConfig setContinueSavedCompilationFileName(String fileName, int restoredCompilationStage) {
            if (fileName != null) {
                Preconditions.checkArgument(restoredCompilationStage > 0 && restoredCompilationStage < 3, "invalid compilation stage: %s", restoredCompilationStage);
                this.continueSavedCompilationFileName = fileName;
                this.restoredCompilationStage = restoredCompilationStage;
            }
            return this;
        }

        boolean shouldSaveAfterStage1() {
            if (this.saveCompilationStateToFilename != null && this.saveAfterCompilationStage == 1) {
                Preconditions.checkState(this.restoredCompilationStage < 0, "cannot perform stage 1 after restoring from stage %s", this.restoredCompilationStage);
                Preconditions.checkState(this.continueSavedCompilationFileName == null, "cannot restore a saved compilation and also save after stage 1");
                return true;
            }
            return false;
        }

        String getContinueSavedCompilationFileName() {
            return this.continueSavedCompilationFileName;
        }

        boolean shouldRestoreAndPerformStages2And3() {
            return this.shouldContinueCompilation() && this.restoredCompilationStage == 1 && this.saveAfterCompilationStage < 0;
        }

        private boolean shouldContinueCompilation() {
            if (this.continueSavedCompilationFileName != null) {
                Preconditions.checkState(this.restoredCompilationStage > 0 && this.restoredCompilationStage < 3, "invalid restored compilation stage: %s", this.restoredCompilationStage);
                return true;
            }
            return false;
        }

        boolean shouldRestoreAndPerformStage2AndSave() {
            return this.shouldContinueCompilation() && this.restoredCompilationStage == 1 && this.saveAfterCompilationStage == 2;
        }

        boolean shouldRestoreAndPerformStage3() {
            if (this.shouldContinueCompilation() && this.restoredCompilationStage == 2) {
                Preconditions.checkState(this.saveAfterCompilationStage < 0, "request to save after stage %s is invalid when restoring from stage 2", this.saveAfterCompilationStage);
                return true;
            }
            return false;
        }

        boolean shouldDoLateLocalization() {
            return this.shouldRestoreAndPerformStage2AndSave() || this.shouldRestoreAndPerformStage3();
        }

        public CommandLineConfig setTypedAstListInputFilename(@Nullable String fileName) {
            this.typedAstListInputFilename = fileName;
            return this;
        }

        public CommandLineConfig setSaveCompilationStateToFilename(String fileName, int saveAfterCompilationStage) {
            this.saveCompilationStateToFilename = fileName;
            this.saveAfterCompilationStage = saveAfterCompilationStage;
            return this;
        }

        public String getSaveCompilationStateToFilename() {
            return this.saveCompilationStateToFilename;
        }

        public CommandLineConfig setModule(List<String> module) {
            this.module.clear();
            this.module.addAll(module);
            return this;
        }

        public CommandLineConfig setSourceMapInputFiles(Map<String, String> sourceMapInputFiles) {
            this.sourceMapInputFiles = sourceMapInputFiles;
            return this;
        }

        public CommandLineConfig setParseInlineSourceMaps(boolean parseInlineSourceMaps) {
            this.parseInlineSourceMaps = parseInlineSourceMaps;
            return this;
        }

        public CommandLineConfig setVariableMapInputFile(String variableMapInputFile) {
            this.variableMapInputFile = variableMapInputFile;
            return this;
        }

        public CommandLineConfig setPropertyMapInputFile(String propertyMapInputFile) {
            this.propertyMapInputFile = propertyMapInputFile;
            return this;
        }

        public CommandLineConfig setVariableMapOutputFile(String variableMapOutputFile) {
            this.variableMapOutputFile = variableMapOutputFile;
            return this;
        }

        public CommandLineConfig setCreateNameMapFiles(boolean createNameMapFiles) {
            this.createNameMapFiles = createNameMapFiles;
            return this;
        }

        public CommandLineConfig setPropertyMapOutputFile(String propertyMapOutputFile) {
            this.propertyMapOutputFile = propertyMapOutputFile;
            return this;
        }

        public CommandLineConfig setStringMapOutputFile(String stringMapOutputPath) {
            this.stringMapOutputPath = stringMapOutputPath;
            return this;
        }

        public CommandLineConfig setInstrumentationMappingFile(String instrumentationMappingFile) {
            this.instrumentationMappingFile = instrumentationMappingFile;
            return this;
        }

        public CommandLineConfig setCodingConvention(CodingConvention codingConvention) {
            this.codingConvention = codingConvention;
            return this;
        }

        public CommandLineConfig setSummaryDetailLevel(int summaryDetailLevel) {
            this.summaryDetailLevel = summaryDetailLevel;
            return this;
        }

        public CommandLineConfig setOutputWrapper(String outputWrapper) {
            this.outputWrapper = outputWrapper;
            return this;
        }

        public CommandLineConfig setModuleWrapper(List<String> moduleWrapper) {
            this.moduleWrapper.clear();
            this.moduleWrapper.addAll(moduleWrapper);
            return this;
        }

        public CommandLineConfig setModuleOutputPathPrefix(String moduleOutputPathPrefix) {
            this.moduleOutputPathPrefix = moduleOutputPathPrefix;
            return this;
        }

        public CommandLineConfig setModuleOutputFiles(List<String> moduleOutputFiles) {
            this.moduleOutputFiles.clear();
            this.moduleOutputFiles.addAll(moduleOutputFiles);
            return this;
        }

        public CommandLineConfig setCreateSourceMap(String createSourceMap) {
            this.createSourceMap = createSourceMap;
            return this;
        }

        public CommandLineConfig setSourceMapDetailLevel(SourceMap.DetailLevel level) {
            this.sourceMapDetailLevel = level;
            return this;
        }

        public CommandLineConfig setSourceMapFormat(SourceMap.Format format) {
            this.sourceMapFormat = format;
            return this;
        }

        public CommandLineConfig setSourceMapLocationMappings(List<SourceMap.LocationMapping> locationMappings) {
            this.sourceMapLocationMappings = ImmutableList.copyOf(locationMappings);
            return this;
        }

        public CommandLineConfig setApplyInputSourceMaps(boolean applyInputSourceMaps) {
            this.applyInputSourceMaps = applyInputSourceMaps;
            return this;
        }

        public CommandLineConfig setWarningGuards(List<FlagEntry<CheckLevel>> warningGuards) {
            this.warningGuards.clear();
            this.warningGuards.addAll(warningGuards);
            return this;
        }

        public CommandLineConfig setDefine(List<String> define) {
            this.define.clear();
            this.define.addAll(define);
            return this;
        }

        public CommandLineConfig setBrowserFeaturesetYear(Integer browserFeaturesetYear) {
            this.browserFeaturesetYear = browserFeaturesetYear;
            return this;
        }

        public CommandLineConfig setTweakProcessing(CompilerOptions.TweakProcessing tweakProcessing) {
            this.tweakProcessing = tweakProcessing;
            return this;
        }

        public CommandLineConfig setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public CommandLineConfig setDependencyOptions(@Nullable DependencyOptions dependencyOptions) {
            this.dependencyOptions = dependencyOptions;
            return this;
        }

        public CommandLineConfig setOutputManifest(List<String> outputManifests) {
            this.outputManifests = new ArrayList<String>();
            for (String manifestName : outputManifests) {
                if (manifestName.isEmpty()) continue;
                this.outputManifests.add(manifestName);
            }
            this.outputManifests = ImmutableList.copyOf(this.outputManifests);
            return this;
        }

        public CommandLineConfig setOutputModuleDependencies(String outputModuleDependencies) {
            this.outputModuleDependencies = outputModuleDependencies;
            return this;
        }

        public CommandLineConfig setOutputBundle(List<String> outputBundles) {
            this.outputBundles = outputBundles;
            return this;
        }

        public CommandLineConfig setSkipNormalOutputs(boolean skipNormalOutputs) {
            this.skipNormalOutputs = skipNormalOutputs;
            return this;
        }

        public CommandLineConfig setManifestMaps(List<String> manifestMaps) {
            this.manifestMaps = manifestMaps;
            return this;
        }

        public CommandLineConfig setTransformAMDToCJSModules(boolean transformAMDToCJSModules) {
            this.transformAMDToCJSModules = transformAMDToCJSModules;
            return this;
        }

        public CommandLineConfig setProcessCommonJSModules(boolean processCommonJSModules) {
            this.processCommonJSModules = processCommonJSModules;
            return this;
        }

        public CommandLineConfig setModuleRoots(List<String> jsChunkRoots) {
            this.moduleRoots = jsChunkRoots;
            return this;
        }

        public CommandLineConfig setWarningsAllowlistFile(String fileName) {
            this.warningsAllowFile = fileName;
            return this;
        }

        public CommandLineConfig setHideWarningsFor(List<String> hideWarningsFor) {
            this.hideWarningsFor = hideWarningsFor;
            return this;
        }

        public CommandLineConfig setAngularPass(boolean angularPass) {
            this.angularPass = angularPass;
            return this;
        }

        public CommandLineConfig setJsonStreamMode(CompilerOptions.JsonStreamMode mode) {
            this.jsonStreamMode = mode;
            return this;
        }

        public CommandLineConfig setErrorFormat(ErrorFormatOption errorFormat) {
            this.errorFormat = errorFormat;
            return this;
        }

        public CommandLineConfig setJsonWarningsFile(String jsonWarningsFile) {
            this.jsonWarningsFile = jsonWarningsFile;
            return this;
        }

        protected static enum ErrorFormatOption {
            STANDARD,
            JSON;

        }
    }
}

