/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public final class AstManipulations {
    private AstManipulations() {
    }

    public static Node fuseExpressions(Node exp1, Node exp2) {
        Preconditions.checkArgument(exp1.getParent() == null, "Expected detached node, got %s", (Object)exp1);
        Preconditions.checkArgument(exp2.getParent() == null, "Expected detached node, got %s", (Object)exp2);
        if (exp2.isEmpty()) {
            return exp1;
        }
        Node comma = new Node(Token.COMMA, exp1);
        comma.srcrefIfMissing(exp2);
        if (exp2.isComma()) {
            Node leftMostChild = exp2;
            while (leftMostChild.isComma()) {
                leftMostChild = leftMostChild.getFirstChild();
            }
            Node parent = leftMostChild.getParent();
            comma.addChildToBack(leftMostChild.detach());
            parent.addChildToFront(comma);
            return exp2;
        }
        comma.addChildToBack(exp2);
        return comma;
    }
}

