/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChromePass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Set<String> createdObjects;
    private static final String CR_DEFINE = "cr.define";
    private static final String OBJECT_DEFINE_PROPERTY = "Object.defineProperty";
    private static final String CR_DEFINE_PROPERTY = "cr.defineProperty";
    private static final String VIRTUAL_FILE = "<ChromePass.java>";
    private static final Node VIRTUAL_NODE = IR.empty().setStaticSourceFile(SourceFile.fromCode("<ChromePass.java>", "", StaticSourceFile.SourceKind.EXTERN));
    private static final String CR_DEFINE_COMMON_EXPLANATION = "It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');";
    static final DiagnosticType CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS = DiagnosticType.error("JSC_CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS", "cr.define() should have exactly 2 arguments. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_FIRST_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_FIRST_ARGUMENT", "Invalid first argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_SECOND_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_SECOND_ARGUMENT", "Invalid second argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_RETURN_IN_FUNCTION = DiagnosticType.error("JSC_CR_DEFINE_INVALID_RETURN_IN_SECOND_ARGUMENT", "Function passed as second argument of cr.define() should return the dictionary in its last statement. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_PROPERTY_TOO_FEW_ARGUMENTS = DiagnosticType.error("JSC_CR_DEFINE_PROPERTY_TOO_FEW_ARGUMENTS", "cr.defineProperty() requires at least 2 arguments.");
    static final DiagnosticType CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND = DiagnosticType.error("JSC_CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND", "Invalid cr.PropertyKind passed to cr.defineProperty(): expected ATTR, BOOL_ATTR or JS, found \"{0}\".");

    public ChromePass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.createdObjects = new HashSet<String>(Arrays.asList("cr"));
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node node, Node parent) {
        if (node.isCall()) {
            Node callee = node.getFirstChild();
            if (callee.matchesQualifiedName(CR_DEFINE)) {
                this.visitNamespaceDefinition(node, parent);
            } else if (callee.matchesQualifiedName(OBJECT_DEFINE_PROPERTY) || callee.matchesQualifiedName(CR_DEFINE_PROPERTY)) {
                this.visitPropertyDefinition(node, parent);
            }
        }
    }

    private void visitPropertyDefinition(Node call, Node parent) {
        Node callee = call.getFirstChild();
        boolean isCrDefinePropertyCall = callee.matchesQualifiedName(CR_DEFINE_PROPERTY);
        if (isCrDefinePropertyCall) {
            if (call.getChildCount() < 3) {
                this.compiler.report(JSError.make(call, CR_DEFINE_PROPERTY_TOO_FEW_ARGUMENTS, new String[0]));
                return;
            }
        } else if (call.getChildCount() < 4) {
            return;
        }
        String target = call.getSecondChild().getQualifiedName();
        if (isCrDefinePropertyCall && !target.endsWith(".prototype")) {
            target = target + ".prototype";
        }
        Node property = call.getChildAtIndex(2);
        Node getPropNode = NodeUtil.newQName(this.compiler, target + "." + property.getString()).srcrefTree(call);
        if (isCrDefinePropertyCall) {
            Node propertyType = this.getTypeByCrPropertyKind(call.getChildAtIndex(3));
            if (propertyType != null) {
                ChromePass.setJsDocWithType(getPropNode, propertyType);
            } else {
                JSDocInfo sourceJsDocInfo = call.getJSDocInfo();
                if (sourceJsDocInfo != null && sourceJsDocInfo.hasType()) {
                    getPropNode.setJSDocInfo(sourceJsDocInfo);
                } else {
                    ChromePass.setJsDocWithType(getPropNode, new Node(Token.QMARK));
                }
            }
            call.setJSDocInfo(null);
        } else {
            ChromePass.setJsDocWithType(getPropNode, new Node(Token.QMARK));
        }
        Node definitionNode = IR.exprResult(getPropNode).srcref(parent);
        definitionNode.insertAfter(parent);
        this.compiler.reportChangeToEnclosingScope(isCrDefinePropertyCall ? call : getPropNode);
    }

    @Nullable
    private Node getTypeByCrPropertyKind(@Nullable Node propertyKind) {
        if (propertyKind == null || propertyKind.matchesQualifiedName("cr.PropertyKind.JS")) {
            return null;
        }
        if (propertyKind.matchesQualifiedName("cr.PropertyKind.ATTR")) {
            return IR.string("string");
        }
        if (propertyKind.matchesQualifiedName("cr.PropertyKind.BOOL_ATTR")) {
            return IR.string("boolean");
        }
        this.compiler.report(JSError.make(propertyKind, CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND, propertyKind.getQualifiedName()));
        return null;
    }

    private static void setJsDocWithType(Node target, Node type) {
        JSDocInfo.Builder builder = JSDocInfo.builder();
        builder.recordType(new JSTypeExpression(type.srcrefTree(VIRTUAL_NODE), VIRTUAL_FILE));
        target.setJSDocInfo(builder.build());
    }

    private void createAndInsertObjectsForQualifiedName(Node scriptChild, String namespace) {
        List<Node> objectsForQualifiedName = this.createObjectsForQualifiedName(namespace);
        for (Node n : objectsForQualifiedName) {
            n.srcrefTree(scriptChild).insertBefore(scriptChild);
        }
        if (!objectsForQualifiedName.isEmpty()) {
            this.compiler.reportChangeToEnclosingScope(scriptChild);
        }
    }

    private void visitNamespaceDefinition(Node crDefineCallNode, Node parent) {
        Node objectLit;
        if (crDefineCallNode.getChildCount() != 3) {
            this.compiler.report(JSError.make(crDefineCallNode, CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS, new String[0]));
        }
        Node namespaceArg = crDefineCallNode.getSecondChild();
        Node function = crDefineCallNode.getChildAtIndex(2);
        if (!namespaceArg.isStringLit()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_FIRST_ARGUMENT, new String[0]));
            return;
        }
        String namespace = namespaceArg.getString();
        this.createAndInsertObjectsForQualifiedName(parent, namespace);
        if (!function.isFunction()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_SECOND_ARGUMENT, new String[0]));
            return;
        }
        Node functionBlock = function.getLastChild();
        Node returnNode = functionBlock.getLastChild();
        if (returnNode == null || !returnNode.isReturn() || (objectLit = returnNode.getFirstChild()) == null || !objectLit.isObjectLit()) {
            this.compiler.report(JSError.make(namespaceArg, CR_DEFINE_INVALID_RETURN_IN_FUNCTION, new String[0]));
            return;
        }
        Map<String, String> exports = ChromePass.objectLitToMap(objectLit);
        NodeTraversal.traverse(this.compiler, functionBlock, new RenameInternalsToExternalsCallback(namespace, exports, functionBlock));
    }

    private static Map<String, String> objectLitToMap(Node objectLit) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Node keyNode = objectLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            String key = keyNode.getString();
            Node valueNode = keyNode.getFirstChild();
            if (!valueNode.isName()) continue;
            String value = keyNode.getFirstChild().getString();
            res.put(value, key);
        }
        return res;
    }

    private List<Node> createObjectsForQualifiedName(String namespace) {
        ArrayList<Node> objects = new ArrayList<Node>();
        String[] parts = namespace.split("\\.");
        this.createObjectIfNew(objects, parts[0], true);
        if (parts.length >= 2) {
            StringBuilder currPrefix = new StringBuilder().append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                currPrefix.append(".").append(parts[i]);
                this.createObjectIfNew(objects, currPrefix.toString(), false);
            }
        }
        return objects;
    }

    private void createObjectIfNew(List<Node> objects, String name, boolean needVar) {
        if (this.createdObjects.contains(name)) {
            return;
        }
        this.createdObjects.add(name);
        Node v = NodeUtil.newQName(this.compiler, name);
        Node lhs = IR.or(v.cloneTree(), IR.objectlit(new Node[0]));
        objects.add(needVar ? IR.var(v, lhs) : IR.exprResult(IR.assign(v, lhs)));
    }

    private class RenameInternalsToExternalsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String namespaceName;
        private final Map<String, String> exports;
        private final Node namespaceBlock;

        public RenameInternalsToExternalsCallback(String namespaceName, Map<String, String> exports, Node namespaceBlock) {
            this.namespaceName = namespaceName;
            this.exports = exports;
            this.namespaceBlock = namespaceBlock;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if ((n.isFunction() || n.isClass()) && parent == this.namespaceBlock && this.exports.containsKey(n.getFirstChild().getString())) {
                Node clone2 = n.cloneTree();
                if (clone2.isClass()) {
                    Node className = clone2.getFirstChild();
                    className.replaceWith(IR.empty().srcref(className));
                }
                NodeUtil.markNewScopesChanged(clone2, ChromePass.this.compiler);
                Node exprResult = IR.exprResult(IR.assign(this.buildQualifiedName(n.getFirstChild()), clone2).srcref(n)).srcref(n);
                if (n.getJSDocInfo() != null) {
                    exprResult.getFirstChild().setJSDocInfo(n.getJSDocInfo());
                    clone2.setJSDocInfo(null);
                }
                n.replaceWith(exprResult);
                NodeUtil.markFunctionsDeleted(n, ChromePass.this.compiler);
                ChromePass.this.compiler.reportChangeToEnclosingScope(exprResult);
            } else if (n.isName() && this.exports.containsKey(n.getString()) && !parent.isFunction() && !parent.isClass()) {
                if (NodeUtil.isNameDeclaration(parent)) {
                    if (parent.getParent() == this.namespaceBlock) {
                        Node varContent = n.removeFirstChild();
                        Node exprResult = varContent == null ? IR.exprResult(this.buildQualifiedName(n)).srcref(parent) : IR.exprResult(IR.assign(this.buildQualifiedName(n), varContent).srcref(parent)).srcref(parent);
                        if (parent.getJSDocInfo() != null) {
                            exprResult.getFirstChild().setJSDocInfo(parent.getJSDocInfo().clone());
                        }
                        parent.replaceWith(exprResult);
                        ChromePass.this.compiler.reportChangeToEnclosingScope(exprResult);
                    }
                } else {
                    Node newNode = this.buildQualifiedName(n);
                    if (n.getJSDocInfo() != null) {
                        newNode.setJSDocInfo(n.getJSDocInfo().clone());
                    }
                    if (parent.isCall()) {
                        parent.putBooleanProp(Node.FREE_CALL, false);
                    }
                    n.replaceWith(newNode);
                    ChromePass.this.compiler.reportChangeToEnclosingScope(newNode);
                }
            }
        }

        private Node buildQualifiedName(Node internalName) {
            String externalName = this.exports.get(internalName.getString());
            return NodeUtil.newQName(ChromePass.this.compiler, this.namespaceName + "." + externalName).srcrefTree(internalName);
        }
    }
}

