/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.dtoa.DToA;
import java.util.HashSet;

final class ClosureOptimizePrimitives
implements CompilerPass {
    static final DiagnosticType DUPLICATE_SET_MEMBER = DiagnosticType.warning("JSC_DUPLICATE_SET_MEMBER", "Found duplicate value ''{0}'' in set");
    private final AbstractCompiler compiler;
    private final boolean propertyRenamingEnabled;
    private final boolean canUseEs6Syntax;

    ClosureOptimizePrimitives(AbstractCompiler compiler, boolean propertyRenamingEnabled, boolean canUseEs6Syntax) {
        this.compiler = compiler;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
        this.canUseEs6Syntax = canUseEs6Syntax;
    }

    @Override
    public void process(Node externs, Node root) {
        FindPrimitives pass = new FindPrimitives();
        NodeTraversal.traverse(this.compiler, root, pass);
    }

    private void processObjectCreateCall(Node callNode) {
        Node curParam = callNode.getSecondChild();
        if (this.canOptimizeObjectCreate(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = curParam.getNext();
                curParam = valueNode.getNext();
                keyNode.detach();
                valueNode.detach();
                this.addKeyValueToObjLit(objNode, keyNode, valueNode, NodeUtil.getEnclosingScript(callNode));
            }
            callNode.replaceWith(objNode);
            this.compiler.reportChangeToEnclosingScope(objNode);
        }
    }

    private void processRenamePropertyCall(Node callNode) {
        Node propName;
        if (!this.propertyRenamingEnabled && (propName = NodeUtil.getArgumentForCallOrNew(callNode, 0)) != null) {
            callNode.replaceWith(propName.detach());
            this.compiler.reportChangeToEnclosingScope(propName);
            return;
        }
        Node nameNode = callNode.getFirstChild();
        if (nameNode.matchesQualifiedName("JSCompiler_renameProperty")) {
            return;
        }
        Node newTarget = IR.name("JSCompiler_renameProperty").srcref(nameNode);
        newTarget.setOriginalName(nameNode.getOriginalQualifiedName());
        nameNode.replaceWith(newTarget);
        callNode.putBooleanProp(Node.FREE_CALL, true);
        this.compiler.reportChangeToEnclosingScope(callNode);
    }

    private boolean canOptimizeObjectCreate(Node firstParam) {
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            if (!this.isOptimizableKey(curParam)) {
                return false;
            }
            if ((curParam = curParam.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private void processObjectCreateSetCall(Node callNode) {
        Node curParam = callNode.getSecondChild();
        if (this.canOptimizeObjectCreateSet(curParam)) {
            Node objNode = IR.objectlit(new Node[0]).srcref(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = IR.trueNode().srcref(keyNode);
                curParam = curParam.getNext();
                keyNode.detach();
                this.addKeyValueToObjLit(objNode, keyNode, valueNode, NodeUtil.getEnclosingScript(callNode));
            }
            callNode.replaceWith(objNode);
            this.compiler.reportChangeToEnclosingScope(objNode);
        }
    }

    private boolean canOptimizeObjectCreateSet(Node firstParam) {
        if (firstParam != null && firstParam.getNext() == null && !firstParam.isNumber() && !firstParam.isStringLit()) {
            return false;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            String key;
            if (!this.isOptimizableKey(curParam)) {
                return false;
            }
            if (!curParam.isStringLit() && !curParam.isNumber()) continue;
            String string = key = curParam.isStringLit() ? curParam.getString() : DToA.numberToString(curParam.getDouble());
            if (keys.add(key)) continue;
            this.compiler.report(JSError.make(firstParam.getPrevious(), DUPLICATE_SET_MEMBER, key));
            return false;
        }
        return true;
    }

    private void addKeyValueToObjLit(Node objNode, Node keyNode, Node valueNode, Node scriptNode) {
        if (keyNode.isNumber() || keyNode.isStringLit()) {
            if (keyNode.isNumber()) {
                keyNode = IR.string(DToA.numberToString(keyNode.getDouble())).srcref(keyNode);
            }
            keyNode.setIsParenthesized(false);
            keyNode.setToken(Token.STRING_KEY);
            keyNode.setQuotedString();
            objNode.addChildToBack(IR.propdef(keyNode, valueNode));
        } else {
            objNode.addChildToBack(IR.computedProp(keyNode, valueNode).srcref(keyNode));
            NodeUtil.addFeatureToScript(scriptNode, FeatureSet.Feature.COMPUTED_PROPERTIES, this.compiler);
        }
    }

    private boolean isOptimizableKey(Node curParam) {
        if (this.canUseEs6Syntax) {
            return !NodeUtil.isStatement(curParam);
        }
        return curParam.isStringLit() || curParam.isNumber();
    }

    private class FindPrimitives
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindPrimitives() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall()) {
                Node fn = n.getFirstChild();
                if (ClosureOptimizePrimitives.this.compiler.getCodingConvention().isPropertyRenameFunction(fn)) {
                    ClosureOptimizePrimitives.this.processRenamePropertyCall(n);
                } else if (fn.matchesName("goog$object$create") || fn.matchesName("module$contents$goog$object_create") || fn.matchesQualifiedName("goog.object.create")) {
                    ClosureOptimizePrimitives.this.processObjectCreateCall(n);
                } else if (fn.matchesName("goog$object$createSet") || fn.matchesName("module$contents$goog$object_createSet") || fn.matchesQualifiedName("goog.object.createSet")) {
                    ClosureOptimizePrimitives.this.processObjectCreateSetCall(n);
                }
            }
        }
    }
}

