/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class J2clEqualitySameRewriterPass
extends AbstractPeepholeOptimization {
    private final boolean useTypes;
    private boolean shouldRunJ2clPasses;

    J2clEqualitySameRewriterPass(boolean useTypes) {
        this.useTypes = useTypes;
    }

    @Override
    void beginTraversal(AbstractCompiler compiler) {
        super.beginTraversal(compiler);
        this.shouldRunJ2clPasses = J2clSourceFileChecker.shouldRunJ2clPasses(compiler);
    }

    @Override
    Node optimizeSubtree(Node node) {
        if (!this.shouldRunJ2clPasses) {
            return node;
        }
        if (!node.hasXChildren(3)) {
            return node;
        }
        Node replacement = null;
        if (J2clEqualitySameRewriterPass.isStringEqualsMethod(node)) {
            replacement = this.trySubstituteStringEquals(node);
        } else if (J2clEqualitySameRewriterPass.isEqualitySameCall(node)) {
            replacement = this.trySubstituteEqualitySame(node);
        }
        if (replacement == null) {
            return node;
        }
        replacement.srcrefIfMissing(node);
        node.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node trySubstituteStringEquals(Node callNode) {
        NodeValue firstExprValue = J2clEqualitySameRewriterPass.getKnownLiteralValue(callNode.getSecondChild());
        if (firstExprValue == NodeValue.UNKNOWN || firstExprValue == NodeValue.NULL_OR_UNDEFINED) {
            return null;
        }
        return this.trySubstituteEqualitySame(callNode);
    }

    private Node trySubstituteEqualitySame(Node callNode) {
        Node firstExpr = callNode.getSecondChild();
        NodeValue firstExprValue = J2clEqualitySameRewriterPass.getKnownLiteralValue(firstExpr);
        Node secondExpr = callNode.getLastChild();
        NodeValue secondExprValue = J2clEqualitySameRewriterPass.getKnownLiteralValue(secondExpr);
        if (firstExprValue == NodeValue.UNKNOWN && secondExprValue == NodeValue.UNKNOWN) {
            return null;
        }
        if (firstExprValue == NodeValue.NULL_OR_UNDEFINED) {
            return this.rewriteNullCheck(secondExpr, firstExpr);
        }
        if (secondExprValue == NodeValue.NULL_OR_UNDEFINED) {
            return this.rewriteNullCheck(firstExpr, secondExpr);
        }
        if (firstExprValue == NodeValue.NON_NULL || secondExprValue == NodeValue.NON_NULL) {
            return this.rewriteAsStrictEq(firstExpr, secondExpr);
        }
        Preconditions.checkState(firstExprValue == NodeValue.NUMBER || secondExprValue == NodeValue.NUMBER);
        return this.rewriteNumberCheck(firstExpr, secondExpr);
    }

    private Node rewriteNullCheck(Node expr, Node nullExpression) {
        expr.detach();
        nullExpression.detach();
        if (this.useTypes && this.canOnlyBeObject(expr)) {
            return IR.not(expr);
        }
        return IR.eq(expr, nullExpression);
    }

    private boolean canOnlyBeObject(Node n) {
        Color color = n.getColor();
        if (color == null) {
            return false;
        }
        if (color.isUnion()) {
            color = color.subtractNullOrVoid();
        }
        return !color.isUnion() && !color.isPrimitive() && !color.equals(StandardColors.UNKNOWN);
    }

    private Node rewriteAsStrictEq(Node firstExpr, Node secondExpr) {
        firstExpr.detach();
        secondExpr.detach();
        return IR.sheq(firstExpr, secondExpr);
    }

    private Node rewriteNumberCheck(Node firstExpr, Node secondExpr) {
        Double firstValue = NodeUtil.getNumberValue(firstExpr);
        Double secondValue = NodeUtil.getNumberValue(secondExpr);
        if (firstValue != null && secondValue != null) {
            firstExpr.detach();
            secondExpr.detach();
            return NodeUtil.booleanNode(firstValue.equals(secondValue));
        }
        if (J2clEqualitySameRewriterPass.isSafeNumber(firstValue) || J2clEqualitySameRewriterPass.isSafeNumber(secondValue)) {
            return this.rewriteAsStrictEq(firstExpr, secondExpr);
        }
        if (this.useTypes && (this.canOnlyBeObject(firstExpr) || this.canOnlyBeObject(secondExpr))) {
            return this.rewriteAsStrictEq(firstExpr, secondExpr);
        }
        return null;
    }

    private static boolean isSafeNumber(Double d) {
        return d != null && d != 0.0 && !d.isNaN();
    }

    private static NodeValue getKnownLiteralValue(Node n) {
        switch (NodeUtil.getKnownValueType(n)) {
            case VOID: {
                return NodeUtil.canBeSideEffected(n) ? NodeValue.UNKNOWN : NodeValue.NULL_OR_UNDEFINED;
            }
            case NULL: {
                return NodeValue.NULL_OR_UNDEFINED;
            }
            case STRING: 
            case BOOLEAN: 
            case OBJECT: 
            case BIGINT: {
                return NodeValue.NON_NULL;
            }
            case NUMBER: {
                return NodeValue.NUMBER;
            }
            case UNDETERMINED: {
                return NodeValue.UNKNOWN;
            }
        }
        throw new AssertionError((Object)"Unknown ValueType");
    }

    private static boolean isEqualitySameCall(Node node) {
        return node.isCall() && J2clEqualitySameRewriterPass.hasName(node.getFirstChild(), "Equality", "$same");
    }

    private static boolean isStringEqualsMethod(Node node) {
        return node.isCall() && J2clEqualitySameRewriterPass.hasName(node.getFirstChild(), "String", "m_equals__java_lang_String__java_lang_Object");
    }

    private static boolean hasName(Node fnName, String className, String methodName) {
        if (!fnName.isQualifiedName()) {
            return false;
        }
        String originalQname = fnName.getOriginalQualifiedName();
        return originalQname.endsWith(methodName) && originalQname.contains(className);
    }

    private static enum NodeValue {
        UNKNOWN,
        NULL_OR_UNDEFINED,
        NUMBER,
        NON_NULL;

    }
}

