/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Map;

class OptimizeConstructors
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    final ArrayList<Node> removableConstructors = new ArrayList();

    OptimizeConstructors(AbstractCompiler compiler) {
        this.compiler = Preconditions.checkNotNull(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED);
        OptimizeCalls.builder().setCompiler(this.compiler).setConsiderExterns(false).addPass(this).build().process(externs, root);
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap refMap) {
        for (Map.Entry<String, ArrayList<Node>> entry : refMap.getNameReferences()) {
            this.addConstructorsToBeRemoved(entry.getKey(), entry.getValue());
        }
        for (Node ref : this.removableConstructors) {
            this.removeConstructorMethod(ref);
        }
    }

    private void addConstructorsToBeRemoved(String name, ArrayList<Node> refs) {
        if (!OptimizeCalls.mayBeOptimizableName(this.compiler, name)) {
            return;
        }
        Node candidateClassDefinition = null;
        ArrayList<Node> subclassConstructors = null;
        for (Node n : refs) {
            Node definition = this.getClassDefinitionOrFunction(n);
            if (definition != null) {
                Node fn;
                Node body;
                Node constructor;
                Node extendsExpr;
                if (candidateClassDefinition != null) {
                    return;
                }
                candidateClassDefinition = definition;
                if (!candidateClassDefinition.isClass() || !(extendsExpr = candidateClassDefinition.getSecondChild()).isEmpty() || (constructor = NodeUtil.getEs6ClassConstructorMemberFunctionDef(candidateClassDefinition)) == null || (body = (fn = constructor.getLastChild()).getLastChild()).hasChildren() || !this.hasRemovableParameterList(constructor)) continue;
                this.removableConstructors.add(constructor);
                continue;
            }
            if (this.isClassExtendsExpression(n)) {
                Node subclassLiteral = n.getParent();
                Node subclassConstructor = NodeUtil.getEs6ClassConstructorMemberFunctionDef(subclassLiteral);
                if (subclassConstructor == null || !OptimizeConstructors.constructorHasRemovableDefinition(subclassConstructor)) continue;
                if (subclassConstructors == null) {
                    subclassConstructors = new ArrayList<Node>();
                }
                subclassConstructors.add(subclassConstructor);
                continue;
            }
            if (!OptimizeConstructors.isAssigningReference(n)) continue;
            return;
        }
        if (candidateClassDefinition == null) {
            return;
        }
        if (subclassConstructors != null) {
            ClassConstructorSummary summary = ClassConstructorSummary.build(candidateClassDefinition);
            for (Node n : subclassConstructors) {
                if (!summary.isEquivalentConstructorDefinition(n)) continue;
                this.removableConstructors.add(n);
            }
        }
    }

    static boolean isAssigningReference(Node n) {
        Node parent = n.getParent();
        Node gparent = parent.getParent();
        switch (parent.getToken()) {
            case LET: 
            case CONST: 
            case VAR: {
                return n.hasChildren();
            }
            case STRING_KEY: {
                return gparent.isObjectPattern();
            }
            case COMPUTED_PROP: {
                return parent.getLastChild() == n && gparent.isObjectPattern();
            }
            case ARRAY_PATTERN: 
            case DEFAULT_VALUE: 
            case PARAM_LIST: 
            case OBJECT_REST: 
            case ITER_REST: 
            case INC: 
            case DEC: {
                return true;
            }
            case FUNCTION: 
            case CLASS: 
            case CATCH: {
                return parent.getFirstChild() == n;
            }
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                return parent.getFirstChild() != n;
            }
        }
        return false;
    }

    private boolean isClassExtendsExpression(Node n) {
        Node parent = n.getParent();
        return parent.isClass() && parent.getSecondChild() == n;
    }

    private Node getClassDefinitionOrFunction(Node n) {
        Node expr;
        Node parent = n.getParent();
        if (OptimizeCalls.ReferenceMap.isSimpleAssignmentTarget(n)) {
            expr = parent.getLastChild();
        } else if (n.isName() && n.hasChildren()) {
            expr = n.getFirstChild();
        } else if (parent.isFunction() && n.isFirstChildOf(parent)) {
            expr = parent;
        } else if (parent.isClass() && n.isFirstChildOf(parent)) {
            expr = parent;
        } else {
            return null;
        }
        expr = this.unwrap(expr);
        if (OptimizeConstructors.isDefinitionClassLiteralOrFunction(expr)) {
            return expr;
        }
        return null;
    }

    private Node unwrap(Node expr) {
        while (expr.isCast() || expr.isComma()) {
            expr = expr.getLastChild();
        }
        return expr;
    }

    private static boolean isDefinitionClassLiteralOrFunction(Node n) {
        switch (n.getToken()) {
            case FUNCTION: {
                return true;
            }
            case CLASS: {
                Node constructorMemberFunctionDef = NodeUtil.getEs6ClassConstructorMemberFunctionDef(n);
                return constructorMemberFunctionDef != null;
            }
        }
        return false;
    }

    static boolean functionHasRest(Node fn) {
        Preconditions.checkState(fn.isFunction());
        Node params = NodeUtil.getFunctionParameters(fn);
        Node lastParam = params.getLastChild();
        return lastParam != null && lastParam.isRest();
    }

    private static boolean constructorHasRemovableDefinition(Node member) {
        Node fn = member.getFirstChild();
        Node superCall = OptimizeConstructors.getOnlySuperCall(fn);
        if (superCall == null) {
            return false;
        }
        Node paramList = NodeUtil.getFunctionParameters(fn);
        if (paramList.getChildCount() != superCall.getChildCount() - 1) {
            return false;
        }
        Node param = paramList.getFirstChild();
        Node arg = superCall.getSecondChild();
        while (param != null) {
            if (param.isRest() ? !arg.isSpread() || !param.getFirstChild().matchesName(arg.getFirstChild()) : !param.matchesName(arg)) {
                return false;
            }
            param = param.getNext();
            arg = arg.getNext();
        }
        return true;
    }

    private boolean hasRemovableParameterList(Node member) {
        Node fn = member.getFirstChild();
        Node paramList = NodeUtil.getFunctionParameters(fn);
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            if (param.isName() || param.isRest() && param.getFirstChild().isName() || param.isDefaultValue() && param.getFirstChild().isName() && !new AstAnalyzer(this.compiler, true).mayHaveSideEffects(param.getLastChild())) continue;
            return false;
        }
        return true;
    }

    private static Node getOnlySuperCall(Node fn) {
        Node call;
        Node stmt;
        Node body = fn.getLastChild();
        if (body.isBlock() && body.hasOneChild() && (stmt = body.getFirstChild()).isExprResult() && (call = stmt.getFirstChild()).isCall() && call.getFirstChild().isSuper()) {
            return call;
        }
        return null;
    }

    private void removeConstructorMethod(Node member) {
        Preconditions.checkState(member.isMemberFunctionDef());
        this.compiler.reportFunctionDeleted(member.getFirstChild());
        this.compiler.reportChangeToEnclosingScope(member);
        member.detach();
    }

    private static class ClassConstructorSummary {
        final int formalParameterCount;
        final boolean isVarArgs;
        final boolean referencesArguments;

        ClassConstructorSummary(boolean isVarArgs, boolean referencesArguments, int formalParameterCount) {
            this.isVarArgs = isVarArgs;
            this.referencesArguments = referencesArguments;
            this.formalParameterCount = formalParameterCount;
        }

        static ClassConstructorSummary build(Node classDefinition) {
            Node fn;
            Preconditions.checkState(classDefinition.isClass() || classDefinition.isFunction());
            if (classDefinition.isClass()) {
                Node member = NodeUtil.getEs6ClassConstructorMemberFunctionDef(classDefinition);
                fn = member.getFirstChild();
            } else {
                fn = classDefinition;
            }
            boolean argumentsReference = NodeUtil.doesFunctionReferenceOwnArgumentsObject(fn);
            boolean hasVarArgs = argumentsReference || OptimizeConstructors.functionHasRest(fn);
            return new ClassConstructorSummary(hasVarArgs, argumentsReference, NodeUtil.getFunctionParameters(fn).getChildCount());
        }

        public boolean isEquivalentConstructorDefinition(Node constructorMember) {
            Node fn = constructorMember.getFirstChild();
            Node paramList = NodeUtil.getFunctionParameters(fn);
            boolean hasRest = OptimizeConstructors.functionHasRest(fn);
            if (hasRest) {
                return true;
            }
            if (this.isVarArgs) {
                return false;
            }
            return this.formalParameterCount == paramList.getChildCount();
        }
    }
}

