/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.List;

class PeepholeOptimizationsPass
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final String passName;
    private final AbstractPeepholeOptimization[] peepholeOptimizations;
    private boolean retraverseOnChange;

    PeepholeOptimizationsPass(AbstractCompiler compiler, String passName, AbstractPeepholeOptimization ... optimizations) {
        this(compiler, passName, Arrays.asList(optimizations));
    }

    PeepholeOptimizationsPass(AbstractCompiler compiler, String passName, List<AbstractPeepholeOptimization> optimizations) {
        this.compiler = compiler;
        this.passName = passName;
        this.peepholeOptimizations = optimizations.toArray(new AbstractPeepholeOptimization[0]);
        this.retraverseOnChange = true;
    }

    @VisibleForTesting
    void setRetraverseOnChange(boolean retraverse) {
        this.retraverseOnChange = retraverse;
    }

    @Override
    public void process(Node externs, Node root) {
        this.beginTraversal();
        List<Node> changedScopeNodes = this.compiler.getChangedScopeNodesForPass(this.passName);
        while (changedScopeNodes == null || !changedScopeNodes.isEmpty()) {
            NodeTraversal.traverseScopeRoots(this.compiler, root, changedScopeNodes, new PeepCallback(), false);
            if (!this.retraverseOnChange) break;
            changedScopeNodes = this.compiler.getChangedScopeNodesForPass(this.passName);
        }
    }

    private void beginTraversal() {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.beginTraversal(this.compiler);
        }
    }

    private class PeepCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private PeepCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node currentNode = n;
            for (AbstractPeepholeOptimization optim : PeepholeOptimizationsPass.this.peepholeOptimizations) {
                if ((currentNode = optim.optimizeSubtree(currentNode)) != null) continue;
                return;
            }
        }
    }
}

