/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Ordering;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.List;

@GwtIncompatible(value="JsMessage")
class ReplaceMessagesForChrome
extends JsMessageVisitor {
    private final AstFactory astFactory;

    ReplaceMessagesForChrome(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator, JsMessage.Style style) {
        super(compiler, style, idGenerator);
        this.astFactory = compiler.createAstFactory();
    }

    private Node getChromeI18nGetMessageNode(String messageId) {
        Node getMessage = this.astFactory.createQNameWithUnknownType("chrome.i18n.getMessage");
        return this.astFactory.createCall(getMessage, AstFactory.type(StandardColors.STRING), this.astFactory.createString(messageId));
    }

    @Override
    protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
        try {
            Node msgNode = definition.getMessageNode();
            Node newValue = this.getNewValueNode(msgNode, message);
            newValue.srcrefTreeIfMissing(msgNode);
            msgNode.replaceWith(newValue);
            this.compiler.reportChangeToEnclosingScope(newValue);
        }
        catch (JsMessageVisitor.MalformedException e) {
            this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
        }
    }

    private Node getNewValueNode(Node origNode, JsMessage message) throws JsMessageVisitor.MalformedException {
        Node newValueNode = this.getChromeI18nGetMessageNode(message.getId());
        boolean isHtml = this.isHtml(origNode);
        if (!message.placeholders().isEmpty() || isHtml) {
            Node placeholderValues = origNode.getChildAtIndex(2);
            this.checkNode(placeholderValues, Token.OBJECTLIT);
            List<String> placeholderNames = Ordering.natural().sortedCopy(message.placeholders());
            Node placeholderValueArray = this.astFactory.createArraylit(new Node[0]);
            for (String name : placeholderNames) {
                Node value = ReplaceMessagesForChrome.getPlaceholderValue(placeholderValues, name);
                if (value == null) {
                    throw new JsMessageVisitor.MalformedException("No value was provided for placeholder " + name, origNode);
                }
                placeholderValueArray.addChildToBack(value);
            }
            if (isHtml) {
                Node args = this.astFactory.createArraylit(this.astFactory.createString(message.getId()), placeholderValueArray);
                Node options = this.astFactory.createArraylit(this.astFactory.createObjectLit(this.astFactory.createStringKey("escapeLt", this.astFactory.createBoolean(true))));
                Node regexp = IR.regexp(this.astFactory.createString("Chrome\\/(\\d+)")).setColor(StandardColors.UNKNOWN);
                Node userAgent = this.astFactory.createQNameWithUnknownType("navigator.userAgent");
                Node version = this.astFactory.createGetElem(this.astFactory.createOr(this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(regexp, "exec"), AstFactory.type(StandardColors.ARRAY_ID), userAgent), this.astFactory.createArraylit(new Node[0])), this.astFactory.createNumber(1.0));
                Node condition = IR.ge(version, this.astFactory.createNumber(79.0)).setColor(StandardColors.BOOLEAN);
                args = this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(args, "concat"), AstFactory.type(StandardColors.ARRAY_ID), this.astFactory.createHook(condition, options, this.astFactory.createArraylit(new Node[0])));
                newValueNode = this.astFactory.createCallWithUnknownType(this.astFactory.createQNameWithUnknownType("chrome.i18n.getMessage.apply"), this.astFactory.createNull(), args);
            } else {
                newValueNode.addChildToBack(placeholderValueArray);
            }
        }
        newValueNode.srcrefTreeIfMissing(origNode);
        return newValueNode;
    }

    private boolean isHtml(Node node) throws JsMessageVisitor.MalformedException {
        if (node.getChildCount() > 3) {
            Node options = node.getChildAtIndex(3);
            this.checkNode(options, Token.OBJECTLIT);
            for (Node opt = options.getFirstChild(); opt != null; opt = opt.getNext()) {
                this.checkNode(opt, Token.STRING_KEY);
                if (!opt.getString().equals("html")) continue;
                return opt.getFirstChild().isTrue();
            }
        }
        return false;
    }

    private static Node getPlaceholderValue(Node placeholderValues, String placeholderName) {
        for (Node key = placeholderValues.getFirstChild(); key != null; key = key.getNext()) {
            if (!key.getString().equals(placeholderName)) continue;
            return key.getFirstChild().cloneTree();
        }
        return null;
    }
}

