/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RewriteAsyncIteration
implements NodeTraversal.Callback,
CompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    static final DiagnosticType CANNOT_CONVERT_ASYNCGEN = DiagnosticType.error("JSC_CANNOT_CONVERT_ASYNCGEN", "Cannot convert async generator. {0}");
    private static final String ACTION_RECORD_NAME = "$jscomp.AsyncGeneratorWrapper$ActionRecord";
    private static final String ACTION_ENUM_AWAIT = "$jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE";
    private static final String ACTION_ENUM_YIELD = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE";
    private static final String ACTION_ENUM_YIELD_STAR = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR";
    private static final String FOR_AWAIT_ITERATOR_TEMP_NAME = "$jscomp$forAwait$tempIterator";
    private static final String FOR_AWAIT_RESULT_TEMP_NAME = "$jscomp$forAwait$tempResult";
    private int nextForAwaitId = 0;
    private final AbstractCompiler compiler;
    private final ArrayDeque<LexicalContext> contextStack;
    private final String thisVarName = "$jscomp$asyncIter$this";
    private final String argumentsVarName = "$jscomp$asyncIter$arguments";
    private final String superPropGetterPrefix = "$jscomp$asyncIter$super$get$";
    private final AstFactory astFactory;
    private final StaticScope namespace;

    private RewriteAsyncIteration(AbstractCompiler compiler, AstFactory astFactory, StaticScope namespace) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.astFactory = Preconditions.checkNotNull(astFactory);
        this.namespace = Preconditions.checkNotNull(namespace);
        this.contextStack = new ArrayDeque();
    }

    static RewriteAsyncIteration create(AbstractCompiler compiler) {
        AstFactory astFactory = compiler.createAstFactory();
        StaticScope namespace = compiler.getTranspilationNamespace();
        return new RewriteAsyncIteration(compiler, astFactory, namespace);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.contextStack.isEmpty());
        this.contextStack.push(LexicalContext.newGlobalContext(root));
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
        Preconditions.checkState(this.contextStack.element().function == null);
        this.contextStack.remove();
        Preconditions.checkState(this.contextStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.push(LexicalContext.newContextForFunction(this.contextStack.element(), n));
        } else if (n.isParamList()) {
            this.contextStack.push(LexicalContext.newContextForParamList(this.contextStack.element(), n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext ctx = this.contextStack.element();
        switch (n.getToken()) {
            case PARAM_LIST: {
                Preconditions.checkState(n.equals(ctx.contextRoot), n);
                this.contextStack.pop();
                break;
            }
            case FUNCTION: {
                Preconditions.checkState(n.equals(ctx.contextRoot));
                if (n.isAsyncGeneratorFunction()) {
                    this.convertAsyncGenerator(n);
                    this.prependTempVarDeclarations(ctx, t);
                }
                this.contextStack.pop();
                break;
            }
            case AWAIT: {
                Preconditions.checkNotNull(ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertAwaitOfAsyncGenerator(ctx, n);
                break;
            }
            case YIELD: {
                Preconditions.checkNotNull(ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertYieldOfAsyncGenerator(ctx, n);
                break;
            }
            case RETURN: {
                Preconditions.checkNotNull(ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertReturnOfAsyncGenerator(ctx, n);
                break;
            }
            case FOR_AWAIT_OF: {
                Preconditions.checkNotNull(ctx.function);
                Preconditions.checkState(ctx.function.isAsyncFunction());
                this.replaceForAwaitOf(ctx, n);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
                break;
            }
            case THIS: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceThis(ctx, n);
                break;
            }
            case NAME: {
                if (!ctx.mustReplaceThisSuperArgs() || !n.matchesName("arguments")) break;
                this.replaceArguments(ctx, n);
                break;
            }
            case SUPER: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceSuper(ctx, n, parent);
                break;
            }
        }
    }

    private void convertAsyncGenerator(Node originalFunction) {
        Preconditions.checkNotNull(originalFunction);
        Preconditions.checkState(originalFunction.isAsyncGeneratorFunction());
        Node asyncGeneratorWrapperRef = this.astFactory.createQName(this.namespace, "$jscomp.AsyncGeneratorWrapper");
        Node innerFunction = this.astFactory.createEmptyAsyncGeneratorWrapperArgument(null);
        Node innerBlock = originalFunction.getLastChild();
        innerBlock.detach();
        innerFunction.getLastChild().replaceWith(innerBlock);
        Node outerBlock = this.astFactory.createBlock(this.astFactory.createReturn(this.astFactory.createNewNode(asyncGeneratorWrapperRef, this.astFactory.createCall(innerFunction, AstFactory.type(StandardColors.GENERATOR_ID), new Node[0]))));
        originalFunction.addChildToBack(outerBlock);
        originalFunction.setIsAsyncFunction(false);
        originalFunction.setIsGeneratorFunction(false);
        originalFunction.srcrefTreeIfMissing(originalFunction);
        this.compiler.reportChangeToChangeScope(originalFunction);
        this.compiler.reportChangeToChangeScope(innerFunction);
    }

    private void convertAwaitOfAsyncGenerator(LexicalContext ctx, Node awaitNode) {
        Preconditions.checkNotNull(awaitNode);
        Preconditions.checkState(awaitNode.isAwait());
        Preconditions.checkState(ctx != null && ctx.function != null);
        Preconditions.checkState(ctx.function.isAsyncGeneratorFunction());
        Node expression = awaitNode.removeFirstChild();
        Preconditions.checkNotNull(expression, "await needs an expression");
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), this.astFactory.createQName(this.namespace, ACTION_ENUM_AWAIT), expression);
        newActionRecord.srcrefTreeIfMissing(awaitNode);
        awaitNode.addChildToFront(newActionRecord);
        awaitNode.setToken(Token.YIELD);
    }

    private void convertYieldOfAsyncGenerator(LexicalContext ctx, Node yieldNode) {
        Preconditions.checkNotNull(yieldNode);
        Preconditions.checkState(yieldNode.isYield());
        Preconditions.checkState(ctx != null && ctx.function != null);
        Preconditions.checkState(ctx.function.isAsyncGeneratorFunction());
        Node expression = yieldNode.removeFirstChild();
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), new Node[0]);
        if (yieldNode.isYieldAll()) {
            Preconditions.checkNotNull(expression);
            newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD_STAR));
            newActionRecord.addChildToBack(expression);
        } else {
            if (expression == null) {
                expression = NodeUtil.newUndefinedNode(null);
            }
            newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD));
            newActionRecord.addChildToBack(expression);
        }
        newActionRecord.srcrefTreeIfMissing(yieldNode);
        yieldNode.addChildToFront(newActionRecord);
        yieldNode.putBooleanProp(Node.YIELD_ALL, false);
    }

    private void convertReturnOfAsyncGenerator(LexicalContext ctx, Node returnNode) {
        Preconditions.checkNotNull(returnNode);
        Preconditions.checkState(returnNode.isReturn());
        Preconditions.checkState(ctx != null && ctx.function != null);
        Preconditions.checkState(ctx.function.isAsyncGeneratorFunction());
        Node expression = returnNode.removeFirstChild();
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), new Node[0]);
        if (expression == null) {
            expression = NodeUtil.newUndefinedNode(null);
        }
        newActionRecord.addChildToBack(this.astFactory.createQName(this.namespace, ACTION_ENUM_YIELD));
        newActionRecord.addChildToBack(expression);
        newActionRecord.srcrefTreeIfMissing(returnNode);
        returnNode.addChildToFront(newActionRecord);
    }

    private void replaceForAwaitOf(LexicalContext ctx, Node forAwaitOf) {
        Node lhsAssignment;
        AstFactory.Type resultType;
        int forAwaitId = this.nextForAwaitId++;
        String iteratorTempName = FOR_AWAIT_ITERATOR_TEMP_NAME + forAwaitId;
        String resultTempName = FOR_AWAIT_RESULT_TEMP_NAME + forAwaitId;
        Preconditions.checkState(forAwaitOf.hasParent(), "Cannot replace parentless for-await-of");
        Node lhs = forAwaitOf.removeFirstChild();
        Node rhs = forAwaitOf.removeFirstChild();
        Node originalBody = forAwaitOf.removeFirstChild();
        Node initializer = this.astFactory.createSingleConstNameDeclaration(iteratorTempName, this.astFactory.createJSCompMakeAsyncIteratorCall(rhs, this.namespace)).srcrefTreeIfMissing(rhs);
        AstFactory.Type iterableResultType = AstFactory.type(StandardColors.TOP_OBJECT);
        Node breakIfDone = this.astFactory.createIf(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "done", AstFactory.type(StandardColors.BOOLEAN)), this.astFactory.createBlock(this.astFactory.createBreak()));
        if (lhs.isValidAssignmentTarget()) {
            resultType = AstFactory.type(lhs);
            lhsAssignment = this.astFactory.exprResult(this.astFactory.createAssign(lhs, this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType)));
        } else if (NodeUtil.isNameDeclaration(lhs)) {
            Node declarationTarget = lhs.getFirstChild();
            if (declarationTarget.isName()) {
                resultType = AstFactory.type(declarationTarget);
                declarationTarget.addChildToBack(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType));
            } else {
                Preconditions.checkState(declarationTarget.isDestructuringLhs(), declarationTarget);
                Node destructuringPattern = declarationTarget.getOnlyChild();
                resultType = AstFactory.type(destructuringPattern);
                declarationTarget.addChildToBack(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value", resultType));
            }
            lhsAssignment = lhs;
        } else {
            throw new AssertionError((Object)"unexpected for-await-of lhs");
        }
        lhsAssignment.srcrefTreeIfMissing(lhs);
        Node resultDeclaration = this.astFactory.createSingleConstNameDeclaration(resultTempName, this.constructAwaitNextResult(ctx, iteratorTempName, resultType, iterableResultType));
        Node newForLoop = this.astFactory.createFor(initializer, this.astFactory.createEmpty(), this.astFactory.createEmpty(), this.astFactory.createBlock(resultDeclaration, breakIfDone, lhsAssignment, this.ensureBlock(originalBody)));
        forAwaitOf.replaceWith(newForLoop);
        newForLoop.srcrefTreeIfMissing(forAwaitOf);
        this.compiler.reportChangeToEnclosingScope(newForLoop);
    }

    private Node ensureBlock(Node possiblyBlock) {
        return possiblyBlock.isBlock() ? possiblyBlock : this.astFactory.createBlock(possiblyBlock).srcref(possiblyBlock);
    }

    private Node constructAwaitNextResult(LexicalContext ctx, String iteratorTempName, AstFactory.Type iteratorType, AstFactory.Type iterableResultType) {
        Preconditions.checkNotNull(ctx.function);
        Node iteratorTemp = this.astFactory.createName(iteratorTempName, iteratorType);
        Node result = ctx.function.isAsyncGeneratorFunction() ? this.astFactory.createYield(iterableResultType, this.astFactory.createNewNode(this.astFactory.createQName(this.namespace, ACTION_RECORD_NAME), this.astFactory.createQName(this.namespace, ACTION_ENUM_AWAIT), this.astFactory.createCallWithUnknownType(this.astFactory.createGetPropWithUnknownType(iteratorTemp, "next"), new Node[0]))) : this.astFactory.createAwait(iterableResultType, this.astFactory.createCall(this.astFactory.createGetPropWithUnknownType(iteratorTemp, "next"), AstFactory.type(StandardColors.PROMISE_ID), new Node[0]));
        return result;
    }

    private void replaceThis(LexicalContext ctx, Node n) {
        Preconditions.checkArgument(n.isThis());
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName("$jscomp$asyncIter$this", AstFactory.type(n)).srcref(n));
        ((LexicalContext)ctx).thisSuperArgsContext.thisNodeToAdd = this.astFactory.createThis(AstFactory.type(n));
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceArguments(LexicalContext ctx, Node n) {
        Preconditions.checkArgument(n.isName() && "arguments".equals(n.getString()));
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName("$jscomp$asyncIter$arguments", AstFactory.type(n)).srcref(n));
        ctx.thisSuperArgsContext.usedArguments = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceSuper(LexicalContext ctx, Node n, Node parent) {
        if (!parent.isGetProp()) {
            this.compiler.report(JSError.make(parent, CANNOT_CONVERT_ASYNCGEN, "super only allowed with getprop (like super.foo(), not super['foo']())"));
            return;
        }
        Preconditions.checkArgument(n.isSuper());
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        String propertyName = parent.getString();
        String propertyReplacementNameText = "$jscomp$asyncIter$super$get$" + propertyName;
        Node getPropReplacement = this.astFactory.createCall(this.astFactory.createName(propertyReplacementNameText, AstFactory.type(StandardColors.TOP_OBJECT)), AstFactory.type(parent), new Node[0]);
        Node grandparent = parent.getParent();
        if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
            getPropReplacement = this.astFactory.createGetPropWithUnknownType(getPropReplacement, "call");
            ((LexicalContext)ctx).thisSuperArgsContext.thisNodeToAdd = this.astFactory.createThisForEs6ClassMember(ctx.contextRoot.getParent());
            this.astFactory.createName("$jscomp$asyncIter$this", AstFactory.type(((LexicalContext)ctx).thisSuperArgsContext.thisNodeToAdd)).srcref(parent).insertAfter(parent);
        }
        getPropReplacement.srcrefTree(parent);
        parent.replaceWith(getPropReplacement);
        ctx.thisSuperArgsContext.usedSuperProperties.add(parent);
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void prependTempVarDeclarations(LexicalContext ctx, NodeTraversal t) {
        Preconditions.checkArgument(ctx != null);
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        ThisSuperArgsContext thisSuperArgsCtx = ctx.thisSuperArgsContext;
        Node function = ctx.function;
        Node block = function.getLastChild();
        Preconditions.checkNotNull(block, function);
        Node prefixBlock = this.astFactory.createBlock(new Node[0]);
        if (thisSuperArgsCtx.thisNodeToAdd != null) {
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration("$jscomp$asyncIter$this", thisSuperArgsCtx.thisNodeToAdd).srcrefTree(block));
        }
        if (thisSuperArgsCtx.usedArguments) {
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration("$jscomp$asyncIter$arguments", this.astFactory.createArgumentsReference()).srcrefTree(block));
        }
        for (Node replacedMethodReference : thisSuperArgsCtx.usedSuperProperties) {
            prefixBlock.addChildToBack(this.createSuperMethodReferenceGetter(replacedMethodReference, t));
        }
        prefixBlock.srcrefTreeIfMissing(block);
        block.addChildrenToFront(prefixBlock.removeChildren());
        if (thisSuperArgsCtx.thisNodeToAdd != null || thisSuperArgsCtx.usedArguments || !thisSuperArgsCtx.usedSuperProperties.isEmpty()) {
            this.compiler.reportChangeToChangeScope(function);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        }
    }

    private Node createSuperMethodReferenceGetter(Node replacedMethodReference, NodeTraversal t) {
        AstFactory.Type typeOfSuper = AstFactory.type(replacedMethodReference.getFirstChild());
        Node superReference = this.astFactory.createSuper(typeOfSuper);
        String replacedMethodName = replacedMethodReference.getString();
        Node arrowFunction = this.astFactory.createZeroArgArrowFunctionForExpression(this.astFactory.createGetProp(superReference, replacedMethodName, AstFactory.type(replacedMethodReference)));
        this.compiler.reportChangeToChangeScope(arrowFunction);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS, this.compiler);
        String superReplacementName = "$jscomp$asyncIter$super$get$" + replacedMethodName;
        return this.astFactory.createSingleConstNameDeclaration(superReplacementName, arrowFunction);
    }

    private static final class ThisSuperArgsContext {
        private final LexicalContext ctx;
        private final Set<Node> usedSuperProperties = new LinkedHashSet<Node>();
        @Nullable
        Node thisNodeToAdd = null;
        private boolean usedArguments = false;

        ThisSuperArgsContext(LexicalContext ctx) {
            this.ctx = ctx;
        }
    }

    private static final class LexicalContext {
        private final Node contextRoot;
        private final Node function;
        private final ThisSuperArgsContext thisSuperArgsContext;

        private LexicalContext(Node contextRoot) {
            this.contextRoot = Preconditions.checkNotNull(contextRoot);
            this.function = null;
            this.thisSuperArgsContext = null;
        }

        private LexicalContext(LexicalContext parent, Node contextRoot, Node function) {
            Preconditions.checkNotNull(parent);
            Preconditions.checkNotNull(contextRoot);
            Preconditions.checkArgument(contextRoot == function || contextRoot.isParamList(), contextRoot);
            Preconditions.checkNotNull(function);
            Preconditions.checkArgument(function.isFunction(), function);
            this.contextRoot = contextRoot;
            this.function = function;
            this.thisSuperArgsContext = function.isArrowFunction() ? parent.thisSuperArgsContext : (contextRoot.isFunction() ? new ThisSuperArgsContext(this) : null);
        }

        static LexicalContext newGlobalContext(Node contextRoot) {
            return new LexicalContext(contextRoot);
        }

        static LexicalContext newContextForFunction(LexicalContext parent, Node function) {
            return new LexicalContext(parent, function, function);
        }

        static LexicalContext newContextForParamList(LexicalContext parent, Node paramList) {
            return new LexicalContext(parent, paramList, parent.function);
        }

        Node getFunctionDeclaringThisArgsSuper() {
            return ((ThisSuperArgsContext)this.thisSuperArgsContext).ctx.function;
        }

        boolean mustReplaceThisSuperArgs() {
            return this.thisSuperArgsContext != null && this.getFunctionDeclaringThisArgsSuper().isAsyncGeneratorFunction();
        }
    }
}

