/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AutoValue_TypeMismatch;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

@AutoValue
public abstract class TypeMismatch
implements Serializable {
    private static final Node TEST_LOCATION = IR.empty();

    public abstract JSType getFound();

    public abstract JSType getRequired();

    public abstract Node getLocation();

    private static TypeMismatch create(JSType found, JSType required, Node location) {
        return new AutoValue_TypeMismatch(found, required, location);
    }

    @VisibleForTesting
    public static TypeMismatch createForTesting(JSType found, JSType required) {
        return TypeMismatch.create(found, required, TEST_LOCATION);
    }

    static class Accumulator
    implements Serializable {
        private final ArrayList<TypeMismatch> mismatches = new ArrayList();

        Accumulator() {
        }

        void registerMismatch(Node location, JSType found, JSType required) {
            if ((found = Accumulator.removeNullUndefinedAndTemplates(found)).isSubtypeOf(required = Accumulator.removeNullUndefinedAndTemplates(required)) || required.isSubtypeOf(found)) {
                return;
            }
            if (Accumulator.bothAreNotTemplateTypes(found, required)) {
                this.mismatches.add(TypeMismatch.create(found, required, location));
            }
            if (found.isFunctionType() && required.isFunctionType()) {
                FunctionType fnTypeA = found.toMaybeFunctionType();
                FunctionType fnTypeB = required.toMaybeFunctionType();
                Iterator paramItA = fnTypeA.getParameters().iterator();
                Iterator paramItB = fnTypeB.getParameters().iterator();
                while (paramItA.hasNext() && paramItB.hasNext()) {
                    this.registerIfMismatch(location, ((FunctionType.Parameter)paramItA.next()).getJSType(), ((FunctionType.Parameter)paramItB.next()).getJSType());
                }
                this.registerIfMismatch(location, fnTypeA.getReturnType(), fnTypeB.getReturnType());
            }
        }

        ImmutableCollection<TypeMismatch> getMismatches() {
            return ImmutableList.copyOf(this.mismatches);
        }

        private void registerIfMismatch(Node location, JSType found, JSType required) {
            if (found != null && required != null && !found.isSubtypeOf(required)) {
                this.registerMismatch(location, found, required);
            }
        }

        private static boolean bothAreNotTemplateTypes(JSType found, JSType required) {
            return !found.isTemplateType() && !required.isTemplateType();
        }

        private static JSType removeNullUndefinedAndTemplates(JSType t) {
            JSType result = t.restrictByNotNullOrUndefined();
            ObjectType obj = result.toMaybeObjectType();
            if (obj != null && obj.isTemplatizedType()) {
                return obj.toMaybeTemplatizedType().getRawType();
            }
            return result;
        }
    }
}

