/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

class TypeTransformation {
    private static final String VIRTUAL_FILE = "<TypeTransformation.java>";
    static final DiagnosticType UNKNOWN_TYPEVAR = DiagnosticType.warning("TYPEVAR_UNDEFINED", "Reference to an unknown type variable {0}");
    static final DiagnosticType UNKNOWN_STRVAR = DiagnosticType.warning("UNKNOWN_STRVAR", "Reference to an unknown string variable {0}");
    static final DiagnosticType UNKNOWN_TYPENAME = DiagnosticType.warning("TYPENAME_UNDEFINED", "Reference to an unknown type name {0}");
    static final DiagnosticType BASETYPE_INVALID = DiagnosticType.warning("BASETYPE_INVALID", "The type {0} cannot be templatized");
    static final DiagnosticType TEMPTYPE_INVALID = DiagnosticType.warning("TEMPTYPE_INVALID", "Expected templatized type in {0} found {1}");
    static final DiagnosticType INDEX_OUTOFBOUNDS = DiagnosticType.warning("INDEX_OUTOFBOUNDS", "Index out of bounds in templateTypeOf: expected a number less than {0}, found {1}");
    static final DiagnosticType DUPLICATE_VARIABLE = DiagnosticType.warning("DUPLICATE_VARIABLE", "The variable {0} is already defined");
    static final DiagnosticType UNKNOWN_NAMEVAR = DiagnosticType.warning("UNKNOWN_NAMEVAR", "Reference to an unknown name variable {0}");
    static final DiagnosticType RECTYPE_INVALID = DiagnosticType.warning("RECTYPE_INVALID", "The first parameter of a maprecord must be a record type, found {0}");
    static final DiagnosticType MAPRECORD_BODY_INVALID = DiagnosticType.warning("MAPRECORD_BODY_INVALID", "The body of a maprecord function must evaluate to a record type or a no type, found {0}");
    static final DiagnosticType VAR_UNDEFINED = DiagnosticType.warning("VAR_UNDEFINED", "Variable {0} is undefined in the scope");
    static final DiagnosticType INVALID_CTOR = DiagnosticType.warning("INVALID_CTOR", "Expected a constructor type, found {0}");
    static final DiagnosticType RECPARAM_INVALID = DiagnosticType.warning("RECPARAM_INVALID", "Expected a record type, found {0}");
    static final DiagnosticType PROPTYPE_INVALID = DiagnosticType.warning("PROPTYPE_INVALID", "Expected object type, found {0}");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final StaticTypedScope typeEnv;

    TypeTransformation(AbstractCompiler compiler, StaticTypedScope typeEnv) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.typeEnv = typeEnv;
    }

    private boolean isTypeVar(Node n) {
        return n.isName();
    }

    private boolean isTypeName(Node n) {
        return n.isStringLit();
    }

    private boolean isBooleanOperation(Node n) {
        return n.isAnd() || n.isOr() || n.isNot();
    }

    private TypeTransformationParser.Keywords nameToKeyword(String s) {
        return TypeTransformationParser.Keywords.valueOf(Ascii.toUpperCase(s));
    }

    private JSType getType(String typeName) {
        JSDocInfo jsdoc;
        JSType type = this.registry.getType(this.typeEnv, typeName);
        if (type != null) {
            return type;
        }
        StaticTypedSlot slot = this.typeEnv.getSlot(typeName);
        JSType jSType = type = slot != null ? slot.getType() : null;
        if (type != null) {
            if (type.isConstructor() || type.isInterface()) {
                return type.toMaybeFunctionType().getInstanceType().getRawType();
            }
            if (type.isEnumElementType()) {
                return type.getEnumeratedTypeOfEnumElement();
            }
            return type;
        }
        JSDocInfo jSDocInfo = jsdoc = slot == null ? null : slot.getJSDocInfo();
        if (jsdoc != null && jsdoc.hasTypedefType()) {
            return this.registry.evaluateTypeExpression(jsdoc.getTypedefType(), this.typeEnv);
        }
        return null;
    }

    private JSType getUnknownType() {
        return this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private JSType getNoType() {
        return this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
    }

    private JSType getAllType() {
        return this.registry.getNativeType(JSTypeNative.ALL_TYPE);
    }

    private JSType getObjectType() {
        return this.registry.getNativeType(JSTypeNative.OBJECT_TYPE);
    }

    private JSType createUnionType(JSType[] variants) {
        return this.registry.createUnionType(variants);
    }

    private JSType createRecordType(ImmutableMap<String, JSType> props) {
        return this.registry.createRecordType(props);
    }

    private void reportWarning(Node n, DiagnosticType msg, String ... param) {
        this.compiler.report(JSError.make(n, msg, param));
    }

    private <T> ImmutableMap<String, T> addNewEntry(ImmutableMap<String, T> map, String name, T type) {
        return new ImmutableMap.Builder<String, T>().putAll(map).put(name, type).buildOrThrow();
    }

    private String getFunctionParameter(Node n, int i) {
        Preconditions.checkArgument(n.isFunction(), "Expected a function node, found %s", (Object)n);
        return n.getSecondChild().getChildAtIndex(i).getString();
    }

    private String getCallName(Node n) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getFirstChild().getString();
    }

    private Node getCallArgument(Node n, int i) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getChildAtIndex(i + 1);
    }

    private int getCallParamCount(Node n) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        return n.getChildCount() - 1;
    }

    private ImmutableList<Node> getCallParams(Node n) {
        Preconditions.checkArgument(n.isCall(), "Expected a call node, found %s", (Object)n);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < this.getCallParamCount(n); ++i) {
            builder.add(this.getCallArgument(n, i));
        }
        return builder.build();
    }

    private Node getComputedPropValue(Node n) {
        Preconditions.checkArgument(n.isComputedProp(), "Expected a computed property node, found %s", (Object)n);
        return n.getSecondChild();
    }

    private String getComputedPropName(Node n) {
        Preconditions.checkArgument(n.isComputedProp(), "Expected a computed property node, found %s", (Object)n);
        return n.getFirstChild().getString();
    }

    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        return this.eval(ttlAst, typeVars, ImmutableMap.of());
    }

    @VisibleForTesting
    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars, ImmutableMap<String, String> nameVars) {
        JSType result = this.evalInternal(ttlAst, new NameResolver(typeVars, nameVars));
        return result.isEmptyType() ? this.getUnknownType() : result;
    }

    private JSType evalInternal(Node ttlAst, NameResolver nameResolver) {
        if (this.isTypeName(ttlAst)) {
            return this.evalTypeName(ttlAst);
        }
        if (this.isTypeVar(ttlAst)) {
            return this.evalTypeVar(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case TYPE_CONSTRUCTOR: {
                return this.evalTypeExpression(ttlAst, nameResolver);
            }
            case OPERATION: {
                return this.evalOperationExpression(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Could not evaluate the type transformation expression");
    }

    private JSType evalOperationExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case COND: {
                return this.evalConditional(ttlAst, nameResolver);
            }
            case MAPUNION: {
                return this.evalMapunion(ttlAst, nameResolver);
            }
            case MAPRECORD: {
                return this.evalMaprecord(ttlAst, nameResolver);
            }
            case TYPEOFVAR: {
                return this.evalTypeOfVar(ttlAst);
            }
            case INSTANCEOF: {
                return this.evalInstanceOf(ttlAst, nameResolver);
            }
            case PRINTTYPE: {
                return this.evalPrintType(ttlAst, nameResolver);
            }
            case PROPTYPE: {
                return this.evalPropType(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid type transformation operation");
    }

    private JSType evalTypeExpression(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case TYPE: {
                return this.evalTemplatizedType(ttlAst, nameResolver);
            }
            case UNION: {
                return this.evalUnionType(ttlAst, nameResolver);
            }
            case NONE: {
                return this.getNoType();
            }
            case ALL: {
                return this.getAllType();
            }
            case UNKNOWN: {
                return this.getUnknownType();
            }
            case RAWTYPEOF: {
                return this.evalRawTypeOf(ttlAst, nameResolver);
            }
            case TEMPLATETYPEOF: {
                return this.evalTemplateTypeOf(ttlAst, nameResolver);
            }
            case RECORD: {
                return this.evalRecordType(ttlAst, nameResolver);
            }
            case TYPEEXPR: {
                return this.evalNativeTypeExpr(ttlAst);
            }
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private JSType evalTypeName(Node ttlAst) {
        String typeName = ttlAst.getString();
        JSType resultingType = this.getType(typeName);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPENAME, typeName);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalTemplatizedType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType firstParam = this.evalInternal((Node)params.get(0), nameResolver);
        if (!firstParam.isRawTypeOfTemplatizedType()) {
            this.reportWarning(ttlAst, BASETYPE_INVALID, firstParam.toString());
            return this.getUnknownType();
        }
        JSType[] templatizedTypes = new JSType[params.size() - 1];
        Arrays.setAll(templatizedTypes, i -> this.evalInternal((Node)params.get(i + 1), nameResolver));
        ObjectType baseType = firstParam.toMaybeObjectType();
        return this.registry.createTemplatizedType(baseType, templatizedTypes);
    }

    private JSType evalTypeVar(Node ttlAst, NameResolver nameResolver) {
        String typeVar = ttlAst.getString();
        JSType resultingType = nameResolver.typeVars.get(typeVar);
        if (resultingType == null) {
            this.reportWarning(ttlAst, UNKNOWN_TYPEVAR, typeVar);
            return this.getUnknownType();
        }
        return resultingType;
    }

    private JSType evalUnionType(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        JSType[] basicTypes = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            basicTypes[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return this.createUnionType(basicTypes);
    }

    private JSType[] evalTypeParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        JSType[] result = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalInternal((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private String evalString(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isName()) {
            if (!nameResolver.nameVars.containsKey(ttlAst.getString())) {
                this.reportWarning(ttlAst, UNKNOWN_STRVAR, ttlAst.getString());
                return "";
            }
            return nameResolver.nameVars.get(ttlAst.getString());
        }
        return ttlAst.getString();
    }

    private String[] evalStringParams(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        int paramCount = params.size();
        String[] result = new String[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            result[i] = this.evalString((Node)params.get(i), nameResolver);
        }
        return result;
    }

    private boolean evalTypePredicate(Node ttlAst, NameResolver nameResolver) {
        JSType[] params = this.evalTypeParams(ttlAst, nameResolver);
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        JSType type = params[0];
        switch (keyword) {
            case EQ: {
                return type.equals(params[1]);
            }
            case SUB: {
                return type.isSubtypeOf(params[1]);
            }
            case ISCTOR: {
                return type.isConstructor();
            }
            case ISTEMPLATIZED: {
                return type.isTemplatizedType();
            }
            case ISRECORD: {
                return type.isRecordType();
            }
            case ISUNKNOWN: {
                return type.isUnknownType();
            }
        }
        throw new IllegalStateException("Invalid type predicate in the type transformation");
    }

    private boolean evalStringPredicate(Node ttlAst, NameResolver nameResolver) {
        String[] params = this.evalStringParams(ttlAst, nameResolver);
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].isEmpty()) continue;
            return false;
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case STREQ: {
                return params[0].equals(params[1]);
            }
        }
        throw new IllegalStateException("Invalid string predicate in the type transformation");
    }

    private boolean evalTypevarPredicate(Node ttlAst, NameResolver nameResolver) {
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword) {
            case ISDEFINED: {
                return nameResolver.typeVars.containsKey(this.getCallArgument(ttlAst, 0).getString());
            }
        }
        throw new IllegalStateException("Invalid typevar predicate in the type transformation");
    }

    private boolean evalBooleanOperation(Node ttlAst, NameResolver nameResolver) {
        boolean param0 = this.evalBoolean(ttlAst.getFirstChild(), nameResolver);
        if (ttlAst.isNot()) {
            return !param0;
        }
        if (ttlAst.isAnd()) {
            return param0 && this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        if (ttlAst.isOr()) {
            return param0 || this.evalBoolean(ttlAst.getLastChild(), nameResolver);
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private boolean evalBoolean(Node ttlAst, NameResolver nameResolver) {
        if (this.isBooleanOperation(ttlAst)) {
            return this.evalBooleanOperation(ttlAst, nameResolver);
        }
        String name = this.getCallName(ttlAst);
        TypeTransformationParser.Keywords keyword = this.nameToKeyword(name);
        switch (keyword.kind) {
            case STRING_PREDICATE: {
                return this.evalStringPredicate(ttlAst, nameResolver);
            }
            case TYPE_PREDICATE: {
                return this.evalTypePredicate(ttlAst, nameResolver);
            }
            case TYPEVAR_PREDICATE: {
                return this.evalTypevarPredicate(ttlAst, nameResolver);
            }
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private JSType evalConditional(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        if (this.evalBoolean((Node)params.get(0), nameResolver)) {
            return this.evalInternal((Node)params.get(1), nameResolver);
        }
        return this.evalInternal((Node)params.get(2), nameResolver);
    }

    private JSType evalMapunion(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        Node unionParam = (Node)params.get(0);
        Node mapFunction = (Node)params.get(1);
        String paramName = this.getFunctionParameter(mapFunction, 0);
        if (nameResolver.typeVars.containsKey(paramName)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramName);
            return this.getUnknownType();
        }
        Node mapFunctionBody = NodeUtil.getFunctionBody(mapFunction);
        JSType unionType = this.evalInternal(unionParam, nameResolver);
        if (!unionType.isUnionType()) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, unionType), nameResolver.nameVars);
            return this.evalInternal(mapFunctionBody, newNameResolver);
        }
        ImmutableList<JSType> unionElms = ImmutableList.copyOf(unionType.getUnionMembers());
        int unionSize = unionElms.size();
        JSType[] newUnionElms = new JSType[unionSize];
        int i = 0;
        for (JSType elm : unionElms) {
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramName, elm), nameResolver.nameVars);
            newUnionElms[i] = this.evalInternal(mapFunctionBody, newNameResolver);
            ++i;
        }
        return this.createUnionType(newUnionElms);
    }

    private JSType evalRawTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "rawTypeOf", type.toString());
            return this.getUnknownType();
        }
        return type.toMaybeObjectType().getRawType();
    }

    private JSType evalTemplateTypeOf(Node ttlAst, NameResolver nameResolver) {
        ImmutableList<JSType> templateTypes;
        ImmutableList<Node> params = this.getCallParams(ttlAst);
        JSType type = this.evalInternal((Node)params.get(0), nameResolver);
        if (!type.isTemplatizedType()) {
            this.reportWarning(ttlAst, TEMPTYPE_INVALID, "templateTypeOf", type.toString());
            return this.getUnknownType();
        }
        int index = (int)((Node)params.get(1)).getDouble();
        if (index >= (templateTypes = type.toMaybeObjectType().getTemplateTypes()).size()) {
            this.reportWarning(ttlAst, INDEX_OUTOFBOUNDS, Integer.toString(templateTypes.size()), Integer.toString(index));
            return this.getUnknownType();
        }
        return (JSType)templateTypes.get(index);
    }

    private JSType evalRecord(Node record, NameResolver nameResolver) {
        LinkedHashMap<String, JSType> props = new LinkedHashMap<String, JSType>();
        for (Node propNode = record.getFirstChild(); propNode != null; propNode = propNode.getNext()) {
            if (propNode.isComputedProp()) {
                String compPropName = this.getComputedPropName(propNode);
                if (!nameResolver.nameVars.containsKey(compPropName)) {
                    this.reportWarning(record, UNKNOWN_NAMEVAR, compPropName);
                    return this.getUnknownType();
                }
                Node propValue = this.getComputedPropValue(propNode);
                String resolvedName = nameResolver.nameVars.get(compPropName);
                JSType resultingType = this.evalInternal(propValue, nameResolver);
                props.put(resolvedName, resultingType);
                continue;
            }
            String propName = propNode.getString();
            JSType resultingType = this.evalInternal(propNode.getFirstChild(), nameResolver);
            props.put(propName, resultingType);
        }
        return this.registry.createRecordType(props);
    }

    private JSType evalRecordParam(Node ttlAst, NameResolver nameResolver) {
        if (ttlAst.isObjectLit()) {
            return this.evalRecord(ttlAst, nameResolver);
        }
        return this.evalInternal(ttlAst, nameResolver);
    }

    private JSType evalRecordType(Node ttlAst, NameResolver nameResolver) {
        int paramCount = this.getCallParamCount(ttlAst);
        ImmutableList.Builder recTypesBuilder = new ImmutableList.Builder();
        for (int i = 0; i < paramCount; ++i) {
            JSType type = this.evalRecordParam(this.getCallArgument(ttlAst, i), nameResolver);
            ObjectType objType = type.toMaybeObjectType();
            if (objType == null || objType.isUnknownType()) {
                this.reportWarning(ttlAst, RECPARAM_INVALID, type.toString());
                return this.getUnknownType();
            }
            JSType recType = this.registry.buildRecordTypeFromObject(objType);
            if (recType.equals(this.getObjectType())) continue;
            recTypesBuilder.add(recType.toMaybeObjectType());
        }
        return this.joinRecordTypes((ImmutableList<ObjectType>)recTypesBuilder.build());
    }

    private void putNewPropInPropertyMap(Map<String, JSType> props, String newPropName, JSType newPropValue) {
        if (!(props.containsKey(newPropName) && newPropValue.isRecordType() && props.get(newPropName).isRecordType())) {
            props.put(newPropName, newPropValue);
            return;
        }
        props.put(newPropName, this.joinRecordTypes(ImmutableList.of((ObjectType)props.get(newPropName), (ObjectType)newPropValue)));
    }

    private JSType joinRecordTypes(ImmutableList<ObjectType> recTypes) {
        LinkedHashMap<String, JSType> props = new LinkedHashMap<String, JSType>();
        for (ObjectType recType : recTypes) {
            for (String newPropName : recType.getOwnPropertyNames()) {
                JSType newPropValue = recType.getPropertyType(newPropName);
                this.putNewPropInPropertyMap(props, newPropName, newPropValue);
            }
        }
        return this.createRecordType(ImmutableMap.copyOf(props));
    }

    private JSType evalMaprecord(Node ttlAst, NameResolver nameResolver) {
        Node recordNode = ttlAst.getSecondChild();
        Node mapFunction = ttlAst.getChildAtIndex(2);
        JSType type = this.evalInternal(recordNode, nameResolver);
        if (type.equals(this.getObjectType())) {
            return this.getObjectType();
        }
        if (!type.isRecordType()) {
            this.reportWarning(recordNode, RECTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        ObjectType objtype = type.toMaybeObjectType();
        String paramKey = this.getFunctionParameter(mapFunction, 0);
        String paramValue = this.getFunctionParameter(mapFunction, 1);
        if (nameResolver.nameVars.containsKey(paramKey)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramKey);
            return this.getUnknownType();
        }
        if (nameResolver.typeVars.containsKey(paramValue)) {
            this.reportWarning(ttlAst, DUPLICATE_VARIABLE, paramValue);
            return this.getUnknownType();
        }
        Node mapFnBody = NodeUtil.getFunctionBody(mapFunction);
        LinkedHashMap<String, JSType> newProps = new LinkedHashMap<String, JSType>();
        for (String propName : objtype.getOwnPropertyNames()) {
            JSType propValue = objtype.getPropertyType(propName);
            NameResolver newNameResolver = new NameResolver(this.addNewEntry(nameResolver.typeVars, paramValue, propValue), this.addNewEntry(nameResolver.nameVars, paramKey, propName));
            JSType body = this.evalInternal(mapFnBody, newNameResolver);
            if (body.isUnknownType()) {
                return this.getUnknownType();
            }
            if (body.isEmptyType() || body.equals(this.getObjectType())) continue;
            if (!body.isRecordType()) {
                this.reportWarning(ttlAst, MAPRECORD_BODY_INVALID, body.toString());
                return this.getUnknownType();
            }
            ObjectType bodyAsObj = body.toMaybeObjectType();
            for (String newPropName : bodyAsObj.getOwnPropertyNames()) {
                JSType newPropValue = bodyAsObj.getPropertyType(newPropName);
                this.putNewPropInPropertyMap(newProps, newPropName, newPropValue);
            }
        }
        return this.createRecordType(ImmutableMap.copyOf(newProps));
    }

    private JSType evalTypeOfVar(Node ttlAst) {
        JSType type;
        String name = this.getCallArgument(ttlAst, 0).getString();
        StaticTypedSlot slot = this.typeEnv.getSlot(name);
        JSType jSType = type = slot != null ? slot.getType() : null;
        if (type == null) {
            this.reportWarning(ttlAst, VAR_UNDEFINED, name);
            return this.getUnknownType();
        }
        return type;
    }

    private JSType evalInstanceOf(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 0), nameResolver);
        if (type.isUnknownType() || !type.isConstructor()) {
            this.reportWarning(ttlAst, INVALID_CTOR, type.getDisplayName());
            return this.getUnknownType();
        }
        return type.toMaybeFunctionType().getInstanceType();
    }

    private JSType evalNativeTypeExpr(Node ttlAst) {
        JSTypeExpression expr = new JSTypeExpression(this.getCallArgument(ttlAst, 0), VIRTUAL_FILE);
        return this.registry.evaluateTypeExpression(expr, this.typeEnv);
    }

    private JSType evalPrintType(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        String msg = this.getCallArgument(ttlAst, 0).getString() + type;
        System.out.println(msg);
        return type;
    }

    private JSType evalPropType(Node ttlAst, NameResolver nameResolver) {
        JSType type = this.evalInternal(this.getCallArgument(ttlAst, 1), nameResolver);
        ObjectType objType = type.toMaybeObjectType();
        if (objType == null) {
            this.reportWarning(ttlAst, PROPTYPE_INVALID, type.toString());
            return this.getUnknownType();
        }
        JSType propType = objType.getPropertyType(this.getCallArgument(ttlAst, 0).getString());
        return MoreObjects.firstNonNull(propType, this.getUnknownType());
    }

    private static class NameResolver {
        ImmutableMap<String, JSType> typeVars;
        ImmutableMap<String, String> nameVars;

        NameResolver(ImmutableMap<String, JSType> typeVars, ImmutableMap<String, String> nameVars) {
            this.typeVars = typeVars;
            this.nameVars = nameVars;
        }
    }
}

