/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableBiMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.common.io.Files;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.Immutable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Map;

@Immutable
public final class VariableMap
implements Serializable {
    private static final char SEPARATOR = ':';
    private final ImmutableBiMap<String, String> map;

    public VariableMap(Map<String, String> map) {
        this.map = ImmutableBiMap.copyOf(map);
    }

    public String lookupNewName(String sourceName) {
        return (String)this.map.get(sourceName);
    }

    public String lookupSourceName(String newName) {
        return (String)((ImmutableMap)((Object)this.map.inverse())).get(newName);
    }

    public ImmutableMap<String, String> getOriginalNameToNewNameMap() {
        return ImmutableSortedMap.copyOf(this.map);
    }

    public ImmutableMap<String, String> getNewNameToOriginalNameMap() {
        return this.map.inverse();
    }

    @GwtIncompatible(value="com.google.javascript.jscomp.jarjar.com.google.io.Files")
    public void save(String filename) throws IOException {
        Files.write(this.toBytes(), new File(filename));
    }

    @GwtIncompatible(value="java.io.File")
    public static VariableMap load(String filename) throws IOException {
        try {
            return VariableMap.fromBytes(Files.toByteArray(new File(filename)));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @GwtIncompatible(value="java.io.ByteArrayOutputStream")
    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        try {
            for (Map.Entry entry : ImmutableSortedSet.copyOf(Map.Entry.comparingByKey(), this.map.entrySet())) {
                writer.write(VariableMap.escape((String)entry.getKey()));
                ((Writer)writer).write(58);
                writer.write(VariableMap.escape((String)entry.getValue()));
                ((Writer)writer).write(10);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    @GwtIncompatible(value="com.google.common.base.Splitter.onPattern()")
    public static VariableMap fromBytes(byte[] bytes) throws ParseException {
        String string = new String(bytes, StandardCharsets.UTF_8);
        ImmutableMap.Builder<String, String> map = ImmutableMap.builder();
        int startOfLine = 0;
        while (startOfLine < string.length()) {
            int newLine = string.indexOf(10, startOfLine);
            if (newLine == -1) {
                newLine = string.length();
            }
            int endOfLine = newLine;
            if (string.charAt(newLine - 1) == '\r') {
                --newLine;
            }
            String line = string.substring(startOfLine, newLine);
            startOfLine = endOfLine + 1;
            if (line.isEmpty()) continue;
            int pos = VariableMap.findIndexOfUnescapedChar(line, ':');
            if (pos <= 0) {
                throw new ParseException("Bad line: " + line, 0);
            }
            map.put(VariableMap.unescape(line.substring(0, pos)), pos == line.length() - 1 ? "" : VariableMap.unescape(line.substring(pos + 1)));
        }
        return new VariableMap(map.buildOrThrow());
    }

    private static String escape(String value) {
        return value.replace("\\", "\\\\").replace(":", "\\:").replace("\n", "\\n");
    }

    private static int findIndexOfUnescapedChar(String value, char stopChar) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            int stopCharIndex = value.indexOf(stopChar, i);
            if (stopCharIndex == -1) {
                return -1;
            }
            if (value.charAt(stopCharIndex - 1) != '\\') {
                return stopCharIndex;
            }
            i = stopCharIndex + 1;
        }
        return -1;
    }

    private static String unescape(String value) {
        int slashIndex = value.indexOf(92);
        if (slashIndex == -1) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length() - 1);
        sb.append(value, 0, slashIndex);
        int len = value.length();
        for (int i = slashIndex; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len) {
                c = value.charAt(i);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static VariableMap fromMap(Map<String, String> map) {
        return new VariableMap(map);
    }

    @VisibleForTesting
    ImmutableMap<String, String> toMap() {
        return this.map;
    }
}

