/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.util.LinkedHashMap;

class ColorGraphNodeFactory {
    private final LinkedHashMap<Color, ColorGraphNode> typeIndex;
    private final ColorRegistry registry;

    protected ColorGraphNodeFactory(LinkedHashMap<Color, ColorGraphNode> initialTypeIndex, ColorRegistry registry) {
        this.typeIndex = initialTypeIndex;
        this.registry = registry;
    }

    static ColorGraphNodeFactory createFactory(ColorRegistry colorRegistry) {
        LinkedHashMap<Color, ColorGraphNode> typeIndex = new LinkedHashMap<Color, ColorGraphNode>();
        ColorGraphNode unknownColorNode = ColorGraphNode.create(StandardColors.UNKNOWN, 0);
        typeIndex.put(StandardColors.UNKNOWN, unknownColorNode);
        return new ColorGraphNodeFactory(typeIndex, colorRegistry);
    }

    public ColorGraphNode createNode(@Nullable Color color) {
        Color key = this.simplifyColor(color);
        return this.typeIndex.computeIfAbsent(key, this::newColorGraphNode);
    }

    public ImmutableSet<ColorGraphNode> getAllKnownTypes() {
        return ImmutableSet.copyOf(this.typeIndex.values());
    }

    private ColorGraphNode newColorGraphNode(Color key) {
        int id = this.typeIndex.size();
        return ColorGraphNode.create(key, id);
    }

    private Color simplifyColor(@Nullable Color type) {
        if (type == null) {
            return StandardColors.UNKNOWN;
        }
        if (type.isUnion()) {
            return (type = type.subtractNullOrVoid()).isUnion() ? Color.createUnion(type.getUnionElements().stream().map(this::simplifyColor).collect(ImmutableSet.toImmutableSet())) : this.simplifyColor(type);
        }
        if (type.getBoxId() != null) {
            return this.registry.get(type.getBoxId());
        }
        if (type.equals(StandardColors.NULL_OR_VOID)) {
            return StandardColors.UNKNOWN;
        }
        return type;
    }
}

