/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtCompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Objects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterators;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.MultimapBuilder;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimaps;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class StandardUnionFind<E>
implements Serializable,
UnionFind<E> {
    private final Map<E, Node<E>> elmap = new LinkedHashMap<E, Node<E>>();

    public StandardUnionFind() {
    }

    public StandardUnionFind(UnionFind<E> other) {
        for (E elem : other.elements()) {
            this.union(other.find(elem), elem);
        }
    }

    @Override
    public void add(@Nullable E e) {
        this.union(e, e);
    }

    public void addAll(Iterable<E> es) {
        for (E e : es) {
            this.add(e);
        }
    }

    @Override
    @CanIgnoreReturnValue
    public E union(@Nullable E a, @Nullable E b) {
        Node<E> nodeB;
        Node<E> nodeA = this.findRootOrCreateNode(a);
        if (nodeA == (nodeB = this.findRootOrCreateNode(b))) {
            return nodeA.element;
        }
        if (nodeA.rank >= nodeB.rank) {
            nodeB.parent = nodeA;
            nodeA.size += nodeB.size;
            if (nodeA.rank == nodeB.rank) {
                ++nodeA.rank;
            }
            return nodeA.element;
        }
        nodeA.parent = nodeB;
        nodeB.size += nodeA.size;
        Object temp = nodeB.element;
        nodeB.element = nodeA.element;
        nodeA.element = temp;
        return nodeB.element;
    }

    @Override
    public E find(@Nullable E e) {
        Preconditions.checkArgument(this.elmap.containsKey(e), "Element does not exist: %s", e);
        return this.findRoot(this.elmap.get(e)).element;
    }

    @Override
    public boolean areEquivalent(@Nullable E a, @Nullable E b) {
        E bRep;
        E aRep = this.find(a);
        return aRep == (bRep = this.find(b));
    }

    @Override
    public Set<E> elements() {
        return Collections.unmodifiableSet(this.elmap.keySet());
    }

    @Override
    public ImmutableList<ImmutableSet<E>> allEquivalenceClasses() {
        Multimap groupsTmp = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        for (Node<E> elem : this.elmap.values()) {
            groupsTmp.put(this.findRoot(elem), elem.element);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (Set group : Multimaps.asMap(groupsTmp).values()) {
            result.add(ImmutableSet.copyOf(group));
        }
        return result.build();
    }

    public ImmutableSet<E> allRepresentatives() {
        return this.elmap.values().stream().filter(n -> n == n.parent).map(n -> n.element).collect(ImmutableSet.toImmutableSet());
    }

    private Node<E> findRootOrCreateNode(E e) {
        Node<E> node = this.elmap.get(e);
        if (node != null) {
            return this.findRoot(node);
        }
        node = new Node<E>(e);
        this.elmap.put(e, node);
        return node;
    }

    private Node<E> findRoot(Node<E> node) {
        if (node.parent != node) {
            node.parent = this.findRoot(node.parent);
        }
        return node.parent;
    }

    @Override
    public Set<E> findAll(final @Nullable E value) {
        Preconditions.checkArgument(this.elmap.containsKey(value), "Element does not exist: %s", value);
        final Predicate<Object> isSameRoot = new Predicate<Object>(){
            Node<E> nodeForValue;
            {
                this.nodeForValue = (Node)StandardUnionFind.this.elmap.get(value);
            }

            @Override
            public boolean apply(@Nullable Object b) {
                if (Objects.equal(value, b)) {
                    return true;
                }
                Node nodeForB = (Node)StandardUnionFind.this.elmap.get(b);
                if (nodeForB == null) {
                    return false;
                }
                this.nodeForValue = StandardUnionFind.this.findRoot(this.nodeForValue);
                return StandardUnionFind.this.findRoot(nodeForB) == this.nodeForValue;
            }
        };
        return new AbstractSet<E>(){

            @Override
            public boolean contains(Object o) {
                return isSameRoot.apply(o);
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(StandardUnionFind.this.elmap.keySet().iterator(), isSameRoot);
            }

            @Override
            public int size() {
                return ((StandardUnionFind)StandardUnionFind.this).findRoot((Node)((Node)((StandardUnionFind)StandardUnionFind.this).elmap.get((Object)value))).size;
            }
        };
    }

    private static class Node<E> {
        Node<E> parent = this;
        E element;
        int rank = 0;
        int size = 1;

        Node(E element) {
            this.element = element;
        }
    }
}

