/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation.reporter;

import com.google.javascript.jscomp.instrumentation.reporter.ReportDecoder;
import com.google.javascript.jscomp.instrumentation.reporter.proto.FileProfile;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPoint;
import com.google.javascript.jscomp.instrumentation.reporter.proto.InstrumentationPointStats;
import com.google.javascript.jscomp.instrumentation.reporter.proto.ReportProfile;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@GwtIncompatible
final class ProfilingReport {
    ProfilingReport() {
    }

    public static String createTabSeparatedProfilingReport(Map<String, InstrumentationPoint> instrumentationMapping, ImmutableList<Map<String, Long>> allInstrumentationReports) {
        List profiles = allInstrumentationReports.stream().map(report -> ReportDecoder.decodeReport(instrumentationMapping, report)).collect(Collectors.toList());
        Map metrics = instrumentationMapping.values().stream().collect(Collectors.toMap(Function.identity(), point -> new InstrumentationPointMetrics()));
        for (ReportProfile profile : profiles) {
            for (FileProfile fileProfile : profile.getFileProfileList()) {
                for (InstrumentationPointStats pointStats : fileProfile.getInstrumentationPointsStatsList()) {
                    InstrumentationPointMetrics metric = metrics.get(pointStats.getPoint());
                    metric.totalTimesExecuted += pointStats.getTimesExecuted();
                    metric.numberOfReports++;
                }
            }
        }
        ArrayList result = new ArrayList(metrics.entrySet());
        Collections.sort(result, Comparator.comparing(point -> ((InstrumentationPoint)point.getKey()).getFileName()).thenComparingLong(point -> -((InstrumentationPointMetrics)point.getValue()).totalTimesExecuted).thenComparingInt(point -> ((InstrumentationPoint)point.getKey()).getLineNumber()).thenComparingInt(point -> ((InstrumentationPoint)point.getKey()).getType().getNumber()));
        ArrayList<ImmutableList<String>> output = new ArrayList<ImmutableList<String>>();
        output.add(ImmutableList.of("File", "Function name", "Line", "Type", "Total executed", "Reports occured"));
        for (Map.Entry entry : result) {
            output.add(ImmutableList.of(((InstrumentationPoint)entry.getKey()).getFileName(), ((InstrumentationPoint)entry.getKey()).getFunctionName(), String.valueOf(((InstrumentationPoint)entry.getKey()).getLineNumber()), ((InstrumentationPoint)entry.getKey()).getType().name(), String.valueOf(((InstrumentationPointMetrics)entry.getValue()).totalTimesExecuted), String.valueOf(((InstrumentationPointMetrics)entry.getValue()).numberOfReports)));
        }
        return output.stream().map(row -> String.join((CharSequence)"\t", row)).collect(Collectors.joining("\n"));
    }

    private static class InstrumentationPointMetrics {
        private long totalTimesExecuted = 0L;
        private int numberOfReports = 0;

        private InstrumentationPointMetrics() {
        }
    }
}

