/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public final class CheckPrimitiveAsObject
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType NEW_PRIMITIVE_OBJECT = DiagnosticType.warning("JSC_PRIMITIVE_OBJECT", "Explicit creation of a {0} object.");
    public static final DiagnosticType PRIMITIVE_OBJECT_DECLARATION = DiagnosticType.warning("JSC_PRIMITIVE_OBJECT_DECLARATION", "Declaration of {0} object instead of primitive type.");
    private static final ImmutableSet<String> PRIMITIVE_OBJECT_CONSTRUCTORS = ImmutableSet.of("Boolean", "Number", "String");
    private final AbstractCompiler compiler;

    public CheckPrimitiveAsObject(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.checkForPrimitiveObjectConstructor(t, n);
        this.checkForPrimitiveObjectDeclaration(t, n);
    }

    private void checkForPrimitiveObjectDeclaration(NodeTraversal t, Node n) {
        JSDocInfo jsDocInfo = n.getJSDocInfo();
        if (jsDocInfo != null) {
            for (Node typeRoot : jsDocInfo.getTypeNodes()) {
                this.checkTypeNodeForPrimitiveObjectDeclaration(t, typeRoot);
            }
        }
    }

    private void checkTypeNodeForPrimitiveObjectDeclaration(NodeTraversal t, Node typeRoot) {
        NodeUtil.visitPreOrder(typeRoot, node -> {
            String typeName;
            if (node.isStringLit() && PRIMITIVE_OBJECT_CONSTRUCTORS.contains(typeName = node.getString())) {
                t.report(node, PRIMITIVE_OBJECT_DECLARATION, typeName);
            }
        });
    }

    private void checkForPrimitiveObjectConstructor(NodeTraversal t, Node n) {
        String constructorName;
        Node constructorFunction;
        if (n.isNew() && (constructorFunction = n.getFirstChild()).isName() && PRIMITIVE_OBJECT_CONSTRUCTORS.contains(constructorName = constructorFunction.getString())) {
            t.report(n, NEW_PRIMITIVE_OBJECT, constructorName);
        }
    }
}

