/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.regex;

import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.regex.CharRanges;

public final class CaseCanonicalize {
    public static final CharRanges CASE_SENSITIVE = CharRanges.withRanges(65, 91, 97, 123, 181, 182, 192, 215, 216, 223, 224, 247, 248, 304, 306, 312, 313, 329, 330, 383, 384, 397, 398, 411, 412, 426, 428, 442, 444, 446, 447, 448, 452, 496, 497, 545, 546, 564, 570, 575, 577, 592, 595, 597, 598, 600, 601, 602, 603, 604, 608, 609, 611, 612, 616, 618, 619, 620, 623, 624, 626, 627, 629, 630, 637, 638, 640, 641, 643, 644, 648, 653, 658, 659, 837, 838, 891, 894, 902, 903, 904, 907, 908, 909, 910, 912, 913, 930, 931, 944, 945, 975, 976, 978, 981, 983, 984, 1011, 1013, 1014, 1015, 1020, 1021, 1154, 1162, 1300, 1329, 1367, 1377, 1415, 4256, 4294, 7549, 7550, 7680, 7830, 7835, 7836, 7840, 7930, 7936, 7958, 7960, 7966, 7968, 8006, 8008, 8014, 8017, 8018, 8019, 8020, 8021, 8022, 8023, 8024, 8025, 8026, 8027, 8028, 8029, 8030, 8031, 8062, 8112, 8114, 8120, 8124, 8126, 8127, 8136, 8140, 8144, 8146, 8152, 8156, 8160, 8162, 8165, 8166, 8168, 8173, 8184, 8188, 8498, 8499, 8526, 8527, 8544, 8576, 8579, 8581, 9398, 9450, 11264, 11311, 11312, 11359, 11360, 11373, 11381, 11383, 11392, 11492, 11520, 11558, 65313, 65339, 65345, 65371);
    private static final CharRanges UCASE_ASCII_LETTERS = CharRanges.inclusive(65, 90);
    private static final ImmutableList<DeltaSet> DELTA_SETS = ImmutableList.of(new DeltaSet(-10795, CharRanges.withMembers(570)), new DeltaSet(-10792, CharRanges.withMembers(574)), new DeltaSet(-10743, CharRanges.withMembers(619)), new DeltaSet(-10727, CharRanges.withMembers(637)), new DeltaSet(-7264, CharRanges.withRanges(4256, 4294)), new DeltaSet(-7205, CharRanges.withMembers(921)), new DeltaSet(-3814, CharRanges.withMembers(7549)), new DeltaSet(-743, CharRanges.withMembers(181)), new DeltaSet(-219, CharRanges.withMembers(439)), new DeltaSet(-218, CharRanges.withMembers(422, 425, 430)), new DeltaSet(-217, CharRanges.withRanges(433, 435)), new DeltaSet(-214, CharRanges.withMembers(415)), new DeltaSet[]{new DeltaSet(-213, CharRanges.withMembers(413)), new DeltaSet(-211, CharRanges.withMembers(406, 412)), new DeltaSet(-210, CharRanges.withMembers(385)), new DeltaSet(-209, CharRanges.withMembers(407)), new DeltaSet(-207, CharRanges.withMembers(404)), new DeltaSet(-206, CharRanges.withMembers(390)), new DeltaSet(-205, CharRanges.withRanges(393, 395, 403, 404)), new DeltaSet(-203, CharRanges.withMembers(400)), new DeltaSet(-202, CharRanges.withMembers(399)), new DeltaSet(-195, CharRanges.withMembers(384)), new DeltaSet(-163, CharRanges.withMembers(410)), new DeltaSet(-130, CharRanges.withRanges(414, 415, 891, 894)), new DeltaSet(-128, CharRanges.withRanges(8056, 8058)), new DeltaSet(-126, CharRanges.withRanges(8060, 8062)), new DeltaSet(-121, CharRanges.withMembers(255)), new DeltaSet(-112, CharRanges.withRanges(8058, 8060)), new DeltaSet(-100, CharRanges.withRanges(8054, 8056)), new DeltaSet(-97, CharRanges.withMembers(405)), new DeltaSet(-96, CharRanges.withMembers(917)), new DeltaSet(-86, CharRanges.withRanges(922, 923, 8050, 8054)), new DeltaSet(-84, CharRanges.withMembers(837)), new DeltaSet(-80, CharRanges.withRanges(929, 930, 1024, 1040)), new DeltaSet(-79, CharRanges.withMembers(398)), new DeltaSet(-74, CharRanges.withRanges(8048, 8050)), new DeltaSet(-71, CharRanges.withMembers(581)), new DeltaSet(-69, CharRanges.withMembers(580)), new DeltaSet(-64, CharRanges.withMembers(908)), new DeltaSet(-63, CharRanges.withRanges(910, 912)), new DeltaSet(-62, CharRanges.withMembers(914)), new DeltaSet(-59, CharRanges.withMembers(7776)), new DeltaSet(-57, CharRanges.withMembers(920)), new DeltaSet(-56, CharRanges.withMembers(447)), new DeltaSet(-54, CharRanges.withMembers(928)), new DeltaSet(-48, CharRanges.withRanges(1329, 1367, 11264, 11311)), new DeltaSet(-47, CharRanges.withMembers(934)), new DeltaSet(-38, CharRanges.withMembers(902)), new DeltaSet(-37, CharRanges.withRanges(904, 907)), new DeltaSet(-32, CharRanges.withRanges(65, 91, 192, 215, 216, 223, 913, 930, 931, 940, 1040, 1072, 65313, 65339)), new DeltaSet(-31, CharRanges.withMembers(931)), new DeltaSet(-28, CharRanges.withMembers(8498)), new DeltaSet(-26, CharRanges.withRanges(9398, 9424)), new DeltaSet(-16, CharRanges.withRanges(8544, 8560)), new DeltaSet(-15, CharRanges.withMembers(1216)), new DeltaSet(-8, CharRanges.withRanges(7936, 7944, 7952, 7958, 7968, 7976, 7984, 7992, 8000, 8006, 8017, 8018, 8019, 8020, 8021, 8022, 8023, 8024, 8032, 8040, 8112, 8114, 8144, 8146, 8160, 8162)), new DeltaSet(-7, CharRanges.withMembers(1010, 8165)), new DeltaSet(-2, CharRanges.withMembers(452, 455, 458, 497)), new DeltaSet(-1, CharRanges.withMembers(256, 258, 260, 262, 264, 266, 268, 270, 272, 274, 276, 278, 280, 282, 284, 286, 288, 290, 292, 294, 296, 298, 300, 302, 306, 308, 310, 313, 315, 317, 319, 321, 323, 325, 327, 330, 332, 334, 336, 338, 340, 342, 344, 346, 348, 350, 352, 354, 356, 358, 360, 362, 364, 366, 368, 370, 372, 374, 377, 379, 381, 386, 388, 391, 395, 401, 408, 416, 418, 420, 423, 428, 431, 435, 437, 440, 444, 452, 455, 458, 461, 463, 465, 467, 469, 471, 473, 475, 478, 480, 482, 484, 486, 488, 490, 492, 494, 497, 500, 504, 506, 508, 510, 512, 514, 516, 518, 520, 522, 524, 526, 528, 530, 532, 534, 536, 538, 540, 542, 546, 548, 550, 552, 554, 556, 558, 560, 562, 571, 577, 582, 584, 586, 588, 590, 984, 986, 988, 990, 992, 994, 996, 998, 1000, 1002, 1004, 1006, 1015, 1018, 1120, 1122, 1124, 1126, 1128, 1130, 1132, 1134, 1136, 1138, 1140, 1142, 1144, 1146, 1148, 1150, 1152, 1162, 1164, 1166, 1168, 1170, 1172, 1174, 1176, 1178, 1180, 1182, 1184, 1186, 1188, 1190, 1192, 1194, 1196, 1198, 1200, 1202, 1204, 1206, 1208, 1210, 1212, 1214, 1217, 1219, 1221, 1223, 1225, 1227, 1229, 1232, 1234, 1236, 1238, 1240, 1242, 1244, 1246, 1248, 1250, 1252, 1254, 1256, 1258, 1260, 1262, 1264, 1266, 1268, 1270, 1272, 1274, 1276, 1278, 1280, 1282, 1284, 1286, 1288, 1290, 1292, 1294, 1296, 1298, 7680, 7682, 7684, 7686, 7688, 7690, 7692, 7694, 7696, 7698, 7700, 7702, 7704, 7706, 7708, 7710, 7712, 7714, 7716, 7718, 7720, 7722, 7724, 7726, 7728, 7730, 7732, 7734, 7736, 7738, 7740, 7742, 7744, 7746, 7748, 7750, 7752, 7754, 7756, 7758, 7760, 7762, 7764, 7766, 7768, 7770, 7772, 7774, 7776, 7778, 7780, 7782, 7784, 7786, 7788, 7790, 7792, 7794, 7796, 7798, 7800, 7802, 7804, 7806, 7808, 7810, 7812, 7814, 7816, 7818, 7820, 7822, 7824, 7826, 7828, 7840, 7842, 7844, 7846, 7848, 7850, 7852, 7854, 7856, 7858, 7860, 7862, 7864, 7866, 7868, 7870, 7872, 7874, 7876, 7878, 7880, 7882, 7884, 7886, 7888, 7890, 7892, 7894, 7896, 7898, 7900, 7902, 7904, 7906, 7908, 7910, 7912, 7914, 7916, 7918, 7920, 7922, 7924, 7926, 7928, 8579, 11360, 11367, 11369, 11371, 11381, 11392, 11394, 11396, 11398, 11400, 11402, 11404, 11406, 11408, 11410, 11412, 11414, 11416, 11418, 11420, 11422, 11424, 11426, 11428, 11430, 11432, 11434, 11436, 11438, 11440, 11442, 11444, 11446, 11448, 11450, 11452, 11454, 11456, 11458, 11460, 11462, 11464, 11466, 11468, 11470, 11472, 11474, 11476, 11478, 11480, 11482, 11484, 11486, 11488, 11490)), new DeltaSet(1, CharRanges.withMembers(257, 259, 261, 263, 265, 267, 269, 271, 273, 275, 277, 279, 281, 283, 285, 287, 289, 291, 293, 295, 297, 299, 301, 303, 307, 309, 311, 314, 316, 318, 320, 322, 324, 326, 328, 331, 333, 335, 337, 339, 341, 343, 345, 347, 349, 351, 353, 355, 357, 359, 361, 363, 365, 367, 369, 371, 373, 375, 378, 380, 382, 387, 389, 392, 396, 402, 409, 417, 419, 421, 424, 429, 432, 436, 438, 441, 445, 453, 456, 459, 462, 464, 466, 468, 470, 472, 474, 476, 479, 481, 483, 485, 487, 489, 491, 493, 495, 498, 501, 505, 507, 509, 511, 513, 515, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535, 537, 539, 541, 543, 547, 549, 551, 553, 555, 557, 559, 561, 563, 572, 578, 583, 585, 587, 589, 591, 985, 987, 989, 991, 993, 995, 997, 999, 1001, 1003, 1005, 1007, 1016, 1019, 1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 1153, 1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 1179, 1181, 1183, 1185, 1187, 1189, 1191, 1193, 1195, 1197, 1199, 1201, 1203, 1205, 1207, 1209, 1211, 1213, 1215, 1218, 1220, 1222, 1224, 1226, 1228, 1230, 1233, 1235, 1237, 1239, 1241, 1243, 1245, 1247, 1249, 1251, 1253, 1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273, 1275, 1277, 1279, 1281, 1283, 1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 7681, 7683, 7685, 7687, 7689, 7691, 7693, 7695, 7697, 7699, 7701, 7703, 7705, 7707, 7709, 7711, 7713, 7715, 7717, 7719, 7721, 7723, 7725, 7727, 7729, 7731, 7733, 7735, 7737, 7739, 7741, 7743, 7745, 7747, 7749, 7751, 7753, 7755, 7757, 7759, 7761, 7763, 7765, 7767, 7769, 7771, 7773, 7775, 7777, 7779, 7781, 7783, 7785, 7787, 7789, 7791, 7793, 7795, 7797, 7799, 7801, 7803, 7805, 7807, 7809, 7811, 7813, 7815, 7817, 7819, 7821, 7823, 7825, 7827, 7829, 7841, 7843, 7845, 7847, 7849, 7851, 7853, 7855, 7857, 7859, 7861, 7863, 7865, 7867, 7869, 7871, 7873, 7875, 7877, 7879, 7881, 7883, 7885, 7887, 7889, 7891, 7893, 7895, 7897, 7899, 7901, 7903, 7905, 7907, 7909, 7911, 7913, 7915, 7917, 7919, 7921, 7923, 7925, 7927, 7929, 8580, 11361, 11368, 11370, 11372, 11382, 11393, 11395, 11397, 11399, 11401, 11403, 11405, 11407, 11409, 11411, 11413, 11415, 11417, 11419, 11421, 11423, 11425, 11427, 11429, 11431, 11433, 11435, 11437, 11439, 11441, 11443, 11445, 11447, 11449, 11451, 11453, 11455, 11457, 11459, 11461, 11463, 11465, 11467, 11469, 11471, 11473, 11475, 11477, 11479, 11481, 11483, 11485, 11487, 11489, 11491)), new DeltaSet(2, CharRanges.withMembers(454, 457, 460, 499)), new DeltaSet(7, CharRanges.withMembers(1017, 8172)), new DeltaSet(8, CharRanges.withRanges(7944, 7952, 7960, 7966, 7976, 7984, 7992, 8000, 8008, 8014, 8025, 8026, 8027, 8028, 8029, 8030, 8031, 8032, 8040, 8048, 8120, 8122, 8152, 8154, 8168, 8170)), new DeltaSet(15, CharRanges.withMembers(1231)), new DeltaSet(16, CharRanges.withRanges(8560, 8576)), new DeltaSet(26, CharRanges.withRanges(9424, 9450)), new DeltaSet(28, CharRanges.withMembers(8526)), new DeltaSet(31, CharRanges.withMembers(962)), new DeltaSet(32, CharRanges.withRanges(97, 123, 224, 247, 248, 255, 945, 962, 963, 972, 1072, 1104, 65345, 65371)), new DeltaSet(37, CharRanges.withRanges(941, 944)), new DeltaSet(38, CharRanges.withMembers(940)), new DeltaSet(47, CharRanges.withMembers(981)), new DeltaSet(48, CharRanges.withRanges(1377, 1415, 11312, 11359)), new DeltaSet(54, CharRanges.withMembers(982)), new DeltaSet(56, CharRanges.withMembers(503)), new DeltaSet(57, CharRanges.withMembers(977)), new DeltaSet(59, CharRanges.withMembers(7835)), new DeltaSet(62, CharRanges.withMembers(976)), new DeltaSet(63, CharRanges.withRanges(973, 975)), new DeltaSet(64, CharRanges.withMembers(972)), new DeltaSet(69, CharRanges.withMembers(649)), new DeltaSet(71, CharRanges.withMembers(652)), new DeltaSet(74, CharRanges.withRanges(8122, 8124)), new DeltaSet(79, CharRanges.withMembers(477)), new DeltaSet(80, CharRanges.withRanges(1009, 1010, 1104, 1120)), new DeltaSet(84, CharRanges.withMembers(921)), new DeltaSet(86, CharRanges.withRanges(1008, 1009, 8136, 8140)), new DeltaSet(96, CharRanges.withMembers(1013)), new DeltaSet(97, CharRanges.withMembers(502)), new DeltaSet(100, CharRanges.withRanges(8154, 8156)), new DeltaSet(112, CharRanges.withRanges(8170, 8172)), new DeltaSet(121, CharRanges.withMembers(376)), new DeltaSet(126, CharRanges.withRanges(8186, 8188)), new DeltaSet(128, CharRanges.withRanges(8184, 8186)), new DeltaSet(130, CharRanges.withRanges(544, 545, 1021, 1024)), new DeltaSet(163, CharRanges.withMembers(573)), new DeltaSet(195, CharRanges.withMembers(579)), new DeltaSet(202, CharRanges.withMembers(601)), new DeltaSet(203, CharRanges.withMembers(603)), new DeltaSet(205, CharRanges.withRanges(598, 600, 608, 609)), new DeltaSet(206, CharRanges.withMembers(596)), new DeltaSet(207, CharRanges.withMembers(611)), new DeltaSet(209, CharRanges.withMembers(616)), new DeltaSet(210, CharRanges.withMembers(595)), new DeltaSet(211, CharRanges.withMembers(617, 623)), new DeltaSet(213, CharRanges.withMembers(626)), new DeltaSet(214, CharRanges.withMembers(629)), new DeltaSet(217, CharRanges.withRanges(650, 652)), new DeltaSet(218, CharRanges.withMembers(640, 643, 648)), new DeltaSet(219, CharRanges.withMembers(658)), new DeltaSet(743, CharRanges.withMembers(924)), new DeltaSet(3814, CharRanges.withMembers(11363)), new DeltaSet(7205, CharRanges.withMembers(8126)), new DeltaSet(7264, CharRanges.withRanges(11520, 11558)), new DeltaSet(10727, CharRanges.withMembers(11364)), new DeltaSet(10743, CharRanges.withMembers(11362)), new DeltaSet(10792, CharRanges.withMembers(11366)), new DeltaSet(10795, CharRanges.withMembers(11365))});
    private static final ImmutableList<DeltaSet> CANON_DELTA_SETS = ImmutableList.of(new DeltaSet(-10743, CharRanges.withMembers(619)), new DeltaSet(-10727, CharRanges.withMembers(637)), new DeltaSet(-3814, CharRanges.withMembers(7549)), new DeltaSet(-743, CharRanges.withMembers(181)), new DeltaSet(-195, CharRanges.withMembers(384)), new DeltaSet(-163, CharRanges.withMembers(410)), new DeltaSet(-130, CharRanges.withRanges(414, 415, 891, 894)), new DeltaSet(-128, CharRanges.withRanges(8056, 8058)), new DeltaSet(-126, CharRanges.withRanges(8060, 8062)), new DeltaSet(-121, CharRanges.withMembers(255)), new DeltaSet(-112, CharRanges.withRanges(8058, 8060)), new DeltaSet(-100, CharRanges.withRanges(8054, 8056)), new DeltaSet[]{new DeltaSet(-97, CharRanges.withMembers(405)), new DeltaSet(-86, CharRanges.withRanges(8050, 8054)), new DeltaSet(-84, CharRanges.withMembers(837)), new DeltaSet(-74, CharRanges.withRanges(8048, 8050)), new DeltaSet(-56, CharRanges.withMembers(447)), new DeltaSet(-8, CharRanges.withRanges(7936, 7944, 7952, 7958, 7968, 7976, 7984, 7992, 8000, 8006, 8017, 8018, 8019, 8020, 8021, 8022, 8023, 8024, 8032, 8040, 8112, 8114, 8144, 8146, 8160, 8162)), new DeltaSet(-7, CharRanges.withMembers(1010, 8165)), new DeltaSet(1, CharRanges.withMembers(257, 259, 261, 263, 265, 267, 269, 271, 273, 275, 277, 279, 281, 283, 285, 287, 289, 291, 293, 295, 297, 299, 301, 303, 307, 309, 311, 314, 316, 318, 320, 322, 324, 326, 328, 331, 333, 335, 337, 339, 341, 343, 345, 347, 349, 351, 353, 355, 357, 359, 361, 363, 365, 367, 369, 371, 373, 375, 378, 380, 382, 387, 389, 392, 396, 402, 409, 417, 419, 421, 424, 429, 432, 436, 438, 441, 445, 453, 456, 459, 462, 464, 466, 468, 470, 472, 474, 476, 479, 481, 483, 485, 487, 489, 491, 493, 495, 498, 501, 505, 507, 509, 511, 513, 515, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535, 537, 539, 541, 543, 547, 549, 551, 553, 555, 557, 559, 561, 563, 572, 578, 583, 585, 587, 589, 591, 985, 987, 989, 991, 993, 995, 997, 999, 1001, 1003, 1005, 1007, 1016, 1019, 1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 1153, 1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 1179, 1181, 1183, 1185, 1187, 1189, 1191, 1193, 1195, 1197, 1199, 1201, 1203, 1205, 1207, 1209, 1211, 1213, 1215, 1218, 1220, 1222, 1224, 1226, 1228, 1230, 1233, 1235, 1237, 1239, 1241, 1243, 1245, 1247, 1249, 1251, 1253, 1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273, 1275, 1277, 1279, 1281, 1283, 1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 7681, 7683, 7685, 7687, 7689, 7691, 7693, 7695, 7697, 7699, 7701, 7703, 7705, 7707, 7709, 7711, 7713, 7715, 7717, 7719, 7721, 7723, 7725, 7727, 7729, 7731, 7733, 7735, 7737, 7739, 7741, 7743, 7745, 7747, 7749, 7751, 7753, 7755, 7757, 7759, 7761, 7763, 7765, 7767, 7769, 7771, 7773, 7775, 7777, 7779, 7781, 7783, 7785, 7787, 7789, 7791, 7793, 7795, 7797, 7799, 7801, 7803, 7805, 7807, 7809, 7811, 7813, 7815, 7817, 7819, 7821, 7823, 7825, 7827, 7829, 7841, 7843, 7845, 7847, 7849, 7851, 7853, 7855, 7857, 7859, 7861, 7863, 7865, 7867, 7869, 7871, 7873, 7875, 7877, 7879, 7881, 7883, 7885, 7887, 7889, 7891, 7893, 7895, 7897, 7899, 7901, 7903, 7905, 7907, 7909, 7911, 7913, 7915, 7917, 7919, 7921, 7923, 7925, 7927, 7929, 8580, 11361, 11368, 11370, 11372, 11382, 11393, 11395, 11397, 11399, 11401, 11403, 11405, 11407, 11409, 11411, 11413, 11415, 11417, 11419, 11421, 11423, 11425, 11427, 11429, 11431, 11433, 11435, 11437, 11439, 11441, 11443, 11445, 11447, 11449, 11451, 11453, 11455, 11457, 11459, 11461, 11463, 11465, 11467, 11469, 11471, 11473, 11475, 11477, 11479, 11481, 11483, 11485, 11487, 11489, 11491)), new DeltaSet(2, CharRanges.withMembers(454, 457, 460, 499)), new DeltaSet(15, CharRanges.withMembers(1231)), new DeltaSet(16, CharRanges.withRanges(8560, 8576)), new DeltaSet(26, CharRanges.withRanges(9424, 9450)), new DeltaSet(28, CharRanges.withMembers(8526)), new DeltaSet(31, CharRanges.withMembers(962)), new DeltaSet(32, CharRanges.withRanges(97, 123, 224, 247, 248, 255, 945, 962, 963, 972, 1072, 1104, 65345, 65371)), new DeltaSet(37, CharRanges.withRanges(941, 944)), new DeltaSet(38, CharRanges.withMembers(940)), new DeltaSet(47, CharRanges.withMembers(981)), new DeltaSet(48, CharRanges.withRanges(1377, 1415, 11312, 11359)), new DeltaSet(54, CharRanges.withMembers(982)), new DeltaSet(57, CharRanges.withMembers(977)), new DeltaSet(59, CharRanges.withMembers(7835)), new DeltaSet(62, CharRanges.withMembers(976)), new DeltaSet(63, CharRanges.withRanges(973, 975)), new DeltaSet(64, CharRanges.withMembers(972)), new DeltaSet(69, CharRanges.withMembers(649)), new DeltaSet(71, CharRanges.withMembers(652)), new DeltaSet(79, CharRanges.withMembers(477)), new DeltaSet(80, CharRanges.withRanges(1009, 1010, 1104, 1120)), new DeltaSet(86, CharRanges.withMembers(1008)), new DeltaSet(96, CharRanges.withMembers(1013)), new DeltaSet(202, CharRanges.withMembers(601)), new DeltaSet(203, CharRanges.withMembers(603)), new DeltaSet(205, CharRanges.withRanges(598, 600, 608, 609)), new DeltaSet(206, CharRanges.withMembers(596)), new DeltaSet(207, CharRanges.withMembers(611)), new DeltaSet(209, CharRanges.withMembers(616)), new DeltaSet(210, CharRanges.withMembers(595)), new DeltaSet(211, CharRanges.withMembers(617, 623)), new DeltaSet(213, CharRanges.withMembers(626)), new DeltaSet(214, CharRanges.withMembers(629)), new DeltaSet(217, CharRanges.withRanges(650, 652)), new DeltaSet(218, CharRanges.withMembers(640, 643, 648)), new DeltaSet(219, CharRanges.withMembers(658)), new DeltaSet(7205, CharRanges.withMembers(8126)), new DeltaSet(7264, CharRanges.withRanges(11520, 11558)), new DeltaSet(10792, CharRanges.withMembers(11366)), new DeltaSet(10795, CharRanges.withMembers(11365))});

    private CaseCanonicalize() {
    }

    public static String caseCanonicalize(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            char cu = CaseCanonicalize.caseCanonicalize(ch);
            if (cu == ch) continue;
            StringBuilder sb = new StringBuilder(s);
            sb.setCharAt(i, cu);
            while (++i < n) {
                sb.setCharAt(i, CaseCanonicalize.caseCanonicalize(s.charAt(i)));
            }
            return sb.toString();
        }
        return s;
    }

    public static char caseCanonicalize(char ch) {
        if (ch < '\u0080') {
            return 'A' <= ch && ch <= 'Z' ? (char)(ch | 0x20) : ch;
        }
        if (CASE_SENSITIVE.contains(ch)) {
            for (DeltaSet ds : CANON_DELTA_SETS) {
                if (!ds.codeUnits.contains(ch)) continue;
                return (char)(ch - ds.delta);
            }
        }
        return ch;
    }

    public static CharRanges expandToAllMatched(CharRanges ranges) {
        CharRanges caseSensitive = ranges.intersection(CASE_SENSITIVE);
        if (caseSensitive.isEmpty()) {
            return ranges;
        }
        CharRanges expanded = CharRanges.EMPTY;
        for (DeltaSet ds : DELTA_SETS) {
            expanded = expanded.union(caseSensitive.intersection(ds.codeUnits).shift(-ds.delta));
        }
        return ranges.union(expanded);
    }

    public static CharRanges reduceToMinimum(CharRanges ranges) {
        CharRanges caseSensitive = ranges.intersection(CASE_SENSITIVE);
        if (caseSensitive.isEmpty()) {
            return ranges;
        }
        CharRanges expanded = CharRanges.EMPTY;
        for (DeltaSet ds : CANON_DELTA_SETS) {
            expanded = expanded.union(caseSensitive.intersection(ds.codeUnits).shift(-ds.delta));
        }
        expanded = expanded.difference(UCASE_ASCII_LETTERS).union(expanded.intersection(UCASE_ASCII_LETTERS).shift(32));
        return ranges.difference(caseSensitive).union(expanded);
    }

    private static final class DeltaSet {
        final int delta;
        final CharRanges codeUnits;

        DeltaSet(int delta, CharRanges codeUnits) {
            this.delta = delta;
            this.codeUnits = codeUnits;
        }
    }
}

