/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Function;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.CheckReturnValue;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Map;

public final class ClosureReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private final Visitor<JSType> restrictToObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType topType) {
            return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }
    };
    private final Visitor<JSType> restrictToNotObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }
    };
    private final Map<String, Function<TypeRestriction, JSType>> restricters = ImmutableMap.of("isObject", p -> {
        if (((TypeRestriction)p).type == null) {
            return ((TypeRestriction)p).outcome ? this.getNativeType(JSTypeNative.OBJECT_TYPE) : null;
        }
        Visitor<JSType> visitor = ((TypeRestriction)p).outcome ? this.restrictToObjectVisitor : this.restrictToNotObjectVisitor;
        return ((TypeRestriction)p).type.visit(visitor);
    });

    public ClosureReverseAbstractInterpreter(JSTypeRegistry typeRegistry) {
        super(typeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, Outcome outcome) {
        if (condition.isCall() && condition.hasTwoChildren()) {
            Node callee = condition.getFirstChild();
            Node param = condition.getLastChild();
            if (callee.isGetProp() && param.isQualifiedName()) {
                Function<TypeRestriction, JSType> restricter;
                JSType paramType = this.getTypeIfRefinable(param, blindScope);
                Node receiver = callee.getFirstChild();
                if (receiver.isName() && "goog".equals(receiver.getString()) && (restricter = this.restricters.get(callee.getString())) != null) {
                    return this.restrictParameter(param, paramType, blindScope, restricter, outcome.isTruthy());
                }
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    @CheckReturnValue
    private FlowScope restrictParameter(Node parameter, JSType type, FlowScope blindScope, Function<TypeRestriction, JSType> restriction, boolean outcome) {
        if ((type = restriction.apply(new TypeRestriction(type, outcome))) != null) {
            return this.declareNameInScope(blindScope, parameter, type);
        }
        return blindScope;
    }

    private static class TypeRestriction {
        private final JSType type;
        private final boolean outcome;

        private TypeRestriction(JSType type, boolean outcome) {
            this.type = type;
            this.outcome = outcome;
        }
    }
}

