/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Function;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.CheckReturnValue;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.HashSet;
import java.util.Set;

public final class SemanticReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private static final Function<JSType.TypePair, JSType.TypePair> EQ = p -> {
        if (p.typeA == null || p.typeB == null) {
            return null;
        }
        return p.typeA.getTypesUnderEquality(p.typeB);
    };
    private static final Function<JSType.TypePair, JSType.TypePair> NE = p -> {
        if (p.typeA == null || p.typeB == null) {
            return null;
        }
        return p.typeA.getTypesUnderInequality(p.typeB);
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHEQ = p -> {
        if (p.typeA == null || p.typeB == null) {
            return null;
        }
        return p.typeA.getTypesUnderShallowEquality(p.typeB);
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHNE = p -> {
        if (p.typeA == null || p.typeB == null) {
            return null;
        }
        return p.typeA.getTypesUnderShallowInequality(p.typeB);
    };
    private final Function<JSType.TypePair, JSType.TypePair> ineq = p -> new JSType.TypePair(p.typeA != null ? p.typeA.restrictByNotUndefined() : null, p.typeB != null ? p.typeB.restrictByNotUndefined() : null);

    public SemanticReverseAbstractInterpreter(JSTypeRegistry typeRegistry) {
        super(typeRegistry);
    }

    @Override
    @CheckReturnValue
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, Outcome outcome) {
        Node right;
        Node left;
        Token operatorToken = condition.getToken();
        switch (operatorToken) {
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case CASE: {
                boolean resultEqualsValue;
                Node operandNode;
                JSType operandType;
                if (operatorToken == Token.CASE) {
                    left = condition.getParent().getFirstChild();
                    right = condition.getFirstChild();
                } else {
                    left = condition.getFirstChild();
                    right = condition.getLastChild();
                }
                Node typeOfNode = null;
                Node stringNode = null;
                if (left.isTypeOf() && right.isStringLit()) {
                    typeOfNode = left;
                    stringNode = right;
                } else if (right.isTypeOf() && left.isStringLit()) {
                    typeOfNode = right;
                    stringNode = left;
                }
                if (typeOfNode == null || stringNode == null || (operandType = this.getTypeIfRefinable(operandNode = typeOfNode.getFirstChild(), blindScope)) == null) break;
                boolean bl = resultEqualsValue = operatorToken == Token.EQ || operatorToken == Token.SHEQ || operatorToken == Token.CASE;
                if (!outcome.isTruthy()) {
                    resultEqualsValue = !resultEqualsValue;
                }
                return this.caseTypeOf(operandNode, operandType, stringNode.getString(), resultEqualsValue, blindScope);
            }
        }
        switch (operatorToken) {
            case AND: {
                if (outcome.isTruthy()) {
                    return this.caseAndOrNotShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, Outcome.TRUE);
                }
                return this.caseAndOrMaybeShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, Outcome.TRUE);
            }
            case OR: {
                if (!outcome.isTruthy()) {
                    return this.caseAndOrNotShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, Outcome.FALSE);
                }
                return this.caseAndOrMaybeShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, Outcome.FALSE);
            }
            case EQ: {
                if (outcome.isTruthy()) {
                    return this.caseEquality(condition, blindScope, EQ);
                }
                return this.caseEquality(condition, blindScope, NE);
            }
            case NE: {
                if (outcome.isTruthy()) {
                    return this.caseEquality(condition, blindScope, NE);
                }
                return this.caseEquality(condition, blindScope, EQ);
            }
            case SHEQ: {
                if (outcome.isTruthy()) {
                    return this.caseEquality(condition, blindScope, SHEQ);
                }
                return this.caseEquality(condition, blindScope, SHNE);
            }
            case SHNE: {
                if (outcome.isTruthy()) {
                    return this.caseEquality(condition, blindScope, SHNE);
                }
                return this.caseEquality(condition, blindScope, SHEQ);
            }
            case NAME: 
            case GETPROP: {
                return this.caseNameOrGetProp(condition, blindScope, outcome);
            }
            case ASSIGN: {
                return this.firstPreciserScopeKnowingConditionOutcome(condition.getFirstChild(), this.firstPreciserScopeKnowingConditionOutcome(condition.getSecondChild(), blindScope, outcome), outcome);
            }
            case NOT: {
                return this.firstPreciserScopeKnowingConditionOutcome(condition.getFirstChild(), blindScope, outcome.not());
            }
            case LE: 
            case LT: 
            case GE: 
            case GT: {
                if (!outcome.isTruthy()) break;
                return this.caseEquality(condition, blindScope, this.ineq);
            }
            case INSTANCEOF: {
                return this.caseInstanceOf(condition.getFirstChild(), condition.getLastChild(), blindScope, outcome);
            }
            case IN: {
                if (!outcome.isTruthy() || !condition.getFirstChild().isStringLit()) break;
                return this.caseIn(condition.getLastChild(), condition.getFirstChild().getString(), blindScope);
            }
            case CASE: {
                left = condition.getParent().getFirstChild();
                right = condition.getFirstChild();
                if (outcome.isTruthy()) {
                    return this.caseEquality(left, right, blindScope, SHEQ);
                }
                return this.caseEquality(left, right, blindScope, SHNE);
            }
            case CALL: {
                left = condition.getFirstChild();
                String leftName = left.getQualifiedName();
                if (!"Array.isArray".equals(leftName) || left.getNext() == null) break;
                return this.caseIsArray(left.getNext(), blindScope, outcome);
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    @CheckReturnValue
    private FlowScope caseIsArray(Node value, FlowScope blindScope, Outcome outcome) {
        JSType type = this.getTypeIfRefinable(value, blindScope);
        if (type != null) {
            Visitor visitor = outcome.isTruthy() ? this.restrictToArrayVisitor : this.restrictToNotArrayVisitor;
            return this.maybeRestrictName(blindScope, value, type, (JSType)type.visit(visitor));
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope caseEquality(Node condition, FlowScope blindScope, Function<JSType.TypePair, JSType.TypePair> merging) {
        return this.caseEquality(condition.getFirstChild(), condition.getLastChild(), blindScope, merging);
    }

    @CheckReturnValue
    private FlowScope caseEquality(Node left, Node right, FlowScope blindScope, Function<JSType.TypePair, JSType.TypePair> merging) {
        boolean rightIsRefineable;
        boolean leftIsRefineable;
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType != null) {
            leftIsRefineable = true;
        } else {
            leftIsRefineable = false;
            leftType = left.getJSType();
        }
        JSType rightType = this.getTypeIfRefinable(right, blindScope);
        if (rightType != null) {
            rightIsRefineable = true;
        } else {
            rightIsRefineable = false;
            rightType = right.getJSType();
        }
        JSType.TypePair merged = merging.apply(new JSType.TypePair(leftType, rightType));
        if (merged != null) {
            return this.maybeRestrictTwoNames(blindScope, left, leftType, leftIsRefineable ? merged.typeA : null, right, rightType, rightIsRefineable ? merged.typeB : null);
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope caseAndOrNotShortCircuiting(Node left, Node right, FlowScope blindScope, Outcome outcome) {
        boolean rightIsRefineable;
        JSType restrictedLeftType;
        boolean leftIsRefineable;
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType != null) {
            leftIsRefineable = true;
        } else {
            leftIsRefineable = false;
            leftType = left.getJSType();
            blindScope = this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, outcome);
        }
        JSType jSType = restrictedLeftType = leftType == null ? null : leftType.getRestrictedTypeGivenOutcome(outcome);
        if (restrictedLeftType == null) {
            return this.firstPreciserScopeKnowingConditionOutcome(right, blindScope, outcome);
        }
        JSType rightType = this.getTypeIfRefinable(right, blindScope = this.maybeRestrictName(blindScope, left, leftType, leftIsRefineable ? restrictedLeftType : null));
        if (rightType != null) {
            rightIsRefineable = true;
        } else {
            rightIsRefineable = false;
            rightType = right.getJSType();
            blindScope = this.firstPreciserScopeKnowingConditionOutcome(right, blindScope, outcome);
        }
        if (outcome.isTruthy()) {
            JSType restrictedRightType = rightType == null ? null : rightType.getRestrictedTypeGivenOutcome(outcome);
            return this.maybeRestrictName(blindScope, right, rightType, rightIsRefineable ? restrictedRightType : null);
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope caseAndOrMaybeShortCircuiting(Node left, Node right, FlowScope blindScope, Outcome outcome) {
        StaticTypedSlot rightVar;
        StaticTypedSlot leftVar;
        HashSet<String> refinements = new HashSet<String>();
        blindScope = new RefinementTrackingFlowScope(blindScope, refinements);
        FlowScope leftScope = this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, outcome.not());
        StaticTypedSlot staticTypedSlot = leftVar = refinements.size() == 1 ? leftScope.getSlot((String)refinements.iterator().next()) : null;
        if (leftVar == null) {
            return SemanticReverseAbstractInterpreter.unwrap(blindScope);
        }
        refinements.clear();
        FlowScope rightScope = new RefinementTrackingFlowScope(this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, outcome), refinements);
        rightScope = this.firstPreciserScopeKnowingConditionOutcome(right, rightScope, outcome.not());
        StaticTypedSlot staticTypedSlot2 = rightVar = refinements.size() == 1 ? rightScope.getSlot((String)refinements.iterator().next()) : null;
        if (rightVar == null || !leftVar.getName().equals(rightVar.getName())) {
            return SemanticReverseAbstractInterpreter.unwrap(blindScope);
        }
        JSType type = leftVar.getType().getLeastSupertype(rightVar.getType());
        return SemanticReverseAbstractInterpreter.unwrap(blindScope).inferSlotType(leftVar.getName(), type);
    }

    @CheckReturnValue
    private FlowScope maybeRestrictName(FlowScope blindScope, Node node, JSType originalType, JSType restrictedType) {
        if (restrictedType != null && !JSCompObjects.identical(restrictedType, originalType)) {
            return this.declareNameInScope(blindScope, node, restrictedType);
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope maybeRestrictTwoNames(FlowScope blindScope, Node left, JSType originalLeftType, JSType restrictedLeftType, Node right, JSType originalRightType, JSType restrictedRightType) {
        boolean shouldRefineRight;
        boolean shouldRefineLeft = restrictedLeftType != null && !JSCompObjects.identical(restrictedLeftType, originalLeftType);
        boolean bl = shouldRefineRight = restrictedRightType != null && !JSCompObjects.identical(restrictedRightType, originalRightType);
        if (shouldRefineLeft || shouldRefineRight) {
            FlowScope informed = blindScope;
            if (shouldRefineLeft) {
                informed = this.declareNameInScope(informed, left, restrictedLeftType);
            }
            if (shouldRefineRight) {
                informed = this.declareNameInScope(informed, right, restrictedRightType);
            }
            return informed;
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope caseNameOrGetProp(Node name, FlowScope blindScope, Outcome outcome) {
        JSType type = this.getTypeIfRefinable(name, blindScope);
        if (type != null) {
            JSType restrictedType = type.getRestrictedTypeGivenOutcome(outcome);
            return this.maybeRestrictName(blindScope, name, type, restrictedType);
        }
        return blindScope;
    }

    @CheckReturnValue
    private FlowScope caseTypeOf(Node node, JSType type, String value, boolean resultEqualsValue, FlowScope blindScope) {
        return this.maybeRestrictName(blindScope, node, type, this.getRestrictedByTypeOfResult(type, value, resultEqualsValue));
    }

    @CheckReturnValue
    private FlowScope caseInstanceOf(Node left, Node right, FlowScope blindScope, Outcome outcome) {
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType == null) {
            return blindScope;
        }
        JSType rightType = right.getJSType();
        ObjectType targetType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        if (rightType != null && rightType.isFunctionType()) {
            targetType = rightType.toMaybeFunctionType();
        }
        ChainableReverseAbstractInterpreter.RestrictByTypeOfResultVisitor visitor = outcome.isTruthy() ? new RestrictByTrueInstanceOfResultVisitor(targetType) : new RestrictByFalseInstanceOfResultVisitor(targetType);
        return this.maybeRestrictName(blindScope, left, leftType, leftType.visit(visitor));
    }

    @CheckReturnValue
    private FlowScope caseIn(Node object, String propertyName, FlowScope blindScope) {
        String propertyQualifiedName;
        String qualifiedName;
        JSType jsType = object.getJSType();
        jsType = jsType != null ? jsType.restrictByNotNullOrUndefined() : null;
        boolean hasProperty = false;
        ObjectType objectType = ObjectType.cast(jsType);
        if (objectType != null) {
            hasProperty = objectType.hasProperty(propertyName);
        }
        if (!hasProperty && (qualifiedName = object.getQualifiedName()) != null && blindScope.getSlot(propertyQualifiedName = qualifiedName + "." + propertyName) == null) {
            JSType unknownType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            return blindScope.inferQualifiedSlot(object, propertyQualifiedName, unknownType, unknownType, false);
        }
        return blindScope;
    }

    private static FlowScope unwrap(FlowScope scope) {
        while (scope instanceof RefinementTrackingFlowScope) {
            scope = ((RefinementTrackingFlowScope)scope).delegate;
        }
        return scope;
    }

    private static class RefinementTrackingFlowScope
    implements FlowScope {
        final FlowScope delegate;
        final Set<String> refinements;

        RefinementTrackingFlowScope(FlowScope delegate, Set<String> refinements) {
            this.delegate = delegate;
            this.refinements = refinements;
        }

        @Override
        public FlowScope withSyntacticScope(StaticTypedScope scope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FlowScope inferSlotType(String symbol, JSType type) {
            this.refinements.add(symbol);
            return this.wrap(this.delegate.inferSlotType(symbol, type));
        }

        @Override
        public FlowScope inferQualifiedSlot(Node node, String symbol, JSType bottomType, JSType inferredType, boolean declare) {
            this.refinements.add(symbol);
            return this.wrap(this.delegate.inferQualifiedSlot(node, symbol, bottomType, inferredType, declare));
        }

        private FlowScope wrap(FlowScope scope) {
            return scope != this.delegate ? new RefinementTrackingFlowScope(scope, this.refinements) : this;
        }

        @Override
        public StaticTypedScope getDeclarationScope() {
            return this.delegate.getDeclarationScope();
        }

        @Override
        public Node getRootNode() {
            return this.delegate.getRootNode();
        }

        @Override
        public StaticTypedScope getParentScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StaticTypedSlot getSlot(String name) {
            return this.delegate.getSlot(name);
        }

        @Override
        public StaticTypedSlot getOwnSlot(String name) {
            return this.delegate.getOwnSlot(name);
        }

        @Override
        public JSType getTypeOfThis() {
            return this.delegate.getTypeOfThis();
        }
    }

    private class RestrictByFalseInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByFalseInstanceOfResultVisitor(ObjectType target) {
            this.target = target;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                if (type.isSubtypeOf(funcTarget.getInstanceType())) {
                    return null;
                }
                return type;
            }
            return null;
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                return type.getRestrictedUnion(funcTarget.getInstanceType());
            }
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return this.caseObjectType(type);
        }
    }

    private class RestrictByTrueInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByTrueInstanceOfResultVisitor(ObjectType target) {
            this.target = target;
        }

        @Override
        protected JSType caseTopType(JSType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseUnknownType() {
            FunctionType funcTarget = JSType.toMaybeFunctionType(this.target);
            if (funcTarget != null && funcTarget.hasInstanceType()) {
                return funcTarget.getInstanceType();
            }
            return SemanticReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return this.caseObjectType(type);
        }

        private JSType applyCommonRestriction(JSType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                return type.getGreatestSubtype(funcTarget.getInstanceType());
            }
            return null;
        }
    }
}

