/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

public abstract class SourcePosition<T> {
    private T item = null;
    private int startLineno = 0;
    private int startCharno = 0;
    private int endLineno = 0;
    private int endCharno = 0;

    public void setItem(T item) {
        this.item = item;
    }

    public void setPositionInformation(int startLineno, int startCharno, int endLineno, int endCharno) {
        if (startLineno > endLineno) {
            throw new IllegalStateException("Recorded bad position information\nstart-line: " + startLineno + "\nend-line: " + endLineno);
        }
        if (startLineno == endLineno && startCharno >= endCharno) {
            throw new IllegalStateException("Recorded bad position information\nline: " + startLineno + "\nstart-char: " + startCharno + "\nend-char: " + endCharno);
        }
        this.startLineno = startLineno;
        this.startCharno = startCharno;
        this.endLineno = endLineno;
        this.endCharno = endCharno;
    }

    public T getItem() {
        return this.item;
    }

    public int getStartLine() {
        return this.startLineno;
    }

    public int getPositionOnStartLine() {
        return this.startCharno;
    }

    public int getEndLine() {
        return this.endLineno;
    }

    public int getPositionOnEndLine() {
        return this.endCharno;
    }

    boolean isSamePositionAs(SourcePosition<?> that) {
        return this.startLineno == that.startLineno && this.startCharno == that.startCharno && this.endLineno == that.endLineno && this.endCharno == that.endCharno;
    }
}

