/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicate;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.ForOverride;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Outcome;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.CanCastToVisitor;
import com.google.javascript.rhino.jstype.ContainsUpperBoundSuperTypeVisitor;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.EqualityChecker;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.SubtypeChecker;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;

public abstract class JSType {
    private static final long serialVersionUID = 1L;
    private JSType resolveResult = null;
    protected TemplateTypeMap templateTypeMap;
    private boolean loosenTypecheckingDueToForwardReferencedSupertype;
    private boolean hashCodeInProgress = false;
    private boolean inTemplatedCheckVisit = false;
    private static final CanCastToVisitor CAN_CAST_TO_VISITOR = new CanCastToVisitor();
    final JSTypeRegistry registry;

    JSType(JSTypeRegistry registry) {
        this(registry, null);
    }

    JSType(JSTypeRegistry registry, TemplateTypeMap templateTypeMap) {
        this.registry = registry;
        this.templateTypeMap = templateTypeMap == null ? registry.getEmptyTemplateTypeMap() : templateTypeMap;
        registry.getResolver().addUnresolved(this);
    }

    abstract JSTypeClass getTypeClass();

    JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    public JSDocInfo getJSDocInfo() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public boolean hasDisplayName() {
        String displayName = this.getDisplayName();
        return displayName != null && !displayName.isEmpty();
    }

    public HasPropertyKind getPropertyKind(String pname) {
        return this.getPropertyKind(pname, true);
    }

    public HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        return HasPropertyKind.ABSENT;
    }

    public final boolean hasProperty(String pname) {
        return !this.getPropertyKind(pname, false).equals((Object)HasPropertyKind.ABSENT);
    }

    public boolean isNoType() {
        return false;
    }

    public boolean isNoResolvedType() {
        return false;
    }

    public boolean isNoObjectType() {
        return false;
    }

    public final boolean isEmptyType() {
        return this.isNoType() || this.isNoObjectType() || this.isNoResolvedType() || JSCompObjects.identical(this, this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE));
    }

    public boolean isNumberObjectType() {
        return false;
    }

    public boolean isNumberValueType() {
        return false;
    }

    public boolean isBigIntObjectType() {
        return false;
    }

    public boolean isBigIntValueType() {
        return false;
    }

    public boolean isFunctionPrototypeType() {
        return false;
    }

    public boolean isStringObjectType() {
        return false;
    }

    public boolean isSymbolObjectType() {
        return false;
    }

    boolean isTheObjectType() {
        return false;
    }

    public boolean isStringValueType() {
        return false;
    }

    public boolean isSymbolValueType() {
        return false;
    }

    public final boolean isString() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.STRING_TYPE)) || this.isSubtypeOf(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
    }

    public final boolean isNumber() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_TYPE)) || this.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
    }

    public final boolean isSymbol() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.SYMBOL_TYPE)) || this.isSubtypeOf(this.getNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE));
    }

    public final boolean isBigIntOrNumber() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER)) || this.isSubtypeOf(this.getNativeType(JSTypeNative.BIGINT_NUMBER_OBJECT));
    }

    public final boolean isOnlyBigInt() {
        return this.isBigIntValueType() || this.isBigIntObjectType();
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBooleanObjectType() {
        return false;
    }

    public boolean isBooleanValueType() {
        return false;
    }

    public boolean isRegexpType() {
        return false;
    }

    public boolean isDateType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isVoidType() {
        return false;
    }

    public boolean isAllType() {
        return false;
    }

    public boolean isUnknownType() {
        return false;
    }

    public final boolean isSomeUnknownType() {
        return this.isUnknownType();
    }

    public boolean isCheckedUnknownType() {
        return false;
    }

    public final boolean isUnionType() {
        return this.toMaybeUnionType() != null;
    }

    public final boolean isRawTypeOfTemplatizedType() {
        return this.getTemplateParamCount() > 0 && !this.isTemplatizedType();
    }

    public boolean isStruct() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesStructs();
            }
            return ctor.makesStructs();
        }
        return false;
    }

    public boolean isDict() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesDicts();
            }
            return ctor.makesDicts();
        }
        return false;
    }

    public final boolean containsReferenceAncestor(JSType target) {
        ContainsUpperBoundSuperTypeVisitor visitor = new ContainsUpperBoundSuperTypeVisitor(target);
        return this.visit(visitor) == ContainsUpperBoundSuperTypeVisitor.Result.PRESENT;
    }

    public final boolean isLiteralObject() {
        if (this instanceof PrototypeObjectType) {
            return ((PrototypeObjectType)this).isAnonymous();
        }
        return false;
    }

    public UnionType toMaybeUnionType() {
        return null;
    }

    public final boolean isGlobalThisType() {
        return JSCompObjects.identical(this, this.registry.getNativeType(JSTypeNative.GLOBAL_THIS));
    }

    public final boolean isFunctionType() {
        return this.toMaybeFunctionType() != null;
    }

    public FunctionType toMaybeFunctionType() {
        return null;
    }

    public FunctionType assertFunctionType() {
        FunctionType result = Preconditions.checkNotNull(this.toMaybeFunctionType(), "not a FunctionType: %s", (Object)this);
        return result;
    }

    public ObjectType assertObjectType() {
        ObjectType result = Preconditions.checkNotNull(this.toMaybeObjectType(), "Not an ObjectType: %s", (Object)this);
        return result;
    }

    public static FunctionType toMaybeFunctionType(JSType type) {
        return type == null ? null : type.toMaybeFunctionType();
    }

    public final boolean isEnumElementType() {
        return this.toMaybeEnumElementType() != null;
    }

    public final JSType getEnumeratedTypeOfEnumElement() {
        EnumElementType e = this.toMaybeEnumElementType();
        return e == null ? null : e.getPrimitiveType();
    }

    public EnumElementType toMaybeEnumElementType() {
        return null;
    }

    public boolean isEnumType() {
        return this.toMaybeEnumType() != null;
    }

    public EnumType toMaybeEnumType() {
        return null;
    }

    public boolean isNamedType() {
        return this.toMaybeNamedType() != null;
    }

    public NamedType toMaybeNamedType() {
        return null;
    }

    public boolean isRecordType() {
        return this.toMaybeRecordType() != null;
    }

    public boolean isStructuralInterface() {
        return false;
    }

    public boolean isStructuralType() {
        return false;
    }

    public RecordType toMaybeRecordType() {
        return null;
    }

    public final boolean isTemplatizedType() {
        return this.toMaybeTemplatizedType() != null;
    }

    public TemplatizedType toMaybeTemplatizedType() {
        return null;
    }

    public final boolean isTemplateType() {
        return this.toMaybeTemplateType() != null;
    }

    public TemplateType toMaybeTemplateType() {
        return null;
    }

    public boolean hasAnyTemplateTypes() {
        if (!this.inTemplatedCheckVisit) {
            this.inTemplatedCheckVisit = true;
            boolean result = this.hasAnyTemplateTypesInternal();
            this.inTemplatedCheckVisit = false;
            return result;
        }
        return false;
    }

    boolean hasAnyTemplateTypesInternal() {
        return this.getTemplateTypeMap().hasAnyTemplateTypesInternal();
    }

    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    public final ImmutableList<TemplateType> getTypeParameters() {
        TemplateTypeMap map = this.getTemplateTypeMap();
        return map.getTemplateKeys().subList(map.size() - this.getTemplateParamCount(), map.size());
    }

    public int getTemplateParamCount() {
        return 0;
    }

    public void mergeSupertypeTemplateTypes(ObjectType other) {
        this.maybeLoosenTypecheckingDueToForwardReferencedSupertype(other);
        if (other.isRawTypeOfTemplatizedType()) {
            other = this.registry.createTemplatizedType(other, ImmutableList.of());
        }
        this.templateTypeMap = other.getTemplateTypeMap().copyWithExtension(this.getTemplateTypeMap());
    }

    public boolean isObject() {
        return false;
    }

    public final boolean isObjectType() {
        return this.isObject();
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isNominalType() {
        return false;
    }

    public final boolean isNominalConstructorOrInterface() {
        if (this.isConstructor() || this.isInterface()) {
            FunctionType fn = this.toMaybeFunctionType();
            if (fn == null) {
                return false;
            }
            if (fn.getSource() != null) {
                return true;
            }
            return fn.isNativeObjectType();
        }
        return false;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public boolean loosenTypecheckingDueToForwardReferencedSupertype() {
        return this.loosenTypecheckingDueToForwardReferencedSupertype;
    }

    final void maybeLoosenTypecheckingDueToForwardReferencedSupertype(JSType supertype) {
        if (supertype.isNamedType() && !supertype.isResolved() || supertype.loosenTypecheckingDueToForwardReferencedSupertype()) {
            this.loosenTypecheckingDueToForwardReferencedSupertype = true;
        }
    }

    public boolean isInstanceType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isOrdinaryFunction() {
        return false;
    }

    public final boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JSType && new EqualityChecker().setEqMethod(EqualityChecker.EqMethod.IDENTITY).check(this, (JSType)other);
    }

    public final boolean differsFrom(JSType that) {
        return !new EqualityChecker().setEqMethod(EqualityChecker.EqMethod.DATA_FLOW).check(this, that);
    }

    public static final boolean areSimilar(@Nullable JSType first, @Nullable JSType second) {
        if (first == null || second == null) {
            return first == second;
        }
        return !first.differsFrom(second);
    }

    public final int hashCode() {
        if (this.hashCodeInProgress) {
            return -1;
        }
        this.hashCodeInProgress = true;
        int hashCode = this.recursionUnsafeHashCode();
        this.hashCodeInProgress = false;
        return hashCode;
    }

    abstract int recursionUnsafeHashCode();

    public boolean matchesNumberContext() {
        return false;
    }

    public boolean matchesStringContext() {
        return false;
    }

    public boolean matchesSymbolContext() {
        return false;
    }

    public boolean matchesObjectContext() {
        return false;
    }

    @Nullable
    public final JSType findPropertyType(String propertyName) {
        JSType propertyType = this.findPropertyTypeWithoutConsideringTemplateTypes(propertyName);
        if (propertyType == null) {
            return null;
        }
        if (this.getTemplateTypeMap().isEmpty() || !propertyType.hasAnyTemplateTypes()) {
            return propertyType;
        }
        TemplateTypeMap typeMap = this.getTemplateTypeMap();
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forPartialReplacement(this.registry, typeMap);
        return propertyType.visit(replacer);
    }

    @Nullable
    @ForOverride
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        ObjectType autoboxObjType = ObjectType.cast(this.autoboxesTo());
        if (autoboxObjType != null) {
            return autoboxObjType.findPropertyType(propertyName);
        }
        return null;
    }

    public boolean canBeCalled() {
        return false;
    }

    public final boolean canCastTo(JSType that) {
        return this.visit(CAN_CAST_TO_VISITOR, that);
    }

    public JSType autoboxesTo() {
        return null;
    }

    public boolean isBoxableScalar() {
        return this.autoboxesTo() != null;
    }

    public ObjectType toObjectType() {
        return this instanceof ObjectType ? (ObjectType)this : null;
    }

    public JSType autobox() {
        JSType restricted = this.restrictByNotNullOrUndefined();
        JSType autobox = restricted.autoboxesTo();
        return autobox == null ? restricted : autobox;
    }

    @Nullable
    public final ObjectType dereference() {
        return this.autobox().toObjectType();
    }

    public final boolean canTestForEqualityWith(JSType that) {
        return this.testForEquality(that).equals((Object)Tri.UNKNOWN);
    }

    public Tri testForEquality(JSType that) {
        return this.testForEqualityHelper(this, that);
    }

    final Tri testForEqualityHelper(JSType aType, JSType bType) {
        if (bType.isAllType() || bType.isUnknownType() || bType.isNoResolvedType() || aType.isAllType() || aType.isUnknownType() || aType.isNoResolvedType()) {
            return Tri.UNKNOWN;
        }
        boolean aIsEmpty = aType.isEmptyType();
        boolean bIsEmpty = bType.isEmptyType();
        if (aIsEmpty || bIsEmpty) {
            if (aIsEmpty && bIsEmpty) {
                return Tri.TRUE;
            }
            return Tri.UNKNOWN;
        }
        if (aType.isFunctionType() || bType.isFunctionType()) {
            JSType otherType;
            JSType jSType = otherType = aType.isFunctionType() ? bType : aType;
            if (otherType.isSymbol()) {
                return Tri.FALSE;
            }
            JSType greatestSubtype = otherType.getGreatestSubtype(this.getNativeType(JSTypeNative.OBJECT_TYPE));
            if (greatestSubtype.isNoType() || greatestSubtype.isNoObjectType()) {
                return Tri.FALSE;
            }
            return Tri.UNKNOWN;
        }
        if (bType.isEnumElementType() || bType.isUnionType()) {
            return bType.testForEquality(aType);
        }
        if (aType.isSymbol()) {
            return bType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_TYPE)) || bType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE)) ? Tri.UNKNOWN : Tri.FALSE;
        }
        if (bType.isSymbol()) {
            return aType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_TYPE)) || aType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE)) ? Tri.UNKNOWN : Tri.FALSE;
        }
        return null;
    }

    public final boolean canTestForShallowEqualityWith(JSType that) {
        if (this.isEmptyType() || that.isEmptyType()) {
            return this.isSubtypeOf(that) || that.isSubtypeOf(this);
        }
        JSType inf = this.getGreatestSubtype(that);
        return !inf.isEmptyType() || JSCompObjects.identical(inf, this.registry.getNativeType(JSTypeNative.LEAST_FUNCTION_TYPE));
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isVoidable() {
        return false;
    }

    public boolean isExplicitlyVoidable() {
        return false;
    }

    public JSType collapseUnion() {
        return this;
    }

    public JSType getLeastSupertype(JSType that) {
        if (JSCompObjects.identical(this, that)) {
            return this;
        }
        if ((that = JSType.filterNoResolvedType(that)).isUnionType()) {
            return that.toMaybeUnionType().getLeastSupertype(this);
        }
        return JSType.getLeastSupertype(this, that);
    }

    static JSType getLeastSupertype(JSType thisType, JSType thatType) {
        boolean areEquivalent = thisType.equals(thatType);
        return areEquivalent ? thisType : JSType.filterNoResolvedType(thisType.registry.createUnionType(thisType, thatType));
    }

    public JSType getGreatestSubtype(JSType that) {
        return JSType.getGreatestSubtype(this, that);
    }

    static JSType getGreatestSubtype(JSType thisType, JSType thatType) {
        JSType inf;
        if (thisType.isFunctionType() && thatType.isFunctionType()) {
            return thisType.toMaybeFunctionType().supAndInfHelper(thatType.toMaybeFunctionType(), false);
        }
        if (thisType.equals(thatType)) {
            return thisType;
        }
        if (thisType.isUnknownType()) {
            if (!thatType.isUnknownType()) {
                return thatType;
            }
            if (thisType.isCheckedUnknownType() || thatType.isCheckedUnknownType()) {
                return thisType.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return thisType.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (thatType.isUnknownType()) {
            return thisType;
        }
        if (thisType.isUnionType()) {
            return UnionType.getGreatestSubtype(thisType.toMaybeUnionType(), thatType);
        }
        if (thatType.isUnionType()) {
            return UnionType.getGreatestSubtype(thatType.toMaybeUnionType(), thisType);
        }
        if (thisType.isTemplatizedType()) {
            return thisType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isTemplatizedType()) {
            return thatType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isSubtypeOf(thatType)) {
            return JSType.filterNoResolvedType(thisType);
        }
        if (thatType.isSubtypeOf(thisType)) {
            return JSType.filterNoResolvedType(thatType);
        }
        if (thisType.isRecordType()) {
            return thisType.toMaybeRecordType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isRecordType()) {
            return thatType.toMaybeRecordType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isEnumElementType()) {
            JSType inf2 = EnumElementType.getGreatestSubtype(thisType.toMaybeEnumElementType(), thatType);
            if (inf2 != null) {
                return inf2;
            }
        } else if (thatType.isEnumElementType() && (inf = EnumElementType.getGreatestSubtype(thatType.toMaybeEnumElementType(), thisType)) != null) {
            return inf;
        }
        if (thisType.isObject() && thatType.isObject()) {
            return thisType.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return thisType.getNativeType(JSTypeNative.NO_TYPE);
    }

    static JSType filterNoResolvedType(JSType type) {
        if (type.isNoResolvedType()) {
            return type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE);
        }
        if (type.isUnionType()) {
            UnionType unionType = type.toMaybeUnionType();
            boolean needsFiltering = false;
            ImmutableList<JSType> alternatesList = unionType.getAlternates();
            for (int i = 0; i < alternatesList.size(); ++i) {
                JSType alt = (JSType)alternatesList.get(i);
                if (!alt.isNoResolvedType()) continue;
                needsFiltering = true;
                break;
            }
            if (needsFiltering) {
                UnionType.Builder builder = UnionType.builder(type.registry).addAlternate(type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE));
                for (int i = 0; i < alternatesList.size(); ++i) {
                    JSType alt = (JSType)alternatesList.get(i);
                    if (alt.isNoResolvedType()) continue;
                    builder.addAlternate(alt);
                }
                return builder.build();
            }
        }
        return type;
    }

    public JSType getRestrictedTypeGivenOutcome(Outcome outcome) {
        if (outcome.isTruthy() && JSCompObjects.identical(this, this.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        if (outcome.isNullish().toBoolean(false)) {
            if (JSCompObjects.identical(this, this.getNativeType(JSTypeNative.VOID_TYPE)) || JSCompObjects.identical(this, this.getNativeType(JSTypeNative.NULL_TYPE))) {
                return this;
            }
            return this.getNativeType(JSTypeNative.NO_TYPE);
        }
        BooleanLiteralSet literals = this.getPossibleToBooleanOutcomes();
        if (literals.contains(outcome.isTruthy())) {
            return this;
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public abstract BooleanLiteralSet getPossibleToBooleanOutcomes();

    public TypePair getTypesUnderEquality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderEquality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        switch (this.testForEquality(that)) {
            case FALSE: {
                return new TypePair(null, null);
            }
            case TRUE: 
            case UNKNOWN: {
                return new TypePair(this, that);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        if (this.isNullTypeOrVoidType() && that.isNullTypeOrVoidType()) {
            JSType noType = this.registry.getNativeType(JSTypeNative.NO_TYPE);
            return new TypePair(noType, noType);
        }
        return new TypePair(this, that);
    }

    public final TypePair getTypesUnderShallowEquality(JSType that) {
        JSType commonType = this.getGreatestSubtype(that);
        return new TypePair(commonType, commonType);
    }

    public TypePair getTypesUnderShallowInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderShallowInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        if (JSCompObjects.identical(this, that) && this.isNullTypeOrVoidType()) {
            return new TypePair(null, null);
        }
        return new TypePair(this, that);
    }

    private boolean isNullTypeOrVoidType() {
        return this.isNullType() || this.isVoidType();
    }

    public Iterable<JSType> getUnionMembers() {
        return this.isUnionType() ? this.toMaybeUnionType().getAlternates() : null;
    }

    public JSType restrictByNotNullOrUndefined() {
        return this;
    }

    public JSType restrictByNotUndefined() {
        return this;
    }

    public JSType restrictByNotNull() {
        return this;
    }

    public final boolean isSubtypeWithoutStructuralTyping(JSType supertype) {
        return new SubtypeChecker(this.registry).setSubtype(this).setSupertype(supertype).setUsingStructuralSubtyping(false).setSubtypingMode(SubtypingMode.NORMAL).check();
    }

    public final boolean isSubtype(JSType supertype) {
        return this.isSubtypeOf(supertype);
    }

    @Deprecated
    public final boolean isSubtype(JSType supertype, SubtypingMode mode) {
        return this.isSubtypeOf(supertype, mode);
    }

    public final boolean isSubtypeOf(JSType supertype) {
        return new SubtypeChecker(this.registry).setSubtype(this).setSupertype(supertype).setUsingStructuralSubtyping(true).setSubtypingMode(SubtypingMode.NORMAL).check();
    }

    public final boolean isSubtypeOf(JSType supertype, SubtypingMode mode) {
        return new SubtypeChecker(this.registry).setSubtype(this).setSupertype(supertype).setUsingStructuralSubtyping(true).setSubtypingMode(mode).check();
    }

    public abstract <T> T visit(Visitor<T> var1);

    abstract <T> T visit(RelationshipVisitor<T> var1, JSType var2);

    public final JSType resolve(ErrorReporter reporter) {
        this.registry.getResolver().assertLegalToResolveTypes();
        if (!this.isResolved()) {
            this.resolveResult = this;
            this.resolveResult = this.resolveInternal(reporter);
            Preconditions.checkState(this.isResolved());
        }
        return this.resolveResult;
    }

    @ForOverride
    abstract JSType resolveInternal(ErrorReporter var1);

    final void eagerlyResolveToSelf() {
        Preconditions.checkState(!this.isResolved());
        this.resolveResult = this;
        this.registry.getResolver().resolveIfClosed(this, this.getTypeClass());
    }

    public final boolean isResolved() {
        return this.resolveResult != null;
    }

    public final boolean isSuccessfullyResolved() {
        return this.isResolved() && !this.isNoResolvedType();
    }

    public final boolean isUnsuccessfullyResolved() {
        return this.isResolved() && this.isNoResolvedType();
    }

    static final JSType safeResolve(JSType type, ErrorReporter reporter) {
        return type == null ? null : type.resolve(reporter);
    }

    public boolean setValidator(Predicate<JSType> validator) {
        return validator.apply(this);
    }

    public String toString() {
        return new TypeStringBuilder(false).append(this).build();
    }

    public final String toAnnotationString(Nullability nullability) {
        TypeStringBuilder builder = new TypeStringBuilder(true);
        return (nullability == Nullability.EXPLICIT ? builder.appendNonNull(this) : builder.append(this)).build();
    }

    abstract void appendTo(TypeStringBuilder var1);

    public void matchConstraint(JSType constraint) {
    }

    public ObjectType toMaybeObjectType() {
        return this.toObjectType();
    }

    public static enum Nullability {
        EXPLICIT,
        IMPLICIT;

    }

    static enum MatchStatus {
        MATCH(true),
        NOT_MATCH(false),
        PROCESSING(true);

        private final boolean isSubtype;

        private MatchStatus(boolean isSubtype) {
            this.isSubtype = isSubtype;
        }

        boolean subtypeValue() {
            return this.isSubtype;
        }

        static MatchStatus valueOf(boolean match) {
            return match ? MATCH : NOT_MATCH;
        }
    }

    public static interface WithSourceRef {
        @Nullable
        public Node getSource();

        @Nullable
        public String getGoogModuleId();
    }

    public static class TypePair {
        public final JSType typeA;
        public final JSType typeB;

        public TypePair(JSType typeA, JSType typeB) {
            this.typeA = typeA;
            this.typeB = typeB;
        }
    }

    public static enum SubtypingMode {
        NORMAL,
        IGNORE_NULL_UNDEFINED;

    }

    public static enum HasPropertyKind {
        ABSENT,
        KNOWN_PRESENT,
        MAYBE_PRESENT;


        public static HasPropertyKind of(boolean has) {
            return has ? KNOWN_PRESENT : ABSENT;
        }
    }
}

