/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.linker.backend.wasmemitter;

import java.io.Serializable;
import org.scalajs.ir.Names;
import org.scalajs.ir.Types;
import org.scalajs.ir.Types$AnyNotNullType$;
import org.scalajs.ir.Types$AnyType$;
import org.scalajs.ir.Types$BooleanType$;
import org.scalajs.ir.Types$ByteType$;
import org.scalajs.ir.Types$CharType$;
import org.scalajs.ir.Types$DoubleType$;
import org.scalajs.ir.Types$FloatType$;
import org.scalajs.ir.Types$IntType$;
import org.scalajs.ir.Types$LongType$;
import org.scalajs.ir.Types$NothingType$;
import org.scalajs.ir.Types$NullType$;
import org.scalajs.ir.Types$ShortType$;
import org.scalajs.ir.Types$StringType$;
import org.scalajs.ir.Types$UndefType$;
import org.scalajs.ir.Types$VoidType$;
import org.scalajs.ir.WellKnownNames$;
import org.scalajs.linker.backend.wasmemitter.VarGen;
import org.scalajs.linker.backend.wasmemitter.VarGen$genTypeID$;
import org.scalajs.linker.backend.wasmemitter.WasmContext;
import org.scalajs.linker.backend.webassembly.Identitities;
import org.scalajs.linker.backend.webassembly.Types;
import org.scalajs.linker.backend.webassembly.Types$Float32$;
import org.scalajs.linker.backend.webassembly.Types$Float64$;
import org.scalajs.linker.backend.webassembly.Types$HeapType$;
import org.scalajs.linker.backend.webassembly.Types$HeapType$Any$;
import org.scalajs.linker.backend.webassembly.Types$HeapType$Extern$;
import org.scalajs.linker.backend.webassembly.Types$HeapType$None$;
import org.scalajs.linker.backend.webassembly.Types$Int32$;
import org.scalajs.linker.backend.webassembly.Types$Int64$;
import org.scalajs.linker.backend.webassembly.Types$RefType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class TypeTransformer$ {
    public static final TypeTransformer$ MODULE$ = new TypeTransformer$();

    public Types.Type transformFieldType(Types.Type tpe, WasmContext ctx) {
        return this.transformSingleType(tpe, ctx);
    }

    public Types.Type transformParamType(Types.Type tpe, WasmContext ctx) {
        Types.Type type = tpe;
        if (Types$NothingType$.MODULE$.equals(type)) {
            return Types$Int32$.MODULE$;
        }
        if (type instanceof Types.RecordType) {
            throw new AssertionError((Object)new StringBuilder(25).append("Unexpected ").append(tpe).append(" for parameter").toString());
        }
        return this.transformSingleType(tpe, ctx);
    }

    public List<Types.Type> transformResultType(Types.Type tpe, WasmContext ctx) {
        Types.Type type = tpe;
        if (Types$VoidType$.MODULE$.equals(type)) {
            return Nil$.MODULE$;
        }
        if (Types$NothingType$.MODULE$.equals(type)) {
            return Nil$.MODULE$;
        }
        if (type instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)type;
            List<Types.RecordType.Field> fields = recordType.fields();
            return fields.flatMap((Function1 & Serializable)f -> MODULE$.transformResultType(f.tpe(), ctx));
        }
        return new .colon.colon((Object)this.transformSingleType(tpe, ctx), (List)Nil$.MODULE$);
    }

    public Types.Type transformSingleType(Types.Type tpe, WasmContext ctx) {
        Types.Type type = tpe;
        if (Types$AnyType$.MODULE$.equals(type)) {
            return Types$RefType$.MODULE$.anyref();
        }
        if (Types$AnyNotNullType$.MODULE$.equals(type)) {
            return Types$RefType$.MODULE$.any();
        }
        if (type instanceof Types.ClassType) {
            Types.ClassType classType = (Types.ClassType)type;
            Names.ClassName className = classType.className();
            boolean nullable = classType.nullable();
            return this.transformClassType(className, nullable, ctx);
        }
        if (type instanceof Types.PrimType) {
            Types.PrimType primType = (Types.PrimType)type;
            return this.transformPrimType(primType);
        }
        if (type instanceof Types.ArrayType) {
            Types.ArrayType arrayType = (Types.ArrayType)type;
            Types.ArrayTypeRef arrayTypeRef = arrayType.arrayTypeRef();
            boolean nullable = arrayType.nullable();
            return Types$RefType$.MODULE$.apply(nullable, VarGen$genTypeID$.MODULE$.forArrayClass(arrayTypeRef));
        }
        if (type instanceof Types.ClosureType) {
            Types.ClosureType closureType = (Types.ClosureType)type;
            boolean nullable = closureType.nullable();
            Tuple2<Identitities.TypeID, Identitities.TypeID> tuple2 = ctx.genTypedClosureStructType(closureType);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Identitities.TypeID typedClosureTypeID = (Identitities.TypeID)tuple2._2();
            Identitities.TypeID typedClosureTypeID2 = typedClosureTypeID;
            return Types$RefType$.MODULE$.apply(nullable, typedClosureTypeID2);
        }
        if (type instanceof Types.RecordType) {
            throw new AssertionError((Object)new StringBuilder(23).append("Unexpected record type ").append(tpe).toString());
        }
        throw new MatchError((Object)type);
    }

    public Types.RefType transformClassType(Names.ClassName className, boolean nullable, WasmContext ctx) {
        Types.HeapType heapType;
        Option<WasmContext.ClassInfo> option = ctx.getClassInfoOption(className);
        if (option instanceof Some) {
            Some some = (Some)option;
            WasmContext.ClassInfo info = (WasmContext.ClassInfo)some.value();
            Names.ClassName className2 = className;
            Names.ClassName className3 = WellKnownNames$.MODULE$.BoxedStringClass();
            heapType = !(className2 != null ? !((Object)className2).equals(className3) : className3 != null) ? Types$HeapType$Extern$.MODULE$ : (info.isAncestorOfHijackedClass() ? Types$HeapType$Any$.MODULE$ : (!info.hasInstances() ? Types$HeapType$None$.MODULE$ : (info.isInterface() ? Types$HeapType$.MODULE$.apply(VarGen$genTypeID$.MODULE$.ObjectStruct()) : Types$HeapType$.MODULE$.apply(new VarGen.genTypeID.forClass(className)))));
        } else if (None$.MODULE$.equals(option)) {
            heapType = Types$HeapType$None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Types$HeapType$None$ heapType2 = heapType;
        return new Types.RefType(nullable, heapType2);
    }

    public Types.Type transformPrimType(Types.PrimType tpe) {
        Types.PrimType primType = tpe;
        if (Types$UndefType$.MODULE$.equals(primType)) {
            return Types$RefType$.MODULE$.any();
        }
        if (Types$BooleanType$.MODULE$.equals(primType)) {
            return Types$Int32$.MODULE$;
        }
        if (Types$ByteType$.MODULE$.equals(primType)) {
            return Types$Int32$.MODULE$;
        }
        if (Types$ShortType$.MODULE$.equals(primType)) {
            return Types$Int32$.MODULE$;
        }
        if (Types$IntType$.MODULE$.equals(primType)) {
            return Types$Int32$.MODULE$;
        }
        if (Types$CharType$.MODULE$.equals(primType)) {
            return Types$Int32$.MODULE$;
        }
        if (Types$LongType$.MODULE$.equals(primType)) {
            return Types$Int64$.MODULE$;
        }
        if (Types$FloatType$.MODULE$.equals(primType)) {
            return Types$Float32$.MODULE$;
        }
        if (Types$DoubleType$.MODULE$.equals(primType)) {
            return Types$Float64$.MODULE$;
        }
        if (Types$StringType$.MODULE$.equals(primType)) {
            return Types$RefType$.MODULE$.extern();
        }
        if (Types$NullType$.MODULE$.equals(primType)) {
            return Types$RefType$.MODULE$.nullref();
        }
        if (Types$VoidType$.MODULE$.equals(primType) ? true : Types$NothingType$.MODULE$.equals(primType)) {
            throw new IllegalArgumentException(new StringBuilder(40).append(tpe.show()).append(" does not have a corresponding Wasm type").toString());
        }
        throw new MatchError((Object)primType);
    }

    private TypeTransformer$() {
    }
}

