/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.linker.interface;

import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.scalajs.linker.interface.LinkerOutput;
import org.scalajs.linker.interface.OutputDirectory;
import org.scalajs.linker.interface.Report;
import org.scalajs.linker.interface.ReportToLinkerOutputAdapter;
import org.scalajs.linker.interface.unstable.OutputDirectoryImpl;
import org.scalajs.linker.interface.unstable.OutputDirectoryImpl$;
import org.scalajs.linker.interface.unstable.OutputFileImpl$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ReportToLinkerOutputAdapter$ {
    public static final ReportToLinkerOutputAdapter$ MODULE$ = new ReportToLinkerOutputAdapter$();
    private static final Regex sourceMapRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:^|\\n)(//# sourceMappingURL=[^\\n]*)(?:\\n|$)"));
    private static final Regex fileFieldRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([,{])\\s*\"file\"\\s*:\\s*\"[^\"]*\"\\s*([,}])"));

    public Future<BoxedUnit> convert(Report report, OutputDirectory outputDirectory, LinkerOutput legacyOutput, ExecutionContext ec) {
        SeqOps seqOps;
        List list = report.publicModules().toList();
        if (Nil$.MODULE$.equals(list)) {
            return this.writeEmptyOutput(legacyOutput, ec);
        }
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Report.Module module = (Report.Module)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return this.retrieveOutputFiles(module, outputDirectory, ec).flatMap((Function1 & Serializable)x$1 -> MODULE$.writePatchedOutput((Tuple2<ByteBuffer, Option<ByteBuffer>>)x$1, legacyOutput, ec), ec);
        }
        throw new ReportToLinkerOutputAdapter.UnsupportedLinkerOutputException(new java.lang.StringBuilder(59).append("Linking returned more than one public module. Full report:\n").append(report).toString());
    }

    private Future<BoxedUnit> writeEmptyOutput(LinkerOutput legacyOutput, ExecutionContext ec) {
        return (Future)legacyOutput.sourceMap().fold((Function0 & Serializable)() -> MODULE$.writeString(legacyOutput.jsFile(), "", ec), (Function1 & Serializable)sourceMapFile -> {
            List smFields = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)"3"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mappings"), (Object)"\"\""), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sources"), (Object)"[]"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"names"), (Object)"[]"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineCount"), (Object)"1"), (List)Nil$.MODULE$))))).$plus$plus((IterableOnce)legacyOutput.jsFileURI().map((Function1 & Serializable)uri -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)new java.lang.StringBuilder(2).append("\"").append(uri.toASCIIString()).append("\"").toString())));
            String jsContent = (String)legacyOutput.sourceMapURI().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)uri -> new java.lang.StringBuilder(22).append("//# sourceMappingURL=").append(uri.toASCIIString()).append("\n").toString());
            String smContent = smFields.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new java.lang.StringBuilder(4).append("\"").append(n).append("\": ").append(v).toString();
                }
                throw new MatchError((Object)tuple2);
            }).mkString("{\n", ",\n", "\n}");
            return MODULE$.writeString(legacyOutput.jsFile(), jsContent, ec).flatMap((Function1 & Serializable)x$2 -> MODULE$.writeString((LinkerOutput.File)sourceMapFile, smContent, ec), ec);
        });
    }

    private Future<BoxedUnit> writePatchedOutput(Tuple2<ByteBuffer, Option<ByteBuffer>> output, LinkerOutput legacyOutput, ExecutionContext ec) {
        Tuple2<ByteBuffer, Option<ByteBuffer>> tuple2 = output;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ByteBuffer jsFileContent = (ByteBuffer)tuple2._1();
        Option optSourceMapContent = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jsFileContent, (Object)optSourceMapContent);
        ByteBuffer jsFileContent2 = (ByteBuffer)tuple22._1();
        Option optSourceMapContent2 = (Option)tuple22._2();
        boolean hasSourceMap = optSourceMapContent2.isDefined() && legacyOutput.sourceMap().isDefined();
        String content = StandardCharsets.UTF_8.decode(jsFileContent2).toString();
        String patched = this.patchJSFileContent(content, (Option<URI>)legacyOutput.sourceMapURI().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)hasSourceMap)));
        Future<BoxedUnit> jsFileWrite = this.writeString(legacyOutput.jsFile(), patched, ec);
        Option sourceMapWrite = optSourceMapContent2.flatMap((Function1 & Serializable)sourceMapContent -> legacyOutput.sourceMap().map((Function1 & Serializable)sourceMapFile -> {
            String content = StandardCharsets.UTF_8.decode((ByteBuffer)sourceMapContent).toString();
            String patched = MODULE$.patchSourceMapContent(content, legacyOutput.jsFileURI());
            return MODULE$.writeString((LinkerOutput.File)sourceMapFile, patched, ec);
        }));
        return Future$.MODULE$.sequence((IterableOnce)new .colon.colon(jsFileWrite, (List)Nil$.MODULE$).$plus$plus((IterableOnce)sourceMapWrite), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)x$5 -> {
            ReportToLinkerOutputAdapter$.$anonfun$writePatchedOutput$4(x$5);
            return BoxedUnit.UNIT;
        }, ec);
    }

    private Future<Tuple2<ByteBuffer, Option<ByteBuffer>>> retrieveOutputFiles(Report.Module module, OutputDirectory outputDirectory, ExecutionContext ec) {
        OutputDirectoryImpl outDirImpl = OutputDirectoryImpl$.MODULE$.fromOutputDirectory(outputDirectory);
        Future checkFiles = outDirImpl.listFiles(ec).map((Function1 & Serializable)foundFilesList -> {
            ReportToLinkerOutputAdapter$.$anonfun$retrieveOutputFiles$1(module, foundFilesList);
            return BoxedUnit.UNIT;
        }, ec);
        return checkFiles.flatMap((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit = x$7;
            return outDirImpl.readFull(module.jsFileName(), ec).flatMap((Function1 & Serializable)jsFileContent -> Future$.MODULE$.traverse((IterableOnce)module.sourceMapName().toList(), (Function1 & Serializable)x$6 -> outDirImpl.readFull((String)x$6, ec), BuildFrom$.MODULE$.buildFromIterableOps(), ec).map((Function1 & Serializable)sourceMapContent -> new Tuple2(jsFileContent, (Object)sourceMapContent.headOption()), ec), ec);
        }, ec);
    }

    private Regex sourceMapRe() {
        return sourceMapRe;
    }

    private String patchJSFileContent(String content, Option<URI> sourceMapURI) {
        Option newLine = sourceMapURI.map((Function1 & Serializable)u -> new java.lang.StringBuilder(21).append("//# sourceMappingURL=").append(u.toASCIIString()).toString());
        return (String)this.sourceMapRe().findFirstMatchIn((CharSequence)content).fold((Function0 & Serializable)() -> new java.lang.StringBuilder(0).append(content).append(newLine.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$8 -> new java.lang.StringBuilder(2).append("\n").append((String)x$8).append("\n").toString())).toString(), (Function1 & Serializable)reMatch -> {
            StringBuilder res = new StringBuilder();
            res.append(reMatch.before(1));
            newLine.foreach((Function1 & Serializable)x$9 -> res.append(x$9));
            res.append(reMatch.after(1));
            return res.toString();
        });
    }

    private Regex fileFieldRe() {
        return fileFieldRe;
    }

    private String patchSourceMapContent(String content, Option<URI> jsFileURI) {
        Option newField = jsFileURI.map((Function1 & Serializable)u -> new java.lang.StringBuilder(10).append("\"file\": \"").append(u.toASCIIString()).append("\"").toString());
        return (String)this.fileFieldRe().findFirstMatchIn((CharSequence)content).fold((Function0 & Serializable)() -> (String)newField.fold((Function0 & Serializable)() -> content, (Function1 & Serializable)field -> {
            Object object;
            String[] stringArray = content.split("\\{", 2);
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String pre = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String post = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                return new java.lang.StringBuilder(2).append(pre).append("{").append((String)field).append(",").append(post).toString();
            }
            throw new IllegalArgumentException(new java.lang.StringBuilder(56).append("source map file does not seem to contain a JSON object: ").append(content).toString());
        }), (Function1 & Serializable)reMatch -> {
            StringBuilder res = new StringBuilder();
            res.append(reMatch.before());
            Option option = newField;
            if (None$.MODULE$.equals(option)) {
                String string = reMatch.group(1);
                String string2 = "{";
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? res.append('{') : BoxedUnit.UNIT;
                String string3 = reMatch.group(2);
                String string4 = "}";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    res.append('}');
                }
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String field = (String)some.value();
                res.append(reMatch.group(1));
                res.append(field);
                res.append(reMatch.group(2));
            } else {
                throw new MatchError((Object)option);
            }
            res.append(reMatch.after());
            return res.toString();
        });
    }

    private Future<BoxedUnit> writeString(LinkerOutput.File outputFile, String content, ExecutionContext ec) {
        return OutputFileImpl$.MODULE$.fromOutputFile(outputFile).writeFull(ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), ec);
    }

    public static final /* synthetic */ void $anonfun$writePatchedOutput$4(List x$5) {
    }

    public static final /* synthetic */ void $anonfun$retrieveOutputFiles$1(Report.Module module$1, List foundFilesList) {
        scala.collection.immutable.Set foundFiles = foundFilesList.toSet();
        scala.collection.immutable.Set expectedFiles = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{module$1.jsFileName()}))).$plus$plus(module$1.sourceMapName());
        scala.collection.immutable.Set set = foundFiles;
        scala.collection.immutable.Set set2 = expectedFiles;
        if (set == null ? set2 != null : !set.equals(set2)) {
            if (expectedFiles.subsetOf((Set)foundFiles)) {
                throw new ReportToLinkerOutputAdapter.UnsupportedLinkerOutputException(new java.lang.StringBuilder(95).append("Linking produced more than a single JS file (and source map). ").append("Expected files:\n").append(expectedFiles).append("\nProduced files:\n").append(foundFiles).toString());
            }
            throw new AssertionError((Object)new java.lang.StringBuilder(121).append("Linking did not produce the files mentioned in the report. This is a bug in the linker. ").append("Expected files:\n").append(expectedFiles).append("\nProduced files:\n").append(foundFiles).toString());
        }
    }

    private ReportToLinkerOutputAdapter$() {
    }
}

