/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.workflow.execution;

import java.io.Serializable;
import java.util.concurrent.Semaphore;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.workflow.execution.ExecutorPool$;
import org.openmole.core.workflow.execution.LocalEnvironment;
import org.openmole.core.workflow.execution.LocalExecutionJob;
import org.openmole.core.workflow.execution.LocalExecutor;
import org.openmole.core.workflow.job.Job;
import org.openmole.tool.collection.ArrayStack;
import org.openmole.tool.collection.ArrayStack$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.ref.WeakReference;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ExecutorPool {
    private final WeakReference<LocalEnvironment> environment;
    private final ThreadProvider threadProvider;
    private final ArrayStack<LocalExecutionJob> jobs;
    private final Semaphore semaphore;
    private final HashMap<LocalExecutor, Thread> executorMap;

    public ExecutorPool(int nbThreads, WeakReference<LocalEnvironment> environment, ThreadProvider threadProvider) {
        this.environment = environment;
        this.threadProvider = threadProvider;
        this.jobs = ArrayStack$.MODULE$.apply(1024, ArrayStack$.MODULE$.apply$default$2(), ClassTag$.MODULE$.apply(LocalExecutionJob.class));
        this.semaphore = new Semaphore(0);
        HashMap map = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nbThreads).foreach((Function1 & Serializable)_$1 -> ExecutorPool.$init$$$anonfun$1(map, environment, threadProvider, BoxesRunTime.unboxToInt((Object)_$1)));
        this.executorMap = map;
    }

    public Iterable<Job> runningJobs() {
        return (Iterable)this.executorMap.keys().flatMap((Function1 & Serializable)_$2 -> _$2.runningJob());
    }

    public void finalize() {
        this.executorMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                LocalExecutor exe = (LocalExecutor)tuple2._1();
                Thread thread = (Thread)tuple2._2();
                exe.stop_$eq(true);
                thread.interrupt();
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public LocalExecutionJob takeNextJob() {
        this.semaphore.acquire();
        return (LocalExecutionJob)this.jobs.pop();
    }

    public void enqueue(LocalExecutionJob job) {
        this.jobs.add((Object)job);
        this.semaphore.release();
    }

    public int waiting() {
        return this.jobs.size();
    }

    public int running() {
        int n;
        HashMap<LocalExecutor, Thread> hashMap = this.executorMap;
        synchronized (hashMap) {
            n = this.executorMap.toList().count((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    LocalExecutor e = (LocalExecutor)tuple2._1();
                    return e.runningJob().isDefined();
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return n;
    }

    public int stop() {
        HashMap<LocalExecutor, Thread> hashMap = this.executorMap;
        synchronized (hashMap) {
            this.executorMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    LocalExecutor exe = (LocalExecutor)tuple2._1();
                    Thread thread = (Thread)tuple2._2();
                    exe.stop_$eq(true);
                    thread.interrupt();
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.executorMap.clear();
        }
        this.jobs.clear();
        return this.semaphore.drainPermits();
    }

    private static final /* synthetic */ HashMap $init$$$anonfun$1(HashMap map$1, WeakReference environment$1, ThreadProvider threadProvider$1, int _$1) {
        return (HashMap)map$1.$plus$eq(ExecutorPool$.MODULE$.org$openmole$core$workflow$execution$ExecutorPool$$$createExecutor((WeakReference<LocalEnvironment>)environment$1, threadProvider$1));
    }
}

