/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class IOFiberConstants {
    static final int MaxStackDepth = 512;
    static final byte MapK = 0;
    static final byte FlatMapK = 1;
    static final byte CancelationLoopK = 2;
    static final byte RunTerminusK = 3;
    static final byte EvalOnK = 4;
    static final byte HandleErrorWithK = 5;
    static final byte OnCancelK = 6;
    static final byte UncancelableK = 7;
    static final byte UnmaskK = 8;
    static final byte AttemptK = 9;
    static final byte ExecR = 0;
    static final byte AsyncContinueSuccessfulR = 1;
    static final byte AsyncContinueFailedR = 2;
    static final byte AsyncContinueCanceledR = 3;
    static final byte AsyncContinueCanceledWithFinalizerR = 4;
    static final byte BlockingR = 5;
    static final byte CedeR = 6;
    static final byte AutoCedeR = 7;
    static final byte DoneR = 8;
    static final boolean TrackFiberContext;
    private static final MethodHandle THREAD_IS_VIRTUAL_HANDLE;

    IOFiberConstants() {
    }

    static boolean isVirtualThread(Thread thread) {
        try {
            return THREAD_IS_VIRTUAL_HANDLE.invokeExact(thread);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        MethodHandle methodHandle;
        TrackFiberContext = Boolean.getBoolean("cats.effect.trackFiberContext");
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType methodType = MethodType.methodType(Boolean.TYPE);
        try {
            methodHandle = lookup.findVirtual(Thread.class, "isVirtual", methodType);
        }
        catch (Throwable throwable) {
            methodHandle = MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, false), 0, new Class[]{Thread.class});
        }
        THREAD_IS_VIRTUAL_HANDLE = methodHandle;
    }
}

