/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.std.CountDownLatch$;
import cats.effect.std.CountDownLatch$Awaiting$;
import cats.effect.std.CountDownLatch$Done$;
import cats.effect.std.CountDownLatch$State$;
import cats.syntax.package$all$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class CountDownLatch<F> {
    public static <F> Object apply(int n, GenConcurrent<F, ?> genConcurrent) {
        return CountDownLatch$.MODULE$.apply(n, genConcurrent);
    }

    public abstract F release();

    public abstract F await();

    public <G> CountDownLatch<G> mapK(FunctionK<F, G> f) {
        return new CountDownLatch<G>(f, this){
            private final FunctionK f$1;
            private final /* synthetic */ CountDownLatch $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object release() {
                return this.f$1.apply(this.$outer.release());
            }

            public Object await() {
                return this.f$1.apply(this.$outer.await());
            }
        };
    }

    public static class Awaiting<F>
    implements State<F>,
    Product,
    Serializable {
        private final int latches;
        private final Deferred signal;

        public static <F> Awaiting<F> apply(int n, Deferred<F, BoxedUnit> deferred) {
            return CountDownLatch$Awaiting$.MODULE$.apply(n, deferred);
        }

        public static Awaiting<?> fromProduct(Product product) {
            return CountDownLatch$Awaiting$.MODULE$.fromProduct(product);
        }

        public static <F> Awaiting<F> unapply(Awaiting<F> awaiting) {
            return CountDownLatch$Awaiting$.MODULE$.unapply(awaiting);
        }

        public Awaiting(int latches, Deferred<F, BoxedUnit> signal) {
            this.latches = latches;
            this.signal = signal;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.latches());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.signal()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Awaiting)) return false;
            Awaiting awaiting = (Awaiting)object;
            if (this.latches() != awaiting.latches()) return false;
            Deferred<F, BoxedUnit> deferred = this.signal();
            Deferred<F, BoxedUnit> deferred2 = awaiting.signal();
            if (deferred == null) {
                if (deferred2 != null) {
                    return false;
                }
            } else if (!deferred.equals(deferred2)) return false;
            if (!awaiting.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Awaiting;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Awaiting";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "latches";
            }
            if (1 == n2) {
                return "signal";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int latches() {
            return this.latches;
        }

        public Deferred<F, BoxedUnit> signal() {
            return this.signal;
        }

        public <F> Awaiting<F> copy(int latches, Deferred<F, BoxedUnit> signal) {
            return new Awaiting<F>(latches, signal);
        }

        public int copy$default$1() {
            return this.latches();
        }

        public <F> Deferred<F, BoxedUnit> copy$default$2() {
            return this.signal();
        }

        public int _1() {
            return this.latches();
        }

        public Deferred<F, BoxedUnit> _2() {
            return this.signal();
        }
    }

    public static class ConcurrentCountDownLatch<F>
    extends CountDownLatch<F> {
        private final Ref<F, State<F>> state;
        private final GenConcurrent<F, ?> F;

        public ConcurrentCountDownLatch(Ref<F, State<F>> state2, GenConcurrent<F, ?> F) {
            this.state = state2;
            this.F = F;
        }

        @Override
        public F release() {
            return this.state.flatModify((Function1 & Serializable)x$1 -> {
                Done done;
                State state2 = x$1;
                if (state2 instanceof Awaiting) {
                    Awaiting awaiting = CountDownLatch$Awaiting$.MODULE$.unapply((Awaiting)state2);
                    int n = awaiting._1();
                    Deferred deferred = awaiting._2();
                    int n2 = n;
                    Deferred signal = deferred;
                    if (n2 > 1) {
                        return Tuple2$.MODULE$.apply(CountDownLatch$Awaiting$.MODULE$.apply(n2 - 1, signal), this.F.unit());
                    }
                    return Tuple2$.MODULE$.apply(CountDownLatch$Done$.MODULE$.apply(), package$all$.MODULE$.toFunctorOps(signal.complete(BoxedUnit.UNIT), (Functor)this.F).void());
                }
                if (state2 instanceof Done && CountDownLatch$Done$.MODULE$.unapply(done = (Done)state2)) {
                    Done d = done;
                    return Tuple2$.MODULE$.apply((Object)d, this.F.unit());
                }
                throw new MatchError((Object)state2);
            }, this.F);
        }

        @Override
        public F await() {
            return package$all$.MODULE$.toFlatMapOps(this.state.get(), (FlatMap)this.F).flatMap((Function1 & Serializable)x$1 -> {
                State state2 = x$1;
                if (state2 instanceof Awaiting) {
                    Deferred deferred;
                    Awaiting awaiting = CountDownLatch$Awaiting$.MODULE$.unapply((Awaiting)state2);
                    int n = awaiting._1();
                    Deferred signal = deferred = awaiting._2();
                    return signal.get();
                }
                if (state2 instanceof Done && CountDownLatch$Done$.MODULE$.unapply((Done)state2)) {
                    return this.F.unit();
                }
                throw new MatchError((Object)state2);
            });
        }
    }

    public static class Done<F>
    implements State<F>,
    Product,
    Serializable {
        public static <F> Done<F> apply() {
            return CountDownLatch$Done$.MODULE$.apply();
        }

        public static Done<?> fromProduct(Product product) {
            return CountDownLatch$Done$.MODULE$.fromProduct(product);
        }

        public static <F> boolean unapply(Done<F> done) {
            return CountDownLatch$Done$.MODULE$.unapply(done);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Done)) return false;
            Done done = (Done)object;
            boolean bl = done.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Done;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Done";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public <F> Done<F> copy() {
            return new Done<F>();
        }
    }

    public static interface State<F> {
        public static <F> Object initial(int n, GenConcurrent<F, ?> genConcurrent) {
            return CountDownLatch$State$.MODULE$.initial(n, genConcurrent);
        }

        public static int ordinal(State<?> state2) {
            return CountDownLatch$State$.MODULE$.ordinal(state2);
        }
    }
}

