/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.Monad$;
import cats.MonadError;
import cats.arrow.FunctionK;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Ref$ApplyBuilders$;
import cats.effect.kernel.Ref$Make$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.Sync$Type$Delay$;
import cats.effect.std.Random$;
import cats.kernel.Monoid;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public interface Random<F> {
    public static <F> Random<F> apply(Random<F> random) {
        return Random$.MODULE$.apply(random);
    }

    public static <F, L> Random<?> catsEitherTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsEitherTRandom(random, functor);
    }

    public static <F, E, L, S> Random<?> catsIndexedReaderWriterStateTRandom(Random<F> random, Applicative<F> applicative, Monoid<L> monoid) {
        return Random$.MODULE$.catsIndexedReaderWriterStateTRandom(random, applicative, monoid);
    }

    public static <F, S> Random<?> catsIndexedStateTRandom(Random<F> random, Applicative<F> applicative) {
        return Random$.MODULE$.catsIndexedStateTRandom(random, applicative);
    }

    public static <F, L> Random<?> catsIorTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsIorTRandom(random, functor);
    }

    public static <F, R> Random<?> catsKleisliRandom(Random<F> random) {
        return Random$.MODULE$.catsKleisliRandom(random);
    }

    public static <F> Random<?> catsOptionTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsOptionTRandom(random, functor);
    }

    public static <F, L> Random<?> catsWriterTRandom(Random<F> random, Applicative<F> applicative, Monoid<L> monoid) {
        return Random$.MODULE$.catsWriterTRandom(random, applicative, monoid);
    }

    public static <F> Object javaSecuritySecureRandom(int n, Sync<F> sync) {
        return Random$.MODULE$.javaSecuritySecureRandom(n, sync);
    }

    public static <F> Object javaSecuritySecureRandom(Sync<F> sync) {
        return Random$.MODULE$.javaSecuritySecureRandom(sync);
    }

    public static <F> Random<F> javaUtilConcurrentThreadLocalRandom(Sync<F> sync) {
        return Random$.MODULE$.javaUtilConcurrentThreadLocalRandom(sync);
    }

    public static <F> Object javaUtilRandom(java.util.Random random, Sync<F> sync) {
        return Random$.MODULE$.javaUtilRandom(random, sync);
    }

    public static <F> Object scalaUtilRandom(Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandom(sync);
    }

    public static <F> Object scalaUtilRandomN(int n, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomN(n, sync);
    }

    public static <F> Object scalaUtilRandomSeedInt(int n, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomSeedInt(n, sync);
    }

    public static <F> Object scalaUtilRandomSeedLong(long l, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomSeedLong(l, sync);
    }

    public F betweenDouble(double var1, double var3);

    public F betweenFloat(float var1, float var2);

    public F betweenInt(int var1, int var2);

    public F betweenLong(long var1, long var3);

    public F nextAlphaNumeric();

    public F nextBoolean();

    public F nextBytes(int var1);

    public F nextDouble();

    public F nextFloat();

    public F nextGaussian();

    public F nextInt();

    public F nextIntBounded(int var1);

    public F nextLong();

    public F nextLongBounded(long var1);

    public F nextPrintableChar();

    public F nextString(int var1);

    public <A> F shuffleList(List<A> var1);

    public <A> F shuffleVector(Vector<A> var1);

    public static Object oneOf$(Random $this, Object x, scala.collection.immutable.Seq xs, Applicative ev) {
        return $this.oneOf(x, xs, ev);
    }

    default public <A> F oneOf(A x, scala.collection.immutable.Seq<A> xs, Applicative<F> ev) {
        if (xs.isEmpty()) {
            Object object = package$all$.MODULE$.catsSyntaxApplicativeId((Object)x);
            return (F)ApplicativeIdOps$.MODULE$.pure$extension(object, ev);
        }
        return package$all$.MODULE$.toFunctorOps((Object)this.nextIntBounded(1 + xs.size()), (Functor)ev).map((Function1 & Serializable)x$1 -> Random.oneOf$$anonfun$1(x, xs, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static Object elementOf$(Random $this, Iterable xs, MonadError ev) {
        return $this.elementOf(xs, ev);
    }

    default public <A> F elementOf(Iterable<A> xs, MonadError<F, Throwable> ev) {
        Object object;
        if (xs.nonEmpty()) {
            BoxedUnit boxedUnit = (BoxedUnit)package$all$.MODULE$.catsSyntaxApplicativeId(BoxedUnit.UNIT);
            object = ApplicativeIdOps$.MODULE$.pure$extension(boxedUnit, ev);
        } else {
            NoSuchElementException noSuchElementException = (NoSuchElementException)package$all$.MODULE$.catsSyntaxApplicativeErrorId(new NoSuchElementException("Cannot choose a random element of an empty collection"));
            object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension(noSuchElementException, ev);
        }
        Object requireNonEmpty = object;
        Object object2 = package$all$.MODULE$.catsSyntaxApplyOps(requireNonEmpty);
        return (F)ApplyOps$.MODULE$.$times$greater$extension(object2, package$all$.MODULE$.toFunctorOps((Object)this.nextIntBounded(xs.size()), (Functor)ev).map((Function1 & Serializable)i -> Random.elementOf$$anonfun$1(xs, BoxesRunTime.unboxToInt((Object)i))), ev);
    }

    public static Random mapK$(Random $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Random<G> mapK(FunctionK<F, G> f) {
        return new TranslatedRandom<F, G>(f, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer, f$1);
            }
        };
    }

    private static /* synthetic */ Object oneOf$$anonfun$1(Object x$1, scala.collection.immutable.Seq xs$1, int x$12) {
        int n = x$12;
        if (0 == n) {
            return x$1;
        }
        int i = n;
        return xs$1.apply(i - 1);
    }

    private static Object loop$1(int i$1, Iterator it, int n) {
        while (true) {
            Object next = it.next();
            if (n == i$1) {
                return next;
            }
            ++n;
        }
    }

    private static /* synthetic */ Object elementOf$$anonfun$1(Iterable xs$2, int i) {
        Iterable iterable = xs$2;
        if (iterable instanceof Seq) {
            Seq seq = (Seq)iterable;
            return seq.apply(i);
        }
        return Random.loop$1(i, xs$2.iterator(), 0);
    }

    public static abstract class RandomCommon<F>
    implements Random<F> {
        private final Sync<F> evidence$1;

        public RandomCommon(Sync<F> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public F betweenDouble(double minInclusive, double maxExclusive) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)Random$::cats$effect$std$Random$RandomCommon$$_$betweenDouble$$anonfun$1)), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package$all$.MODULE$.toFunctorOps(this.nextDouble(), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$betweenDouble$$anonfun$2$$anonfun$1(maxExclusive, minInclusive, arg_0));
            });
        }

        @Override
        public F betweenFloat(float minInclusive, float maxExclusive) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)Random$::cats$effect$std$Random$RandomCommon$$_$betweenFloat$$anonfun$1)), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package$all$.MODULE$.toFunctorOps(this.nextFloat(), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$betweenFloat$$anonfun$2$$anonfun$1(maxExclusive, minInclusive, arg_0));
            });
        }

        @Override
        public F betweenInt(int minInclusive, int maxExclusive) {
            Object object = package$all$.MODULE$.catsSyntaxApplyOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)Random$::cats$effect$std$Random$RandomCommon$$_$betweenInt$$anonfun$1)));
            int difference = maxExclusive - minInclusive;
            return (F)ApplyOps$.MODULE$.$times$greater$extension(object, package$all$.MODULE$.toFunctorOps(difference >= 0 ? package$all$.MODULE$.toFunctorOps(this.nextIntBounded(difference), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$betweenInt$$anonfun$2(minInclusive, arg_0)) : this.loop$2(minInclusive, maxExclusive), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$RandomCommon$$_$betweenInt$$anonfun$3), this.evidence$1);
        }

        @Override
        public F betweenLong(long minInclusive, long maxExclusive) {
            Object object = package$all$.MODULE$.catsSyntaxApplyOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)Random$::cats$effect$std$Random$RandomCommon$$_$betweenLong$$anonfun$1)));
            long difference = maxExclusive - minInclusive;
            return (F)ApplyOps$.MODULE$.$times$greater$extension(object, package$all$.MODULE$.toFunctorOps(difference >= 0L ? package$all$.MODULE$.toFunctorOps((Object)this.nextLongBounded(difference), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$betweenLong$$anonfun$2(minInclusive, arg_0)) : this.loop$3(minInclusive, maxExclusive), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$RandomCommon$$_$betweenLong$$anonfun$3), this.evidence$1);
        }

        @Override
        public F nextAlphaNumeric() {
            String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            return package$all$.MODULE$.toFunctorOps(this.nextIntBounded(chars.length()), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$nextAlphaNumeric$$anonfun$adapted$1(chars, arg_0));
        }

        @Override
        public F nextLongBounded(long n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(n > 0L, (Function0<String>)((Function0 & Serializable)() -> Random$.cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$1(n))), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Ref.Make make = Ref$.MODULE$.apply(Ref$Make$.MODULE$.syncInstance((Sync)this.evidence$1));
                return package$all$.MODULE$.toFlatMapOps(Ref$ApplyBuilders$.MODULE$.of$extension(make, BoxesRunTime.boxToLong((long)0L)), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)offset -> {
                    Ref.Make make = Ref$.MODULE$.apply(Ref$Make$.MODULE$.syncInstance((Sync)this.evidence$1));
                    return package$all$.MODULE$.toFlatMapOps(Ref$ApplyBuilders$.MODULE$.of$extension(make, BoxesRunTime.boxToLong((long)n)), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)_n -> package$all$.MODULE$.toFlatMapOps((Object)Monad$.MODULE$.apply(this.evidence$1).whileM_(package$all$.MODULE$.toFunctorOps(_n.get(), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1), () -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(_n, offset)), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package$all$.MODULE$.toFlatMapOps(offset.get(), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)finalOffset -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1((Ref)_n, BoxesRunTime.unboxToLong((Object)finalOffset)));
                    }));
                });
            });
        }

        private F require(boolean condition, Function0<String> errorMessage) {
            if (condition) {
                BoxedUnit boxedUnit = (BoxedUnit)package$all$.MODULE$.catsSyntaxApplicativeId(BoxedUnit.UNIT);
                return (F)ApplicativeIdOps$.MODULE$.pure$extension(boxedUnit, this.evidence$1);
            }
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)package$all$.MODULE$.catsSyntaxApplicativeErrorId(new IllegalArgumentException((String)errorMessage.apply()));
            return (F)ApplicativeErrorIdOps$.MODULE$.raiseError$extension(illegalArgumentException, this.evidence$1);
        }

        private final /* synthetic */ Object loop$2$$anonfun$1(int minInclusive$7, int maxExclusive$6, int n) {
            if (n >= minInclusive$7 && n < maxExclusive$6) {
                Integer n2 = (Integer)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToInteger((int)n));
                return ApplicativeIdOps$.MODULE$.pure$extension(n2, this.evidence$1);
            }
            return this.loop$2(minInclusive$7, maxExclusive$6);
        }

        private final Object loop$2(int minInclusive$6, int maxExclusive$5) {
            return package$all$.MODULE$.toFlatMapOps(this.nextInt(), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)n -> this.loop$2$$anonfun$1(minInclusive$6, maxExclusive$5, BoxesRunTime.unboxToInt((Object)n)));
        }

        private final /* synthetic */ Object loop$3$$anonfun$1(long minInclusive$10, long maxExclusive$8, long n) {
            if (n >= minInclusive$10 && n < maxExclusive$8) {
                Long l = (Long)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToLong((long)n));
                return ApplicativeIdOps$.MODULE$.pure$extension(l, this.evidence$1);
            }
            return this.loop$3(minInclusive$10, maxExclusive$8);
        }

        private final Object loop$3(long minInclusive$9, long maxExclusive$7) {
            return package$all$.MODULE$.toFlatMapOps(this.nextLong(), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)n -> this.loop$3$$anonfun$1(minInclusive$9, maxExclusive$7, BoxesRunTime.unboxToLong((Object)n)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(int bits$2, Ref _n$4, Ref offset$4, long nextN) {
            return package$all$.MODULE$.toFlatMapOps((bits$2 & 1) == 0 ? package$all$.MODULE$.toFlatMapOps(_n$4.get(), (FlatMap)this.evidence$1).flatMap(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$adapted$1(offset$4, nextN, arg_0)) : Applicative$.MODULE$.apply(this.evidence$1).unit(), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package$all$.MODULE$.toFunctorOps(_n$4.set(BoxesRunTime.boxToLong((long)nextN)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1);
            });
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(int bits$1, Ref _n$3, Ref offset$3, long halfn) {
            Object object;
            if ((bits$1 & 2) == 0) {
                Long l = (Long)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToLong((long)halfn));
                object = ApplicativeIdOps$.MODULE$.pure$extension(l, this.evidence$1);
            } else {
                object = package$all$.MODULE$.toFunctorOps(_n$3.get(), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(halfn, arg_0));
            }
            return package$all$.MODULE$.toFlatMapOps(object, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)nextN -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(bits$1, _n$3, offset$3, BoxesRunTime.unboxToLong((Object)nextN)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Ref _n$2, Ref offset$2, int bits) {
            return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFunctorOps(_n$2.get(), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)halfn -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(bits, _n$2, offset$2, BoxesRunTime.unboxToLong((Object)halfn)));
        }

        private final Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(Ref _n$1, Ref offset$1) {
            return package$all$.MODULE$.toFlatMapOps(this.nextIntBounded(2), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)bits -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(_n$1, offset$1, BoxesRunTime.unboxToInt((Object)bits)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(long l) {
            return this.nextIntBounded((int)l);
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(Ref _n$7, long finalOffset) {
            return package$all$.MODULE$.toFunctorOps(package$all$.MODULE$.toFlatMapOps(_n$7.get(), (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)l -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)l))), (Functor)this.evidence$1).map(arg_0 -> Random$.cats$effect$std$Random$RandomCommon$$_$nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$2(finalOffset, arg_0));
        }
    }

    public static abstract class ScalaRandom<F>
    extends RandomCommon<F> {
        private final F f;
        private final Sync.Type hint;
        private final Sync<F> evidence$1;

        public ScalaRandom(Object f, Sync.Type hint, Sync<F> evidence$1) {
            this.f = f;
            this.hint = hint;
            this.evidence$1 = evidence$1;
            super(evidence$1);
        }

        public ScalaRandom(Object f, Sync<F> evidence$1) {
            this(f, Sync$Type$Delay$.MODULE$, evidence$1);
        }

        @Override
        public F nextBoolean() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextBoolean$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextBoolean$$anonfun$1$$anonfun$adapted$1));
        }

        @Override
        public F nextBytes(int n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextBytes$$anonfun$1$$anonfun$1(n, r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextBytes$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextDouble() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextDouble$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextDouble$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextFloat() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextFloat$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextFloat$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextGaussian() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextGaussian$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextGaussian$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextInt() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextInt$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextInt$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextIntBounded(int n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextIntBounded$$anonfun$1$$anonfun$1(r, n)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextIntBounded$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextLong() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextLong$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextLong$$anonfun$1$$anonfun$2));
        }

        @Override
        public F nextPrintableChar() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextPrintableChar$$anonfun$1$$anonfun$1(r)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextPrintableChar$$anonfun$1$$anonfun$adapted$1));
        }

        @Override
        public F nextString(int length) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$nextString$$anonfun$1$$anonfun$1(r, length)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$nextString$$anonfun$1$$anonfun$2));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$shuffleList$$anonfun$1$$anonfun$1(r, l)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$shuffleList$$anonfun$1$$anonfun$2));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$1).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$1).suspend(this.hint, () -> Random$.cats$effect$std$Random$ScalaRandom$$_$shuffleVector$$anonfun$1$$anonfun$1(r, v)), (Functor)this.evidence$1).map(Random$::cats$effect$std$Random$ScalaRandom$$_$shuffleVector$$anonfun$1$$anonfun$2));
        }
    }

    public static abstract class ThreadLocalRandom<F>
    extends RandomCommon<F> {
        private final Sync<F> evidence$1;

        public ThreadLocalRandom(Sync<F> evidence$1) {
            this.evidence$1 = evidence$1;
            super(evidence$1);
        }

        @Override
        public F nextBoolean() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextBoolean$$anonfun$2);
        }

        @Override
        public F nextBytes(int n) {
            return Sync$.MODULE$.apply(this.evidence$1).delay(() -> Random$.cats$effect$std$Random$ThreadLocalRandom$$_$nextBytes$$anonfun$2(n));
        }

        @Override
        public F nextDouble() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextDouble$$anonfun$2);
        }

        @Override
        public F nextFloat() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextFloat$$anonfun$2);
        }

        @Override
        public F nextGaussian() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextGaussian$$anonfun$2);
        }

        @Override
        public F nextInt() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextInt$$anonfun$2);
        }

        @Override
        public F nextIntBounded(int n) {
            return Sync$.MODULE$.apply(this.evidence$1).delay(() -> Random$.cats$effect$std$Random$ThreadLocalRandom$$_$nextIntBounded$$anonfun$2(n));
        }

        @Override
        public F nextLong() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextLong$$anonfun$2);
        }

        @Override
        public F nextPrintableChar() {
            return Sync$.MODULE$.apply(this.evidence$1).delay(Random$::cats$effect$std$Random$ThreadLocalRandom$$_$nextPrintableChar$$anonfun$2);
        }

        @Override
        public F nextString(int length) {
            return Sync$.MODULE$.apply(this.evidence$1).delay(() -> Random$.cats$effect$std$Random$ThreadLocalRandom$$_$nextString$$anonfun$2(length));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return Sync$.MODULE$.apply(this.evidence$1).delay(() -> Random$.cats$effect$std$Random$ThreadLocalRandom$$_$shuffleList$$anonfun$2(l));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return Sync$.MODULE$.apply(this.evidence$1).delay(() -> Random$.cats$effect$std$Random$ThreadLocalRandom$$_$shuffleVector$$anonfun$2(v));
        }
    }

    public static abstract class TranslatedRandom<F, G>
    implements Random<G> {
        private final Random<F> self;
        private final FunctionK<F, G> f;

        public TranslatedRandom(Random<F> self, FunctionK<F, G> f) {
            this.self = self;
            this.f = f;
        }

        @Override
        public G betweenDouble(double minInclusive, double maxExclusive) {
            return this.f.apply(this.self.betweenDouble(minInclusive, maxExclusive));
        }

        @Override
        public G betweenFloat(float minInclusive, float maxExclusive) {
            return this.f.apply(this.self.betweenFloat(minInclusive, maxExclusive));
        }

        @Override
        public G betweenInt(int minInclusive, int maxExclusive) {
            return this.f.apply(this.self.betweenInt(minInclusive, maxExclusive));
        }

        @Override
        public G betweenLong(long minInclusive, long maxExclusive) {
            return this.f.apply(this.self.betweenLong(minInclusive, maxExclusive));
        }

        @Override
        public G nextAlphaNumeric() {
            return this.f.apply(this.self.nextAlphaNumeric());
        }

        @Override
        public G nextBoolean() {
            return this.f.apply(this.self.nextBoolean());
        }

        @Override
        public G nextBytes(int n) {
            return this.f.apply(this.self.nextBytes(n));
        }

        @Override
        public G nextDouble() {
            return this.f.apply(this.self.nextDouble());
        }

        @Override
        public G nextFloat() {
            return this.f.apply(this.self.nextFloat());
        }

        @Override
        public G nextGaussian() {
            return this.f.apply(this.self.nextGaussian());
        }

        @Override
        public G nextInt() {
            return this.f.apply(this.self.nextInt());
        }

        @Override
        public G nextIntBounded(int n) {
            return this.f.apply(this.self.nextIntBounded(n));
        }

        @Override
        public G nextLong() {
            return this.f.apply(this.self.nextLong());
        }

        @Override
        public G nextLongBounded(long n) {
            return this.f.apply(this.self.nextLongBounded(n));
        }

        @Override
        public G nextPrintableChar() {
            return this.f.apply(this.self.nextPrintableChar());
        }

        @Override
        public G nextString(int length) {
            return this.f.apply(this.self.nextString(length));
        }

        @Override
        public <A> G shuffleList(List<A> l) {
            return this.f.apply(this.self.shuffleList(l));
        }

        @Override
        public <A> G shuffleVector(Vector<A> v) {
            return this.f.apply(this.self.shuffleVector(v));
        }
    }
}

