/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Selector;
import cats.effect.unsafe.PollResult;
import cats.effect.unsafe.PollResult$Complete$;
import cats.effect.unsafe.PollResult$Interrupted$;
import cats.effect.unsafe.PollingContext;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.SelectorSystem$;
import cats.effect.unsafe.UnsafeNonFatal;
import cats.effect.unsafe.metrics.PollerMetrics;
import java.io.Serializable;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import scala.Function0;
import scala.Function1;
import scala.Some$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;

public final class SelectorSystem
extends PollingSystem {
    private final SelectorProvider provider;

    public static SelectorSystem apply() {
        return SelectorSystem$.MODULE$.apply();
    }

    public static SelectorSystem apply(SelectorProvider selectorProvider) {
        return SelectorSystem$.MODULE$.apply(selectorProvider);
    }

    public SelectorSystem(SelectorProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
    }

    public Selector makeApi(PollingContext<Poller> ctx) {
        return new SelectorImpl(this, ctx, this.provider);
    }

    @Override
    public Poller makePoller() {
        return new Poller(this, this.provider.openSelector());
    }

    public void closePoller(Poller poller) {
        poller.selector().close();
    }

    public PollResult poll(Poller poller, long nanos) {
        long millis = nanos >= 0L ? nanos / 1000000L : -1L;
        AbstractSelector selector = poller.selector();
        int n = millis == 0L ? selector.selectNow() : (millis > 0L ? selector.select(millis) : selector.select());
        return selector.isOpen() && !selector.selectedKeys().isEmpty() ? PollResult$Complete$.MODULE$ : PollResult$Interrupted$.MODULE$;
    }

    public boolean processReadyEvents(Poller poller) {
        AbstractSelector selector = poller.selector();
        boolean fibersRescheduled = false;
        Iterator<SelectionKey> ready = selector.selectedKeys().iterator();
        while (ready.hasNext()) {
            SelectionKey selectionKey;
            SelectionKey key = ready.next();
            ready.remove();
            int readyOps = 0;
            Throwable error = null;
            try {
                readyOps = key.readyOps();
                selectionKey = key.interestOps(key.interestOps() & ~readyOps);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (!UnsafeNonFatal.apply(ex)) {
                    throw throwable;
                }
                error = ex;
                readyOps = -1;
                selectionKey = BoxedUnit.UNIT;
            }
            Left value = error != null ? package$.MODULE$.Left().apply((Object)error) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)readyOps));
            Callbacks callbacks = (Callbacks)key.attachment();
            Iterator<Callbacks.Node> iter = callbacks.iterator();
            while (iter.hasNext()) {
                Callbacks.Node node = iter.next();
                if ((node.interest() & readyOps) == 0) continue;
                node.remove();
                Function1<Either<Throwable, Object>, BoxedUnit> cb = node.callback();
                if (cb != null) {
                    cb.apply((Object)value);
                    fibersRescheduled = true;
                    if (error == null) {
                        poller.countSucceededOperation(readyOps);
                        continue;
                    }
                    poller.countErroredOperation(node.interest());
                    continue;
                }
                poller.countCanceledOperation(node.interest());
            }
        }
        return fibersRescheduled;
    }

    public boolean needsPoll(Poller poller) {
        return !poller.selector().keys().isEmpty();
    }

    public void interrupt(Thread targetThread, Poller targetPoller) {
        targetPoller.selector().wakeup();
    }

    public PollerMetrics metrics(Poller poller) {
        return poller;
    }

    public static final class Callbacks {
        public Node cats$effect$unsafe$SelectorSystem$Callbacks$$head = null;
        public Node cats$effect$unsafe$SelectorSystem$Callbacks$$last = null;

        public Node append(int interest, Function1<Either<Throwable, Object>, BoxedUnit> callback) {
            Node node = new Node(this, interest, callback);
            if (this.cats$effect$unsafe$SelectorSystem$Callbacks$$last != null) {
                this.cats$effect$unsafe$SelectorSystem$Callbacks$$last.next_$eq(node);
                node.prev_$eq(this.cats$effect$unsafe$SelectorSystem$Callbacks$$last);
            } else {
                this.cats$effect$unsafe$SelectorSystem$Callbacks$$head = node;
            }
            this.cats$effect$unsafe$SelectorSystem$Callbacks$$last = node;
            return node;
        }

        public Iterator<Node> iterator() {
            return new Iterator<Node>(this){
                private Node _next;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this._next = $outer.cats$effect$unsafe$SelectorSystem$Callbacks$$head;
                }

                public boolean hasNext() {
                    return this._next != null;
                }

                public Node next() {
                    Node next = this._next;
                    this._next = next.next();
                    return next;
                }
            };
        }

        public final class Node {
            private int interest;
            private Function1 callback;
            private Node prev;
            private Node next;
            private final /* synthetic */ Callbacks $outer;

            public Node(Callbacks $outer, int interest, Function1<Either<Throwable, Object>, BoxedUnit> callback) {
                this.interest = interest;
                this.callback = callback;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.prev = null;
                this.next = null;
            }

            public int interest() {
                return this.interest;
            }

            public void interest_$eq(int x$1) {
                this.interest = x$1;
            }

            public Function1<Either<Throwable, Object>, BoxedUnit> callback() {
                return this.callback;
            }

            public void callback_$eq(Function1<Either<Throwable, Object>, BoxedUnit> x$1) {
                this.callback = x$1;
            }

            public Node prev() {
                return this.prev;
            }

            public void prev_$eq(Node x$1) {
                this.prev = x$1;
            }

            public Node next() {
                return this.next;
            }

            public void next_$eq(Node x$1) {
                this.next = x$1;
            }

            public void remove() {
                if (this.prev() != null) {
                    this.prev().next_$eq(this.next());
                } else {
                    this.$outer.cats$effect$unsafe$SelectorSystem$Callbacks$$head = this.next();
                }
                if (this.next() != null) {
                    this.next().prev_$eq(this.prev());
                    return;
                }
                this.$outer.cats$effect$unsafe$SelectorSystem$Callbacks$$last = this.prev();
            }

            public void clear() {
                this.interest_$eq(-1);
                this.callback_$eq(null);
            }

            public final /* synthetic */ Callbacks cats$effect$unsafe$SelectorSystem$Callbacks$Node$$$outer() {
                return this.$outer;
            }
        }
    }

    public final class Poller
    implements PollerMetrics {
        private final AbstractSelector selector;
        private int outstandingOperations;
        private int outstandingAccepts;
        private int outstandingConnects;
        private int outstandingReads;
        private int outstandingWrites;
        private long submittedOperations;
        private long submittedAccepts;
        private long submittedConnects;
        private long submittedReads;
        private long submittedWrites;
        private long succeededOperations;
        private long succeededAccepts;
        private long succeededConnects;
        private long succeededReads;
        private long succeededWrites;
        private long erroredOperations;
        private long erroredAccepts;
        private long erroredConnects;
        private long erroredReads;
        private long erroredWrites;
        private long canceledOperations;
        private long canceledAccepts;
        private long canceledConnects;
        private long canceledReads;
        private long canceledWrites;
        private final /* synthetic */ SelectorSystem $outer;

        public Poller(SelectorSystem $outer, AbstractSelector selector) {
            this.selector = selector;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.outstandingOperations = 0;
            this.outstandingAccepts = 0;
            this.outstandingConnects = 0;
            this.outstandingReads = 0;
            this.outstandingWrites = 0;
            this.submittedOperations = 0L;
            this.submittedAccepts = 0L;
            this.submittedConnects = 0L;
            this.submittedReads = 0L;
            this.submittedWrites = 0L;
            this.succeededOperations = 0L;
            this.succeededAccepts = 0L;
            this.succeededConnects = 0L;
            this.succeededReads = 0L;
            this.succeededWrites = 0L;
            this.erroredOperations = 0L;
            this.erroredAccepts = 0L;
            this.erroredConnects = 0L;
            this.erroredReads = 0L;
            this.erroredWrites = 0L;
            this.canceledOperations = 0L;
            this.canceledAccepts = 0L;
            this.canceledConnects = 0L;
            this.canceledReads = 0L;
            this.canceledWrites = 0L;
        }

        public AbstractSelector selector() {
            return this.selector;
        }

        public void countSubmittedOperation(int ops) {
            ++this.outstandingOperations;
            ++this.submittedOperations;
            if (this.isAccept(ops)) {
                ++this.outstandingAccepts;
                ++this.submittedAccepts;
            }
            if (this.isConnect(ops)) {
                ++this.outstandingConnects;
                ++this.submittedConnects;
            }
            if (this.isRead(ops)) {
                ++this.outstandingReads;
                ++this.submittedReads;
            }
            if (this.isWrite(ops)) {
                ++this.outstandingWrites;
                ++this.submittedWrites;
                return;
            }
        }

        public void countSucceededOperation(int ops) {
            --this.outstandingOperations;
            ++this.succeededOperations;
            if (this.isAccept(ops)) {
                --this.outstandingAccepts;
                ++this.succeededAccepts;
            }
            if (this.isConnect(ops)) {
                --this.outstandingConnects;
                ++this.succeededConnects;
            }
            if (this.isRead(ops)) {
                --this.outstandingReads;
                ++this.succeededReads;
            }
            if (this.isWrite(ops)) {
                --this.outstandingWrites;
                ++this.succeededWrites;
                return;
            }
        }

        public void countErroredOperation(int ops) {
            --this.outstandingOperations;
            ++this.erroredOperations;
            if (this.isAccept(ops)) {
                --this.outstandingAccepts;
                ++this.erroredAccepts;
            }
            if (this.isConnect(ops)) {
                --this.outstandingConnects;
                ++this.erroredConnects;
            }
            if (this.isRead(ops)) {
                --this.outstandingReads;
                ++this.erroredReads;
            }
            if (this.isWrite(ops)) {
                --this.outstandingWrites;
                ++this.erroredWrites;
                return;
            }
        }

        public void countCanceledOperation(int ops) {
            --this.outstandingOperations;
            ++this.canceledOperations;
            if (this.isAccept(ops)) {
                --this.outstandingAccepts;
                ++this.canceledAccepts;
            }
            if (this.isConnect(ops)) {
                --this.outstandingConnects;
                ++this.canceledConnects;
            }
            if (this.isRead(ops)) {
                --this.outstandingReads;
                ++this.canceledReads;
            }
            if (this.isWrite(ops)) {
                --this.outstandingWrites;
                ++this.canceledWrites;
                return;
            }
        }

        private boolean isAccept(int ops) {
            return (ops & 0x10) != 0;
        }

        private boolean isConnect(int ops) {
            return (ops & 8) != 0;
        }

        private boolean isRead(int ops) {
            return (ops & 1) != 0;
        }

        private boolean isWrite(int ops) {
            return (ops & 4) != 0;
        }

        @Override
        public int operationsOutstandingCount() {
            return this.outstandingOperations;
        }

        @Override
        public long totalOperationsSubmittedCount() {
            return this.submittedOperations;
        }

        @Override
        public long totalOperationsSucceededCount() {
            return this.succeededOperations;
        }

        @Override
        public long totalOperationsErroredCount() {
            return this.erroredOperations;
        }

        @Override
        public long totalOperationsCanceledCount() {
            return this.canceledOperations;
        }

        @Override
        public int acceptOperationsOutstandingCount() {
            return this.outstandingAccepts;
        }

        @Override
        public long totalAcceptOperationsSubmittedCount() {
            return this.submittedAccepts;
        }

        @Override
        public long totalAcceptOperationsSucceededCount() {
            return this.succeededAccepts;
        }

        @Override
        public long totalAcceptOperationsErroredCount() {
            return this.erroredAccepts;
        }

        @Override
        public long totalAcceptOperationsCanceledCount() {
            return this.canceledAccepts;
        }

        @Override
        public int connectOperationsOutstandingCount() {
            return this.outstandingConnects;
        }

        @Override
        public long totalConnectOperationsSubmittedCount() {
            return this.submittedConnects;
        }

        @Override
        public long totalConnectOperationsSucceededCount() {
            return this.succeededConnects;
        }

        @Override
        public long totalConnectOperationsErroredCount() {
            return this.erroredConnects;
        }

        @Override
        public long totalConnectOperationsCanceledCount() {
            return this.canceledConnects;
        }

        @Override
        public int readOperationsOutstandingCount() {
            return this.outstandingReads;
        }

        @Override
        public long totalReadOperationsSubmittedCount() {
            return this.submittedReads;
        }

        @Override
        public long totalReadOperationsSucceededCount() {
            return this.succeededReads;
        }

        @Override
        public long totalReadOperationsErroredCount() {
            return this.erroredReads;
        }

        @Override
        public long totalReadOperationsCanceledCount() {
            return this.canceledReads;
        }

        @Override
        public int writeOperationsOutstandingCount() {
            return this.outstandingWrites;
        }

        @Override
        public long totalWriteOperationsSubmittedCount() {
            return this.submittedWrites;
        }

        @Override
        public long totalWriteOperationsSucceededCount() {
            return this.succeededWrites;
        }

        @Override
        public long totalWriteOperationsErroredCount() {
            return this.erroredWrites;
        }

        @Override
        public long totalWriteOperationsCanceledCount() {
            return this.canceledWrites;
        }

        public String toString() {
            return "Selector";
        }

        public final /* synthetic */ SelectorSystem cats$effect$unsafe$SelectorSystem$Poller$$$outer() {
            return this.$outer;
        }
    }

    public final class SelectorImpl
    implements Selector {
        private final PollingContext<Poller> ctx;
        private final SelectorProvider provider;
        private final /* synthetic */ SelectorSystem $outer;

        public SelectorImpl(SelectorSystem $outer, PollingContext<Poller> ctx, SelectorProvider provider) {
            this.ctx = ctx;
            this.provider = provider;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public SelectorProvider provider() {
            return this.provider;
        }

        @Override
        public IO<Object> select(SelectableChannel ch, int ops) {
            return IO$.MODULE$.async((Function1 & Serializable)selectCb -> IO$.MODULE$.async_((JProcedure1 & Serializable)cb -> this.ctx.accessPoller((Function1<Poller, BoxedUnit>)(JProcedure1 & Serializable)poller -> {
                try {
                    Callbacks.Node node;
                    AbstractSelector selector = poller.selector();
                    SelectionKey key = ch.keyFor(selector);
                    poller.countSubmittedOperation(ops);
                    if (key == null) {
                        Callbacks cbs = new Callbacks();
                        ch.register(selector, ops, cbs);
                        node = cbs.append(ops, (Function1<Either<Throwable, Object>, BoxedUnit>)selectCb);
                    } else {
                        key.interestOps(key.interestOps() | ops);
                        Callbacks cbs = (Callbacks)key.attachment();
                        node = cbs.append(ops, (Function1<Either<Throwable, Object>, BoxedUnit>)selectCb);
                    }
                    Callbacks.Node node2 = node;
                    IO cancel = IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.$anonfun$1((Poller)poller, ops, node2);
                        return BoxedUnit.UNIT;
                    });
                    cb.apply((Object)package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply(cancel)));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (UnsafeNonFatal.apply(ex)) {
                        poller.countErroredOperation(ops);
                        cb.apply((Object)package$.MODULE$.Left().apply((Object)ex));
                    }
                    throw throwable;
                }
            })));
        }

        public final /* synthetic */ SelectorSystem cats$effect$unsafe$SelectorSystem$SelectorImpl$$$outer() {
            return this.$outer;
        }

        private final void $anonfun$1(Poller poller$1, int ops$4, Callbacks.Node node$1) {
            if (this.ctx.ownPoller(poller$1)) {
                poller$1.countCanceledOperation(ops$4);
                node$1.remove();
                return;
            }
            node$1.clear();
        }
    }
}

