/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.StripedHashtable$;
import cats.effect.unsafe.ThreadSafeHashtable$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;

public final class ThreadSafeHashtable<A> {
    private final int initialCapacity;
    private Object[] hashtable;
    private int size;
    private int mask;
    private int capacity;
    private final int log2NumTables;
    private final Object Tombstone;

    public ThreadSafeHashtable(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.hashtable = new Object[initialCapacity];
        this.size = 0;
        this.mask = initialCapacity - 1;
        this.capacity = initialCapacity;
        this.log2NumTables = StripedHashtable$.MODULE$.log2NumTables();
        this.Tombstone = ThreadSafeHashtable$.MODULE$.Tombstone();
    }

    public void put(A a, int hash2) {
        ThreadSafeHashtable threadSafeHashtable = this;
        synchronized (threadSafeHashtable) {
            int sz = this.size;
            int cap = this.capacity;
            if (sz << 1 >= cap) {
                int newCap = cap << 1;
                int newMask = newCap - 1;
                Object[] newHashtable = new Object[newCap];
                Object[] table = this.hashtable;
                for (int i = 0; i < cap; ++i) {
                    Object cur = table[i];
                    if (cur == null || cur == this.Tombstone) continue;
                    this.insert(newHashtable, newMask, cur, System.identityHashCode(cur) >> this.log2NumTables);
                }
                this.hashtable = newHashtable;
                this.mask = newMask;
                this.capacity = newCap;
            }
            this.insert(this.hashtable, this.mask, a, hash2);
            this.size = sz + 1;
        }
    }

    private void insert(Object[] table, int mask, Object a, int hash2) {
        int idx = hash2 & mask;
        for (int remaining = mask; remaining >= 0; --remaining) {
            Object cur = table[idx];
            if (cur == null || cur == this.Tombstone) {
                table[idx] = a;
                return;
            }
            idx = idx + 1 & mask;
        }
    }

    public void remove(A a, int hash2) {
        block10: {
            ThreadSafeHashtable threadSafeHashtable = this;
            synchronized (threadSafeHashtable) {
                block9: {
                    int init;
                    int msk = this.mask;
                    int idx = init = hash2 & msk;
                    Object[] table = this.hashtable;
                    for (int remaining = msk; remaining >= 0; --remaining) {
                        Object cur = table[idx];
                        if (a == cur) {
                            table[idx] = this.Tombstone;
                            --this.size;
                            int sz = this.size;
                            int cap = this.capacity;
                            if (cap > this.initialCapacity && sz << 2 < cap) {
                                int newCap = cap >>> 1;
                                int newMask = newCap - 1;
                                Object[] newHashtable = new Object[newCap];
                                Object[] table2 = this.hashtable;
                                for (int i = 0; i < cap; ++i) {
                                    Object cur2 = table2[i];
                                    if (cur2 == null || cur2 == this.Tombstone) continue;
                                    this.insert(newHashtable, newMask, cur2, System.identityHashCode(cur2) >> this.log2NumTables);
                                }
                                this.hashtable = newHashtable;
                                this.mask = newMask;
                                this.capacity = newCap;
                            }
                        } else if (cur != null) {
                            idx = idx + 1 & msk;
                            continue;
                        }
                        break block9;
                    }
                    break block10;
                }
                return;
            }
        }
    }

    public Object[] unsafeHashtable() {
        return this.hashtable;
    }

    public boolean isEmpty() {
        Object object;
        return this.size == 0 && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.refArrayOps(this.hashtable), (Function1 & Serializable)cb -> cb == null || cb == this.Tombstone);
    }

    public int unsafeCapacity() {
        return this.capacity;
    }

    public int unsafeInitialCapacity() {
        return this.initialCapacity;
    }
}

