/*
 * Decompiled with CFR 0.152.
 */
package cats.parse;

import cats.parse.Caret;
import cats.parse.Caret$;
import cats.parse.LocationMap$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public class LocationMap {
    private final String input;
    private final String[] lines;
    private final boolean endsWithNewLine;
    private final int[] firstPos;

    public static LocationMap apply(String string) {
        return LocationMap$.MODULE$.apply(string);
    }

    public LocationMap(String input) {
        this.input = input;
        this.lines = input.split("\n", -1);
        this.endsWithNewLine = input.length() > 0 && StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(input)) == '\n';
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.lines());
        Iterator it = ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)_$1 -> _$1.length());
        Iterator<Tuple2<Object, Object>> it2 = new Iterator<Tuple2<Object, Object>>(it){
            private final Iterator it$1;
            {
                this.it$1 = it$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }

            public boolean hasNext() {
                return this.it$1.hasNext();
            }

            public Tuple2 next() {
                boolean hn = this.hasNext();
                int i = BoxesRunTime.unboxToInt((Object)this.it$1.next());
                return new Tuple2.mcIZ.sp(i, hn);
            }
        };
        Object object2 = Predef$.MODULE$.intArrayOps((int[])it2.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n = tuple2._1$mcI$sp();
                boolean bl = tuple2._2$mcZ$sp();
                int i = n;
                if (bl) {
                    return i + 1;
                }
                int i2 = n;
                if (!bl) {
                    return i2;
                }
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        this.firstPos = (int[])ArrayOps$.MODULE$.scanLeft$extension(object2, (Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(_$2, _$3) -> _$2 + _$3, ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    public String input() {
        return this.input;
    }

    public String[] lines() {
        return this.lines;
    }

    public int lineCount() {
        return this.lines().length;
    }

    public boolean isValidOffset(int offset) {
        return 0 <= offset && offset <= this.input().length();
    }

    public Option<Tuple2<Object, Object>> toLineCol(int offset) {
        if (this.isValidOffset(offset)) {
            Caret caret = this.toCaretUnsafeImpl(offset);
            if (caret == null) {
                throw new MatchError((Object)caret);
            }
            Caret caret2 = Caret$.MODULE$.unapply(caret);
            int n = caret2._1();
            int n2 = caret2._2();
            int n3 = caret2._3();
            int line = n;
            int col = n2;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(line, col);
            int line2 = sp2._1$mcI$sp();
            int col2 = sp2._2$mcI$sp();
            return Some$.MODULE$.apply((Object)new Tuple2.mcII.sp(line2, col2));
        }
        return None$.MODULE$;
    }

    private Caret toCaretUnsafeImpl(int offset) {
        if (offset == this.input().length()) {
            if (offset == 0) {
                return Caret$.MODULE$.Start();
            }
            Caret caret = this.toCaretUnsafeImpl(offset - 1);
            if (caret == null) {
                throw new MatchError((Object)caret);
            }
            Caret caret2 = Caret$.MODULE$.unapply(caret);
            int n = caret2._1();
            int n2 = caret2._2();
            int n3 = caret2._3();
            int line = n;
            int col = n2;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(line, col);
            int line2 = sp2._1$mcI$sp();
            int col2 = sp2._2$mcI$sp();
            if (this.endsWithNewLine) {
                return Caret$.MODULE$.apply(line2 + 1, 0, offset);
            }
            return Caret$.MODULE$.apply(line2, col2 + 1, offset);
        }
        int idx = Arrays.binarySearch(this.firstPos, offset);
        if (idx < 0) {
            int line = ~(idx + 1);
            int lineStart = this.firstPos[line];
            int col = offset - lineStart;
            return Caret$.MODULE$.apply(line, col, offset);
        }
        return Caret$.MODULE$.apply(idx, 0, offset);
    }

    public Caret toCaretUnsafe(int offset) {
        if (this.isValidOffset(offset)) {
            return this.toCaretUnsafeImpl(offset);
        }
        throw new IllegalArgumentException(new StringBuilder(18).append("offset = ").append(offset).append(" exceeds ").append(this.input().length()).toString());
    }

    public Option<Caret> toCaret(int offset) {
        if (this.isValidOffset(offset)) {
            return Some$.MODULE$.apply((Object)this.toCaretUnsafeImpl(offset));
        }
        return None$.MODULE$;
    }

    public Option<String> getLine(int i) {
        if (i >= 0 && i < this.lines().length) {
            return Some$.MODULE$.apply((Object)this.lines()[i]);
        }
        return None$.MODULE$;
    }

    public Option<Object> toOffset(int line, int col) {
        if (line < 0 || line > this.lines().length) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(this.firstPos[line] + col)));
    }
}

