/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncResponseTransformer;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public class ByteArraySplittingTransformer<ResponseT>
implements SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> {
    private static final Logger log = Logger.loggerFor(ByteArraySplittingTransformer.class);
    private final AsyncResponseTransformer<ResponseT, ResponseBytes<ResponseT>> upstreamResponseTransformer;
    private final CompletableFuture<ResponseBytes<ResponseT>> resultFuture;
    private Subscriber<? super AsyncResponseTransformer<ResponseT, ResponseT>> downstreamSubscriber;
    private final AtomicInteger nextPartNumber = new AtomicInteger(1);
    private final AtomicReference<ResponseT> responseT = new AtomicReference();
    private final SimplePublisher<ByteBuffer> publisherToUpstream = new SimplePublisher();
    private final AtomicLong outstandingDemand = new AtomicLong(0L);
    private final AtomicBoolean emitting = new AtomicBoolean(false);
    private final Object lock = new Object();
    private boolean onStreamCalled;
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final Map<Integer, ByteBuffer> buffers;

    public ByteArraySplittingTransformer(AsyncResponseTransformer<ResponseT, ResponseBytes<ResponseT>> upstreamResponseTransformer, CompletableFuture<ResponseBytes<ResponseT>> resultFuture) {
        this.upstreamResponseTransformer = upstreamResponseTransformer;
        this.resultFuture = resultFuture;
        this.buffers = new ConcurrentHashMap<Integer, ByteBuffer>();
    }

    @Override
    public void subscribe(Subscriber<? super AsyncResponseTransformer<ResponseT, ResponseT>> subscriber) {
        this.downstreamSubscriber = subscriber;
        subscriber.onSubscribe(new DownstreamSubscription());
    }

    private void emit() {
        do {
            if (!this.emitting.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.doEmit()) {
                    return;
                }
            }
            finally {
                this.emitting.compareAndSet(true, false);
            }
        } while (this.outstandingDemand.get() > 0L);
    }

    private boolean doEmit() {
        long demand = this.outstandingDemand.get();
        while (demand > 0L) {
            if (this.isCancelled.get()) {
                return true;
            }
            demand = this.outstandingDemand.decrementAndGet();
            this.downstreamSubscriber.onNext(new IndividualTransformer(this.nextPartNumber.getAndIncrement()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscriptionCancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstreamSubscriber == null) {
                log.trace(() -> "downstreamSubscriber already null, skipping downstreamSubscriber.onComplete()");
                return;
            }
            if (!this.onStreamCalled) {
                this.downstreamSubscriber = null;
                return;
            }
            if (this.resultFuture.isDone()) {
                return;
            }
            try {
                CompletableFuture<ResponseBytes<ResponseT>> upstreamPrepareFuture = this.upstreamResponseTransformer.prepare();
                CompletableFutureUtils.forwardResultTo(upstreamPrepareFuture, this.resultFuture);
                this.upstreamResponseTransformer.onResponse(this.responseT.get());
                int totalPartCount = this.nextPartNumber.get() - 1;
                if (this.buffers.size() != totalPartCount) {
                    this.resultFuture.completeExceptionally(SdkClientException.create(String.format("Number of parts in buffer [%d] does not match total part count [%d], some parts did not complete successfully.", this.buffers.size(), totalPartCount)));
                    return;
                }
                for (int i = 1; i <= totalPartCount; ++i) {
                    this.publisherToUpstream.send(this.buffers.get(i)).exceptionally(ex -> {
                        this.resultFuture.completeExceptionally(SdkClientException.create("unexpected error occurred", ex));
                        return null;
                    });
                }
                this.publisherToUpstream.complete().exceptionally(ex -> {
                    this.resultFuture.completeExceptionally(SdkClientException.create("unexpected error occurred", ex));
                    return null;
                });
                this.upstreamResponseTransformer.onStream(SdkPublisher.adapt(this.publisherToUpstream));
            }
            catch (Throwable throwable) {
                this.resultFuture.completeExceptionally(SdkClientException.create("unexpected error occurred", throwable));
            }
        }
    }

    private final class IndividualTransformer
    implements AsyncResponseTransformer<ResponseT, ResponseT> {
        private final int partNumber;
        private final ByteArrayAsyncResponseTransformer<ResponseT> delegate = new ByteArrayAsyncResponseTransformer();

        private IndividualTransformer(int partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public CompletableFuture<ResponseT> prepare() {
            CompletableFuture prepare = this.delegate.prepare();
            return prepare.thenApply(responseBytes -> {
                ByteArraySplittingTransformer.this.buffers.put(this.partNumber, responseBytes.asByteBuffer());
                return responseBytes.response();
            });
        }

        @Override
        public void onResponse(ResponseT response) {
            ByteArraySplittingTransformer.this.responseT.compareAndSet(null, response);
            this.delegate.onResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            this.delegate.onStream(publisher);
            Object object = ByteArraySplittingTransformer.this.lock;
            synchronized (object) {
                if (!ByteArraySplittingTransformer.this.onStreamCalled) {
                    ByteArraySplittingTransformer.this.onStreamCalled = true;
                }
            }
        }

        @Override
        public void exceptionOccurred(Throwable error) {
            this.delegate.exceptionOccurred(error);
        }
    }

    private final class DownstreamSubscription
    implements Subscription {
        private DownstreamSubscription() {
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                ByteArraySplittingTransformer.this.downstreamSubscriber.onError(new IllegalArgumentException("Amount requested must be positive"));
                return;
            }
            long newDemand = ByteArraySplittingTransformer.this.outstandingDemand.updateAndGet(current -> {
                if (Long.MAX_VALUE - current < n) {
                    return Long.MAX_VALUE;
                }
                return current + n;
            });
            log.trace(() -> String.format("new outstanding demand: %s", newDemand));
            ByteArraySplittingTransformer.this.emit();
        }

        @Override
        public void cancel() {
            log.trace(() -> String.format("received cancel signal. Current cancel state is 'isCancelled=%s'", ByteArraySplittingTransformer.this.isCancelled.get()));
            if (ByteArraySplittingTransformer.this.isCancelled.compareAndSet(false, true)) {
                ByteArraySplittingTransformer.this.handleSubscriptionCancel();
            }
        }
    }
}

