/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.internal.useragent.SdkUserAgentBuilder;
import software.amazon.awssdk.core.internal.useragent.UserAgentConstant;
import software.amazon.awssdk.core.internal.useragent.UserAgentLangValues;
import software.amazon.awssdk.core.util.SystemUserAgent;
import software.amazon.awssdk.utils.JavaSystemSetting;
import software.amazon.awssdk.utils.SystemSetting;

@ThreadSafe
@SdkProtectedApi
public final class DefaultSystemUserAgent
implements SystemUserAgent {
    private static volatile DefaultSystemUserAgent instance;
    private final String sdkVersion;
    private final String osMetadata = UserAgentConstant.uaPair(this.systemSetting(JavaSystemSetting.OS_NAME), this.systemSetting(JavaSystemSetting.OS_VERSION));
    private final String langMetadata = UserAgentConstant.uaPair("java", this.systemSetting(JavaSystemSetting.JAVA_VERSION));
    private final String envMetadata = this.systemSetting(SdkSystemSetting.AWS_EXECUTION_ENV);
    private final String vmMetadata = UserAgentConstant.uaPair(this.systemSetting(JavaSystemSetting.JAVA_VM_NAME), this.systemSetting(JavaSystemSetting.JAVA_VM_VERSION));
    private final String vendorMetadata = UserAgentConstant.uaPair("vendor", this.systemSetting(JavaSystemSetting.JAVA_VENDOR));
    private final Optional<String> languageTagMetadata = this.getLanguageTagMetadata();
    private final List<String> additionalJvmLanguages = UserAgentLangValues.getAdditionalJvmLanguages();
    private final String systemUserAgent = this.getUserAgent();

    private DefaultSystemUserAgent() {
        this.sdkVersion = "2.37.5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultSystemUserAgent getOrCreate() {
        if (instance != null) return instance;
        Class<DefaultSystemUserAgent> clazz = DefaultSystemUserAgent.class;
        synchronized (DefaultSystemUserAgent.class) {
            if (instance != null) return instance;
            instance = new DefaultSystemUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String userAgentString() {
        return this.systemUserAgent;
    }

    @Override
    public String sdkVersion() {
        return this.sdkVersion;
    }

    @Override
    public String osMetadata() {
        return this.osMetadata;
    }

    @Override
    public String langMetadata() {
        return this.langMetadata;
    }

    @Override
    public String envMetadata() {
        return this.envMetadata;
    }

    @Override
    public String vmMetadata() {
        return this.vmMetadata;
    }

    @Override
    public String vendorMetadata() {
        return this.vendorMetadata;
    }

    @Override
    public Optional<String> languageTagMetadata() {
        return this.languageTagMetadata;
    }

    @Override
    public List<String> additionalJvmLanguages() {
        return Collections.unmodifiableList(this.additionalJvmLanguages);
    }

    private String getUserAgent() {
        return SdkUserAgentBuilder.buildSystemUserAgentString(this);
    }

    private String systemSetting(SystemSetting systemSetting) {
        return UserAgentConstant.sanitizeInput(systemSetting.getStringValue().orElse(null));
    }

    private Optional<String> getLanguageTagMetadata() {
        Optional<String> language = JavaSystemSetting.USER_LANGUAGE.getStringValue();
        Optional<String> country = JavaSystemSetting.USER_COUNTRY.getStringValue();
        String value = null;
        if (language.isPresent() && country.isPresent()) {
            value = UserAgentConstant.sanitizeInput(language.get()) + "_" + UserAgentConstant.sanitizeInput(country.get());
        }
        return Optional.ofNullable(value);
    }
}

