/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.TrailerProvider;
import software.amazon.awssdk.http.auth.spi.signer.PayloadChecksumStore;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class ChecksumTrailerProvider
implements TrailerProvider {
    private final SdkChecksum checksum;
    private final String checksumName;
    private final ChecksumAlgorithm checksumAlgorithm;
    private final PayloadChecksumStore checksumStore;

    public ChecksumTrailerProvider(SdkChecksum checksum, String checksumName, ChecksumAlgorithm checksumAlgorithm, PayloadChecksumStore checksumStore) {
        this.checksum = checksum;
        this.checksumName = checksumName;
        this.checksumAlgorithm = checksumAlgorithm;
        this.checksumStore = checksumStore;
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }

    @Override
    public Pair<String, List<String>> get() {
        byte[] checksumBytes = this.checksumStore.getChecksumValue(this.checksumAlgorithm);
        if (checksumBytes == null) {
            checksumBytes = this.checksum.getChecksumBytes();
            this.checksumStore.putChecksumValue(this.checksumAlgorithm, checksumBytes);
        }
        return Pair.of(this.checksumName, Collections.singletonList(BinaryUtils.toBase64(checksumBytes)));
    }
}

