/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBucketsRequest
extends S3Request
implements ToCopyableBuilder<Builder, ListBucketsRequest> {
    private static final SdkField<Integer> MAX_BUCKETS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("MaxBuckets").getter(ListBucketsRequest.getter(ListBucketsRequest::maxBuckets)).setter(ListBucketsRequest.setter(Builder::maxBuckets)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-buckets").unmarshallLocationName("max-buckets").build()).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ContinuationToken").getter(ListBucketsRequest.getter(ListBucketsRequest::continuationToken)).setter(ListBucketsRequest.setter(Builder::continuationToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuation-token").unmarshallLocationName("continuation-token").build()).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Prefix").getter(ListBucketsRequest.getter(ListBucketsRequest::prefix)).setter(ListBucketsRequest.setter(Builder::prefix)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").unmarshallLocationName("prefix").build()).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("BucketRegion").getter(ListBucketsRequest.getter(ListBucketsRequest::bucketRegion)).setter(ListBucketsRequest.setter(Builder::bucketRegion)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bucket-region").unmarshallLocationName("bucket-region").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BUCKETS_FIELD, CONTINUATION_TOKEN_FIELD, PREFIX_FIELD, BUCKET_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBucketsRequest.memberNameToFieldInitializer();
    private final Integer maxBuckets;
    private final String continuationToken;
    private final String prefix;
    private final String bucketRegion;

    private ListBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.maxBuckets = builder.maxBuckets;
        this.continuationToken = builder.continuationToken;
        this.prefix = builder.prefix;
        this.bucketRegion = builder.bucketRegion;
    }

    public final Integer maxBuckets() {
        return this.maxBuckets;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsRequest)) {
            return false;
        }
        ListBucketsRequest other = (ListBucketsRequest)obj;
        return Objects.equals(this.maxBuckets(), other.maxBuckets()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.bucketRegion(), other.bucketRegion());
    }

    public final String toString() {
        return ToString.builder("ListBucketsRequest").add("MaxBuckets", this.maxBuckets()).add("ContinuationToken", this.continuationToken()).add("Prefix", this.prefix()).add("BucketRegion", this.bucketRegion()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxBuckets": {
                return Optional.ofNullable(clazz.cast(this.maxBuckets()));
            }
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("max-buckets", MAX_BUCKETS_FIELD);
        map.put("continuation-token", CONTINUATION_TOKEN_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("bucket-region", BUCKET_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBucketsRequest, T> g) {
        return obj -> g.apply((ListBucketsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private Integer maxBuckets;
        private String continuationToken;
        private String prefix;
        private String bucketRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsRequest model) {
            super(model);
            this.maxBuckets(model.maxBuckets);
            this.continuationToken(model.continuationToken);
            this.prefix(model.prefix);
            this.bucketRegion(model.bucketRegion);
        }

        public final Integer getMaxBuckets() {
            return this.maxBuckets;
        }

        public final void setMaxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
        }

        @Override
        public final Builder maxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBucketsRequest build() {
            return new ListBucketsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBucketsRequest> {
        public Builder maxBuckets(Integer var1);

        public Builder continuationToken(String var1);

        public Builder prefix(String var1);

        public Builder bucketRegion(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

