/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.GitLocationResolverCarrier;
import org.apache.sshd.server.command.AbstractFileSystemCommand;

public abstract class AbstractGitCommand
extends AbstractFileSystemCommand
implements GitLocationResolverCarrier {
    public static final int CHAR = 1;
    public static final int DELIMITER = 2;
    public static final int STARTQUOTE = 4;
    public static final int ENDQUOTE = 8;
    protected final GitLocationResolver rootDirResolver;

    protected AbstractGitCommand(GitLocationResolver rootDirResolver, String command, CloseableExecutorService executorService) {
        super(command, executorService);
        this.rootDirResolver = Objects.requireNonNull(rootDirResolver, "No GIT root directory resolver provided");
    }

    @Override
    public GitLocationResolver getGitLocationResolver() {
        return this.rootDirResolver;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        super.setOutputStream(out);
        if (out instanceof ChannelOutputStream) {
            ((ChannelOutputStream)out).setNoDelay(true);
        }
    }

    @Override
    public void setErrorStream(OutputStream err) {
        super.setErrorStream(err);
        if (err instanceof ChannelOutputStream) {
            ((ChannelOutputStream)err).setNoDelay(true);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[session=" + this.getServerSession() + "]";
    }

    public static List<String> parseDelimitedString(String value, String delim, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int expecting = 7;
        boolean isEscaped = false;
        for (int i = 0; i < value.length(); ++i) {
            boolean isDelimiter;
            char c = value.charAt(i);
            boolean bl = isDelimiter = delim.indexOf(c) >= 0;
            if (!isEscaped && c == '\\') {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                sb.append(c);
            } else if (isDelimiter && (expecting & 2) != 0) {
                if (trim) {
                    String str = sb.toString();
                    list.add(str.trim());
                } else {
                    list.add(sb.toString());
                }
                sb.delete(0, sb.length());
                expecting = 7;
            } else if (c == '\"' && (expecting & 4) != 0) {
                sb.append(c);
                expecting = 9;
            } else if (c == '\"' && (expecting & 8) != 0) {
                sb.append(c);
                expecting = 7;
            } else if ((expecting & 1) != 0) {
                sb.append(c);
            } else {
                throw new IllegalArgumentException("Invalid delimited string: " + value);
            }
            isEscaped = false;
        }
        if (sb.length() > 0) {
            if (trim) {
                String str = sb.toString();
                list.add(str.trim());
            } else {
                list.add(sb.toString());
            }
        }
        return list;
    }
}

