/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CommandCatalog;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.pgm.opt.SubcommandHandler;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;

public class EmbeddedCommandRunner {
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    @Option(name="--show-stack-trace", usage="usage_displayThejavaStackTraceOnExceptions")
    private boolean showStackTrace;
    @Option(name="--git-dir", metaVar="metaVar_gitDir", usage="usage_setTheGitRepositoryToOperateOn")
    private String gitdir;
    @Argument(index=0, metaVar="metaVar_command", required=true, handler=SubcommandHandler.class)
    private TextBuiltin subcommand;
    @Argument(index=1, metaVar="metaVar_arg")
    private List<String> arguments = new ArrayList<String>();
    private Path rootDir;

    public EmbeddedCommandRunner(Path rootDir) {
        this.rootDir = Objects.requireNonNull(rootDir, "No root directory specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] argv, InputStream in, OutputStream out, OutputStream err) throws Exception {
        PrintWriter writer;
        CmdLineParser clp;
        block16: {
            clp = new CmdLineParser((Object)this);
            writer = new PrintWriter(err != null ? err : System.err);
            try {
                clp.parseArgument(argv);
            }
            catch (CmdLineException e) {
                if (argv.length <= 0 || this.help) break block16;
                writer.println(MessageFormat.format(CLIText.get().fatalError, e.getMessage()));
                writer.flush();
                throw new Die(true);
            }
        }
        if (argv.length == 0 || this.help) {
            String ex = clp.printExample(OptionHandlerFilter.ALL, CLIText.get().resourceBundle());
            writer.println("jgit" + ex + " command [ARG ...]");
            if (this.help) {
                writer.println();
                clp.printUsage((Writer)writer, CLIText.get().resourceBundle());
                writer.println();
            } else if (this.subcommand == null) {
                writer.println();
                writer.println(CLIText.get().mostCommonlyUsedCommandsAre);
                CommandRef[] common = CommandCatalog.common();
                int width = 0;
                for (CommandRef c : common) {
                    width = Math.max(width, c.getName().length());
                }
                width += 2;
                for (CommandRef c : common) {
                    writer.print(' ');
                    writer.print(c.getName());
                    for (int i = c.getName().length(); i < width; ++i) {
                        writer.print(' ');
                    }
                    writer.print(CLIText.get().resourceBundle().getString(c.getUsage()));
                    writer.println();
                }
                writer.println();
            }
            writer.flush();
            throw new Die(true);
        }
        this.gitdir = Objects.toString(this.rootDir.resolve(this.gitdir));
        TextBuiltin cmd = this.subcommand;
        this.set(cmd, "ins", in);
        this.set(cmd, "outs", out);
        this.set(cmd, "errs", err);
        Boolean success = (Boolean)this.call(cmd, "requiresRepository");
        if (success.booleanValue()) {
            this.call(cmd, "init", new Class[]{Repository.class, String.class}, new Object[]{this.openGitDir(this.gitdir), this.gitdir});
        } else {
            this.call(cmd, "init", new Class[]{Repository.class, String.class}, new Object[]{null, this.gitdir});
        }
        try {
            cmd.execute(this.arguments.toArray(new String[this.arguments.size()]));
        }
        finally {
            if (this.get(cmd, "outw") != null) {
                ((ThrowingPrintWriter)this.get(cmd, "outw")).flush();
            }
            if (this.get(cmd, "errw") != null) {
                ((ThrowingPrintWriter)this.get(cmd, "errw")).flush();
            }
        }
    }

    private Object get(Object obj, String name) throws IllegalAccessException, NoSuchFieldException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private void set(Object obj, String name, Object val) throws IllegalAccessException, NoSuchFieldException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                field.set(obj, val);
                return;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private Object call(Object obj, String name) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.call(obj, name, new Class[0], new Object[0]);
    }

    private Object call(Object obj, String name, Class<?>[] types, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(name, types);
                method.setAccessible(true);
                return method.invoke(obj, args);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(name);
    }

    protected Repository openGitDir(String gitdir) throws IOException {
        return Git.open(new File(gitdir)).getRepository();
    }
}

