/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.BlockType;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Emitter;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LineType;
import com.github.rjeschke.txtmark.LinkRef;
import com.github.rjeschke.txtmark.TableDef;
import com.github.rjeschke.txtmark.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class Processor {
    private final Reader reader;
    private final Emitter emitter;
    final Configuration config;
    private boolean useExtensions = false;

    private Processor(Reader reader, Configuration configuration) {
        this.reader = reader;
        this.config = configuration;
        this.useExtensions = configuration.forceExtendedProfile;
        this.emitter = new Emitter(this.config);
    }

    public static final String process(Reader reader, Configuration configuration) throws IOException {
        Processor processor = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, configuration);
        return processor.process();
    }

    public static final String process(String string, Configuration configuration) {
        try {
            return Processor.process((Reader)new StringReader(string), configuration);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final String process(File file, Configuration configuration) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = Processor.process((InputStream)fileInputStream, configuration);
        fileInputStream.close();
        return string;
    }

    public static final String process(InputStream inputStream, Configuration configuration) throws IOException {
        Processor processor = new Processor(new BufferedReader(new InputStreamReader(inputStream, configuration.encoding)), configuration);
        return processor.process();
    }

    public static final String process(String string) {
        return Processor.process(string, Configuration.DEFAULT);
    }

    public static final String process(String string, boolean bl) {
        return Processor.process(string, Configuration.builder().setSafeMode(bl).build());
    }

    public static final String process(String string, Decorator decorator) {
        return Processor.process(string, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(String string, Decorator decorator, boolean bl) {
        return Processor.process(string, Configuration.builder().setDecorator(decorator).setSafeMode(bl).build());
    }

    public static final String process(File file) throws IOException {
        return Processor.process(file, Configuration.DEFAULT);
    }

    public static final String process(File file, boolean bl) throws IOException {
        return Processor.process(file, Configuration.builder().setSafeMode(bl).build());
    }

    public static final String process(File file, Decorator decorator) throws IOException {
        return Processor.process(file, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(File file, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(file, Configuration.builder().setDecorator(decorator).setSafeMode(bl).build());
    }

    public static final String process(File file, String string) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(string).build());
    }

    public static final String process(File file, String string, boolean bl) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(string).setSafeMode(bl).build());
    }

    public static final String process(File file, String string, Decorator decorator) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(string).setDecorator(decorator).build());
    }

    public static final String process(File file, String string, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(file, Configuration.builder().setEncoding(string).setSafeMode(bl).setDecorator(decorator).build());
    }

    public static final String process(InputStream inputStream) throws IOException {
        return Processor.process(inputStream, Configuration.DEFAULT);
    }

    public static final String process(InputStream inputStream, boolean bl) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setSafeMode(bl).build());
    }

    public static final String process(InputStream inputStream, Decorator decorator) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(InputStream inputStream, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setDecorator(decorator).setSafeMode(bl).build());
    }

    public static final String process(InputStream inputStream, String string) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setEncoding(string).build());
    }

    public static final String process(InputStream inputStream, String string, boolean bl) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setEncoding(string).setSafeMode(bl).build());
    }

    public static final String process(InputStream inputStream, String string, Decorator decorator) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setEncoding(string).setDecorator(decorator).build());
    }

    public static final String process(InputStream inputStream, String string, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(inputStream, Configuration.builder().setEncoding(string).setDecorator(decorator).setSafeMode(bl).build());
    }

    public static final String process(Reader reader) throws IOException {
        return Processor.process(reader, Configuration.DEFAULT);
    }

    public static final String process(Reader reader, boolean bl) throws IOException {
        return Processor.process(reader, Configuration.builder().setSafeMode(bl).build());
    }

    public static final String process(Reader reader, Decorator decorator) throws IOException {
        return Processor.process(reader, Configuration.builder().setDecorator(decorator).build());
    }

    public static final String process(Reader reader, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(reader, Configuration.builder().setDecorator(decorator).setSafeMode(bl).build());
    }

    private Block readLines() throws IOException {
        Block block = new Block();
        StringBuilder stringBuilder = new StringBuilder(80);
        int n = this.reader.read();
        LinkRef linkRef = null;
        while (n != -1) {
            char c;
            stringBuilder.setLength(0);
            int n2 = 0;
            boolean bl = false;
            block7: while (!bl) {
                switch (n) {
                    case -1: {
                        bl = true;
                        continue block7;
                    }
                    case 10: {
                        n = this.reader.read();
                        if (n == 13) {
                            n = this.reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 13: {
                        n = this.reader.read();
                        if (n == 10) {
                            n = this.reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 9: {
                        int n3 = n2 + (4 - (n2 & 3));
                        while (n2 < n3) {
                            stringBuilder.append(' ');
                            ++n2;
                        }
                        n = this.reader.read();
                        continue block7;
                    }
                }
                if (n != 60 || !this.config.panicMode) {
                    ++n2;
                    stringBuilder.append((char)n);
                } else {
                    n2 += 4;
                    stringBuilder.append("&lt;");
                }
                n = this.reader.read();
            }
            Line line = new Line();
            line.value = stringBuilder.toString();
            line.init();
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (!line.isEmpty && line.leading < 4 && line.value.charAt(line.leading) == '[') {
                line.pos = line.leading + 1;
                string = line.readUntil(']');
                if (string != null && line.pos + 2 < line.value.length() && line.value.charAt(line.pos + 1) == ':') {
                    line.pos += 2;
                    if (!line.skipSpaces()) {
                        bl2 = false;
                    } else if (line.value.charAt(line.pos) == '<') {
                        ++line.pos;
                        string2 = line.readUntil('>');
                        ++line.pos;
                    } else {
                        string2 = line.readUntil(' ', '\n');
                    }
                    if (string2 != null) {
                        if (line.skipSpaces()) {
                            c = line.value.charAt(line.pos);
                            if (c == '\"' || c == '\'' || c == '(') {
                                ++line.pos;
                                string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                                if (string3 != null) {
                                    bl2 = true;
                                }
                            }
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2 && string != null && string2 != null) {
                if (string.toLowerCase().equals("$profile$")) {
                    this.emitter.useExtensions = this.useExtensions = string2.toLowerCase().equals("extended");
                    linkRef = null;
                    continue;
                }
                LinkRef linkRef2 = new LinkRef(string2, string3, string3 != null && string2.length() == 1 && string2.charAt(0) == '*');
                this.emitter.addLinkRef(string, linkRef2);
                if (string3 != null) continue;
                linkRef = linkRef2;
                continue;
            }
            string3 = null;
            if (!line.isEmpty && linkRef != null) {
                line.pos = line.leading;
                c = line.value.charAt(line.pos);
                if (c == '\"' || c == '\'' || c == '(') {
                    ++line.pos;
                    string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                }
                if (string3 != null) {
                    linkRef.title = string3;
                }
                linkRef = null;
            }
            if (string3 != null) continue;
            line.pos = 0;
            block.appendLine(line);
        }
        return block;
    }

    private void initListBlock(Block block) {
        Line line = block.lines;
        line = line.next;
        while (line != null) {
            LineType lineType = line.getLineType(this.config);
            if (lineType == LineType.OLIST || lineType == LineType.ULIST || !line.isEmpty && line.prevEmpty && line.leading == 0 && lineType != LineType.OLIST && lineType != LineType.ULIST) {
                block.split((Line)line.previous).type = BlockType.LIST_ITEM;
            }
            line = line.next;
        }
        block.split((Line)block.lineTail).type = BlockType.LIST_ITEM;
    }

    private void recurse(Block block, boolean bl) {
        Line line = block.lines;
        if (bl) {
            block.removeListIndent(this.config);
            if (this.useExtensions && block.lines != null && block.lines.getLineType(this.config) != LineType.CODE) {
                block.id = block.lines.stripID();
            }
        }
        while (line != null && line.isEmpty) {
            line = line.next;
        }
        if (line == null) {
            return;
        }
        block12: while (line != null) {
            LineType lineType = line.getLineType(this.config);
            switch (lineType) {
                case OTHER: {
                    Enum enum_;
                    boolean bl2 = line.prevEmpty;
                    while (line != null && !line.isEmpty) {
                        enum_ = line.getLineType(this.config);
                        if ((bl || this.useExtensions) && (enum_ == LineType.OLIST || enum_ == LineType.ULIST) || this.useExtensions && (enum_ == LineType.CODE || enum_ == LineType.FENCED_CODE) || enum_ == LineType.HEADLINE || enum_ == LineType.HEADLINE1 || enum_ == LineType.HEADLINE2 || enum_ == LineType.HR || enum_ == LineType.BQUOTE || enum_ == LineType.XML) break;
                        line = line.next;
                    }
                    if (line != null && !line.isEmpty) {
                        block.split((Line)line.previous).type = enum_ = bl && !bl2 ? BlockType.NONE : BlockType.PARAGRAPH;
                        block.removeLeadingEmptyLines();
                    } else {
                        enum_ = bl && (line == null || !line.isEmpty) && !bl2 ? BlockType.NONE : BlockType.PARAGRAPH;
                        block.split((Line)(line == null ? block.lineTail : line)).type = enum_;
                        block.removeLeadingEmptyLines();
                    }
                    line = block.lines;
                    continue block12;
                }
                case CODE: {
                    while (line != null && (line.isEmpty || line.leading > 3)) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.CODE;
                    block2.removeSurroundingEmptyLines();
                    continue block12;
                }
                case XML: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    block.split((Line)line.xmlEndLine).type = BlockType.XML;
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block12;
                }
                case BQUOTE: {
                    while (line != null && (line.isEmpty || !line.prevEmpty || line.leading != 0 || line.getLineType(this.config) == LineType.BQUOTE)) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.BLOCKQUOTE;
                    block2.removeSurroundingEmptyLines();
                    block2.removeBlockQuotePrefix();
                    this.recurse(block2, false);
                    line = block.lines;
                    continue block12;
                }
                case HR: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    block.split((Line)line).type = BlockType.RULER;
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block12;
                }
                case FENCED_CODE: {
                    line = line.next;
                    while (line != null && line.getLineType(this.config) != LineType.FENCED_CODE) {
                        line = line.next;
                    }
                    if (line != null) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.FENCED_CODE;
                    block2.meta = Utils.getMetaFromFence(block2.lines.value);
                    block2.lines.setEmpty();
                    if (block2.lineTail.getLineType(this.config) == LineType.FENCED_CODE) {
                        block2.lineTail.setEmpty();
                    }
                    block2.removeSurroundingEmptyLines();
                    continue block12;
                }
                case HEADLINE: 
                case HEADLINE1: 
                case HEADLINE2: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    if (lineType != LineType.HEADLINE) {
                        line.next.setEmpty();
                    }
                    Block block2 = block.split(line);
                    block2.type = BlockType.HEADLINE;
                    if (lineType != LineType.HEADLINE) {
                        int n = block2.hlDepth = lineType == LineType.HEADLINE1 ? 1 : 2;
                    }
                    if (this.useExtensions) {
                        block2.id = block2.lines.stripID();
                    }
                    block2.transfromHeadline();
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block12;
                }
                case OLIST: 
                case ULIST: {
                    while (line != null) {
                        LineType lineType2 = line.getLineType(this.config);
                        if (!line.isEmpty && line.prevEmpty && line.leading == 0 && lineType2 != LineType.OLIST && lineType2 != LineType.ULIST) break;
                        line = line.next;
                    }
                    Block block3 = block.split(line != null ? line.previous : block.lineTail);
                    block3.type = lineType == LineType.OLIST ? BlockType.ORDERED_LIST : BlockType.UNORDERED_LIST;
                    block3.lines.prevEmpty = false;
                    block3.lineTail.nextEmpty = false;
                    block3.removeSurroundingEmptyLines();
                    block3.lineTail.nextEmpty = false;
                    block3.lines.prevEmpty = false;
                    this.initListBlock(block3);
                    Block block2 = block3.blocks;
                    while (block2 != null) {
                        this.recurse(block2, true);
                        block2 = block2.next;
                    }
                    block3.expandListParagraphs();
                    continue block12;
                }
                case TABLE: {
                    TableDef tableDef = (TableDef)line.data;
                    line = line.next.next;
                    while (line != null && !line.isEmpty && tableDef.addRow(line.value)) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.TABLE;
                    line = block.lines;
                    continue block12;
                }
            }
            line = line.next;
        }
    }

    private String process() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Block block = this.readLines();
        block.removeSurroundingEmptyLines();
        this.recurse(block, false);
        Block block2 = block.blocks;
        while (block2 != null) {
            this.emitter.emit(stringBuilder, block2);
            block2 = block2.next;
        }
        return stringBuilder.toString();
    }
}

