/*
 * Decompiled with CFR 0.152.
 */
package gridscale.cluster;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.BatchScheduler$BatchJob$;
import gridscale.cluster.HeadNode;
import gridscale.package;
import java.io.Serializable;
import java.util.UUID;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class BatchScheduler$
implements Serializable {
    public static final BatchScheduler$BatchJob$ BatchJob;
    public static final BatchScheduler$ MODULE$;

    private BatchScheduler$() {
    }

    static {
        MODULE$ = new BatchScheduler$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BatchScheduler$.class);
    }

    public String output(String uniqId) {
        return uniqId + ".out";
    }

    public String error(String uniqId) {
        return uniqId + ".err";
    }

    public String scriptName(String suffix, String uniqId) {
        return uniqId + suffix;
    }

    public String scriptPath(String workDirectory, String suffix, String uniqId) {
        return workDirectory + "/" + this.scriptName(suffix, uniqId);
    }

    public BatchScheduler.BatchJob submit(String workDirectory, Function1<String, String> buildScript, String scriptSuffix, Function2<String, String, String> submitCommand, Function1<String, String> retrieveJobID, HeadNode server, Function2<String, package.ExecutionResult, String> errorWrapper) {
        package.ExecutionResult cmdRet;
        server.execute("mkdir -p '" + workDirectory + "'");
        String uniqueId = "job-" + UUID.randomUUID().toString();
        String script = (String)buildScript.apply((Object)uniqueId);
        String sName = this.scriptName(scriptSuffix, uniqueId);
        String sPath = this.scriptPath(workDirectory, scriptSuffix, uniqueId);
        server.write(script.getBytes(), sPath);
        server.execute("chmod +x '" + sPath + "'");
        String command = "cd '" + workDirectory + "' && " + submitCommand.apply((Object)sName, (Object)uniqueId);
        package.ExecutionResult executionResult = cmdRet = server.execute(command);
        if (executionResult == null) {
            throw new MatchError((Object)executionResult);
        }
        package.ExecutionResult executionResult2 = package.ExecutionResult$.MODULE$.unapply(executionResult);
        int n = executionResult2._1();
        String string = executionResult2._2();
        String string2 = executionResult2._3();
        int ret = n;
        String out = string;
        String error = string2;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ret), (Object)out, (Object)error);
        int ret2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
        String out2 = (String)tuple3._2();
        String error2 = (String)tuple3._3();
        if (ret2 != 0) {
            throw new RuntimeException((String)errorWrapper.apply((Object)command, (Object)cmdRet));
        }
        if (out2 == null) {
            throw new RuntimeException(submitCommand + " did not return a JobID");
        }
        String jobId = (String)retrieveJobID.apply((Object)out2);
        return BatchScheduler$BatchJob$.MODULE$.apply(uniqueId, jobId, workDirectory);
    }

    public Function2<String, package.ExecutionResult, String> submit$default$7() {
        return (Function2 & Serializable)(command, executionResult) -> package.ExecutionResult$.MODULE$.error(command, executionResult);
    }

    public package.JobState state(String stateCommand, Function2<package.ExecutionResult, String, package.JobState> parseState, HeadNode server, BatchScheduler.BatchJob job) {
        package.ExecutionResult cmdRet = server.execute(stateCommand);
        return (package.JobState)parseState.apply((Object)cmdRet, (Object)stateCommand);
    }

    public void clean(String cancelCommand, String scriptSuffix, HeadNode server, BatchScheduler.BatchJob job) {
        server.execute(cancelCommand);
        server.execute(this.rmCommand$1(job, scriptSuffix));
    }

    public String stdOut(HeadNode server, BatchScheduler.BatchJob job) {
        return server.read(job.workDirectory() + "/" + this.output(job.uniqId()));
    }

    public String stdErr(HeadNode server, BatchScheduler.BatchJob job) {
        return server.read(job.workDirectory() + "/" + this.error(job.uniqId()));
    }

    private final Seq paths$1(BatchScheduler.BatchJob job$1, String scriptSuffix$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)this.scriptPath(job$1.workDirectory(), scriptSuffix$1, job$1.uniqId()), (List)new .colon.colon((Object)(job$1.workDirectory() + "/" + this.output(job$1.uniqId())), (List)new .colon.colon((Object)(job$1.workDirectory() + "/" + this.error(job$1.uniqId())), (List)Nil$.MODULE$))));
    }

    private final String rmCommand$1(BatchScheduler.BatchJob job$2, String scriptSuffix$2) {
        return "rm -f " + ((IterableOnceOps)this.paths$1(job$2, scriptSuffix$2).map((Function1 & Serializable)p -> "'" + p + "'")).mkString(" ");
    }
}

