/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jsat.RowMajorStore;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;
import jsat.utils.ListUtils;

public interface DataStore {
    public static final DataStore DEFAULT_STORE = new RowMajorStore();

    public void setCategoricalDataInfo(CategoricalData[] var1);

    public CategoricalData[] getCategoricalDataInfo();

    public void addDataPoint(DataPoint var1);

    default public void addDataPointCheck(DataPoint dp) {
        if (dp.getNumericalValues().length() != this.numNumeric()) {
            throw new IllegalArgumentException("Input has incorrect number of numeric features");
        }
        int[] cat_vals = dp.getCategoricalValues();
        if (cat_vals.length != this.numCategorical()) {
            throw new IllegalArgumentException("Input has the incorrect number of categorical features");
        }
        for (int i = 0; i < cat_vals.length; ++i) {
            if (this.getCategoricalDataInfo()[i].getNumOfCategories() > cat_vals[i]) continue;
            throw new IllegalArgumentException("Input has an invalid value for categorical feature");
        }
        this.addDataPoint(dp);
    }

    public DataPoint getDataPoint(int var1);

    public void finishAdding();

    public int numNumeric();

    public void setNumNumeric(int var1);

    public int numCategorical();

    public void setDataPoint(int var1, DataPoint var2);

    default public Vec getNumericColumn(int i) {
        if (i < 0 || i >= this.numNumeric()) {
            throw new IndexOutOfBoundsException("There is no index for column " + i);
        }
        HashSet<Integer> toSkip = new HashSet<Integer>(ListUtils.range(0, this.numNumeric()));
        toSkip.remove(i);
        return this.getNumericColumns(toSkip)[i];
    }

    public int[] getCatColumn(int var1);

    public Vec[] getNumericColumns(Set<Integer> var1);

    default public List<DataPoint> toList() {
        ArrayList<DataPoint> list = new ArrayList<DataPoint>();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.getDataPoint(i));
        }
        return list;
    }

    default public boolean rowMajor() {
        return true;
    }

    public int size();

    public OnLineStatistics getSparsityStats();

    public DataStore clone();

    public DataStore emptyClone();

    default public Iterator<DataPoint> getRowIter() {
        final int total = this.size();
        final DataStore self = this;
        if (this.rowMajor()) {
            final AtomicInteger pos = new AtomicInteger(0);
            return new Iterator<DataPoint>(){

                @Override
                public boolean hasNext() {
                    return pos.get() < total;
                }

                @Override
                public DataPoint next() {
                    return self.getDataPoint(pos.getAndIncrement());
                }
            };
        }
        final HashMap nonZeroTable = new HashMap(this.numNumeric() + 1);
        Vec[] all_cols = this.getNumericColumns(Collections.EMPTY_SET);
        final ArrayList<Iterator<IndexValue>> col_iters = new ArrayList<Iterator<IndexValue>>();
        for (Vec v : all_cols) {
            col_iters.add(v.getNonZeroIterator());
        }
        final IndexValue[] cur_col_vals = new IndexValue[this.numNumeric()];
        AtomicInteger non_null = new AtomicInteger(cur_col_vals.length);
        for (int j = 0; j < cur_col_vals.length; ++j) {
            if (((Iterator)col_iters.get(j)).hasNext()) {
                cur_col_vals[j] = (IndexValue)((Iterator)col_iters.get(j)).next();
                int i = cur_col_vals[j].getIndex();
                Set row_i = (Set)nonZeroTable.get(i);
                if (row_i == null) {
                    row_i = Collections.newSetFromMap(new LinkedHashMap());
                    nonZeroTable.put(i, row_i);
                }
                row_i.add(j);
                continue;
            }
            cur_col_vals[j] = null;
            non_null.decrementAndGet();
        }
        final Vec scratch = all_cols.length > 0 ? all_cols[0].clone() : new DenseVector(0);
        scratch.zeroOut();
        scratch.setLength(this.numNumeric());
        final int[] scratch_cat = new int[this.numCategorical()];
        final AtomicInteger pos = new AtomicInteger(0);
        final CategoricalData[] categoricalData = this.getCategoricalDataInfo();
        return new Iterator<DataPoint>(){
            final Set<Integer> empty_set = Collections.EMPTY_SET;

            @Override
            public boolean hasNext() {
                return pos.get() < total;
            }

            @Override
            public DataPoint next() {
                scratch.zeroOut();
                int i = pos.getAndIncrement();
                for (int j : nonZeroTable.getOrDefault(i, this.empty_set)) {
                    if (cur_col_vals[j] == null || cur_col_vals[j].getIndex() > i) continue;
                    if (cur_col_vals[j].getIndex() == i) {
                        scratch.set(j, cur_col_vals[j].getValue());
                    }
                    if (((Iterator)col_iters.get(j)).hasNext()) {
                        cur_col_vals[j] = (IndexValue)((Iterator)col_iters.get(j)).next();
                        int i_future = cur_col_vals[j].getIndex();
                        Set row_i_future = (Set)nonZeroTable.get(i_future);
                        if (row_i_future == null) {
                            row_i_future = Collections.newSetFromMap(new LinkedHashMap());
                            nonZeroTable.put(i_future, row_i_future);
                        }
                        row_i_future.add(j);
                        continue;
                    }
                    cur_col_vals[j] = null;
                }
                nonZeroTable.remove(i);
                for (int j = 0; j < self.numCategorical(); ++j) {
                    scratch_cat[j] = self.getCatColumn(j)[i];
                }
                return new DataPoint(scratch, scratch_cat, categoricalData);
            }
        };
    }
}

