/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.Collections;
import java.util.Iterator;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.UpdateableClassifier;
import jsat.utils.IntList;
import jsat.utils.ListUtils;

public abstract class BaseUpdateableClassifier
implements UpdateableClassifier {
    private static final long serialVersionUID = 3138493999362400767L;
    protected int epochs = 1;

    public BaseUpdateableClassifier() {
    }

    public BaseUpdateableClassifier(BaseUpdateableClassifier toCopy) {
        this.epochs = toCopy.epochs;
    }

    public void setEpochs(int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be a positive value");
        }
        this.epochs = epochs;
    }

    public int getEpochs() {
        return this.epochs;
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        this.train(dataSet);
    }

    @Override
    public void train(ClassificationDataSet dataSet) {
        BaseUpdateableClassifier.trainEpochs(dataSet, this, this.epochs);
    }

    public static void trainEpochs(ClassificationDataSet dataSet, UpdateableClassifier toTrain, int epochs) {
        if (epochs < 1) {
            throw new IllegalArgumentException("epochs must be positive");
        }
        toTrain.setUp(dataSet.getCategories(), dataSet.getNumNumericalVars(), dataSet.getPredicting());
        IntList randomOrder = new IntList(dataSet.size());
        ListUtils.addRange(randomOrder, 0, dataSet.size(), 1);
        for (int epoch = 0; epoch < epochs; ++epoch) {
            Collections.shuffle(randomOrder);
            Iterator iterator = randomOrder.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                toTrain.update(dataSet.getDataPoint(i), dataSet.getWeight(i), dataSet.getDataPointCategory(i));
            }
        }
    }

    @Override
    public abstract UpdateableClassifier clone();
}

