/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CategoricalData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5783467611963064930L;
    private int n;
    private List<String> catNames;
    private String categoryName;

    public CategoricalData(int n) {
        this.n = n;
        this.catNames = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.catNames.add("Option " + (i + 1));
        }
        this.categoryName = "No Name";
    }

    public int getNumOfCategories() {
        return this.n;
    }

    public boolean isValidCategory(int i) {
        return i >= 0 && i < this.n;
    }

    public String getOptionName(int i) {
        if (i < 0) {
            return "Missing Value";
        }
        if (this.catNames != null) {
            return this.catNames.get(i);
        }
        return Integer.toString(i);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public boolean setOptionName(String name, int i) {
        name = name.toLowerCase();
        if (i < 0 || i >= this.n) {
            return false;
        }
        if (this.catNames.contains(name)) {
            return false;
        }
        this.catNames.set(i, name);
        return true;
    }

    public CategoricalData clone() {
        CategoricalData copy = new CategoricalData(this.n);
        if (this.catNames != null) {
            copy.catNames = new ArrayList<String>(this.catNames);
        }
        return copy;
    }

    public static CategoricalData[] copyOf(CategoricalData[] orig) {
        CategoricalData[] copy = new CategoricalData[orig.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = orig[i].clone();
        }
        return copy;
    }
}

