/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.linear;

import java.util.List;
import jsat.classifiers.ClassificationDataSet;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Vec;

public class LinearTools {
    private LinearTools() {
    }

    public static double maxLambdaLogisticL1(ClassificationDataSet cds) {
        double D_part_i = 0.5;
        int n = cds.getNumNumericalVars();
        DenseVector delta_L = new DenseVector(n);
        if (cds.rowMajor()) {
            List<Vec> X = cds.getDataVectors();
            for (int i = 0; i < X.size(); ++i) {
                double y_i = cds.getDataPointCategory(i) * 2 - 1;
                Vec x = X.get(i);
                ((Vec)delta_L).mutableAdd(0.5 * y_i, x);
            }
        } else {
            Vec[] cols = cds.getNumericColumns();
            for (int j = 0; j < cds.getNumNumericalVars(); ++j) {
                Vec X_j = cols[j];
                for (IndexValue iv : X_j) {
                    int i = iv.getIndex();
                    double y_i = cds.getDataPointCategory(i) * 2 - 1;
                    delta_L.increment(j, 0.5 * y_i * iv.getValue());
                }
            }
        }
        return Math.max(Math.abs(((Vec)delta_L).max()), Math.abs(((Vec)delta_L).min())) / (double)cds.size();
    }

    public static double lambda2C(double lambda, double N) {
        return 1.0 / (lambda * N);
    }

    public static double c2Lambda(double C2, double N) {
        return 1.0 / (C2 * N);
    }
}

