/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.ClustererBase;
import jsat.clustering.dissimilarity.ClusterDissimilarity;
import jsat.clustering.evaluation.ClusterEvaluation;
import jsat.clustering.evaluation.intra.IntraClusterEvaluation;

public class DunnIndex
implements ClusterEvaluation {
    private IntraClusterEvaluation ice;
    private ClusterDissimilarity cd;

    public DunnIndex(IntraClusterEvaluation ice, ClusterDissimilarity cd) {
        this.ice = ice;
        this.cd = cd;
    }

    public DunnIndex(DunnIndex toCopy) {
        this(toCopy.ice.clone(), toCopy.cd.clone());
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        return this.evaluate(ClustererBase.createClusterListFromAssignmentArray(designations, dataSet));
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        double minVal = Double.POSITIVE_INFINITY;
        double maxIntra = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dataSets.size(); ++i) {
            for (int j = i + 1; j < dataSets.size(); ++j) {
                minVal = Math.min(minVal, this.cd.dissimilarity(dataSets.get(i), dataSets.get(j)));
            }
            maxIntra = Math.max(maxIntra, this.ice.evaluate(dataSets.get(i)));
        }
        return maxIntra / (minVal + maxIntra);
    }

    @Override
    public double naturalScore(double evaluate_score) {
        return 1.0 / evaluate_score - 1.0;
    }

    @Override
    public DunnIndex clone() {
        return new DunnIndex(this);
    }
}

