/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.InPlaceTransform;
import jsat.datatransform.WhitenedPCA;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.SingularValueDecomposition;
import jsat.linear.Vec;

public class WhitenedZCA
extends WhitenedPCA
implements InPlaceTransform {
    private static final long serialVersionUID = 7546033727733619587L;
    private ThreadLocal<Vec> tempVecs;

    public WhitenedZCA() {
        this(50);
    }

    public WhitenedZCA(int dims) {
        this(1.0E-4, dims);
    }

    public WhitenedZCA(double regularization, int dims) {
        this.setRegularization(regularization);
        this.setDimensions(dims);
    }

    public WhitenedZCA(DataSet dataSet, double regularization) {
        super(dataSet, regularization);
    }

    public WhitenedZCA(DataSet dataSet) {
        super(dataSet);
    }

    @Override
    public void fit(DataSet dataSet) {
        super.fit(dataSet);
        this.tempVecs = this.getThreadLocal(dataSet.getNumNumericalVars());
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec target = this.tempVecs.get();
        target.zeroOut();
        this.transform.multiply(dp.getNumericalValues(), 1.0, target);
        target.copyTo(dp.getNumericalValues());
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    protected void setUpTransform(SingularValueDecomposition svd) {
        double[] s = svd.getSingularValues();
        DenseVector diag = new DenseVector(s.length);
        for (int i = 0; i < s.length; ++i) {
            ((Vec)diag).set(i, 1.0 / Math.sqrt(s[i] + this.regularization));
        }
        Matrix U = svd.getU();
        this.transform = U.multiply(Matrix.diag(diag)).multiply(U.transpose());
    }

    private ThreadLocal<Vec> getThreadLocal(final int dim) {
        return new ThreadLocal<Vec>(){

            @Override
            protected Vec initialValue() {
                return new DenseVector(dim);
            }
        };
    }
}

