/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.parameters.Parameter;

public abstract class DistanceMetricBasedKernel
implements KernelTrick {
    private static final long serialVersionUID = 8395066824809874527L;
    @Parameter.ParameterHolder
    protected DistanceMetric d;

    public DistanceMetricBasedKernel(DistanceMetric d) {
        this.d = d;
    }

    @Override
    public abstract KernelTrick clone();

    @Override
    public boolean supportsAcceleration() {
        return this.d.supportsAcceleration();
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> trainingSet) {
        return this.d.getAccelerationCache(trainingSet);
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return this.d.getQueryInfo(q);
    }

    @Override
    public void addToCache(Vec newVec, List<Double> cache) {
        cache.addAll(this.d.getQueryInfo(newVec));
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, int start, int end) {
        return this.evalSum(finalSet, cache, alpha, y, this.d.getQueryInfo(y), start, end);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, List<Double> qi, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            if (alpha[i] == 0.0) continue;
            sum += alpha[i] * this.eval(i, y, qi, finalSet, cache);
        }
        return sum;
    }
}

