/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import jsat.linear.Vec;

public class ConstantVector
extends Vec {
    private static final long serialVersionUID = 4840204242189111630L;
    private double constant;
    private int length;

    public ConstantVector(double constant, int length) {
        this.setConstant(constant);
        this.setLength(length);
    }

    public void setConstant(double constant) {
        this.constant = constant;
    }

    @Override
    public void setLength(int length) {
        if (length < 1) {
            throw new ArithmeticException("Vector length must be a positive constant");
        }
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int index) {
        return this.constant;
    }

    @Override
    public double sum() {
        return this.constant * (double)this.length;
    }

    @Override
    public double mean() {
        return this.constant;
    }

    @Override
    public double variance() {
        return 0.0;
    }

    @Override
    public double standardDeviation() {
        return 0.0;
    }

    @Override
    public Vec normalized() {
        return new ConstantVector(this.constant / Math.sqrt(this.constant * this.constant * (double)this.length), this.length);
    }

    @Override
    public double pNorm(double p) {
        return Math.pow((double)this.length * Math.pow(Math.abs(this.constant), p), 1.0 / p);
    }

    @Override
    public double median() {
        return this.constant;
    }

    @Override
    public void set(int index, double val) {
        throw new ArithmeticException("ConstantVector does not support mutation");
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public ConstantVector clone() {
        return new ConstantVector(this.constant, this.length);
    }
}

