/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.DenseVector;
import jsat.linear.GenericMatrix;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.utils.FakeExecutor;
import jsat.utils.SystemInfo;

public class DenseMatrix
extends GenericMatrix {
    private static final long serialVersionUID = -3112110093920307822L;
    private double[][] matrix;

    public DenseMatrix(Vec a, Vec b) {
        this.matrix = new double[a.length()][b.length()];
        for (int i = 0; i < a.length(); ++i) {
            Vec rowVals = b.multiply(a.get(i));
            for (int j = 0; j < b.length(); ++j) {
                this.matrix[i][j] = rowVals.get(j);
            }
        }
    }

    public DenseMatrix(int rows, int cols) {
        this.matrix = new double[rows][cols];
    }

    public DenseMatrix(double[][] matrix) {
        this.matrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < this.matrix.length; ++i) {
            if (matrix[i].length != this.matrix[i].length) {
                throw new RuntimeException("Given matrix was not of consistent size (rows have diffrent lengths)");
            }
            System.arraycopy(matrix[i], 0, this.matrix[i], 0, this.matrix[i].length);
        }
    }

    public DenseMatrix(Matrix toCopy) {
        this(toCopy.rows(), toCopy.cols());
        toCopy.copyTo(this);
    }

    @Override
    protected Matrix getMatrixOfSameType(int rows, int cols) {
        return new DenseMatrix(rows, cols);
    }

    @Override
    public void mutableAdd(double c, Matrix b) {
        if (!DenseMatrix.sameDimensions(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + c * b.get(i, j);
            }
        }
    }

    @Override
    public void multiply(Vec b, double z, Vec c) {
        if (this.cols() != b.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree, [" + this.rows() + "," + this.cols() + "] x [" + b.length() + ",1]");
        }
        if (this.rows() != c.length()) {
            throw new ArithmeticException("Target vector dimension does not agree with matrix dimensions. Matrix has " + this.rows() + " rows but tagert has " + c.length());
        }
        for (int i = 0; i < this.rows(); ++i) {
            DenseVector row = new DenseVector(this.matrix[i]);
            c.increment(i, row.dot(b) * z);
        }
    }

    @Override
    public void transposeMultiply(double c, Vec b, Vec x) {
        if (this.rows() != b.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree, [" + this.cols() + "," + this.rows() + "] x [" + b.length() + ",1]");
        }
        if (this.cols() != x.length()) {
            throw new ArithmeticException("Matrix dimensions do not agree with target vector");
        }
        for (int i = 0; i < this.rows(); ++i) {
            double b_i = b.get(i);
            if (b_i == 0.0) continue;
            double[] A_i = this.matrix[i];
            for (int j = 0; j < this.cols(); ++j) {
                x.increment(j, c * b_i * A_i[j]);
            }
        }
    }

    private Matrix blockMultiply(Matrix b) {
        if (!DenseMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        DenseMatrix result = new DenseMatrix(this.rows(), b.cols());
        int iLimit = result.rows();
        int jLimit = result.cols();
        int kLimit = this.cols();
        for (int i0 = 0; i0 < iLimit; i0 += NB2) {
            for (int k0 = 0; k0 < kLimit; k0 += NB2) {
                for (int j0 = 0; j0 < jLimit; j0 += NB2) {
                    for (int i = i0; i < Math.min(i0 + NB2, iLimit); ++i) {
                        double[] c_row_i = result.matrix[i];
                        for (int k = k0; k < Math.min(k0 + NB2, kLimit); ++k) {
                            double a = this.matrix[i][k];
                            for (int j = j0; j < Math.min(j0 + NB2, jLimit); ++j) {
                                int n = j;
                                c_row_i[n] = c_row_i[n] + a * b.get(k, j);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private double initalVKNormCompute(int k, int M, double[] vk, double[] A_k) {
        double vkNorm = 0.0;
        for (int i = k + 1; i < M; ++i) {
            vk[i] = A_k[i];
            vkNorm += vk[i] * vk[i];
        }
        return vkNorm;
    }

    private void qrUpdateQ(DenseMatrix Q, int k, double[] vk, double TwoOverBeta) {
        for (int j = 0; j < Q.cols(); ++j) {
            int i;
            double[] Q_j = Q.matrix[j];
            double y = 0.0;
            for (i = k; i < Q.cols(); ++i) {
                y += vk[i] * Q_j[i];
            }
            y *= TwoOverBeta;
            for (i = k; i < Q.rows(); ++i) {
                int n = i;
                Q_j[n] = Q_j[n] - y * vk[i];
            }
        }
    }

    private void qrUpdateR(int k, int N, DenseMatrix A2, double[] vk, double TwoOverBeta, int M) {
        if (k < N) {
            this.qrUpdateRFirstIteration(A2, k, vk, TwoOverBeta, M);
        }
        for (int j = k + 1; j < N; ++j) {
            int i;
            double[] A_j = A2.matrix[j];
            double y = 0.0;
            for (i = k; i < A2.cols(); ++i) {
                y += vk[i] * A_j[i];
            }
            y *= TwoOverBeta;
            for (i = k; i < M; ++i) {
                int n = i;
                A_j[n] = A_j[n] - y * vk[i];
            }
        }
    }

    private void qrUpdateRFirstIteration(DenseMatrix A2, int k, double[] vk, double TwoOverBeta, int M) {
        int i;
        double[] A_j = A2.matrix[k];
        double y = 0.0;
        for (i = k; i < A2.cols(); ++i) {
            y += vk[i] * A_j[i];
        }
        int n = k;
        A_j[n] = A_j[n] - (y *= TwoOverBeta) * vk[k];
        for (i = k + 1; i < M; ++i) {
            A_j[i] = 0.0;
        }
    }

    @Override
    public void changeSize(int newRows, int newCols) {
        int i;
        if (newRows <= 0) {
            throw new ArithmeticException("Matrix must have a positive number of rows");
        }
        if (newCols <= 0) {
            throw new ArithmeticException("Matrix must have a positive number of columns");
        }
        int oldRow = this.matrix.length;
        if (newCols != this.cols()) {
            for (i = 0; i < this.matrix.length; ++i) {
                this.matrix[i] = Arrays.copyOf(this.matrix[i], newCols);
            }
        }
        this.matrix = (double[][])Arrays.copyOf(this.matrix, newRows);
        for (i = oldRow; i < newRows; ++i) {
            this.matrix[i] = new double[this.cols()];
        }
    }

    private void blockMultiply(DenseMatrix b, ExecutorService threadPool, DenseMatrix C2) {
        if (!DenseMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C2.rows() || b.cols() != C2.cols()) {
            throw new ArithmeticException("Destination matrix does not match the multiplication dimensions");
        }
        CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        for (int threadID = 0; threadID < SystemInfo.LogicalCores; ++threadID) {
            threadPool.submit(new BlockMultRun(latch, C2, b, threadID));
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void transposeMultiply(Matrix b, Matrix C2) {
        this.transposeMultiply(b, C2, new FakeExecutor());
    }

    @Override
    public void transposeMultiply(final Matrix b, final Matrix C2, ExecutorService threadPool) {
        if (this.rows() != b.rows()) {
            throw new ArithmeticException("Matrix dimensions do not agree [" + this.cols() + ", " + this.rows() + "] * [" + b.rows() + ", " + b.cols() + "]");
        }
        if (this.cols() != C2.rows() || b.cols() != C2.cols()) {
            throw new ArithmeticException("Destination matrix does not have matching dimensions");
        }
        final DenseMatrix A2 = this;
        if (!(b instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            super.transposeMultiply(b, C2, threadPool);
            return;
        }
        final int iLimit = C2.rows();
        final int jLimit = C2.cols();
        final int kLimit = this.rows();
        final int blockStep = Math.min(NB2, Math.max(iLimit / SystemInfo.LogicalCores, 1));
        final CountDownLatch cdl = new CountDownLatch(SystemInfo.LogicalCores);
        int threadNum = 0;
        while (threadNum < SystemInfo.LogicalCores) {
            final int threadID = threadNum++;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    DenseMatrix BB = (DenseMatrix)b;
                    DenseMatrix CC = (DenseMatrix)C2;
                    for (int i0 = blockStep * threadID; i0 < iLimit; i0 += blockStep * SystemInfo.LogicalCores) {
                        for (int k0 = 0; k0 < kLimit; k0 += blockStep) {
                            for (int j0 = 0; j0 < jLimit; j0 += blockStep) {
                                for (int k = k0; k < Math.min(k0 + blockStep, kLimit); ++k) {
                                    double[] A_row_k = A2.matrix[k];
                                    double[] B_row_k = BB.matrix[k];
                                    for (int i = i0; i < Math.min(i0 + blockStep, iLimit); ++i) {
                                        double a = A_row_k[i];
                                        double[] c_row_i = CC.matrix[i];
                                        for (int j = j0; j < Math.min(j0 + blockStep, jLimit); ++j) {
                                            int n = j;
                                            c_row_i[n] = c_row_i[n] + a * B_row_k[j];
                                        }
                                    }
                                }
                            }
                        }
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void multiply(Matrix b, Matrix C2) {
        if (!DenseMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C2.rows() || b.cols() != C2.cols()) {
            throw new ArithmeticException("Target Matrix is no the correct size");
        }
        if (!(C2 instanceof DenseMatrix) || !(b instanceof DenseMatrix)) {
            super.multiply(b, C2);
            return;
        }
        DenseMatrix result = (DenseMatrix)C2;
        DenseMatrix B = (DenseMatrix)b;
        for (int i = 0; i < result.rows(); ++i) {
            double[] Arowi = this.matrix[i];
            double[] Crowi = result.matrix[i];
            for (int k = 0; k < this.cols(); ++k) {
                double a = Arowi[k];
                double[] Browk = B.matrix[k];
                for (int j = 0; j < Crowi.length; ++j) {
                    int n = j;
                    Crowi[n] = Crowi[n] + a * Browk[j];
                }
            }
        }
    }

    @Override
    public void multiply(Matrix b, Matrix C2, ExecutorService threadPool) {
        if (!(b instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            super.multiply(b, C2, threadPool);
            return;
        }
        if (this.rows() / NB2 >= SystemInfo.LogicalCores) {
            this.blockMultiply((DenseMatrix)b, threadPool, (DenseMatrix)C2);
            return;
        }
        if (!DenseMatrix.canMultiply(this, b)) {
            throw new ArithmeticException("Matrix dimensions do not agree");
        }
        if (this.rows() != C2.rows() || b.cols() != C2.cols()) {
            throw new ArithmeticException("Destination matrix does not match the multiplication dimensions");
        }
        CountDownLatch cdl = new CountDownLatch(SystemInfo.LogicalCores);
        for (int threadID = 0; threadID < SystemInfo.LogicalCores; ++threadID) {
            threadPool.submit(new MultRun(cdl, this, (DenseMatrix)C2, (DenseMatrix)b, threadID));
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            this.multiply(b, C2);
        }
    }

    @Override
    public void mutableMultiply(double c) {
        for (int i = 0; i < this.rows(); ++i) {
            int j = 0;
            while (j < this.cols()) {
                double[] dArray = this.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * c;
            }
        }
    }

    @Override
    public void mutableTranspose() {
        for (int i = 0; i < this.rows() - 1; ++i) {
            for (int j = i + 1; j < this.cols(); ++j) {
                double tmp = this.matrix[j][i];
                this.matrix[j][i] = this.matrix[i][j];
                this.matrix[i][j] = tmp;
            }
        }
    }

    @Override
    public DenseMatrix transpose() {
        DenseMatrix toReturn = new DenseMatrix(this.cols(), this.rows());
        this.transpose(toReturn);
        return toReturn;
    }

    @Override
    public void transpose(Matrix C2) {
        if (this.rows() != C2.cols() || this.cols() != C2.rows()) {
            throw new ArithmeticException("Target matrix does not have the correct dimensions");
        }
        for (int i0 = 0; i0 < this.rows(); i0 += NB2) {
            for (int j0 = 0; j0 < this.cols(); j0 += NB2) {
                for (int i = i0; i < Math.min(i0 + NB2, this.rows()); ++i) {
                    for (int j = j0; j < Math.min(j0 + NB2, this.cols()); ++j) {
                        C2.set(j, i, this.get(i, j));
                    }
                }
            }
        }
    }

    @Override
    public double get(int i, int j) {
        return this.matrix[i][j];
    }

    @Override
    public void set(int i, int j, double value) {
        this.matrix[i][j] = value;
    }

    @Override
    public int rows() {
        return this.matrix.length;
    }

    @Override
    public int cols() {
        return this.matrix[0].length;
    }

    @Override
    public boolean isSparce() {
        return false;
    }

    @Override
    public void swapRows(int r1, int r2) {
        if (r1 >= this.rows() || r2 >= this.rows()) {
            throw new ArithmeticException("Can not swap row, matrix is smaller then requested");
        }
        if (r1 < 0 || r2 < 0) {
            throw new ArithmeticException("Can not swap row, there are no negative row indices");
        }
        double[] tmp = this.matrix[r1];
        this.matrix[r1] = this.matrix[r2];
        this.matrix[r2] = tmp;
    }

    @Override
    public void zeroOut() {
        for (int i = 0; i < this.rows(); ++i) {
            Arrays.fill(this.matrix[i], 0.0);
        }
    }

    @Override
    public Vec getRowView(int r) {
        return new DenseVector(this.matrix[r]);
    }

    @Override
    public Matrix[] lup() {
        Matrix[] lup = new Matrix[3];
        DenseMatrix P = DenseMatrix.eye(this.rows());
        DenseMatrix U = this;
        DenseMatrix L = this.rows() > this.cols() ? new DenseMatrix(this.rows(), this.cols()) : new DenseMatrix(this.rows(), this.rows());
        for (int i = 0; i < U.rows(); ++i) {
            int j;
            if (i < U.cols()) {
                int largestRow = i;
                double largestVal = Math.abs(U.matrix[i][i]);
                for (j = i + 1; j < U.rows(); ++j) {
                    double rowJLeadVal = Math.abs(U.matrix[j][i]);
                    if (!(rowJLeadVal > largestVal)) continue;
                    largestRow = j;
                    largestVal = rowJLeadVal;
                }
                U.swapRows(largestRow, i);
                ((Matrix)P).swapRows(largestRow, i);
                L.swapRows(largestRow, i);
                L.matrix[i][i] = 1.0;
            }
            for (int k = 0; k < Math.min(i, U.cols()); ++k) {
                double tmp = U.matrix[i][k] / U.matrix[k][k];
                L.matrix[i][k] = Double.isNaN(tmp) ? 0.0 : tmp;
                U.matrix[i][k] = 0.0;
                for (j = k + 1; j < U.cols(); ++j) {
                    double[] dArray = U.matrix[i];
                    int n = j;
                    dArray[n] = dArray[n] - L.matrix[i][k] * U.matrix[k][j];
                }
            }
        }
        if (this.rows() > this.cols()) {
            double[][] newU = new double[this.cols()][];
            System.arraycopy(U.matrix, 0, newU, 0, newU.length);
            U = new DenseMatrix(newU);
        }
        lup[0] = L;
        lup[1] = U;
        lup[2] = P;
        return lup;
    }

    @Override
    public Matrix[] lup(ExecutorService threadPool) {
        int k;
        Matrix[] lup = new Matrix[3];
        DenseMatrix P = DenseMatrix.eye(this.rows());
        DenseMatrix U = this;
        DenseMatrix L = this.rows() > this.cols() ? new DenseMatrix(this.rows(), this.cols()) : new DenseMatrix(this.rows(), this.rows());
        ArrayList<Future<Integer>> bigIndecies = new ArrayList<Future<Integer>>(SystemInfo.LogicalCores);
        for (k = 0; k < Math.min(this.rows(), this.cols()); ++k) {
            int largestRow = k;
            double largestVal = Math.abs(U.matrix[k][k]);
            if (bigIndecies.isEmpty()) {
                for (int j = k + 1; j < U.rows(); ++j) {
                    double d = Math.abs(U.matrix[j][k]);
                    if (!(d > largestVal)) continue;
                    largestRow = j;
                    largestVal = d;
                }
            } else {
                for (Future future : bigIndecies) {
                    try {
                        int j = (Integer)future.get();
                        double rowJLeadVal = Math.abs(U.matrix[j][k]);
                        if (!(rowJLeadVal > largestVal)) continue;
                        largestRow = j;
                        largestVal = rowJLeadVal;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                bigIndecies.clear();
            }
            U.swapRows(largestRow, k);
            ((Matrix)P).swapRows(largestRow, k);
            L.swapRows(largestRow, k);
            L.matrix[k][k] = 1.0;
            for (int threadNumber = 0; threadNumber < SystemInfo.LogicalCores; ++threadNumber) {
                bigIndecies.add(threadPool.submit(new LUProwRun(L, U, k, threadNumber)));
            }
        }
        for (k = 0; k < Math.min(this.rows(), this.cols()); ++k) {
            for (int j = 0; j < k; ++j) {
                U.matrix[k][j] = 0.0;
            }
        }
        if (this.rows() > this.cols()) {
            double[][] newU = new double[this.cols()][];
            System.arraycopy(U.matrix, 0, newU, 0, newU.length);
            U = new DenseMatrix(newU);
        }
        lup[0] = L;
        lup[1] = U;
        lup[2] = P;
        return lup;
    }

    @Override
    public Matrix[] qr() {
        DenseMatrix A2;
        int N = this.cols();
        int M = this.rows();
        Matrix[] qr = new Matrix[2];
        DenseMatrix Q = Matrix.eye(M);
        if (this.isSquare()) {
            this.mutableTranspose();
            A2 = this;
        } else {
            A2 = this.transpose();
        }
        int to = this.cols() > this.rows() ? M : N;
        double[] vk = new double[M];
        for (int k = 0; k < to; ++k) {
            double vkNorm;
            double[] A_k = A2.matrix[k];
            double beta = vkNorm = this.initalVKNormCompute(k, M, vk, A_k);
            double vk_k = vk[k] = A_k[k];
            vkNorm += vk_k * vk_k;
            vkNorm = Math.sqrt(vkNorm);
            double alpha = -Math.signum(vk_k) * vkNorm;
            vk[k] = vk_k -= alpha;
            if ((beta += vk_k * vk_k) == 0.0) continue;
            double TwoOverBeta = 2.0 / beta;
            this.qrUpdateQ(Q, k, vk, TwoOverBeta);
            this.qrUpdateR(k, N, A2, vk, TwoOverBeta, M);
        }
        qr[0] = Q;
        if (this.isSquare()) {
            A2.mutableTranspose();
            qr[1] = A2;
        } else {
            qr[1] = A2.transpose();
        }
        return qr;
    }

    @Override
    public Matrix[] qr(ExecutorService threadPool) {
        DenseMatrix A2;
        int N = this.cols();
        int M = this.rows();
        Matrix[] qr = new Matrix[2];
        DenseMatrix Q = Matrix.eye(M);
        if (this.isSquare()) {
            this.mutableTranspose();
            A2 = this;
        } else {
            A2 = this.transpose();
        }
        double[] vk = new double[M];
        int to = this.cols() > this.rows() ? M : N;
        for (int k = 0; k < to; ++k) {
            double vkNorm;
            double[] A_k = A2.matrix[k];
            double beta = vkNorm = this.initalVKNormCompute(k, M, vk, A_k);
            double vk_k = vk[k] = A_k[k];
            vkNorm += vk_k * vk_k;
            vkNorm = Math.sqrt(vkNorm);
            double alpha = -Math.signum(vk_k) * vkNorm;
            vk[k] = vk_k;
            if ((beta += (vk_k -= alpha) * vk_k) == 0.0) continue;
            double TwoOverBeta = 2.0 / beta;
            CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
            for (int threadID = 0; threadID < SystemInfo.LogicalCores; ++threadID) {
                threadPool.submit(new QRRun(A2, Q, vk, TwoOverBeta, k, threadID, latch));
            }
            try {
                latch.await();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        qr[0] = Q;
        if (this.isSquare()) {
            A2.mutableTranspose();
            qr[1] = A2;
        } else {
            qr[1] = A2.transpose();
        }
        return qr;
    }

    @Override
    public DenseMatrix clone() {
        DenseMatrix copy = new DenseMatrix(this.rows(), this.cols());
        for (int i = 0; i < this.matrix.length; ++i) {
            System.arraycopy(this.matrix[i], 0, copy.matrix[i], 0, this.matrix[i].length);
        }
        return copy;
    }

    private class QRRun
    implements Runnable {
        DenseMatrix A;
        DenseMatrix Q;
        double[] vk;
        double TwoOverBeta;
        int k;
        int threadID;
        int N;
        int M;
        CountDownLatch latch;

        public QRRun(DenseMatrix A2, DenseMatrix Q, double[] vk, double TwoOverBeta, int k, int threadID, CountDownLatch latch) {
            this.A = A2;
            this.Q = Q;
            this.vk = vk;
            this.TwoOverBeta = TwoOverBeta;
            this.k = k;
            this.threadID = threadID;
            this.latch = latch;
            this.N = A2.rows();
            this.M = A2.cols();
        }

        @Override
        public void run() {
            int i;
            double y;
            int j;
            for (j = 0 + this.threadID; j < this.Q.cols(); j += SystemInfo.LogicalCores) {
                double[] Q_j = this.Q.matrix[j];
                y = 0.0;
                for (i = this.k; i < this.Q.cols(); ++i) {
                    y += this.vk[i] * Q_j[i];
                }
                y *= this.TwoOverBeta;
                for (i = this.k; i < this.Q.rows(); ++i) {
                    int n = i;
                    Q_j[n] = Q_j[n] - y * this.vk[i];
                }
            }
            if (this.k < this.N && this.threadID == 0) {
                DenseMatrix.this.qrUpdateRFirstIteration(this.A, this.k, this.vk, this.TwoOverBeta, this.M);
            }
            for (j = this.k + 1 + this.threadID; j < this.N; j += SystemInfo.LogicalCores) {
                double[] A_j = this.A.matrix[j];
                y = 0.0;
                for (i = this.k; i < this.A.cols(); ++i) {
                    y += this.vk[i] * A_j[i];
                }
                y *= this.TwoOverBeta;
                for (i = this.k; i < this.M; ++i) {
                    int n = i;
                    A_j[n] = A_j[n] - y * this.vk[i];
                }
            }
            this.latch.countDown();
        }
    }

    private class LUProwRun
    implements Callable<Integer> {
        final DenseMatrix L;
        final DenseMatrix U;
        final int k;
        final int threadNumber;
        double largestSeen = Double.MIN_VALUE;
        int largestIndex;

        public LUProwRun(DenseMatrix L, DenseMatrix U, int k, int threadNumber) {
            this.L = L;
            this.U = U;
            this.k = k;
            this.largestIndex = k + 1;
            this.threadNumber = threadNumber;
        }

        @Override
        public Integer call() throws Exception {
            for (int i = this.k + 1 + this.threadNumber; i < this.U.rows(); i += SystemInfo.LogicalCores) {
                double tmp = this.U.matrix[i][this.k] / this.U.matrix[this.k][this.k];
                ((DenseMatrix)this.L).matrix[i][this.k] = Double.isNaN(tmp) ? 0.0 : tmp;
                double[] dArray = this.U.matrix[i];
                int n = this.k + 1;
                dArray[n] = dArray[n] - this.L.matrix[i][this.k] * this.U.matrix[this.k][this.k + 1];
                if (Math.abs(this.U.matrix[i][this.k + 1]) > this.largestSeen) {
                    this.largestSeen = Math.abs(this.U.matrix[i][this.k + 1]);
                    this.largestIndex = i;
                }
                for (int j = this.k + 2; j < this.U.cols(); ++j) {
                    double[] dArray2 = this.U.matrix[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] - this.L.matrix[i][this.k] * this.U.matrix[this.k][j];
                }
            }
            return this.largestIndex;
        }
    }

    private class MultRun
    implements Runnable {
        final CountDownLatch latch;
        final DenseMatrix A;
        final DenseMatrix B;
        final DenseMatrix result;
        final int threadID;

        public MultRun(CountDownLatch latch, DenseMatrix A2, DenseMatrix result, DenseMatrix B, int threadID) {
            this.latch = latch;
            this.A = A2;
            this.result = result;
            this.B = B;
            this.threadID = threadID;
        }

        @Override
        public void run() {
            for (int i = 0 + this.threadID; i < this.result.rows(); i += SystemInfo.LogicalCores) {
                double[] Ai = this.A.matrix[i];
                double[] Ci = this.result.matrix[i];
                for (int k = 0; k < this.A.cols(); ++k) {
                    double a = Ai[k];
                    double[] Bi = this.B.matrix[k];
                    for (int j = 0; j < Ci.length; ++j) {
                        int n = j;
                        Ci[n] = Ci[n] + a * Bi[j];
                    }
                }
            }
            this.latch.countDown();
        }
    }

    private class BlockMultRun
    implements Runnable {
        final CountDownLatch latch;
        final DenseMatrix result;
        final DenseMatrix b;
        final int kLimit;
        final int jLimit;
        final int iLimit;
        final int threadID;

        public BlockMultRun(CountDownLatch latch, DenseMatrix result, DenseMatrix b, int threadID) {
            this.latch = latch;
            this.result = result;
            this.b = b;
            this.kLimit = DenseMatrix.this.cols();
            this.jLimit = result.cols();
            this.iLimit = result.rows();
            this.threadID = threadID;
        }

        @Override
        public void run() {
            for (int i0 = GenericMatrix.NB2 * this.threadID; i0 < this.iLimit; i0 += GenericMatrix.NB2 * SystemInfo.LogicalCores) {
                for (int k0 = 0; k0 < this.kLimit; k0 += GenericMatrix.NB2) {
                    for (int j0 = 0; j0 < this.jLimit; j0 += GenericMatrix.NB2) {
                        for (int i = i0; i < Math.min(i0 + GenericMatrix.NB2, this.iLimit); ++i) {
                            double[] Ci = this.result.matrix[i];
                            for (int k = k0; k < Math.min(k0 + GenericMatrix.NB2, this.kLimit); ++k) {
                                double a = DenseMatrix.this.matrix[i][k];
                                double[] Bk = this.b.matrix[k];
                                for (int j = j0; j < Math.min(j0 + GenericMatrix.NB2, this.jLimit); ++j) {
                                    int n = j;
                                    Ci[n] = Ci[n] + a * Bk[j];
                                }
                            }
                        }
                    }
                }
            }
            this.latch.countDown();
        }
    }
}

